from typing import TYPE_CHECKING, Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.core_spec_configurations import CoreSpecConfigurations
    from ..models.flavor import Flavor
    from ..models.revision_configuration import RevisionConfiguration
    from ..models.runtime import Runtime
    from ..models.sandbox_lifecycle import SandboxLifecycle
    from ..models.volume_attachment import VolumeAttachment


T = TypeVar("T", bound="SandboxSpec")


@_attrs_define
class SandboxSpec:
    """Sandbox specification

    Attributes:
        configurations (Union[Unset, CoreSpecConfigurations]): Optional configurations for the object
        enabled (Union[Unset, bool]): Enable or disable the resource
        flavors (Union[Unset, list['Flavor']]): Types of hardware available for deployments
        integration_connections (Union[Unset, list[str]]):
        policies (Union[Unset, list[str]]):
        revision (Union[Unset, RevisionConfiguration]): Revision configuration
        runtime (Union[Unset, Runtime]): Set of configurations for a deployment
        sandbox (Union[Unset, bool]): Sandbox mode
        lifecycle (Union[Unset, SandboxLifecycle]): Lifecycle configuration for sandbox management
        region (Union[Unset, str]): Region where the sandbox should be created (e.g. us-pdx-1, eu-lon-1)
        volumes (Union[Unset, list['VolumeAttachment']]):
    """

    configurations: Union[Unset, "CoreSpecConfigurations"] = UNSET
    enabled: Union[Unset, bool] = UNSET
    flavors: Union[Unset, list["Flavor"]] = UNSET
    integration_connections: Union[Unset, list[str]] = UNSET
    policies: Union[Unset, list[str]] = UNSET
    revision: Union[Unset, "RevisionConfiguration"] = UNSET
    runtime: Union[Unset, "Runtime"] = UNSET
    sandbox: Union[Unset, bool] = UNSET
    lifecycle: Union[Unset, "SandboxLifecycle"] = UNSET
    region: Union[Unset, str] = UNSET
    volumes: Union[Unset, list["VolumeAttachment"]] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:

        configurations: Union[Unset, dict[str, Any]] = UNSET
        if (
            self.configurations
            and not isinstance(self.configurations, Unset)
            and not isinstance(self.configurations, dict)
        ):
            configurations = self.configurations.to_dict()
        elif self.configurations and isinstance(self.configurations, dict):
            configurations = self.configurations

        enabled = self.enabled

        flavors: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.flavors, Unset):
            flavors = []
            for componentsschemas_flavors_item_data in self.flavors:
                if type(componentsschemas_flavors_item_data) is dict:
                    componentsschemas_flavors_item = componentsschemas_flavors_item_data
                else:
                    componentsschemas_flavors_item = componentsschemas_flavors_item_data.to_dict()
                flavors.append(componentsschemas_flavors_item)

        integration_connections: Union[Unset, list[str]] = UNSET
        if not isinstance(self.integration_connections, Unset):
            integration_connections = self.integration_connections

        policies: Union[Unset, list[str]] = UNSET
        if not isinstance(self.policies, Unset):
            policies = self.policies

        revision: Union[Unset, dict[str, Any]] = UNSET
        if self.revision and not isinstance(self.revision, Unset) and not isinstance(self.revision, dict):
            revision = self.revision.to_dict()
        elif self.revision and isinstance(self.revision, dict):
            revision = self.revision

        runtime: Union[Unset, dict[str, Any]] = UNSET
        if self.runtime and not isinstance(self.runtime, Unset) and not isinstance(self.runtime, dict):
            runtime = self.runtime.to_dict()
        elif self.runtime and isinstance(self.runtime, dict):
            runtime = self.runtime

        sandbox = self.sandbox

        lifecycle: Union[Unset, dict[str, Any]] = UNSET
        if self.lifecycle and not isinstance(self.lifecycle, Unset) and not isinstance(self.lifecycle, dict):
            lifecycle = self.lifecycle.to_dict()
        elif self.lifecycle and isinstance(self.lifecycle, dict):
            lifecycle = self.lifecycle

        region = self.region

        volumes: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.volumes, Unset):
            volumes = []
            for componentsschemas_volume_attachments_item_data in self.volumes:
                if type(componentsschemas_volume_attachments_item_data) is dict:
                    componentsschemas_volume_attachments_item = componentsschemas_volume_attachments_item_data
                else:
                    componentsschemas_volume_attachments_item = componentsschemas_volume_attachments_item_data.to_dict()
                volumes.append(componentsschemas_volume_attachments_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if configurations is not UNSET:
            field_dict["configurations"] = configurations
        if enabled is not UNSET:
            field_dict["enabled"] = enabled
        if flavors is not UNSET:
            field_dict["flavors"] = flavors
        if integration_connections is not UNSET:
            field_dict["integrationConnections"] = integration_connections
        if policies is not UNSET:
            field_dict["policies"] = policies
        if revision is not UNSET:
            field_dict["revision"] = revision
        if runtime is not UNSET:
            field_dict["runtime"] = runtime
        if sandbox is not UNSET:
            field_dict["sandbox"] = sandbox
        if lifecycle is not UNSET:
            field_dict["lifecycle"] = lifecycle
        if region is not UNSET:
            field_dict["region"] = region
        if volumes is not UNSET:
            field_dict["volumes"] = volumes

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        from ..models.core_spec_configurations import CoreSpecConfigurations
        from ..models.flavor import Flavor
        from ..models.revision_configuration import RevisionConfiguration
        from ..models.runtime import Runtime
        from ..models.sandbox_lifecycle import SandboxLifecycle
        from ..models.volume_attachment import VolumeAttachment

        if not src_dict:
            return None
        d = src_dict.copy()
        _configurations = d.pop("configurations", UNSET)
        configurations: Union[Unset, CoreSpecConfigurations]
        if isinstance(_configurations, Unset):
            configurations = UNSET
        else:
            configurations = CoreSpecConfigurations.from_dict(_configurations)

        enabled = d.pop("enabled", UNSET)

        flavors = []
        _flavors = d.pop("flavors", UNSET)
        for componentsschemas_flavors_item_data in _flavors or []:
            componentsschemas_flavors_item = Flavor.from_dict(componentsschemas_flavors_item_data)

            flavors.append(componentsschemas_flavors_item)

        integration_connections = cast(list[str], d.pop("integrationConnections", UNSET))

        policies = cast(list[str], d.pop("policies", UNSET))

        _revision = d.pop("revision", UNSET)
        revision: Union[Unset, RevisionConfiguration]
        if isinstance(_revision, Unset):
            revision = UNSET
        else:
            revision = RevisionConfiguration.from_dict(_revision)

        _runtime = d.pop("runtime", UNSET)
        runtime: Union[Unset, Runtime]
        if isinstance(_runtime, Unset):
            runtime = UNSET
        else:
            runtime = Runtime.from_dict(_runtime)

        sandbox = d.pop("sandbox", UNSET)

        _lifecycle = d.pop("lifecycle", UNSET)
        lifecycle: Union[Unset, SandboxLifecycle]
        if isinstance(_lifecycle, Unset):
            lifecycle = UNSET
        else:
            lifecycle = SandboxLifecycle.from_dict(_lifecycle)

        region = d.pop("region", UNSET)

        volumes = []
        _volumes = d.pop("volumes", UNSET)
        for componentsschemas_volume_attachments_item_data in _volumes or []:
            componentsschemas_volume_attachments_item = VolumeAttachment.from_dict(
                componentsschemas_volume_attachments_item_data
            )

            volumes.append(componentsschemas_volume_attachments_item)

        sandbox_spec = cls(
            configurations=configurations,
            enabled=enabled,
            flavors=flavors,
            integration_connections=integration_connections,
            policies=policies,
            revision=revision,
            runtime=runtime,
            sandbox=sandbox,
            lifecycle=lifecycle,
            region=region,
            volumes=volumes,
        )

        sandbox_spec.additional_properties = d
        return sandbox_spec

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
