from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="WebsocketChannel")


@_attrs_define
class WebsocketChannel:
    """WebSocket connection details

    Attributes:
        created_at (Union[Unset, str]): The date and time when the resource was created
        updated_at (Union[Unset, str]): The date and time when the resource was updated
        connection_id (Union[Unset, str]): Unique connection ID
        source_region (Union[Unset, str]): Source region the connection belongs to
        workspace (Union[Unset, str]): Workspace the connection belongs to
    """

    created_at: Union[Unset, str] = UNSET
    updated_at: Union[Unset, str] = UNSET
    connection_id: Union[Unset, str] = UNSET
    source_region: Union[Unset, str] = UNSET
    workspace: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        created_at = self.created_at

        updated_at = self.updated_at

        connection_id = self.connection_id

        source_region = self.source_region

        workspace = self.workspace

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if created_at is not UNSET:
            field_dict["createdAt"] = created_at
        if updated_at is not UNSET:
            field_dict["updatedAt"] = updated_at
        if connection_id is not UNSET:
            field_dict["connection_id"] = connection_id
        if source_region is not UNSET:
            field_dict["sourceRegion"] = source_region
        if workspace is not UNSET:
            field_dict["workspace"] = workspace

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        if not src_dict:
            return None
        d = src_dict.copy()
        created_at = d.pop("createdAt", UNSET)

        updated_at = d.pop("updatedAt", UNSET)

        connection_id = d.pop("connection_id", UNSET)

        source_region = d.pop("sourceRegion", UNSET)

        workspace = d.pop("workspace", UNSET)

        websocket_channel = cls(
            created_at=created_at,
            updated_at=updated_at,
            connection_id=connection_id,
            source_region=source_region,
            workspace=workspace,
        )

        websocket_channel.additional_properties = d
        return websocket_channel

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
