"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomRule = exports.RedirectStatus = exports.App = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const amplify_generated_1 = require("./amplify.generated");
const branch_1 = require("./branch");
const domain_1 = require("./domain");
const utils_1 = require("./utils");
/**
 * An Amplify Console application
 */
class App extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_AppProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, App);
            }
            throw error;
        }
        this.customRules = props.customRules || [];
        this.environmentVariables = props.environmentVariables || {};
        this.autoBranchEnvironmentVariables = props.autoBranchCreation && props.autoBranchCreation.environmentVariables || {};
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('amplify.amazonaws.com'),
        });
        this.grantPrincipal = role;
        const sourceCodeProviderOptions = props.sourceCodeProvider?.bind(this);
        const app = new amplify_generated_1.CfnApp(this, 'Resource', {
            accessToken: sourceCodeProviderOptions?.accessToken?.unsafeUnwrap(),
            autoBranchCreationConfig: props.autoBranchCreation && {
                autoBranchCreationPatterns: props.autoBranchCreation.patterns,
                basicAuthConfig: props.autoBranchCreation.basicAuth
                    ? props.autoBranchCreation.basicAuth.bind(this, 'BranchBasicAuth')
                    : { enableBasicAuth: false },
                buildSpec: props.autoBranchCreation.buildSpec && props.autoBranchCreation.buildSpec.toBuildSpec(),
                enableAutoBranchCreation: true,
                enableAutoBuild: props.autoBranchCreation.autoBuild ?? true,
                environmentVariables: core_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.autoBranchEnvironmentVariables) }, { omitEmptyArray: true }),
                enablePullRequestPreview: props.autoBranchCreation.pullRequestPreview ?? true,
                pullRequestEnvironmentName: props.autoBranchCreation.pullRequestEnvironmentName,
                stage: props.autoBranchCreation.stage,
            },
            enableBranchAutoDeletion: props.autoBranchDeletion,
            basicAuthConfig: props.basicAuth
                ? props.basicAuth.bind(this, 'AppBasicAuth')
                : { enableBasicAuth: false },
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            customRules: core_1.Lazy.any({ produce: () => this.customRules }, { omitEmptyArray: true }),
            description: props.description,
            environmentVariables: core_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            iamServiceRole: role.roleArn,
            name: props.appName || this.node.id,
            oauthToken: sourceCodeProviderOptions?.oauthToken?.unsafeUnwrap(),
            repository: sourceCodeProviderOptions?.repository,
            customHeaders: props.customResponseHeaders ? renderCustomResponseHeaders(props.customResponseHeaders) : undefined,
        });
        this.appId = app.attrAppId;
        this.appName = app.attrAppName;
        this.arn = app.attrArn;
        this.defaultDomain = app.attrDefaultDomain;
    }
    /**
     * Import an existing application
     */
    static fromAppId(scope, id, appId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.appId = appId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds a custom rewrite/redirect rule to this application
     */
    addCustomRule(rule) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_CustomRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addCustomRule);
            }
            throw error;
        }
        this.customRules.push(rule);
        return this;
    }
    /**
     * Adds an environment variable to this application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
    /**
     * Adds an environment variable to the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addAutoBranchEnvironment(name, value) {
        this.autoBranchEnvironmentVariables[name] = value;
        return this;
    }
    /**
     * Adds a branch to this application
     */
    addBranch(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_BranchOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addBranch);
            }
            throw error;
        }
        return new branch_1.Branch(this, id, {
            ...options,
            app: this,
        });
    }
    /**
     * Adds a domain to this application
     */
    addDomain(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_DomainOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDomain);
            }
            throw error;
        }
        return new domain_1.Domain(this, id, {
            ...options,
            app: this,
            autoSubDomainIamRole: this.grantPrincipal,
        });
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "@aws-cdk/aws-amplify.App", version: "1.185.0" };
/**
 * The status code for a URL rewrite or redirect rule.
 */
var RedirectStatus;
(function (RedirectStatus) {
    /**
     * Rewrite (200)
     */
    RedirectStatus["REWRITE"] = "200";
    /**
     * Permanent redirect (301)
     */
    RedirectStatus["PERMANENT_REDIRECT"] = "301";
    /**
     * Temporary redirect (302)
     */
    RedirectStatus["TEMPORARY_REDIRECT"] = "302";
    /**
     * Not found (404)
     */
    RedirectStatus["NOT_FOUND"] = "404";
    /**
     * Not found rewrite (404)
     */
    RedirectStatus["NOT_FOUND_REWRITE"] = "404-200";
})(RedirectStatus = exports.RedirectStatus || (exports.RedirectStatus = {}));
/**
 * Custom rewrite/redirect rule for an Amplify App.
 *
 * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
 */
class CustomRule {
    constructor(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_CustomRuleOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CustomRule);
            }
            throw error;
        }
        this.source = options.source;
        this.target = options.target;
        this.status = options.status;
        this.condition = options.condition;
    }
}
exports.CustomRule = CustomRule;
_b = JSII_RTTI_SYMBOL_1;
CustomRule[_b] = { fqn: "@aws-cdk/aws-amplify.CustomRule", version: "1.185.0" };
/**
 * Sets up a 200 rewrite for all paths to `index.html` except for path
 * containing a file extension.
 */
CustomRule.SINGLE_PAGE_APPLICATION_REDIRECT = new CustomRule({
    source: '</^[^.]+$/>',
    target: '/index.html',
    status: RedirectStatus.REWRITE,
});
function renderCustomResponseHeaders(customHeaders) {
    const yaml = [
        'customHeaders:',
    ];
    for (const customHeader of customHeaders) {
        yaml.push(`  - pattern: "${customHeader.pattern}"`);
        yaml.push('    headers:');
        for (const [key, value] of Object.entries(customHeader.headers)) {
            yaml.push(`      - key: "${key}"`);
            yaml.push(`        value: "${value}"`);
        }
    }
    return `${yaml.join('\n')}\n`;
}
//# sourceMappingURL=data:application/json;base64,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