"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const amplify_generated_1 = require("./amplify.generated");
/**
 * An Amplify Console domain
 */
class Domain extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_DomainProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Domain);
            }
            throw error;
        }
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new amplify_generated_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: core_1.Lazy.any({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
            enableAutoSubDomain: !!props.enableAutoSubdomain,
            autoSubDomainCreationPatterns: props.autoSubdomainCreationPatterns || ['*', 'pr*'],
            autoSubDomainIamRole: props.autoSubDomainIamRole?.roleArn,
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
        this.domainAutoSubDomainCreationPatterns = domain.attrAutoSubDomainCreationPatterns;
        this.domainAutoSubDomainIamRole = domain.attrAutoSubDomainIamRole;
        this.domainEnableAutoSubDomain = domain.attrEnableAutoSubDomain;
    }
    /**
     * Maps a branch to a sub domain
     *
     * @param branch The branch
     * @param prefix The prefix. Use '' to map to the root of the domain. Defaults to branch name.
     */
    mapSubDomain(branch, prefix) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_IBranch(branch);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mapSubDomain);
            }
            throw error;
        }
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * Maps a branch to the domain root
     */
    mapRoot(branch) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_IBranch(branch);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mapRoot);
            }
            throw error;
        }
        return this.mapSubDomain(branch, '');
    }
    validate() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => ({
            branchName: s.branch.branchName,
            prefix: s.prefix ?? s.branch.branchName,
        }));
    }
}
exports.Domain = Domain;
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "@aws-cdk/aws-amplify.Domain", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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