# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServerTypesResult',
    'AwaitableGetServerTypesResult',
    'get_server_types',
    'get_server_types_output',
]

@pulumi.output_type
class GetServerTypesResult:
    """
    A collection of values returned by getServerTypes.
    """
    def __init__(__self__, descriptions=None, id=None, names=None, server_type_ids=None, server_types=None):
        if descriptions and not isinstance(descriptions, list):
            raise TypeError("Expected argument 'descriptions' to be a list")
        pulumi.set(__self__, "descriptions", descriptions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if server_type_ids and not isinstance(server_type_ids, list):
            raise TypeError("Expected argument 'server_type_ids' to be a list")
        pulumi.set(__self__, "server_type_ids", server_type_ids)
        if server_types and not isinstance(server_types, list):
            raise TypeError("Expected argument 'server_types' to be a list")
        pulumi.set(__self__, "server_types", server_types)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use server_types list instead""")
    def descriptions(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "descriptions")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use server_types list instead""")
    def names(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="serverTypeIds")
    @_utilities.deprecated("""Use server_types list instead""")
    def server_type_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "server_type_ids")

    @property
    @pulumi.getter(name="serverTypes")
    def server_types(self) -> Sequence['outputs.GetServerTypesServerTypeResult']:
        return pulumi.get(self, "server_types")


class AwaitableGetServerTypesResult(GetServerTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerTypesResult(
            descriptions=self.descriptions,
            id=self.id,
            names=self.names,
            server_type_ids=self.server_type_ids,
            server_types=self.server_types)


def get_server_types(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerTypesResult:
    """
    Provides a list of available Hetzner Cloud Server Types.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    all = hcloud.get_server_types()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getServerTypes:getServerTypes', __args__, opts=opts, typ=GetServerTypesResult).value

    return AwaitableGetServerTypesResult(
        descriptions=pulumi.get(__ret__, 'descriptions'),
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'),
        server_type_ids=pulumi.get(__ret__, 'server_type_ids'),
        server_types=pulumi.get(__ret__, 'server_types'))
def get_server_types_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerTypesResult]:
    """
    Provides a list of available Hetzner Cloud Server Types.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    all = hcloud.get_server_types()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('hcloud:index/getServerTypes:getServerTypes', __args__, opts=opts, typ=GetServerTypesResult)
    return __ret__.apply(lambda __response__: GetServerTypesResult(
        descriptions=pulumi.get(__response__, 'descriptions'),
        id=pulumi.get(__response__, 'id'),
        names=pulumi.get(__response__, 'names'),
        server_type_ids=pulumi.get(__response__, 'server_type_ids'),
        server_types=pulumi.get(__response__, 'server_types')))
