# Contributing to hdsemg-select

First off, thank you for considering contributing to hdsemg-select! It's people like you that make hdsemg-select such a great tool.

## Ways to Contribute

### Reporting Issues

If you find a bug or have a suggestion for improving hdsemg-select, please first check if a similar issue already exists in our [issue tracker](https://github.com/johanneskasser/hdsemg-select/issues). If not, feel free to create a new one.

When filing an issue, please include:

- A clear description of the problem
- Steps to reproduce the issue
- Expected vs actual behavior
- Your Python version and operating system
- Any relevant code samples or error messages

### Contributing Code

1. Fork the repository on GitHub
2. Create a new branch for your feature:
   ```bash
   git checkout -b feature-name
   ```
3. Make your changes and commit them with clear commit messages
4. Push to your fork:
   ```bash
   git push origin feature-name
   ```
5. Open a Pull Request against our main branch

### Development Setup

1. Clone your fork:
   ```bash
   git clone https://github.com/johanneskasser/hdsemg-select.git
   cd hdsemg_select
   ```

2. Create a virtual environment:
   ```bash
   python -m venv venv
   source venv/bin/activate  # On Windows: venv\Scripts\activate
   ```

## Code Style

- Follow PEP 8 guidelines
- Include docstrings for new functions/classes
- Add type hints where possible
- Write tests for new functionality

## Pull Request Process

1. Update the documentation if needed
2. Add or update tests as needed
3. Ensure all tests pass
4. Update the changelog if applicable
5. Be ready to address review comments

## Questions?

If you have questions about the development process or need help with your contribution, feel free to:

- Open an issue with your question
- Reach out to the maintainers

## Code of Conduct

By participating in this project, you agree to abide by its terms and maintain a respectful and inclusive environment for everyone.

Thank you for your contribution!

