import pandas as pd


class Datasets:
    def __init__(self):
        self.datasets = {
            "imdb": "https://ai.stanford.edu/~amaas/data/sentiment/aclImdb_v1.tar.gz",
            "twitter": "https://github.com/sbhatti/twitter-sentiment-analysis-dataset/raw/master/data.csv",
            "ag_news": "https://raw.githubusercontent.com/mhjabreel/CharCnn_Keras/master/data/ag_news_csv/train.csv",
            # Add more datasets as needed
        }

    def load_dataset(self, name):
        """
        Load a dataset by name.
        :param name: The name of the dataset to load.
        :return: A pandas DataFrame containing the dataset.
        """
        if name not in self.datasets:
            raise ValueError(f"Dataset '{name}' is not available.")

        url = self.datasets[name]
        return pd.read_csv(url)

    def list_datasets(self):
        """
        List all available datasets.
        :return: A list of dataset names.
        """
        return list(self.datasets.keys())
