# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conlist 
from lusid.models.blocked_order_request import BlockedOrderRequest
from lusid.models.currency_and_amount import CurrencyAndAmount
from lusid.models.perpetual_property import PerpetualProperty
from lusid.models.resource_id import ResourceId

class BlockAndOrdersRequest(BaseModel):
    """
    BlockAndOrdersRequest
    """
    block_id: ResourceId = Field(..., alias="blockId")
    orders: conlist(BlockedOrderRequest) = Field(..., description="An order which belongs to a block. Fields common to both entities (such as instrument) should be derived from the block.")
    block_properties: Optional[Dict[str, PerpetualProperty]] = Field(None, alias="blockProperties", description="Client-defined properties associated with this block.")
    instrument_identifiers: Dict[str, StrictStr] = Field(..., alias="instrumentIdentifiers", description="The instrument ordered.")
    side:  Optional[StrictStr] = Field(None,alias="side", description="The client's representation of the block's side (buy, sell, short, etc). BlockedOrders in the request which do not specify a side will have their side populated with this value.") 
    type:  Optional[StrictStr] = Field(None,alias="type", description="The block order's type (examples: Limit, Market, ...)") 
    time_in_force:  Optional[StrictStr] = Field(None,alias="timeInForce", description="The block orders' time in force (examples: Day, GoodTilCancel, ...)") 
    var_date: Optional[datetime] = Field(None, alias="date", description="The date on which the block was made")
    limit_price: Optional[CurrencyAndAmount] = Field(None, alias="limitPrice")
    stop_price: Optional[CurrencyAndAmount] = Field(None, alias="stopPrice")
    __properties = ["blockId", "orders", "blockProperties", "instrumentIdentifiers", "side", "type", "timeInForce", "date", "limitPrice", "stopPrice"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BlockAndOrdersRequest:
        """Create an instance of BlockAndOrdersRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of block_id
        if self.block_id:
            _dict['blockId'] = self.block_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in orders (list)
        _items = []
        if self.orders:
            for _item in self.orders:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orders'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in block_properties (dict)
        _field_dict = {}
        if self.block_properties:
            for _key in self.block_properties:
                if self.block_properties[_key]:
                    _field_dict[_key] = self.block_properties[_key].to_dict()
            _dict['blockProperties'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of limit_price
        if self.limit_price:
            _dict['limitPrice'] = self.limit_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stop_price
        if self.stop_price:
            _dict['stopPrice'] = self.stop_price.to_dict()
        # set to None if block_properties (nullable) is None
        # and __fields_set__ contains the field
        if self.block_properties is None and "block_properties" in self.__fields_set__:
            _dict['blockProperties'] = None

        # set to None if side (nullable) is None
        # and __fields_set__ contains the field
        if self.side is None and "side" in self.__fields_set__:
            _dict['side'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if time_in_force (nullable) is None
        # and __fields_set__ contains the field
        if self.time_in_force is None and "time_in_force" in self.__fields_set__:
            _dict['timeInForce'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BlockAndOrdersRequest:
        """Create an instance of BlockAndOrdersRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BlockAndOrdersRequest.parse_obj(obj)

        _obj = BlockAndOrdersRequest.parse_obj({
            "block_id": ResourceId.from_dict(obj.get("blockId")) if obj.get("blockId") is not None else None,
            "orders": [BlockedOrderRequest.from_dict(_item) for _item in obj.get("orders")] if obj.get("orders") is not None else None,
            "block_properties": dict(
                (_k, PerpetualProperty.from_dict(_v))
                for _k, _v in obj.get("blockProperties").items()
            )
            if obj.get("blockProperties") is not None
            else None,
            "instrument_identifiers": obj.get("instrumentIdentifiers"),
            "side": obj.get("side"),
            "type": obj.get("type"),
            "time_in_force": obj.get("timeInForce"),
            "var_date": obj.get("date"),
            "limit_price": CurrencyAndAmount.from_dict(obj.get("limitPrice")) if obj.get("limitPrice") is not None else None,
            "stop_price": CurrencyAndAmount.from_dict(obj.get("stopPrice")) if obj.get("stopPrice") is not None else None
        })
        return _obj
