# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist, constr, validator 
from lusid.models.alias import Alias
from lusid.models.custom_data_model_identifier_type_specification import CustomDataModelIdentifierTypeSpecification
from lusid.models.custom_data_model_property_specification import CustomDataModelPropertySpecification
from lusid.models.recommended_sort_by import RecommendedSortBy
from lusid.models.resource_id import ResourceId

class CreateCustomDataModelRequest(BaseModel):
    """
    CreateCustomDataModelRequest
    """
    id: ResourceId = Field(...)
    display_name:  StrictStr = Field(...,alias="displayName", description="The name of the Custom Data Model.") 
    description:  StrictStr = Field(...,alias="description", description="A description for the Custom Data Model.") 
    parent_data_model: Optional[ResourceId] = Field(None, alias="parentDataModel")
    conditions:  Optional[StrictStr] = Field(None,alias="conditions", description="The conditions that the bound entity must meet to be valid.") 
    properties: Optional[conlist(CustomDataModelPropertySpecification)] = Field(None, description="The properties that are required or allowed on the bound entity.")
    identifier_types: Optional[conlist(CustomDataModelIdentifierTypeSpecification)] = Field(None, alias="identifierTypes", description="The identifier types that are required or allowed on the bound entity.")
    attribute_aliases: Optional[conlist(Alias)] = Field(None, alias="attributeAliases", description="The aliases for property keys, identifier types, and fields on the bound entity.")
    recommended_sort_by: Optional[conlist(RecommendedSortBy)] = Field(None, alias="recommendedSortBy", description="The preferred default sorting instructions.")
    __properties = ["id", "displayName", "description", "parentDataModel", "conditions", "properties", "identifierTypes", "attributeAliases", "recommendedSortBy"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateCustomDataModelRequest:
        """Create an instance of CreateCustomDataModelRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent_data_model
        if self.parent_data_model:
            _dict['parentDataModel'] = self.parent_data_model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item in self.properties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['properties'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in identifier_types (list)
        _items = []
        if self.identifier_types:
            for _item in self.identifier_types:
                if _item:
                    _items.append(_item.to_dict())
            _dict['identifierTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attribute_aliases (list)
        _items = []
        if self.attribute_aliases:
            for _item in self.attribute_aliases:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributeAliases'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in recommended_sort_by (list)
        _items = []
        if self.recommended_sort_by:
            for _item in self.recommended_sort_by:
                if _item:
                    _items.append(_item.to_dict())
            _dict['recommendedSortBy'] = _items
        # set to None if conditions (nullable) is None
        # and __fields_set__ contains the field
        if self.conditions is None and "conditions" in self.__fields_set__:
            _dict['conditions'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if identifier_types (nullable) is None
        # and __fields_set__ contains the field
        if self.identifier_types is None and "identifier_types" in self.__fields_set__:
            _dict['identifierTypes'] = None

        # set to None if attribute_aliases (nullable) is None
        # and __fields_set__ contains the field
        if self.attribute_aliases is None and "attribute_aliases" in self.__fields_set__:
            _dict['attributeAliases'] = None

        # set to None if recommended_sort_by (nullable) is None
        # and __fields_set__ contains the field
        if self.recommended_sort_by is None and "recommended_sort_by" in self.__fields_set__:
            _dict['recommendedSortBy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateCustomDataModelRequest:
        """Create an instance of CreateCustomDataModelRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateCustomDataModelRequest.parse_obj(obj)

        _obj = CreateCustomDataModelRequest.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "parent_data_model": ResourceId.from_dict(obj.get("parentDataModel")) if obj.get("parentDataModel") is not None else None,
            "conditions": obj.get("conditions"),
            "properties": [CustomDataModelPropertySpecification.from_dict(_item) for _item in obj.get("properties")] if obj.get("properties") is not None else None,
            "identifier_types": [CustomDataModelIdentifierTypeSpecification.from_dict(_item) for _item in obj.get("identifierTypes")] if obj.get("identifierTypes") is not None else None,
            "attribute_aliases": [Alias.from_dict(_item) for _item in obj.get("attributeAliases")] if obj.get("attributeAliases") is not None else None,
            "recommended_sort_by": [RecommendedSortBy.from_dict(_item) for _item in obj.get("recommendedSortBy")] if obj.get("recommendedSortBy") is not None else None
        })
        return _obj
