# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist 
from lusid.models.membership import Membership
from lusid.models.membership_and_status import MembershipAndStatus

class DataModelMembership(BaseModel):
    """
    DataModelMembership
    """
    membership: conlist(Membership) = Field(..., description="The collection of data models this entity is a member of.")
    current_model: Optional[MembershipAndStatus] = Field(None, alias="currentModel")
    __properties = ["membership", "currentModel"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataModelMembership:
        """Create an instance of DataModelMembership from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in membership (list)
        _items = []
        if self.membership:
            for _item in self.membership:
                if _item:
                    _items.append(_item.to_dict())
            _dict['membership'] = _items
        # override the default output from pydantic by calling `to_dict()` of current_model
        if self.current_model:
            _dict['currentModel'] = self.current_model.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataModelMembership:
        """Create an instance of DataModelMembership from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataModelMembership.parse_obj(obj)

        _obj = DataModelMembership.parse_obj({
            "membership": [Membership.from_dict(_item) for _item in obj.get("membership")] if obj.get("membership") is not None else None,
            "current_model": MembershipAndStatus.from_dict(obj.get("currentModel")) if obj.get("currentModel") is not None else None
        })
        return _obj
