# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt 
from lusid.models.link import Link

class GroupReconciliationReviewStatuses(BaseModel):
    """
    GroupReconciliationReviewStatuses
    """
    count_pending: StrictInt = Field(..., alias="countPending", description="The number of comparison results of reviewStatus \"Pending\" with this instanceId and reconciliationType")
    link_pending: Link = Field(..., alias="linkPending")
    count_reviewed: StrictInt = Field(..., alias="countReviewed", description="The number of comparison results of reviewStatus \"Reviewed\" with this instanceId and reconciliationType")
    link_reviewed: Link = Field(..., alias="linkReviewed")
    count_matched: StrictInt = Field(..., alias="countMatched", description="The number of comparison results of reviewStatus \"Matched\" with this instanceId and reconciliationType")
    link_matched: Link = Field(..., alias="linkMatched")
    count_invalid: StrictInt = Field(..., alias="countInvalid", description="The number of comparison results of reviewStatus \"Invalid\" with this instanceId and reconciliationType")
    link_invalid: Link = Field(..., alias="linkInvalid")
    __properties = ["countPending", "linkPending", "countReviewed", "linkReviewed", "countMatched", "linkMatched", "countInvalid", "linkInvalid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GroupReconciliationReviewStatuses:
        """Create an instance of GroupReconciliationReviewStatuses from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of link_pending
        if self.link_pending:
            _dict['linkPending'] = self.link_pending.to_dict()
        # override the default output from pydantic by calling `to_dict()` of link_reviewed
        if self.link_reviewed:
            _dict['linkReviewed'] = self.link_reviewed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of link_matched
        if self.link_matched:
            _dict['linkMatched'] = self.link_matched.to_dict()
        # override the default output from pydantic by calling `to_dict()` of link_invalid
        if self.link_invalid:
            _dict['linkInvalid'] = self.link_invalid.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GroupReconciliationReviewStatuses:
        """Create an instance of GroupReconciliationReviewStatuses from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GroupReconciliationReviewStatuses.parse_obj(obj)

        _obj = GroupReconciliationReviewStatuses.parse_obj({
            "count_pending": obj.get("countPending"),
            "link_pending": Link.from_dict(obj.get("linkPending")) if obj.get("linkPending") is not None else None,
            "count_reviewed": obj.get("countReviewed"),
            "link_reviewed": Link.from_dict(obj.get("linkReviewed")) if obj.get("linkReviewed") is not None else None,
            "count_matched": obj.get("countMatched"),
            "link_matched": Link.from_dict(obj.get("linkMatched")) if obj.get("linkMatched") is not None else None,
            "count_invalid": obj.get("countInvalid"),
            "link_invalid": Link.from_dict(obj.get("linkInvalid")) if obj.get("linkInvalid") is not None else None
        })
        return _obj
