# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, StrictStr, constr 
from lusid.models.quantity_instructed import QuantityInstructed

class InstrumentEventInstructionRequest(BaseModel):
    """
    The request to create an instruction for an instrument event  # noqa: E501
    """
    instrument_event_instruction_id:  StrictStr = Field(...,alias="instrumentEventInstructionId", description="The unique identifier for this instruction") 
    instrument_event_id:  StrictStr = Field(...,alias="instrumentEventId", description="The identifier of the instrument event being instructed") 
    instruction_type:  StrictStr = Field(...,alias="instructionType", description="The type of instruction (Ignore, ElectForPortfolio, ElectForHolding)") 
    election_key:  Optional[StrictStr] = Field(None,alias="electionKey", description="For elected instructions, the key to be chosen") 
    holding_id: Optional[StrictInt] = Field(None, alias="holdingId", description="For holding instructions, the id of the holding for which the instruction will apply")
    entitlement_date_instructed: Optional[datetime] = Field(None, alias="entitlementDateInstructed", description="The instructed entitlement date for the event (where none is set on the event itself)")
    quantity_instructed: Optional[QuantityInstructed] = Field(None, alias="quantityInstructed")
    tax_lot_id:  Optional[StrictStr] = Field(None,alias="taxLotId", description="For loan facility holding instructions, the tax lot id of the holding for which the instruction will apply") 
    __properties = ["instrumentEventInstructionId", "instrumentEventId", "instructionType", "electionKey", "holdingId", "entitlementDateInstructed", "quantityInstructed", "taxLotId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstrumentEventInstructionRequest:
        """Create an instance of InstrumentEventInstructionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of quantity_instructed
        if self.quantity_instructed:
            _dict['quantityInstructed'] = self.quantity_instructed.to_dict()
        # set to None if election_key (nullable) is None
        # and __fields_set__ contains the field
        if self.election_key is None and "election_key" in self.__fields_set__:
            _dict['electionKey'] = None

        # set to None if holding_id (nullable) is None
        # and __fields_set__ contains the field
        if self.holding_id is None and "holding_id" in self.__fields_set__:
            _dict['holdingId'] = None

        # set to None if entitlement_date_instructed (nullable) is None
        # and __fields_set__ contains the field
        if self.entitlement_date_instructed is None and "entitlement_date_instructed" in self.__fields_set__:
            _dict['entitlementDateInstructed'] = None

        # set to None if tax_lot_id (nullable) is None
        # and __fields_set__ contains the field
        if self.tax_lot_id is None and "tax_lot_id" in self.__fields_set__:
            _dict['taxLotId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstrumentEventInstructionRequest:
        """Create an instance of InstrumentEventInstructionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstrumentEventInstructionRequest.parse_obj(obj)

        _obj = InstrumentEventInstructionRequest.parse_obj({
            "instrument_event_instruction_id": obj.get("instrumentEventInstructionId"),
            "instrument_event_id": obj.get("instrumentEventId"),
            "instruction_type": obj.get("instructionType"),
            "election_key": obj.get("electionKey"),
            "holding_id": obj.get("holdingId"),
            "entitlement_date_instructed": obj.get("entitlementDateInstructed"),
            "quantity_instructed": QuantityInstructed.from_dict(obj.get("quantityInstructed")) if obj.get("quantityInstructed") is not None else None,
            "tax_lot_id": obj.get("taxLotId")
        })
        return _obj
