# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr 
from lusid.models.portfolio import Portfolio

class InvestmentPortfolio(BaseModel):
    """
    An Investment Portfolio of an Investment Account.  # noqa: E501
    """
    key:  Optional[StrictStr] = Field(None,alias="key", description="A client-defined key used to identify the Investment Portfolio, unique within the Investment Account") 
    scope:  Optional[StrictStr] = Field(None,alias="scope", description="The scope of the Investment Portfolio") 
    identifiers: Optional[Dict[str, StrictStr]] = Field(None, description="The code identifier of the Investment Portfolio")
    entity_unique_id:  Optional[StrictStr] = Field(None,alias="entityUniqueId", description="The unique Portfolio entity identifier") 
    portfolio: Optional[Portfolio] = None
    __properties = ["key", "scope", "identifiers", "entityUniqueId", "portfolio"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InvestmentPortfolio:
        """Create an instance of InvestmentPortfolio from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of portfolio
        if self.portfolio:
            _dict['portfolio'] = self.portfolio.to_dict()
        # set to None if key (nullable) is None
        # and __fields_set__ contains the field
        if self.key is None and "key" in self.__fields_set__:
            _dict['key'] = None

        # set to None if scope (nullable) is None
        # and __fields_set__ contains the field
        if self.scope is None and "scope" in self.__fields_set__:
            _dict['scope'] = None

        # set to None if identifiers (nullable) is None
        # and __fields_set__ contains the field
        if self.identifiers is None and "identifiers" in self.__fields_set__:
            _dict['identifiers'] = None

        # set to None if entity_unique_id (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_unique_id is None and "entity_unique_id" in self.__fields_set__:
            _dict['entityUniqueId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InvestmentPortfolio:
        """Create an instance of InvestmentPortfolio from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InvestmentPortfolio.parse_obj(obj)

        _obj = InvestmentPortfolio.parse_obj({
            "key": obj.get("key"),
            "scope": obj.get("scope"),
            "identifiers": obj.get("identifiers"),
            "entity_unique_id": obj.get("entityUniqueId"),
            "portfolio": Portfolio.from_dict(obj.get("portfolio")) if obj.get("portfolio") is not None else None
        })
        return _obj
