# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, constr 

class InvestorIdentifier(BaseModel):
    """
    Identification of an Investor on the LUSID API.  # noqa: E501
    """
    investor_type:  StrictStr = Field(...,alias="investorType", description="The type of the investor of the Investor Record. Can be either a Person or a LegalEntity") 
    identifiers: Optional[Dict[str, StrictStr]] = Field(None, description="Single identifier that should target the desired person or legal entity")
    __properties = ["investorType", "identifiers"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InvestorIdentifier:
        """Create an instance of InvestorIdentifier from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if identifiers (nullable) is None
        # and __fields_set__ contains the field
        if self.identifiers is None and "identifiers" in self.__fields_set__:
            _dict['identifiers'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InvestorIdentifier:
        """Create an instance of InvestorIdentifier from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InvestorIdentifier.parse_obj(obj)

        _obj = InvestorIdentifier.parse_obj({
            "investor_type": obj.get("investorType"),
            "identifiers": obj.get("identifiers")
        })
        return _obj
