# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, StrictStr 

class MovementSettlementSummary(BaseModel):
    """
    MovementSettlementSummary
    """
    name:  Optional[StrictStr] = Field(None,alias="name") 
    type:  Optional[StrictStr] = Field(None,alias="type") 
    lusid_instrument_id:  Optional[StrictStr] = Field(None,alias="lusidInstrumentId") 
    instrument_scope:  Optional[StrictStr] = Field(None,alias="instrumentScope") 
    settlement_mode:  Optional[StrictStr] = Field(None,alias="settlementMode") 
    contractual_settlement_date:  Optional[StrictStr] = Field(None,alias="contractualSettlementDate") 
    units: Optional[Union[StrictFloat, StrictInt]] = None
    settled_units: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="settledUnits")
    unsettled_units: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="unsettledUnits")
    overdue_units: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="overdueUnits")
    __properties = ["name", "type", "lusidInstrumentId", "instrumentScope", "settlementMode", "contractualSettlementDate", "units", "settledUnits", "unsettledUnits", "overdueUnits"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MovementSettlementSummary:
        """Create an instance of MovementSettlementSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if lusid_instrument_id (nullable) is None
        # and __fields_set__ contains the field
        if self.lusid_instrument_id is None and "lusid_instrument_id" in self.__fields_set__:
            _dict['lusidInstrumentId'] = None

        # set to None if instrument_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_scope is None and "instrument_scope" in self.__fields_set__:
            _dict['instrumentScope'] = None

        # set to None if settlement_mode (nullable) is None
        # and __fields_set__ contains the field
        if self.settlement_mode is None and "settlement_mode" in self.__fields_set__:
            _dict['settlementMode'] = None

        # set to None if contractual_settlement_date (nullable) is None
        # and __fields_set__ contains the field
        if self.contractual_settlement_date is None and "contractual_settlement_date" in self.__fields_set__:
            _dict['contractualSettlementDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MovementSettlementSummary:
        """Create an instance of MovementSettlementSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MovementSettlementSummary.parse_obj(obj)

        _obj = MovementSettlementSummary.parse_obj({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "lusid_instrument_id": obj.get("lusidInstrumentId"),
            "instrument_scope": obj.get("instrumentScope"),
            "settlement_mode": obj.get("settlementMode"),
            "contractual_settlement_date": obj.get("contractualSettlementDate"),
            "units": obj.get("units"),
            "settled_units": obj.get("settledUnits"),
            "unsettled_units": obj.get("unsettledUnits"),
            "overdue_units": obj.get("overdueUnits")
        })
        return _obj
