# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, constr 
from lusid.models.resource_id import ResourceId

class ReturnsEntity(BaseModel):
    """
    Returns entity, used for configuring the calculation of aggregated returns.  # noqa: E501
    """
    id: ResourceId = Field(...)
    recipe_id: Optional[ResourceId] = Field(None, alias="recipeId")
    recipe_entity:  Optional[StrictStr] = Field(None,alias="recipeEntity", description="Entity a recipe is retrieved from for use in the aggregated returns calculation. Either RecipeId or RecipeEntity must be specified.") 
    fee_handling:  Optional[StrictStr] = Field(None,alias="feeHandling", description="Configures how fees are handled in the aggregated returns calculation.") 
    flow_handling:  Optional[StrictStr] = Field(None,alias="flowHandling", description="Configures how flows are handled in the aggregated returns calculation.") 
    business_calendar:  Optional[StrictStr] = Field(None,alias="businessCalendar", description="Calendar used in the aggregated returns calculation.") 
    handle_flow_discrepancy:  Optional[StrictStr] = Field(None,alias="handleFlowDiscrepancy", description="Configures handling for the case where net flows do not match the sum of tagged flows.") 
    __properties = ["id", "recipeId", "recipeEntity", "feeHandling", "flowHandling", "businessCalendar", "handleFlowDiscrepancy"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReturnsEntity:
        """Create an instance of ReturnsEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of recipe_id
        if self.recipe_id:
            _dict['recipeId'] = self.recipe_id.to_dict()
        # set to None if recipe_entity (nullable) is None
        # and __fields_set__ contains the field
        if self.recipe_entity is None and "recipe_entity" in self.__fields_set__:
            _dict['recipeEntity'] = None

        # set to None if fee_handling (nullable) is None
        # and __fields_set__ contains the field
        if self.fee_handling is None and "fee_handling" in self.__fields_set__:
            _dict['feeHandling'] = None

        # set to None if flow_handling (nullable) is None
        # and __fields_set__ contains the field
        if self.flow_handling is None and "flow_handling" in self.__fields_set__:
            _dict['flowHandling'] = None

        # set to None if business_calendar (nullable) is None
        # and __fields_set__ contains the field
        if self.business_calendar is None and "business_calendar" in self.__fields_set__:
            _dict['businessCalendar'] = None

        # set to None if handle_flow_discrepancy (nullable) is None
        # and __fields_set__ contains the field
        if self.handle_flow_discrepancy is None and "handle_flow_discrepancy" in self.__fields_set__:
            _dict['handleFlowDiscrepancy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReturnsEntity:
        """Create an instance of ReturnsEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReturnsEntity.parse_obj(obj)

        _obj = ReturnsEntity.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "recipe_id": ResourceId.from_dict(obj.get("recipeId")) if obj.get("recipeId") is not None else None,
            "recipe_entity": obj.get("recipeEntity"),
            "fee_handling": obj.get("feeHandling"),
            "flow_handling": obj.get("flowHandling"),
            "business_calendar": obj.get("businessCalendar"),
            "handle_flow_discrepancy": obj.get("handleFlowDiscrepancy")
        })
        return _obj
