# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conint, conlist 
from lusid.models.resource_id import ResourceId

class SettlementCycle(BaseModel):
    """
    The settlement cycle for an instrument  # noqa: E501
    """
    business_day_offset: conint(strict=True) = Field(..., alias="businessDayOffset")
    calendars: conlist(ResourceId) = Field(...)
    __properties = ["businessDayOffset", "calendars"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SettlementCycle:
        """Create an instance of SettlementCycle from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in calendars (list)
        _items = []
        if self.calendars:
            for _item in self.calendars:
                if _item:
                    _items.append(_item.to_dict())
            _dict['calendars'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SettlementCycle:
        """Create an instance of SettlementCycle from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SettlementCycle.parse_obj(obj)

        _obj = SettlementCycle.parse_obj({
            "business_day_offset": obj.get("businessDayOffset"),
            "calendars": [ResourceId.from_dict(_item) for _item in obj.get("calendars")] if obj.get("calendars") is not None else None
        })
        return _obj
