# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictInt, StrictStr 

class StagedModificationStagingRule(BaseModel):
    """
    StagedModificationStagingRule
    """
    staging_rule_set_id:  Optional[StrictStr] = Field(None,alias="stagingRuleSetId", description="System generated unique id for the staging rule set.") 
    rule_id:  Optional[StrictStr] = Field(None,alias="ruleId", description="The ID of the staging rule.") 
    required_approvals: Optional[StrictInt] = Field(None, alias="requiredApprovals", description="The number of approvals required. If left blank, one approval is needed.")
    current_user_can_decide: Optional[StrictBool] = Field(None, alias="currentUserCanDecide", description="True or False indicating whether the current user can make a decision on the staged modification.")
    __properties = ["stagingRuleSetId", "ruleId", "requiredApprovals", "currentUserCanDecide"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StagedModificationStagingRule:
        """Create an instance of StagedModificationStagingRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if staging_rule_set_id (nullable) is None
        # and __fields_set__ contains the field
        if self.staging_rule_set_id is None and "staging_rule_set_id" in self.__fields_set__:
            _dict['stagingRuleSetId'] = None

        # set to None if rule_id (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_id is None and "rule_id" in self.__fields_set__:
            _dict['ruleId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StagedModificationStagingRule:
        """Create an instance of StagedModificationStagingRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StagedModificationStagingRule.parse_obj(obj)

        _obj = StagedModificationStagingRule.parse_obj({
            "staging_rule_set_id": obj.get("stagingRuleSetId"),
            "rule_id": obj.get("ruleId"),
            "required_approvals": obj.get("requiredApprovals"),
            "current_user_can_decide": obj.get("currentUserCanDecide")
        })
        return _obj
