# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, StrictStr 

class TransactionSettlementMovement(BaseModel):
    """
    TransactionSettlementMovement
    """
    name:  Optional[StrictStr] = Field(None,alias="name", description="The movement name (optional)") 
    type:  Optional[StrictStr] = Field(None,alias="type", description="Movement types determine the impact of the movement on the holdings. The available values are: Settlement, Traded, StockMovement, FutureCash,  Commitment, Receivable, CashSettlement, CashForward, CashCommitment, CashReceivable, Accrual, CashAccrual, ForwardFx, CashFxForward, Carry, CarryAsPnl, VariationMargin, Capital, Fee, Deferred, CashDeferred.") 
    units: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The number of units for the movement.")
    direction: Optional[StrictInt] = Field(None, description=" A multiplier to apply to Transaction amounts; the values are -1 to indicate to reverse the signs and 1 to indicate to use the signed values from the Transaction directly. For a typical Transaction with unsigned values, 1 means increase, -1 means decrease")
    settlement_mode:  Optional[StrictStr] = Field(None,alias="settlementMode", description="The mode of settlement for the movement which can either be Internal or External. An Internal movement will settle automatically on the contractual settlement date using TransactionConfiguration. An External movement will be determined by portfolio configuration and settlement instruction.") 
    __properties = ["name", "type", "units", "direction", "settlementMode"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionSettlementMovement:
        """Create an instance of TransactionSettlementMovement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if settlement_mode (nullable) is None
        # and __fields_set__ contains the field
        if self.settlement_mode is None and "settlement_mode" in self.__fields_set__:
            _dict['settlementMode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionSettlementMovement:
        """Create an instance of TransactionSettlementMovement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionSettlementMovement.parse_obj(obj)

        _obj = TransactionSettlementMovement.parse_obj({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "units": obj.get("units"),
            "direction": obj.get("direction"),
            "settlement_mode": obj.get("settlementMode")
        })
        return _obj
