# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr, validator 

class TypedResourceId(BaseModel):
    """
    Represents the user-defined identifier for a Legal Entity or Person.  Users can define their own, scoped identifiers for Legal Entities and Persons using identifier properties.  For example,  when used to identify a Person, the identifier defined by Person/myScope/username would be represented as   {     \"idTypeScope\": \"myScope\",     \"idTypeCode\": \"username\",     \"code\": \"john_doe_001\"   }  # noqa: E501
    """
    id_type_scope:  StrictStr = Field(...,alias="idTypeScope", description="The scope of the identifier's (property) definition.") 
    id_type_code:  StrictStr = Field(...,alias="idTypeCode", description="The code of identifier's (property) definition. This describes what the identifier represents.  For a Person this might be a username, nationalInsuranceNumber or similar.  For a Legal Entity, this might be a registeredCompanyNumber or LEI.") 
    code:  StrictStr = Field(...,alias="code", description="The value of the user-defined identifier in respect of the entity.") 
    __properties = ["idTypeScope", "idTypeCode", "code"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TypedResourceId:
        """Create an instance of TypedResourceId from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TypedResourceId:
        """Create an instance of TypedResourceId from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TypedResourceId.parse_obj(obj)

        _obj = TypedResourceId.parse_obj({
            "id_type_scope": obj.get("idTypeScope"),
            "id_type_code": obj.get("idTypeCode"),
            "code": obj.get("code")
        })
        return _obj
