; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "Finessensual"
#define MyAppVersion "2025-2"
#define MyAppPublisher "Digital Manifold Waves"
#define MyAppURL "https://www.digmanwaves.net"
#define MyAppIconName "finessensual.ico"

[Setup]
PrivilegesRequired=none
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{4802B704-40E9-420B-B161-5825C3A3C989}}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultGroupName=Digital Manifold Waves\Finessensual
DefaultDirName={autopf64}\Digital Manifold Waves\Finessensual
LicenseFile=LICENSE.rtf
OutputDir=ISC Output
OutputBaseFilename=DMW-{#MyAppName}-{#MyAppVersion}
SetupIconFile={#MyAppIconName}
Compression=lzma
SolidCompression=yes
ArchitecturesAllowed=x64compatible
ArchitecturesInstallIn64BitMode=x64compatible

[Run]
FileName: "cmd.exe"; Parameters: "/C python3 -m pip install --upgrade pip"; Flags: runhidden
FileName: "cmd.exe"; Parameters: "/C pip install --upgrade openpyxl"; Flags: runhidden
Filename: "cmd.exe"; Parameters: "/C pip install --upgrade finessensual"; Flags: runhidden

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "dutch"; MessagesFile: "compiler:Languages\Dutch.isl"
Name: "french"; MessagesFile: "compiler:Languages\French.isl"
Name: "german"; MessagesFile: "compiler:Languages\German.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "finessensual.ico"; DestDir: "{app}"; Flags: ignoreversion

Source: "LICENSE.rtf"; DestDir: "{app}"; Flags: ignoreversion
Source: "README.rtf"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{commondesktop}\Finessensual";  Filename: "{code:GetFEScript}"; IconFilename: "{app}\finessensual.ico"; Tasks: desktopicon

[Registry]
Root: HKCU; Subkey: "Software\{#MyAppPublisher}"; Flags: uninsdeletekeyifempty;
Root: HKCU; Subkey: "Software\{#MyAppPublisher}\{#MyAppName}"; ValueType: "string"; ValueName: "Path"; ValueData: "{app}"; Flags: uninsdeletekey;
Root: HKCU; Subkey: "Software\{#MyAppPublisher}\{#MyAppName}"; ValueType: "string"; ValueName: "Version"; ValueData: "{#MyAppVersion}"; Flags: uninsdeletekey;

[Code]
function collectShellOutput( command: String ): String;
var
  TmpFileName, xFileName: String;
  Output: AnsiString;
  ResultCode: Integer;
begin
  TmpFileName := ExpandConstant( '{tmp}\cmd_output.txt' );
  if Exec( 'cmd.exe', '/C ' + command + ' > ' + TmpFileName, '', SW_HIDE, ewWaitUntilTerminated, ResultCode) then
  begin
    if LoadStringFromfile( TmpFileName, Output ) then
      Result := Trim(Output)
    else
      MsgBox( 'Internal Error 1: contact Walter Daems and mention this error number!', mbCriticalError, MB_OK );
  end 
  else
    MsgBox( 'Internal Error 2: contact Walter Daems and mention this error number!', mbCriticalError, MB_OK );
end;

function GetExe( exename: String ): String;
begin
  // Try common install paths or look in PATH
  Result := collectShellOutput( 'where ' + exename );
end;

function GetExeOnPath( exename: String; path: String ): String;
begin
  // Try common install paths or look in PATH
  Result := collectShellOutput( 'where /R ' + path + ' ' + exename );
end;

function InitializeSetup(): Boolean;
var
  soffice: String;
begin
  Result := True;
  soffice := ExpandConstant( '{commonpf64}\LibreOffice\program\soffice.exe' );
  if not FileExists( soffice ) then
  begin
    MsgBox( 'LibreOffice is not found on  your system. Install it first.', mbCriticalError, MB_OK );
    Result := False;
  end;
  
  if GetExe( 'pip3.exe' ) = '' then
  begin
    MsgBox( 'Python is not found on your system. Install it first and make sure python3.exe and pip3.exe are on your %PATH%.', mbCriticalError, MB_OK );
    Result:= False;
  end;
end;

function GetFEScript( Param: String ): String;
var 
  Path: String;
begin
  Result := collectShellOutput( 'where finessensual' );
end;
