# ----------------------------------------------------------------------------
#
#  Welcome to Baml! To use this generated code, please run the following:
#
#  $ pip install baml
#
# ----------------------------------------------------------------------------

# This file was generated by BAML: please do not edit it. Instead, edit the
# BAML files and re-generate this code using: baml-cli generate
# baml-cli is available with the baml package.

import typing
import typing_extensions
from enum import Enum


from pydantic import BaseModel, ConfigDict


import baml_py

CheckT = typing_extensions.TypeVar("CheckT")
CheckName = typing_extensions.TypeVar("CheckName", bound=str)


class Check(BaseModel):
    name: str
    expression: str
    status: str


class Checked(BaseModel, typing.Generic[CheckT, CheckName]):
    value: CheckT
    checks: typing.Dict[CheckName, Check]


def get_checks(checks: typing.Dict[CheckName, Check]) -> typing.List[Check]:
    return list(checks.values())


def all_succeeded(checks: typing.Dict[CheckName, Check]) -> bool:
    return all(check.status == "succeeded" for check in get_checks(checks))


# #########################################################################
# Generated enums (0)
# #########################################################################

# #########################################################################
# Generated classes (17)
# #########################################################################


class AudioContent(BaseModel):
    type: str
    subclass: typing.List[str]


class ContentLabel(BaseModel):
    content_type: typing.Union[
        typing_extensions.Literal["text"],
        typing_extensions.Literal["audio"],
        typing_extensions.Literal["image"],
        typing_extensions.Literal["video"],
        typing_extensions.Literal["multimedia"],
        typing_extensions.Literal["3d_model"],
        typing_extensions.Literal["procedural"],
    ]
    type: str
    subclass: typing.List[str]


class DefaultContentPrediction(BaseModel):
    label: "ContentLabel"


class DynamicKnowledgeGraph(BaseModel):
    model_config = ConfigDict(extra="allow")


class Edge(BaseModel):
    # doc string for edge
    # doc string for source_node_id

    source_node_id: str
    target_node_id: str
    relationship_name: str


class ImageContent(BaseModel):
    type: str
    subclass: typing.List[str]


class KnowledgeGraph(BaseModel):
    nodes: typing.List["Node"]
    edges: typing.List["Edge"]


class Model3DContent(BaseModel):
    type: str
    subclass: typing.List[str]


class MultimediaContent(BaseModel):
    type: str
    subclass: typing.List[str]


class Node(BaseModel):
    model_config = ConfigDict(extra="allow")
    id: str
    name: str
    type: str
    description: str


class ProceduralContent(BaseModel):
    type: str
    subclass: typing.List[str]


class SummarizedClass(BaseModel):
    name: str
    description: str
    methods: typing.Optional[typing.List["SummarizedFunction"]] = None
    decorators: typing.Optional[typing.List[str]] = None


class SummarizedCode(BaseModel):
    high_level_summary: str
    key_features: typing.List[str]
    imports: typing.List[str]
    constants: typing.List[str]
    classes: typing.List["SummarizedClass"]
    functions: typing.List["SummarizedFunction"]
    workflow_description: typing.Optional[str] = None


class SummarizedContent(BaseModel):
    summary: str
    description: str


class SummarizedFunction(BaseModel):
    name: str
    description: str
    inputs: typing.Optional[typing.List[str]] = None
    outputs: typing.Optional[typing.List[str]] = None
    decorators: typing.Optional[typing.List[str]] = None


class TextContent(BaseModel):
    type: str
    subclass: typing.List[str]


class VideoContent(BaseModel):
    type: str
    subclass: typing.List[str]


# #########################################################################
# Generated type aliases (0)
# #########################################################################
