# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BookmarkArgs', 'Bookmark']

@pulumi.input_type
class BookmarkArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 request_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Bookmark resource.
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] url: The URL of the bookmark.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.str] authentication_policy: The ID of the associated app*signon*policy. If this property is removed from the application the default sign-on-policy will be associated with this application.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.bool] request_integration: Would you like Okta to add an integration for this app?
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "url", url)
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if authentication_policy is not None:
            pulumi.set(__self__, "authentication_policy", authentication_policy)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if request_integration is not None:
            pulumi.set(__self__, "request_integration", request_integration)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the bookmark.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable self service. Default is `false`
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_note", value)

    @_builtins.property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_links_json", value)

    @_builtins.property
    @pulumi.getter(name="authenticationPolicy")
    def authentication_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated app*signon*policy. If this property is removed from the application the default sign-on-policy will be associated with this application.
        """
        return pulumi.get(self, "authentication_policy")

    @authentication_policy.setter
    def authentication_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_policy", value)

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enduser_note", value)

    @_builtins.property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_ios", value)

    @_builtins.property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_web", value)

    @_builtins.property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo", value)

    @_builtins.property
    @pulumi.getter(name="requestIntegration")
    def request_integration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Would you like Okta to add an integration for this app?
        """
        return pulumi.get(self, "request_integration")

    @request_integration.setter
    def request_integration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "request_integration", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of application. By default, it is `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _BookmarkState:
    def __init__(__self__, *,
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 logo_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 sign_on_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Bookmark resources.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.str] authentication_policy: The ID of the associated app*signon*policy. If this property is removed from the application the default sign-on-policy will be associated with this application.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.str] logo_url: URL of the application's logo
        :param pulumi.Input[_builtins.str] name: Name of the app.
        :param pulumi.Input[_builtins.bool] request_integration: Would you like Okta to add an integration for this app?
        :param pulumi.Input[_builtins.str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url: The URL of the bookmark.
        """
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if authentication_policy is not None:
            pulumi.set(__self__, "authentication_policy", authentication_policy)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_integration is not None:
            pulumi.set(__self__, "request_integration", request_integration)
        if sign_on_mode is not None:
            pulumi.set(__self__, "sign_on_mode", sign_on_mode)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable self service. Default is `false`
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_note", value)

    @_builtins.property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_links_json", value)

    @_builtins.property
    @pulumi.getter(name="authenticationPolicy")
    def authentication_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated app*signon*policy. If this property is removed from the application the default sign-on-policy will be associated with this application.
        """
        return pulumi.get(self, "authentication_policy")

    @authentication_policy.setter
    def authentication_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_policy", value)

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enduser_note", value)

    @_builtins.property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_ios", value)

    @_builtins.property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_web", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo", value)

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="requestIntegration")
    def request_integration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Would you like Okta to add an integration for this app?
        """
        return pulumi.get(self, "request_integration")

    @request_integration.setter
    def request_integration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "request_integration", value)

    @_builtins.property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @sign_on_mode.setter
    def sign_on_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sign_on_mode", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of application. By default, it is `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the bookmark.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("okta:app/bookmark:Bookmark")
class Bookmark(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 request_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and configure a Bookmark Application.
        > During an apply if there is change in status the app will first be
        activated or deactivated in accordance with the status change. Then, all
        other arguments that changed will be applied.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.app.Bookmark("example",
            label="Example",
            url="https://example.com")
        ```

        ## Import

        ```sh
        $ pulumi import okta:app/bookmark:Bookmark example <app_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.str] authentication_policy: The ID of the associated app*signon*policy. If this property is removed from the application the default sign-on-policy will be associated with this application.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.bool] request_integration: Would you like Okta to add an integration for this app?
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url: The URL of the bookmark.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BookmarkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and configure a Bookmark Application.
        > During an apply if there is change in status the app will first be
        activated or deactivated in accordance with the status change. Then, all
        other arguments that changed will be applied.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.app.Bookmark("example",
            label="Example",
            url="https://example.com")
        ```

        ## Import

        ```sh
        $ pulumi import okta:app/bookmark:Bookmark example <app_id>
        ```

        :param str resource_name: The name of the resource.
        :param BookmarkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BookmarkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 request_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BookmarkArgs.__new__(BookmarkArgs)

            __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
            __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
            __props__.__dict__["accessibility_self_service"] = accessibility_self_service
            __props__.__dict__["admin_note"] = admin_note
            __props__.__dict__["app_links_json"] = app_links_json
            __props__.__dict__["authentication_policy"] = authentication_policy
            __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
            __props__.__dict__["enduser_note"] = enduser_note
            __props__.__dict__["hide_ios"] = hide_ios
            __props__.__dict__["hide_web"] = hide_web
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["logo"] = logo
            __props__.__dict__["request_integration"] = request_integration
            __props__.__dict__["status"] = status
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["logo_url"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["sign_on_mode"] = None
        super(Bookmark, __self__).__init__(
            'okta:app/bookmark:Bookmark',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
            admin_note: Optional[pulumi.Input[_builtins.str]] = None,
            app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_policy: Optional[pulumi.Input[_builtins.str]] = None,
            auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
            enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
            hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
            hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            logo: Optional[pulumi.Input[_builtins.str]] = None,
            logo_url: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            request_integration: Optional[pulumi.Input[_builtins.bool]] = None,
            sign_on_mode: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Bookmark':
        """
        Get an existing Bookmark resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.str] authentication_policy: The ID of the associated app*signon*policy. If this property is removed from the application the default sign-on-policy will be associated with this application.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.str] logo_url: URL of the application's logo
        :param pulumi.Input[_builtins.str] name: Name of the app.
        :param pulumi.Input[_builtins.bool] request_integration: Would you like Okta to add an integration for this app?
        :param pulumi.Input[_builtins.str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url: The URL of the bookmark.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BookmarkState.__new__(_BookmarkState)

        __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
        __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
        __props__.__dict__["accessibility_self_service"] = accessibility_self_service
        __props__.__dict__["admin_note"] = admin_note
        __props__.__dict__["app_links_json"] = app_links_json
        __props__.__dict__["authentication_policy"] = authentication_policy
        __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
        __props__.__dict__["enduser_note"] = enduser_note
        __props__.__dict__["hide_ios"] = hide_ios
        __props__.__dict__["hide_web"] = hide_web
        __props__.__dict__["label"] = label
        __props__.__dict__["logo"] = logo
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["name"] = name
        __props__.__dict__["request_integration"] = request_integration
        __props__.__dict__["sign_on_mode"] = sign_on_mode
        __props__.__dict__["status"] = status
        __props__.__dict__["url"] = url
        return Bookmark(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @_builtins.property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @_builtins.property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable self service. Default is `false`
        """
        return pulumi.get(self, "accessibility_self_service")

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @_builtins.property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @_builtins.property
    @pulumi.getter(name="authenticationPolicy")
    def authentication_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated app*signon*policy. If this property is removed from the application the default sign-on-policy will be associated with this application.
        """
        return pulumi.get(self, "authentication_policy")

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @_builtins.property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @_builtins.property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="requestIntegration")
    def request_integration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Would you like Okta to add an integration for this app?
        """
        return pulumi.get(self, "request_integration")

    @_builtins.property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Status of application. By default, it is `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the bookmark.
        """
        return pulumi.get(self, "url")

