# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ThreeFieldArgs', 'ThreeField']

@pulumi.input_type
class ThreeFieldArgs:
    def __init__(__self__, *,
                 button_selector: pulumi.Input[_builtins.str],
                 extra_field_selector: pulumi.Input[_builtins.str],
                 extra_field_value: pulumi.Input[_builtins.str],
                 label: pulumi.Input[_builtins.str],
                 password_selector: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 username_selector: pulumi.Input[_builtins.str],
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_password: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_username: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ThreeField resource.
        :param pulumi.Input[_builtins.str] button_selector: Login button field CSS selector
        :param pulumi.Input[_builtins.str] extra_field_selector: Extra field CSS selector
        :param pulumi.Input[_builtins.str] extra_field_value: Value for extra form field
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] password_selector: Login password field CSS selector
        :param pulumi.Input[_builtins.str] url: Login URL
        :param pulumi.Input[_builtins.str] username_selector: Login username field CSS selector
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] credentials_scheme: Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.bool] reveal_password: Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        :param pulumi.Input[_builtins.str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[_builtins.str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url_regex: A regex that further restricts URL to the specified regex
        :param pulumi.Input[_builtins.str] user_name_template: Username template. Default: `${source.login}`
        :param pulumi.Input[_builtins.str] user_name_template_push_status: Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        :param pulumi.Input[_builtins.str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[_builtins.str] user_name_template_type: Username template type. Default: `BUILT_IN`
        """
        pulumi.set(__self__, "button_selector", button_selector)
        pulumi.set(__self__, "extra_field_selector", extra_field_selector)
        pulumi.set(__self__, "extra_field_value", extra_field_value)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "password_selector", password_selector)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username_selector", username_selector)
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if credentials_scheme is not None:
            pulumi.set(__self__, "credentials_scheme", credentials_scheme)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if reveal_password is not None:
            pulumi.set(__self__, "reveal_password", reveal_password)
        if shared_password is not None:
            pulumi.set(__self__, "shared_password", shared_password)
        if shared_username is not None:
            pulumi.set(__self__, "shared_username", shared_username)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url_regex is not None:
            pulumi.set(__self__, "url_regex", url_regex)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)

    @_builtins.property
    @pulumi.getter(name="buttonSelector")
    def button_selector(self) -> pulumi.Input[_builtins.str]:
        """
        Login button field CSS selector
        """
        return pulumi.get(self, "button_selector")

    @button_selector.setter
    def button_selector(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "button_selector", value)

    @_builtins.property
    @pulumi.getter(name="extraFieldSelector")
    def extra_field_selector(self) -> pulumi.Input[_builtins.str]:
        """
        Extra field CSS selector
        """
        return pulumi.get(self, "extra_field_selector")

    @extra_field_selector.setter
    def extra_field_selector(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "extra_field_selector", value)

    @_builtins.property
    @pulumi.getter(name="extraFieldValue")
    def extra_field_value(self) -> pulumi.Input[_builtins.str]:
        """
        Value for extra form field
        """
        return pulumi.get(self, "extra_field_value")

    @extra_field_value.setter
    def extra_field_value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "extra_field_value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="passwordSelector")
    def password_selector(self) -> pulumi.Input[_builtins.str]:
        """
        Login password field CSS selector
        """
        return pulumi.get(self, "password_selector")

    @password_selector.setter
    def password_selector(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password_selector", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        Login URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="usernameSelector")
    def username_selector(self) -> pulumi.Input[_builtins.str]:
        """
        Login username field CSS selector
        """
        return pulumi.get(self, "username_selector")

    @username_selector.setter
    def username_selector(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username_selector", value)

    @_builtins.property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable self service. Default is `false`
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_note", value)

    @_builtins.property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_links_json", value)

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @_builtins.property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        """
        return pulumi.get(self, "credentials_scheme")

    @credentials_scheme.setter
    def credentials_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_scheme", value)

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enduser_note", value)

    @_builtins.property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_ios", value)

    @_builtins.property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_web", value)

    @_builtins.property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo", value)

    @_builtins.property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        """
        return pulumi.get(self, "reveal_password")

    @reveal_password.setter
    def reveal_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reveal_password", value)

    @_builtins.property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @shared_password.setter
    def shared_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_password", value)

    @_builtins.property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @shared_username.setter
    def shared_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_username", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of application. By default, it is `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A regex that further restricts URL to the specified regex
        """
        return pulumi.get(self, "url_regex")

    @url_regex.setter
    def url_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_regex", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template. Default: `${source.login}`
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template type. Default: `BUILT_IN`
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_type", value)


@pulumi.input_type
class _ThreeFieldState:
    def __init__(__self__, *,
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 button_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_field_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_field_value: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 logo_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_password: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_username: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_on_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 url_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username_selector: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ThreeField resources.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] button_selector: Login button field CSS selector
        :param pulumi.Input[_builtins.str] credentials_scheme: Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.str] extra_field_selector: Extra field CSS selector
        :param pulumi.Input[_builtins.str] extra_field_value: Value for extra form field
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.str] logo_url: URL of the application's logo
        :param pulumi.Input[_builtins.str] name: Name of the app.
        :param pulumi.Input[_builtins.str] password_selector: Login password field CSS selector
        :param pulumi.Input[_builtins.bool] reveal_password: Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        :param pulumi.Input[_builtins.str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[_builtins.str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[_builtins.str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url: Login URL
        :param pulumi.Input[_builtins.str] url_regex: A regex that further restricts URL to the specified regex
        :param pulumi.Input[_builtins.str] user_name_template: Username template. Default: `${source.login}`
        :param pulumi.Input[_builtins.str] user_name_template_push_status: Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        :param pulumi.Input[_builtins.str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[_builtins.str] user_name_template_type: Username template type. Default: `BUILT_IN`
        :param pulumi.Input[_builtins.str] username_selector: Login username field CSS selector
        """
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if button_selector is not None:
            pulumi.set(__self__, "button_selector", button_selector)
        if credentials_scheme is not None:
            pulumi.set(__self__, "credentials_scheme", credentials_scheme)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if extra_field_selector is not None:
            pulumi.set(__self__, "extra_field_selector", extra_field_selector)
        if extra_field_value is not None:
            pulumi.set(__self__, "extra_field_value", extra_field_value)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_selector is not None:
            pulumi.set(__self__, "password_selector", password_selector)
        if reveal_password is not None:
            pulumi.set(__self__, "reveal_password", reveal_password)
        if shared_password is not None:
            pulumi.set(__self__, "shared_password", shared_password)
        if shared_username is not None:
            pulumi.set(__self__, "shared_username", shared_username)
        if sign_on_mode is not None:
            pulumi.set(__self__, "sign_on_mode", sign_on_mode)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if url_regex is not None:
            pulumi.set(__self__, "url_regex", url_regex)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)
        if username_selector is not None:
            pulumi.set(__self__, "username_selector", username_selector)

    @_builtins.property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable self service. Default is `false`
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_note", value)

    @_builtins.property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_links_json", value)

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @_builtins.property
    @pulumi.getter(name="buttonSelector")
    def button_selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login button field CSS selector
        """
        return pulumi.get(self, "button_selector")

    @button_selector.setter
    def button_selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "button_selector", value)

    @_builtins.property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        """
        return pulumi.get(self, "credentials_scheme")

    @credentials_scheme.setter
    def credentials_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_scheme", value)

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enduser_note", value)

    @_builtins.property
    @pulumi.getter(name="extraFieldSelector")
    def extra_field_selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Extra field CSS selector
        """
        return pulumi.get(self, "extra_field_selector")

    @extra_field_selector.setter
    def extra_field_selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extra_field_selector", value)

    @_builtins.property
    @pulumi.getter(name="extraFieldValue")
    def extra_field_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value for extra form field
        """
        return pulumi.get(self, "extra_field_value")

    @extra_field_value.setter
    def extra_field_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extra_field_value", value)

    @_builtins.property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_ios", value)

    @_builtins.property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_web", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo", value)

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="passwordSelector")
    def password_selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login password field CSS selector
        """
        return pulumi.get(self, "password_selector")

    @password_selector.setter
    def password_selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_selector", value)

    @_builtins.property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        """
        return pulumi.get(self, "reveal_password")

    @reveal_password.setter
    def reveal_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reveal_password", value)

    @_builtins.property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @shared_password.setter
    def shared_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_password", value)

    @_builtins.property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @shared_username.setter
    def shared_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_username", value)

    @_builtins.property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @sign_on_mode.setter
    def sign_on_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sign_on_mode", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of application. By default, it is `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A regex that further restricts URL to the specified regex
        """
        return pulumi.get(self, "url_regex")

    @url_regex.setter
    def url_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_regex", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template. Default: `${source.login}`
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template type. Default: `BUILT_IN`
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_type", value)

    @_builtins.property
    @pulumi.getter(name="usernameSelector")
    def username_selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login username field CSS selector
        """
        return pulumi.get(self, "username_selector")

    @username_selector.setter
    def username_selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username_selector", value)


@pulumi.type_token("okta:app/threeField:ThreeField")
class ThreeField(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 button_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_field_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_field_value: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 password_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_password: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_username: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 url_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a Three Field Application.
        		This resource allows you to create and configure a Three Field Application.
        		> During an apply if there is change in 'status' the app will first be
        		activated or deactivated in accordance with the 'status' change. Then, all
        		other arguments that changed will be applied.

        ## Import

        ```sh
        $ pulumi import okta:app/threeField:ThreeField example <app_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] button_selector: Login button field CSS selector
        :param pulumi.Input[_builtins.str] credentials_scheme: Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.str] extra_field_selector: Extra field CSS selector
        :param pulumi.Input[_builtins.str] extra_field_value: Value for extra form field
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.str] password_selector: Login password field CSS selector
        :param pulumi.Input[_builtins.bool] reveal_password: Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        :param pulumi.Input[_builtins.str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[_builtins.str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url: Login URL
        :param pulumi.Input[_builtins.str] url_regex: A regex that further restricts URL to the specified regex
        :param pulumi.Input[_builtins.str] user_name_template: Username template. Default: `${source.login}`
        :param pulumi.Input[_builtins.str] user_name_template_push_status: Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        :param pulumi.Input[_builtins.str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[_builtins.str] user_name_template_type: Username template type. Default: `BUILT_IN`
        :param pulumi.Input[_builtins.str] username_selector: Login username field CSS selector
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThreeFieldArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Three Field Application.
        		This resource allows you to create and configure a Three Field Application.
        		> During an apply if there is change in 'status' the app will first be
        		activated or deactivated in accordance with the 'status' change. Then, all
        		other arguments that changed will be applied.

        ## Import

        ```sh
        $ pulumi import okta:app/threeField:ThreeField example <app_id>
        ```

        :param str resource_name: The name of the resource.
        :param ThreeFieldArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThreeFieldArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 button_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_field_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_field_value: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 password_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_password: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_username: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 url_regex: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThreeFieldArgs.__new__(ThreeFieldArgs)

            __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
            __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
            __props__.__dict__["accessibility_self_service"] = accessibility_self_service
            __props__.__dict__["admin_note"] = admin_note
            __props__.__dict__["app_links_json"] = app_links_json
            __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
            if button_selector is None and not opts.urn:
                raise TypeError("Missing required property 'button_selector'")
            __props__.__dict__["button_selector"] = button_selector
            __props__.__dict__["credentials_scheme"] = credentials_scheme
            __props__.__dict__["enduser_note"] = enduser_note
            if extra_field_selector is None and not opts.urn:
                raise TypeError("Missing required property 'extra_field_selector'")
            __props__.__dict__["extra_field_selector"] = extra_field_selector
            if extra_field_value is None and not opts.urn:
                raise TypeError("Missing required property 'extra_field_value'")
            __props__.__dict__["extra_field_value"] = extra_field_value
            __props__.__dict__["hide_ios"] = hide_ios
            __props__.__dict__["hide_web"] = hide_web
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["logo"] = logo
            if password_selector is None and not opts.urn:
                raise TypeError("Missing required property 'password_selector'")
            __props__.__dict__["password_selector"] = password_selector
            __props__.__dict__["reveal_password"] = reveal_password
            __props__.__dict__["shared_password"] = shared_password
            __props__.__dict__["shared_username"] = shared_username
            __props__.__dict__["status"] = status
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["url_regex"] = url_regex
            __props__.__dict__["user_name_template"] = user_name_template
            __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
            __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
            __props__.__dict__["user_name_template_type"] = user_name_template_type
            if username_selector is None and not opts.urn:
                raise TypeError("Missing required property 'username_selector'")
            __props__.__dict__["username_selector"] = username_selector
            __props__.__dict__["logo_url"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["sign_on_mode"] = None
        super(ThreeField, __self__).__init__(
            'okta:app/threeField:ThreeField',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
            admin_note: Optional[pulumi.Input[_builtins.str]] = None,
            app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
            auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
            button_selector: Optional[pulumi.Input[_builtins.str]] = None,
            credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
            enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
            extra_field_selector: Optional[pulumi.Input[_builtins.str]] = None,
            extra_field_value: Optional[pulumi.Input[_builtins.str]] = None,
            hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
            hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            logo: Optional[pulumi.Input[_builtins.str]] = None,
            logo_url: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password_selector: Optional[pulumi.Input[_builtins.str]] = None,
            reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
            shared_password: Optional[pulumi.Input[_builtins.str]] = None,
            shared_username: Optional[pulumi.Input[_builtins.str]] = None,
            sign_on_mode: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            url_regex: Optional[pulumi.Input[_builtins.str]] = None,
            user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
            user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
            user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None,
            username_selector: Optional[pulumi.Input[_builtins.str]] = None) -> 'ThreeField':
        """
        Get an existing ThreeField resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] button_selector: Login button field CSS selector
        :param pulumi.Input[_builtins.str] credentials_scheme: Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.str] extra_field_selector: Extra field CSS selector
        :param pulumi.Input[_builtins.str] extra_field_value: Value for extra form field
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.str] logo_url: URL of the application's logo
        :param pulumi.Input[_builtins.str] name: Name of the app.
        :param pulumi.Input[_builtins.str] password_selector: Login password field CSS selector
        :param pulumi.Input[_builtins.bool] reveal_password: Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        :param pulumi.Input[_builtins.str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[_builtins.str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[_builtins.str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url: Login URL
        :param pulumi.Input[_builtins.str] url_regex: A regex that further restricts URL to the specified regex
        :param pulumi.Input[_builtins.str] user_name_template: Username template. Default: `${source.login}`
        :param pulumi.Input[_builtins.str] user_name_template_push_status: Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        :param pulumi.Input[_builtins.str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[_builtins.str] user_name_template_type: Username template type. Default: `BUILT_IN`
        :param pulumi.Input[_builtins.str] username_selector: Login username field CSS selector
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThreeFieldState.__new__(_ThreeFieldState)

        __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
        __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
        __props__.__dict__["accessibility_self_service"] = accessibility_self_service
        __props__.__dict__["admin_note"] = admin_note
        __props__.__dict__["app_links_json"] = app_links_json
        __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
        __props__.__dict__["button_selector"] = button_selector
        __props__.__dict__["credentials_scheme"] = credentials_scheme
        __props__.__dict__["enduser_note"] = enduser_note
        __props__.__dict__["extra_field_selector"] = extra_field_selector
        __props__.__dict__["extra_field_value"] = extra_field_value
        __props__.__dict__["hide_ios"] = hide_ios
        __props__.__dict__["hide_web"] = hide_web
        __props__.__dict__["label"] = label
        __props__.__dict__["logo"] = logo
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["name"] = name
        __props__.__dict__["password_selector"] = password_selector
        __props__.__dict__["reveal_password"] = reveal_password
        __props__.__dict__["shared_password"] = shared_password
        __props__.__dict__["shared_username"] = shared_username
        __props__.__dict__["sign_on_mode"] = sign_on_mode
        __props__.__dict__["status"] = status
        __props__.__dict__["url"] = url
        __props__.__dict__["url_regex"] = url_regex
        __props__.__dict__["user_name_template"] = user_name_template
        __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
        __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
        __props__.__dict__["user_name_template_type"] = user_name_template_type
        __props__.__dict__["username_selector"] = username_selector
        return ThreeField(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @_builtins.property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @_builtins.property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable self service. Default is `false`
        """
        return pulumi.get(self, "accessibility_self_service")

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @_builtins.property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @_builtins.property
    @pulumi.getter(name="buttonSelector")
    def button_selector(self) -> pulumi.Output[_builtins.str]:
        """
        Login button field CSS selector
        """
        return pulumi.get(self, "button_selector")

    @_builtins.property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        """
        return pulumi.get(self, "credentials_scheme")

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @_builtins.property
    @pulumi.getter(name="extraFieldSelector")
    def extra_field_selector(self) -> pulumi.Output[_builtins.str]:
        """
        Extra field CSS selector
        """
        return pulumi.get(self, "extra_field_selector")

    @_builtins.property
    @pulumi.getter(name="extraFieldValue")
    def extra_field_value(self) -> pulumi.Output[_builtins.str]:
        """
        Value for extra form field
        """
        return pulumi.get(self, "extra_field_value")

    @_builtins.property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @_builtins.property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="passwordSelector")
    def password_selector(self) -> pulumi.Output[_builtins.str]:
        """
        Login password field CSS selector
        """
        return pulumi.get(self, "password_selector")

    @_builtins.property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        """
        return pulumi.get(self, "reveal_password")

    @_builtins.property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @_builtins.property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @_builtins.property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Status of application. By default, it is `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        Login URL
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A regex that further restricts URL to the specified regex
        """
        return pulumi.get(self, "url_regex")

    @_builtins.property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username template. Default: `${source.login}`
        """
        return pulumi.get(self, "user_name_template")

    @_builtins.property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        """
        return pulumi.get(self, "user_name_template_push_status")

    @_builtins.property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @_builtins.property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username template type. Default: `BUILT_IN`
        """
        return pulumi.get(self, "user_name_template_type")

    @_builtins.property
    @pulumi.getter(name="usernameSelector")
    def username_selector(self) -> pulumi.Output[_builtins.str]:
        """
        Login username field CSS selector
        """
        return pulumi.get(self, "username_selector")

