# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppUserSchemaPropertyArgs', 'AppUserSchemaProperty']

@pulumi.input_type
class AppUserSchemaPropertyArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 index: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 array_enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 array_one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyArrayOneOfArgs']]]] = None,
                 array_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 master: Optional[pulumi.Input[_builtins.str]] = None,
                 max_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyOneOfArgs']]]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 union: Optional[pulumi.Input[_builtins.bool]] = None,
                 unique: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppUserSchemaProperty resource.
        :param pulumi.Input[_builtins.str] app_id: The Application's ID the user custom schema property should be assigned to.
        :param pulumi.Input[_builtins.str] index: Subschema unique string identifier
        :param pulumi.Input[_builtins.str] title: Subschema title (display name)
        :param pulumi.Input[_builtins.str] type: The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] array_enums: Array of values that an array property's items can be set to.
        :param pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyArrayOneOfArgs']]] array_one_ofs: Display name and value an enum array can be set to. - 'const' - (Required) value mapping to member of 'enum'. - 'title'
               - (Required) display name for the enum value.
        :param pulumi.Input[_builtins.str] array_type: The type of the array elements if `type` is set to `array`
        :param pulumi.Input[_builtins.str] description: The description of the user schema property.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enums: Array of values a primitive property can be set to. See `array_enum` for arrays.
        :param pulumi.Input[_builtins.str] external_name: External name of the user schema property.
        :param pulumi.Input[_builtins.str] external_namespace: External namespace of the user schema property.
        :param pulumi.Input[_builtins.str] master: Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`
        :param pulumi.Input[_builtins.int] max_length: The maximum length of the user property value. Only applies to type `string`
        :param pulumi.Input[_builtins.int] min_length: The minimum length of the user property value. Only applies to type `string`
        :param pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyOneOfArgs']]] one_ofs: Array of maps containing a mapping for display name to enum value. - 'const' - (Required) value mapping to member of
               'enum'. - 'title' - (Required) display name for the enum value.
        :param pulumi.Input[_builtins.str] permissions: Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        :param pulumi.Input[_builtins.bool] required: Whether the subschema is required
        :param pulumi.Input[_builtins.str] scope: determines whether an app user attribute can be set at the Personal `SELF` or Group `NONE` level. Default value is
               `NONE`.
        :param pulumi.Input[_builtins.bool] union: If `type` is set to `array`, used to set whether attribute value is determined by group priority `false`, or combine
               values across groups `true`. Can not be set to `true` if `scope` is set to `SELF`.
        :param pulumi.Input[_builtins.str] unique: Whether the property should be unique. It can be set to `UNIQUE_VALIDATED` or `NOT_UNIQUE`.
        :param pulumi.Input[_builtins.str] user_type: User type ID. By default, it is `default`
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "type", type)
        if array_enums is not None:
            pulumi.set(__self__, "array_enums", array_enums)
        if array_one_ofs is not None:
            pulumi.set(__self__, "array_one_ofs", array_one_ofs)
        if array_type is not None:
            pulumi.set(__self__, "array_type", array_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enums is not None:
            pulumi.set(__self__, "enums", enums)
        if external_name is not None:
            pulumi.set(__self__, "external_name", external_name)
        if external_namespace is not None:
            pulumi.set(__self__, "external_namespace", external_namespace)
        if master is not None:
            pulumi.set(__self__, "master", master)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if one_ofs is not None:
            pulumi.set(__self__, "one_ofs", one_ofs)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if union is not None:
            pulumi.set(__self__, "union", union)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Application's ID the user custom schema property should be assigned to.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Input[_builtins.str]:
        """
        Subschema unique string identifier
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        Subschema title (display name)
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="arrayEnums")
    def array_enums(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of values that an array property's items can be set to.
        """
        return pulumi.get(self, "array_enums")

    @array_enums.setter
    def array_enums(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "array_enums", value)

    @_builtins.property
    @pulumi.getter(name="arrayOneOfs")
    def array_one_ofs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyArrayOneOfArgs']]]]:
        """
        Display name and value an enum array can be set to. - 'const' - (Required) value mapping to member of 'enum'. - 'title'
        - (Required) display name for the enum value.
        """
        return pulumi.get(self, "array_one_ofs")

    @array_one_ofs.setter
    def array_one_ofs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyArrayOneOfArgs']]]]):
        pulumi.set(self, "array_one_ofs", value)

    @_builtins.property
    @pulumi.getter(name="arrayType")
    def array_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the array elements if `type` is set to `array`
        """
        return pulumi.get(self, "array_type")

    @array_type.setter
    def array_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "array_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the user schema property.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enums(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of values a primitive property can be set to. See `array_enum` for arrays.
        """
        return pulumi.get(self, "enums")

    @enums.setter
    def enums(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enums", value)

    @_builtins.property
    @pulumi.getter(name="externalName")
    def external_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External name of the user schema property.
        """
        return pulumi.get(self, "external_name")

    @external_name.setter
    def external_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_name", value)

    @_builtins.property
    @pulumi.getter(name="externalNamespace")
    def external_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External namespace of the user schema property.
        """
        return pulumi.get(self, "external_namespace")

    @external_namespace.setter
    def external_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_namespace", value)

    @_builtins.property
    @pulumi.getter
    def master(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`
        """
        return pulumi.get(self, "master")

    @master.setter
    def master(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master", value)

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum length of the user property value. Only applies to type `string`
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_length", value)

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum length of the user property value. Only applies to type `string`
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_length", value)

    @_builtins.property
    @pulumi.getter(name="oneOfs")
    def one_ofs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyOneOfArgs']]]]:
        """
        Array of maps containing a mapping for display name to enum value. - 'const' - (Required) value mapping to member of
        'enum'. - 'title' - (Required) display name for the enum value.
        """
        return pulumi.get(self, "one_ofs")

    @one_ofs.setter
    def one_ofs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyOneOfArgs']]]]):
        pulumi.set(self, "one_ofs", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the subschema is required
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        determines whether an app user attribute can be set at the Personal `SELF` or Group `NONE` level. Default value is
        `NONE`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def union(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `type` is set to `array`, used to set whether attribute value is determined by group priority `false`, or combine
        values across groups `true`. Can not be set to `true` if `scope` is set to `SELF`.
        """
        return pulumi.get(self, "union")

    @union.setter
    def union(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "union", value)

    @_builtins.property
    @pulumi.getter
    def unique(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the property should be unique. It can be set to `UNIQUE_VALIDATED` or `NOT_UNIQUE`.
        """
        return pulumi.get(self, "unique")

    @unique.setter
    def unique(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unique", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User type ID. By default, it is `default`
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.input_type
class _AppUserSchemaPropertyState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 array_enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 array_one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyArrayOneOfArgs']]]] = None,
                 array_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 master: Optional[pulumi.Input[_builtins.str]] = None,
                 max_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyOneOfArgs']]]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 union: Optional[pulumi.Input[_builtins.bool]] = None,
                 unique: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppUserSchemaProperty resources.
        :param pulumi.Input[_builtins.str] app_id: The Application's ID the user custom schema property should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] array_enums: Array of values that an array property's items can be set to.
        :param pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyArrayOneOfArgs']]] array_one_ofs: Display name and value an enum array can be set to. - 'const' - (Required) value mapping to member of 'enum'. - 'title'
               - (Required) display name for the enum value.
        :param pulumi.Input[_builtins.str] array_type: The type of the array elements if `type` is set to `array`
        :param pulumi.Input[_builtins.str] description: The description of the user schema property.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enums: Array of values a primitive property can be set to. See `array_enum` for arrays.
        :param pulumi.Input[_builtins.str] external_name: External name of the user schema property.
        :param pulumi.Input[_builtins.str] external_namespace: External namespace of the user schema property.
        :param pulumi.Input[_builtins.str] index: Subschema unique string identifier
        :param pulumi.Input[_builtins.str] master: Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`
        :param pulumi.Input[_builtins.int] max_length: The maximum length of the user property value. Only applies to type `string`
        :param pulumi.Input[_builtins.int] min_length: The minimum length of the user property value. Only applies to type `string`
        :param pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyOneOfArgs']]] one_ofs: Array of maps containing a mapping for display name to enum value. - 'const' - (Required) value mapping to member of
               'enum'. - 'title' - (Required) display name for the enum value.
        :param pulumi.Input[_builtins.str] permissions: Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        :param pulumi.Input[_builtins.bool] required: Whether the subschema is required
        :param pulumi.Input[_builtins.str] scope: determines whether an app user attribute can be set at the Personal `SELF` or Group `NONE` level. Default value is
               `NONE`.
        :param pulumi.Input[_builtins.str] title: Subschema title (display name)
        :param pulumi.Input[_builtins.str] type: The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        :param pulumi.Input[_builtins.bool] union: If `type` is set to `array`, used to set whether attribute value is determined by group priority `false`, or combine
               values across groups `true`. Can not be set to `true` if `scope` is set to `SELF`.
        :param pulumi.Input[_builtins.str] unique: Whether the property should be unique. It can be set to `UNIQUE_VALIDATED` or `NOT_UNIQUE`.
        :param pulumi.Input[_builtins.str] user_type: User type ID. By default, it is `default`
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if array_enums is not None:
            pulumi.set(__self__, "array_enums", array_enums)
        if array_one_ofs is not None:
            pulumi.set(__self__, "array_one_ofs", array_one_ofs)
        if array_type is not None:
            pulumi.set(__self__, "array_type", array_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enums is not None:
            pulumi.set(__self__, "enums", enums)
        if external_name is not None:
            pulumi.set(__self__, "external_name", external_name)
        if external_namespace is not None:
            pulumi.set(__self__, "external_namespace", external_namespace)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if master is not None:
            pulumi.set(__self__, "master", master)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if one_ofs is not None:
            pulumi.set(__self__, "one_ofs", one_ofs)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if union is not None:
            pulumi.set(__self__, "union", union)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application's ID the user custom schema property should be assigned to.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="arrayEnums")
    def array_enums(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of values that an array property's items can be set to.
        """
        return pulumi.get(self, "array_enums")

    @array_enums.setter
    def array_enums(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "array_enums", value)

    @_builtins.property
    @pulumi.getter(name="arrayOneOfs")
    def array_one_ofs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyArrayOneOfArgs']]]]:
        """
        Display name and value an enum array can be set to. - 'const' - (Required) value mapping to member of 'enum'. - 'title'
        - (Required) display name for the enum value.
        """
        return pulumi.get(self, "array_one_ofs")

    @array_one_ofs.setter
    def array_one_ofs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyArrayOneOfArgs']]]]):
        pulumi.set(self, "array_one_ofs", value)

    @_builtins.property
    @pulumi.getter(name="arrayType")
    def array_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the array elements if `type` is set to `array`
        """
        return pulumi.get(self, "array_type")

    @array_type.setter
    def array_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "array_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the user schema property.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enums(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of values a primitive property can be set to. See `array_enum` for arrays.
        """
        return pulumi.get(self, "enums")

    @enums.setter
    def enums(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enums", value)

    @_builtins.property
    @pulumi.getter(name="externalName")
    def external_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External name of the user schema property.
        """
        return pulumi.get(self, "external_name")

    @external_name.setter
    def external_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_name", value)

    @_builtins.property
    @pulumi.getter(name="externalNamespace")
    def external_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External namespace of the user schema property.
        """
        return pulumi.get(self, "external_namespace")

    @external_namespace.setter
    def external_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_namespace", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subschema unique string identifier
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter
    def master(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`
        """
        return pulumi.get(self, "master")

    @master.setter
    def master(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master", value)

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum length of the user property value. Only applies to type `string`
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_length", value)

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum length of the user property value. Only applies to type `string`
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_length", value)

    @_builtins.property
    @pulumi.getter(name="oneOfs")
    def one_ofs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyOneOfArgs']]]]:
        """
        Array of maps containing a mapping for display name to enum value. - 'const' - (Required) value mapping to member of
        'enum'. - 'title' - (Required) display name for the enum value.
        """
        return pulumi.get(self, "one_ofs")

    @one_ofs.setter
    def one_ofs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppUserSchemaPropertyOneOfArgs']]]]):
        pulumi.set(self, "one_ofs", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the subschema is required
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        determines whether an app user attribute can be set at the Personal `SELF` or Group `NONE` level. Default value is
        `NONE`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subschema title (display name)
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def union(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `type` is set to `array`, used to set whether attribute value is determined by group priority `false`, or combine
        values across groups `true`. Can not be set to `true` if `scope` is set to `SELF`.
        """
        return pulumi.get(self, "union")

    @union.setter
    def union(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "union", value)

    @_builtins.property
    @pulumi.getter
    def unique(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the property should be unique. It can be set to `UNIQUE_VALIDATED` or `NOT_UNIQUE`.
        """
        return pulumi.get(self, "unique")

    @unique.setter
    def unique(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unique", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User type ID. By default, it is `default`
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.type_token("okta:index/appUserSchemaProperty:AppUserSchemaProperty")
class AppUserSchemaProperty(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 array_enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 array_one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyArrayOneOfArgs', 'AppUserSchemaPropertyArrayOneOfArgsDict']]]]] = None,
                 array_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 master: Optional[pulumi.Input[_builtins.str]] = None,
                 max_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyOneOfArgs', 'AppUserSchemaPropertyOneOfArgsDict']]]]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 union: Optional[pulumi.Input[_builtins.bool]] = None,
                 unique: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.AppUserSchemaProperty("example",
            app_id="<app id>",
            index="customPropertyName",
            title="customPropertyName",
            type="string",
            description="My custom property name",
            master="OKTA",
            scope="SELF",
            array_enums=[
                "1",
                "2",
            ],
            array_one_ofs=[
                {
                    "const": "1",
                    "title": "one",
                },
                {
                    "const": "2",
                    "title": "two",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/appUserSchemaProperty:AppUserSchemaProperty example <app_id>/<property_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The Application's ID the user custom schema property should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] array_enums: Array of values that an array property's items can be set to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyArrayOneOfArgs', 'AppUserSchemaPropertyArrayOneOfArgsDict']]]] array_one_ofs: Display name and value an enum array can be set to. - 'const' - (Required) value mapping to member of 'enum'. - 'title'
               - (Required) display name for the enum value.
        :param pulumi.Input[_builtins.str] array_type: The type of the array elements if `type` is set to `array`
        :param pulumi.Input[_builtins.str] description: The description of the user schema property.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enums: Array of values a primitive property can be set to. See `array_enum` for arrays.
        :param pulumi.Input[_builtins.str] external_name: External name of the user schema property.
        :param pulumi.Input[_builtins.str] external_namespace: External namespace of the user schema property.
        :param pulumi.Input[_builtins.str] index: Subschema unique string identifier
        :param pulumi.Input[_builtins.str] master: Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`
        :param pulumi.Input[_builtins.int] max_length: The maximum length of the user property value. Only applies to type `string`
        :param pulumi.Input[_builtins.int] min_length: The minimum length of the user property value. Only applies to type `string`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyOneOfArgs', 'AppUserSchemaPropertyOneOfArgsDict']]]] one_ofs: Array of maps containing a mapping for display name to enum value. - 'const' - (Required) value mapping to member of
               'enum'. - 'title' - (Required) display name for the enum value.
        :param pulumi.Input[_builtins.str] permissions: Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        :param pulumi.Input[_builtins.bool] required: Whether the subschema is required
        :param pulumi.Input[_builtins.str] scope: determines whether an app user attribute can be set at the Personal `SELF` or Group `NONE` level. Default value is
               `NONE`.
        :param pulumi.Input[_builtins.str] title: Subschema title (display name)
        :param pulumi.Input[_builtins.str] type: The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        :param pulumi.Input[_builtins.bool] union: If `type` is set to `array`, used to set whether attribute value is determined by group priority `false`, or combine
               values across groups `true`. Can not be set to `true` if `scope` is set to `SELF`.
        :param pulumi.Input[_builtins.str] unique: Whether the property should be unique. It can be set to `UNIQUE_VALIDATED` or `NOT_UNIQUE`.
        :param pulumi.Input[_builtins.str] user_type: User type ID. By default, it is `default`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppUserSchemaPropertyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.AppUserSchemaProperty("example",
            app_id="<app id>",
            index="customPropertyName",
            title="customPropertyName",
            type="string",
            description="My custom property name",
            master="OKTA",
            scope="SELF",
            array_enums=[
                "1",
                "2",
            ],
            array_one_ofs=[
                {
                    "const": "1",
                    "title": "one",
                },
                {
                    "const": "2",
                    "title": "two",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/appUserSchemaProperty:AppUserSchemaProperty example <app_id>/<property_name>
        ```

        :param str resource_name: The name of the resource.
        :param AppUserSchemaPropertyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppUserSchemaPropertyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 array_enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 array_one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyArrayOneOfArgs', 'AppUserSchemaPropertyArrayOneOfArgsDict']]]]] = None,
                 array_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 master: Optional[pulumi.Input[_builtins.str]] = None,
                 max_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyOneOfArgs', 'AppUserSchemaPropertyOneOfArgsDict']]]]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 union: Optional[pulumi.Input[_builtins.bool]] = None,
                 unique: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppUserSchemaPropertyArgs.__new__(AppUserSchemaPropertyArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["array_enums"] = array_enums
            __props__.__dict__["array_one_ofs"] = array_one_ofs
            __props__.__dict__["array_type"] = array_type
            __props__.__dict__["description"] = description
            __props__.__dict__["enums"] = enums
            __props__.__dict__["external_name"] = external_name
            __props__.__dict__["external_namespace"] = external_namespace
            if index is None and not opts.urn:
                raise TypeError("Missing required property 'index'")
            __props__.__dict__["index"] = index
            __props__.__dict__["master"] = master
            __props__.__dict__["max_length"] = max_length
            __props__.__dict__["min_length"] = min_length
            __props__.__dict__["one_ofs"] = one_ofs
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["required"] = required
            __props__.__dict__["scope"] = scope
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["union"] = union
            __props__.__dict__["unique"] = unique
            __props__.__dict__["user_type"] = user_type
        super(AppUserSchemaProperty, __self__).__init__(
            'okta:index/appUserSchemaProperty:AppUserSchemaProperty',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            array_enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            array_one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyArrayOneOfArgs', 'AppUserSchemaPropertyArrayOneOfArgsDict']]]]] = None,
            array_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            external_name: Optional[pulumi.Input[_builtins.str]] = None,
            external_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            index: Optional[pulumi.Input[_builtins.str]] = None,
            master: Optional[pulumi.Input[_builtins.str]] = None,
            max_length: Optional[pulumi.Input[_builtins.int]] = None,
            min_length: Optional[pulumi.Input[_builtins.int]] = None,
            one_ofs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyOneOfArgs', 'AppUserSchemaPropertyOneOfArgsDict']]]]] = None,
            permissions: Optional[pulumi.Input[_builtins.str]] = None,
            required: Optional[pulumi.Input[_builtins.bool]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            union: Optional[pulumi.Input[_builtins.bool]] = None,
            unique: Optional[pulumi.Input[_builtins.str]] = None,
            user_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppUserSchemaProperty':
        """
        Get an existing AppUserSchemaProperty resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The Application's ID the user custom schema property should be assigned to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] array_enums: Array of values that an array property's items can be set to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyArrayOneOfArgs', 'AppUserSchemaPropertyArrayOneOfArgsDict']]]] array_one_ofs: Display name and value an enum array can be set to. - 'const' - (Required) value mapping to member of 'enum'. - 'title'
               - (Required) display name for the enum value.
        :param pulumi.Input[_builtins.str] array_type: The type of the array elements if `type` is set to `array`
        :param pulumi.Input[_builtins.str] description: The description of the user schema property.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enums: Array of values a primitive property can be set to. See `array_enum` for arrays.
        :param pulumi.Input[_builtins.str] external_name: External name of the user schema property.
        :param pulumi.Input[_builtins.str] external_namespace: External namespace of the user schema property.
        :param pulumi.Input[_builtins.str] index: Subschema unique string identifier
        :param pulumi.Input[_builtins.str] master: Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`
        :param pulumi.Input[_builtins.int] max_length: The maximum length of the user property value. Only applies to type `string`
        :param pulumi.Input[_builtins.int] min_length: The minimum length of the user property value. Only applies to type `string`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppUserSchemaPropertyOneOfArgs', 'AppUserSchemaPropertyOneOfArgsDict']]]] one_ofs: Array of maps containing a mapping for display name to enum value. - 'const' - (Required) value mapping to member of
               'enum'. - 'title' - (Required) display name for the enum value.
        :param pulumi.Input[_builtins.str] permissions: Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        :param pulumi.Input[_builtins.bool] required: Whether the subschema is required
        :param pulumi.Input[_builtins.str] scope: determines whether an app user attribute can be set at the Personal `SELF` or Group `NONE` level. Default value is
               `NONE`.
        :param pulumi.Input[_builtins.str] title: Subschema title (display name)
        :param pulumi.Input[_builtins.str] type: The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        :param pulumi.Input[_builtins.bool] union: If `type` is set to `array`, used to set whether attribute value is determined by group priority `false`, or combine
               values across groups `true`. Can not be set to `true` if `scope` is set to `SELF`.
        :param pulumi.Input[_builtins.str] unique: Whether the property should be unique. It can be set to `UNIQUE_VALIDATED` or `NOT_UNIQUE`.
        :param pulumi.Input[_builtins.str] user_type: User type ID. By default, it is `default`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppUserSchemaPropertyState.__new__(_AppUserSchemaPropertyState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["array_enums"] = array_enums
        __props__.__dict__["array_one_ofs"] = array_one_ofs
        __props__.__dict__["array_type"] = array_type
        __props__.__dict__["description"] = description
        __props__.__dict__["enums"] = enums
        __props__.__dict__["external_name"] = external_name
        __props__.__dict__["external_namespace"] = external_namespace
        __props__.__dict__["index"] = index
        __props__.__dict__["master"] = master
        __props__.__dict__["max_length"] = max_length
        __props__.__dict__["min_length"] = min_length
        __props__.__dict__["one_ofs"] = one_ofs
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["required"] = required
        __props__.__dict__["scope"] = scope
        __props__.__dict__["title"] = title
        __props__.__dict__["type"] = type
        __props__.__dict__["union"] = union
        __props__.__dict__["unique"] = unique
        __props__.__dict__["user_type"] = user_type
        return AppUserSchemaProperty(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Application's ID the user custom schema property should be assigned to.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="arrayEnums")
    def array_enums(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Array of values that an array property's items can be set to.
        """
        return pulumi.get(self, "array_enums")

    @_builtins.property
    @pulumi.getter(name="arrayOneOfs")
    def array_one_ofs(self) -> pulumi.Output[Optional[Sequence['outputs.AppUserSchemaPropertyArrayOneOf']]]:
        """
        Display name and value an enum array can be set to. - 'const' - (Required) value mapping to member of 'enum'. - 'title'
        - (Required) display name for the enum value.
        """
        return pulumi.get(self, "array_one_ofs")

    @_builtins.property
    @pulumi.getter(name="arrayType")
    def array_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the array elements if `type` is set to `array`
        """
        return pulumi.get(self, "array_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the user schema property.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enums(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Array of values a primitive property can be set to. See `array_enum` for arrays.
        """
        return pulumi.get(self, "enums")

    @_builtins.property
    @pulumi.getter(name="externalName")
    def external_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        External name of the user schema property.
        """
        return pulumi.get(self, "external_name")

    @_builtins.property
    @pulumi.getter(name="externalNamespace")
    def external_namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        External namespace of the user schema property.
        """
        return pulumi.get(self, "external_namespace")

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Output[_builtins.str]:
        """
        Subschema unique string identifier
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def master(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`
        """
        return pulumi.get(self, "master")

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum length of the user property value. Only applies to type `string`
        """
        return pulumi.get(self, "max_length")

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimum length of the user property value. Only applies to type `string`
        """
        return pulumi.get(self, "min_length")

    @_builtins.property
    @pulumi.getter(name="oneOfs")
    def one_ofs(self) -> pulumi.Output[Optional[Sequence['outputs.AppUserSchemaPropertyOneOf']]]:
        """
        Array of maps containing a mapping for display name to enum value. - 'const' - (Required) value mapping to member of
        'enum'. - 'title' - (Required) display name for the enum value.
        """
        return pulumi.get(self, "one_ofs")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the subschema is required
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        determines whether an app user attribute can be set at the Personal `SELF` or Group `NONE` level. Default value is
        `NONE`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[_builtins.str]:
        """
        Subschema title (display name)
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def union(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `type` is set to `array`, used to set whether attribute value is determined by group priority `false`, or combine
        values across groups `true`. Can not be set to `true` if `scope` is set to `SELF`.
        """
        return pulumi.get(self, "union")

    @_builtins.property
    @pulumi.getter
    def unique(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether the property should be unique. It can be set to `UNIQUE_VALIDATED` or `NOT_UNIQUE`.
        """
        return pulumi.get(self, "unique")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User type ID. By default, it is `default`
        """
        return pulumi.get(self, "user_type")

