# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CaptchaOrgWideSettingsArgs', 'CaptchaOrgWideSettings']

@pulumi.input_type
class CaptchaOrgWideSettingsArgs:
    def __init__(__self__, *,
                 captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_fors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CaptchaOrgWideSettings resource.
        :param pulumi.Input[_builtins.str] captcha_id: Array of pages that have CAPTCHA enabled. Valid values: `SSR`, `SSPR` and `SIGN_IN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_fors: Set of pages that have CAPTCHA enabled
        """
        if captcha_id is not None:
            pulumi.set(__self__, "captcha_id", captcha_id)
        if enabled_fors is not None:
            pulumi.set(__self__, "enabled_fors", enabled_fors)

    @_builtins.property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Array of pages that have CAPTCHA enabled. Valid values: `SSR`, `SSPR` and `SIGN_IN`.
        """
        return pulumi.get(self, "captcha_id")

    @captcha_id.setter
    def captcha_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "captcha_id", value)

    @_builtins.property
    @pulumi.getter(name="enabledFors")
    def enabled_fors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of pages that have CAPTCHA enabled
        """
        return pulumi.get(self, "enabled_fors")

    @enabled_fors.setter
    def enabled_fors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_fors", value)


@pulumi.input_type
class _CaptchaOrgWideSettingsState:
    def __init__(__self__, *,
                 captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_fors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CaptchaOrgWideSettings resources.
        :param pulumi.Input[_builtins.str] captcha_id: Array of pages that have CAPTCHA enabled. Valid values: `SSR`, `SSPR` and `SIGN_IN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_fors: Set of pages that have CAPTCHA enabled
        """
        if captcha_id is not None:
            pulumi.set(__self__, "captcha_id", captcha_id)
        if enabled_fors is not None:
            pulumi.set(__self__, "enabled_fors", enabled_fors)

    @_builtins.property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Array of pages that have CAPTCHA enabled. Valid values: `SSR`, `SSPR` and `SIGN_IN`.
        """
        return pulumi.get(self, "captcha_id")

    @captcha_id.setter
    def captcha_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "captcha_id", value)

    @_builtins.property
    @pulumi.getter(name="enabledFors")
    def enabled_fors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of pages that have CAPTCHA enabled
        """
        return pulumi.get(self, "enabled_fors")

    @enabled_fors.setter
    def enabled_fors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_fors", value)


@pulumi.type_token("okta:index/captchaOrgWideSettings:CaptchaOrgWideSettings")
class CaptchaOrgWideSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_fors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages Org-Wide CAPTCHA settings
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.
        This resource allows you to configure which parts of the authentication flow requires users to pass the CAPTCHA logic.
        CAPTCHA org-wide settings can be disabled by unsetting 'captcha_id' and 'enabled_for'.

        ## Import

        ```sh
        $ pulumi import okta:index/captchaOrgWideSettings:CaptchaOrgWideSettings example _
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] captcha_id: Array of pages that have CAPTCHA enabled. Valid values: `SSR`, `SSPR` and `SIGN_IN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_fors: Set of pages that have CAPTCHA enabled
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CaptchaOrgWideSettingsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Org-Wide CAPTCHA settings
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.
        This resource allows you to configure which parts of the authentication flow requires users to pass the CAPTCHA logic.
        CAPTCHA org-wide settings can be disabled by unsetting 'captcha_id' and 'enabled_for'.

        ## Import

        ```sh
        $ pulumi import okta:index/captchaOrgWideSettings:CaptchaOrgWideSettings example _
        ```

        :param str resource_name: The name of the resource.
        :param CaptchaOrgWideSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CaptchaOrgWideSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_fors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CaptchaOrgWideSettingsArgs.__new__(CaptchaOrgWideSettingsArgs)

            __props__.__dict__["captcha_id"] = captcha_id
            __props__.__dict__["enabled_fors"] = enabled_fors
        super(CaptchaOrgWideSettings, __self__).__init__(
            'okta:index/captchaOrgWideSettings:CaptchaOrgWideSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            captcha_id: Optional[pulumi.Input[_builtins.str]] = None,
            enabled_fors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'CaptchaOrgWideSettings':
        """
        Get an existing CaptchaOrgWideSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] captcha_id: Array of pages that have CAPTCHA enabled. Valid values: `SSR`, `SSPR` and `SIGN_IN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_fors: Set of pages that have CAPTCHA enabled
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CaptchaOrgWideSettingsState.__new__(_CaptchaOrgWideSettingsState)

        __props__.__dict__["captcha_id"] = captcha_id
        __props__.__dict__["enabled_fors"] = enabled_fors
        return CaptchaOrgWideSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Array of pages that have CAPTCHA enabled. Valid values: `SSR`, `SSPR` and `SIGN_IN`.
        """
        return pulumi.get(self, "captcha_id")

    @_builtins.property
    @pulumi.getter(name="enabledFors")
    def enabled_fors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of pages that have CAPTCHA enabled
        """
        return pulumi.get(self, "enabled_fors")

