# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAuthenticatorResult',
    'AwaitableGetAuthenticatorResult',
    'get_authenticator',
    'get_authenticator_output',
]

@pulumi.output_type
class GetAuthenticatorResult:
    """
    A collection of values returned by getAuthenticator.
    """
    def __init__(__self__, id=None, key=None, name=None, provider_auth_port=None, provider_hostname=None, provider_instance_id=None, provider_json=None, provider_type=None, provider_user_name_template=None, settings=None, status=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provider_auth_port and not isinstance(provider_auth_port, int):
            raise TypeError("Expected argument 'provider_auth_port' to be a int")
        pulumi.set(__self__, "provider_auth_port", provider_auth_port)
        if provider_hostname and not isinstance(provider_hostname, str):
            raise TypeError("Expected argument 'provider_hostname' to be a str")
        pulumi.set(__self__, "provider_hostname", provider_hostname)
        if provider_instance_id and not isinstance(provider_instance_id, str):
            raise TypeError("Expected argument 'provider_instance_id' to be a str")
        pulumi.set(__self__, "provider_instance_id", provider_instance_id)
        if provider_json and not isinstance(provider_json, str):
            raise TypeError("Expected argument 'provider_json' to be a str")
        pulumi.set(__self__, "provider_json", provider_json)
        if provider_type and not isinstance(provider_type, str):
            raise TypeError("Expected argument 'provider_type' to be a str")
        pulumi.set(__self__, "provider_type", provider_type)
        if provider_user_name_template and not isinstance(provider_user_name_template, str):
            raise TypeError("Expected argument 'provider_user_name_template' to be a str")
        pulumi.set(__self__, "provider_user_name_template", provider_user_name_template)
        if settings and not isinstance(settings, str):
            raise TypeError("Expected argument 'settings' to be a str")
        pulumi.set(__self__, "settings", settings)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the authenticator.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        A human-readable string that identifies the authenticator.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the authenticator.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="providerAuthPort")
    def provider_auth_port(self) -> _builtins.int:
        """
        The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured
        """
        return pulumi.get(self, "provider_auth_port")

    @_builtins.property
    @pulumi.getter(name="providerHostname")
    def provider_hostname(self) -> _builtins.str:
        """
        Server host name or IP address
        """
        return pulumi.get(self, "provider_hostname")

    @_builtins.property
    @pulumi.getter(name="providerInstanceId")
    def provider_instance_id(self) -> _builtins.str:
        """
        (Specific to `security_key`) App Instance ID.
        """
        return pulumi.get(self, "provider_instance_id")

    @_builtins.property
    @pulumi.getter(name="providerJson")
    def provider_json(self) -> _builtins.str:
        """
        Authenticator Provider in JSON format
        """
        return pulumi.get(self, "provider_json")

    @_builtins.property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> _builtins.str:
        """
        Provider type.
        """
        return pulumi.get(self, "provider_type")

    @_builtins.property
    @pulumi.getter(name="providerUserNameTemplate")
    def provider_user_name_template(self) -> _builtins.str:
        """
        Username template expected by the provider.
        """
        return pulumi.get(self, "provider_user_name_template")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> _builtins.str:
        """
        Authenticator settings in JSON format
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the Authenticator.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the authenticator
        """
        return pulumi.get(self, "type")


class AwaitableGetAuthenticatorResult(GetAuthenticatorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthenticatorResult(
            id=self.id,
            key=self.key,
            name=self.name,
            provider_auth_port=self.provider_auth_port,
            provider_hostname=self.provider_hostname,
            provider_instance_id=self.provider_instance_id,
            provider_json=self.provider_json,
            provider_type=self.provider_type,
            provider_user_name_template=self.provider_user_name_template,
            settings=self.settings,
            status=self.status,
            type=self.type)


def get_authenticator(id: Optional[_builtins.str] = None,
                      key: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthenticatorResult:
    """
    Get an authenticator by key, name of ID.

    > **WARNING:** This feature is only available as a part of the
    Identity Engine. Contact support
    for further information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_authenticator(key="security_question")
    test1 = okta.get_authenticator(name="Okta Verify")
    ```


    :param _builtins.str id: ID of the authenticator.
    :param _builtins.str key: A human-readable string that identifies the authenticator.
    :param _builtins.str name: Name of the authenticator.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['key'] = key
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getAuthenticator:getAuthenticator', __args__, opts=opts, typ=GetAuthenticatorResult).value

    return AwaitableGetAuthenticatorResult(
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        name=pulumi.get(__ret__, 'name'),
        provider_auth_port=pulumi.get(__ret__, 'provider_auth_port'),
        provider_hostname=pulumi.get(__ret__, 'provider_hostname'),
        provider_instance_id=pulumi.get(__ret__, 'provider_instance_id'),
        provider_json=pulumi.get(__ret__, 'provider_json'),
        provider_type=pulumi.get(__ret__, 'provider_type'),
        provider_user_name_template=pulumi.get(__ret__, 'provider_user_name_template'),
        settings=pulumi.get(__ret__, 'settings'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))
def get_authenticator_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             key: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthenticatorResult]:
    """
    Get an authenticator by key, name of ID.

    > **WARNING:** This feature is only available as a part of the
    Identity Engine. Contact support
    for further information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_authenticator(key="security_question")
    test1 = okta.get_authenticator(name="Okta Verify")
    ```


    :param _builtins.str id: ID of the authenticator.
    :param _builtins.str key: A human-readable string that identifies the authenticator.
    :param _builtins.str name: Name of the authenticator.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['key'] = key
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getAuthenticator:getAuthenticator', __args__, opts=opts, typ=GetAuthenticatorResult)
    return __ret__.apply(lambda __response__: GetAuthenticatorResult(
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        name=pulumi.get(__response__, 'name'),
        provider_auth_port=pulumi.get(__response__, 'provider_auth_port'),
        provider_hostname=pulumi.get(__response__, 'provider_hostname'),
        provider_instance_id=pulumi.get(__response__, 'provider_instance_id'),
        provider_json=pulumi.get(__response__, 'provider_json'),
        provider_type=pulumi.get(__response__, 'provider_type'),
        provider_user_name_template=pulumi.get(__response__, 'provider_user_name_template'),
        settings=pulumi.get(__response__, 'settings'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type')))
