# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogStreamResult',
    'AwaitableGetLogStreamResult',
    'get_log_stream',
    'get_log_stream_output',
]

@pulumi.output_type
class GetLogStreamResult:
    """
    A collection of values returned by getLogStream.
    """
    def __init__(__self__, id=None, name=None, settings=None, status=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the log stream to retrieve, conflicts with `name`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Unique name for the Log Stream object, conflicts with `id`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional['outputs.GetLogStreamSettingsResult']:
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Log Stream Status - can either be ACTIVE or INACTIVE only
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Streaming provider used - aws*eventbridge or splunk*cloud_logstreaming
        """
        return pulumi.get(self, "type")


class AwaitableGetLogStreamResult(GetLogStreamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogStreamResult(
            id=self.id,
            name=self.name,
            settings=self.settings,
            status=self.status,
            type=self.type)


def get_log_stream(id: Optional[_builtins.str] = None,
                   name: Optional[_builtins.str] = None,
                   settings: Optional[Union['GetLogStreamSettingsArgs', 'GetLogStreamSettingsArgsDict']] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogStreamResult:
    """
    Log Streams


    :param _builtins.str id: ID of the log stream to retrieve, conflicts with `name`.
    :param _builtins.str name: Unique name for the Log Stream object, conflicts with `id`.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['settings'] = settings
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getLogStream:getLogStream', __args__, opts=opts, typ=GetLogStreamResult).value

    return AwaitableGetLogStreamResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        settings=pulumi.get(__ret__, 'settings'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))
def get_log_stream_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          settings: Optional[pulumi.Input[Optional[Union['GetLogStreamSettingsArgs', 'GetLogStreamSettingsArgsDict']]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogStreamResult]:
    """
    Log Streams


    :param _builtins.str id: ID of the log stream to retrieve, conflicts with `name`.
    :param _builtins.str name: Unique name for the Log Stream object, conflicts with `id`.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['settings'] = settings
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getLogStream:getLogStream', __args__, opts=opts, typ=GetLogStreamResult)
    return __ret__.apply(lambda __response__: GetLogStreamResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        settings=pulumi.get(__response__, 'settings'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type')))
