# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HookArgs', 'Hook']

@pulumi.input_type
class HookArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 auth: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 channel: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 channel_json: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['HookHeaderArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Hook resource.
        :param pulumi.Input[_builtins.str] type: The type of hook to create. [See here for supported types](https://developer.okta.com/docs/reference/api/inline-hooks/#supported-inline-hook-types).
        :param pulumi.Input[_builtins.str] version: The version of the hook. The currently-supported version is `1.0.0`.
        :param pulumi.Input[_builtins.str] channel_json: true channel object for the inline hook API contract
        :param pulumi.Input[Sequence[pulumi.Input['HookHeaderArgs']]] headers: Map of headers to send along in inline hook request.
        :param pulumi.Input[_builtins.str] name: The inline hook display name.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if channel_json is not None:
            pulumi.set(__self__, "channel_json", channel_json)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of hook to create. [See here for supported types](https://developer.okta.com/docs/reference/api/inline-hooks/#supported-inline-hook-types).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the hook. The currently-supported version is `1.0.0`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "auth", value)

    @_builtins.property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "channel", value)

    @_builtins.property
    @pulumi.getter(name="channelJson")
    def channel_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        true channel object for the inline hook API contract
        """
        return pulumi.get(self, "channel_json")

    @channel_json.setter
    def channel_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel_json", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HookHeaderArgs']]]]:
        """
        Map of headers to send along in inline hook request.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HookHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The inline hook display name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _HookState:
    def __init__(__self__, *,
                 auth: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 channel: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 channel_json: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['HookHeaderArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Hook resources.
        :param pulumi.Input[_builtins.str] channel_json: true channel object for the inline hook API contract
        :param pulumi.Input[Sequence[pulumi.Input['HookHeaderArgs']]] headers: Map of headers to send along in inline hook request.
        :param pulumi.Input[_builtins.str] name: The inline hook display name.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] type: The type of hook to create. [See here for supported types](https://developer.okta.com/docs/reference/api/inline-hooks/#supported-inline-hook-types).
        :param pulumi.Input[_builtins.str] version: The version of the hook. The currently-supported version is `1.0.0`.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if channel_json is not None:
            pulumi.set(__self__, "channel_json", channel_json)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "auth", value)

    @_builtins.property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "channel", value)

    @_builtins.property
    @pulumi.getter(name="channelJson")
    def channel_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        true channel object for the inline hook API contract
        """
        return pulumi.get(self, "channel_json")

    @channel_json.setter
    def channel_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel_json", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HookHeaderArgs']]]]:
        """
        Map of headers to send along in inline hook request.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HookHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The inline hook display name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of hook to create. [See here for supported types](https://developer.okta.com/docs/reference/api/inline-hooks/#supported-inline-hook-types).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the hook. The currently-supported version is `1.0.0`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("okta:inline/hook:Hook")
class Hook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 channel: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 channel_json: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HookHeaderArgs', 'HookHeaderArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an inline hook. This resource allows you to create and configure an inline hook.

        ## Example Usage

        ### HTTP Auth
        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.inline.Hook("example",
            name="example",
            version="1.0.0",
            type="com.okta.oauth2.tokens.transform",
            channel={
                "version": "1.0.0",
                "uri": "https://example.com/test",
                "method": "POST",
            },
            auth={
                "key": "Authorization",
                "type": "HEADER",
                "value": "secret",
            })
        ```

        ### OAuth2.0 Auth
        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.inline.Hook("example",
            name="example",
            version="1.0.0",
            type="com.okta.saml.tokens.transform",
            status="ACTIVE",
            channel_json=\"\"\"{
                "type": "OAUTH",
                "version": "1.0.0",
                "config": {
                    "headers": [
                        {
                            "key": "Field 1",
                            "value": "Value 1"
                        },
                        {
                            "key": "Field 2",
                            "value": "Value 2"
                        }
                    ],
                    "method": "POST",
                    "authType": "client_secret_post",
                    "uri": "https://example.com/service",
                    "clientId": "abc123",
                    "clientSecret": "fake-secret",
                    "tokenUrl": "https://example.com/token",
                    "scope": "api"
                }
        }
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import okta:inline/hook:Hook example <hook_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] channel_json: true channel object for the inline hook API contract
        :param pulumi.Input[Sequence[pulumi.Input[Union['HookHeaderArgs', 'HookHeaderArgsDict']]]] headers: Map of headers to send along in inline hook request.
        :param pulumi.Input[_builtins.str] name: The inline hook display name.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] type: The type of hook to create. [See here for supported types](https://developer.okta.com/docs/reference/api/inline-hooks/#supported-inline-hook-types).
        :param pulumi.Input[_builtins.str] version: The version of the hook. The currently-supported version is `1.0.0`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an inline hook. This resource allows you to create and configure an inline hook.

        ## Example Usage

        ### HTTP Auth
        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.inline.Hook("example",
            name="example",
            version="1.0.0",
            type="com.okta.oauth2.tokens.transform",
            channel={
                "version": "1.0.0",
                "uri": "https://example.com/test",
                "method": "POST",
            },
            auth={
                "key": "Authorization",
                "type": "HEADER",
                "value": "secret",
            })
        ```

        ### OAuth2.0 Auth
        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.inline.Hook("example",
            name="example",
            version="1.0.0",
            type="com.okta.saml.tokens.transform",
            status="ACTIVE",
            channel_json=\"\"\"{
                "type": "OAUTH",
                "version": "1.0.0",
                "config": {
                    "headers": [
                        {
                            "key": "Field 1",
                            "value": "Value 1"
                        },
                        {
                            "key": "Field 2",
                            "value": "Value 2"
                        }
                    ],
                    "method": "POST",
                    "authType": "client_secret_post",
                    "uri": "https://example.com/service",
                    "clientId": "abc123",
                    "clientSecret": "fake-secret",
                    "tokenUrl": "https://example.com/token",
                    "scope": "api"
                }
        }
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import okta:inline/hook:Hook example <hook_id>
        ```

        :param str resource_name: The name of the resource.
        :param HookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 channel: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 channel_json: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HookHeaderArgs', 'HookHeaderArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HookArgs.__new__(HookArgs)

            __props__.__dict__["auth"] = auth
            __props__.__dict__["channel"] = channel
            __props__.__dict__["channel_json"] = channel_json
            __props__.__dict__["headers"] = headers
            __props__.__dict__["name"] = name
            __props__.__dict__["status"] = status
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
        super(Hook, __self__).__init__(
            'okta:inline/hook:Hook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            channel: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            channel_json: Optional[pulumi.Input[_builtins.str]] = None,
            headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HookHeaderArgs', 'HookHeaderArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Hook':
        """
        Get an existing Hook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] channel_json: true channel object for the inline hook API contract
        :param pulumi.Input[Sequence[pulumi.Input[Union['HookHeaderArgs', 'HookHeaderArgsDict']]]] headers: Map of headers to send along in inline hook request.
        :param pulumi.Input[_builtins.str] name: The inline hook display name.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] type: The type of hook to create. [See here for supported types](https://developer.okta.com/docs/reference/api/inline-hooks/#supported-inline-hook-types).
        :param pulumi.Input[_builtins.str] version: The version of the hook. The currently-supported version is `1.0.0`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HookState.__new__(_HookState)

        __props__.__dict__["auth"] = auth
        __props__.__dict__["channel"] = channel
        __props__.__dict__["channel_json"] = channel_json
        __props__.__dict__["headers"] = headers
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return Hook(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def auth(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "auth")

    @_builtins.property
    @pulumi.getter
    def channel(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "channel")

    @_builtins.property
    @pulumi.getter(name="channelJson")
    def channel_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        true channel object for the inline hook API contract
        """
        return pulumi.get(self, "channel_json")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Sequence['outputs.HookHeader']]]:
        """
        Map of headers to send along in inline hook request.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The inline hook display name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of hook to create. [See here for supported types](https://developer.okta.com/docs/reference/api/inline-hooks/#supported-inline-hook-types).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the hook. The currently-supported version is `1.0.0`.
        """
        return pulumi.get(self, "version")

