# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProjectIamResult',
    'GetProjectsProjectResult',
    'GetProjectsProjectIamResult',
]

@pulumi.output_type
class GetProjectIamResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 urn: _builtins.str):
        """
        :param _builtins.str display_name: Resource display name
        :param _builtins.str id: Unique identifier of the resource in the IAM
        :param Mapping[str, _builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with `ovh:`
        :param _builtins.str urn: URN of the private database, used when writing IAM policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier of the resource in the IAM
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with `ovh:`
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> _builtins.str:
        """
        URN of the private database, used when writing IAM policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 access: _builtins.str,
                 creation_date: _builtins.str,
                 description: _builtins.str,
                 expiration: _builtins.str,
                 iam: 'outputs.GetProjectsProjectIamResult',
                 manual_quota: _builtins.bool,
                 order_id: _builtins.float,
                 plan_code: _builtins.str,
                 project_id: _builtins.str,
                 project_name: _builtins.str,
                 service_name: _builtins.str,
                 status: _builtins.str,
                 unleash: _builtins.bool):
        """
        :param _builtins.str access: Project access
        :param _builtins.str creation_date: Project creation date
        :param _builtins.str description: Description of your project
        :param _builtins.str expiration: Expiration date of your project. After this date, your project will be deleted
        :param 'GetProjectsProjectIamArgs' iam: IAM resource information
        :param _builtins.bool manual_quota: Manual quota prevent automatic quota upgrade
        :param _builtins.float order_id: Project order ID
        :param _builtins.str plan_code: Order plan code
        :param _builtins.str project_id: Project ID
        :param _builtins.str project_name: Project name
        :param _builtins.str service_name: ID of the public cloud project
        :param _builtins.str status: Current status
        :param _builtins.bool unleash: Project unleashed
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "creation_date", creation_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expiration", expiration)
        pulumi.set(__self__, "iam", iam)
        pulumi.set(__self__, "manual_quota", manual_quota)
        pulumi.set(__self__, "order_id", order_id)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "unleash", unleash)

    @_builtins.property
    @pulumi.getter
    def access(self) -> _builtins.str:
        """
        Project access
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        Project creation date
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of your project
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> _builtins.str:
        """
        Expiration date of your project. After this date, your project will be deleted
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def iam(self) -> 'outputs.GetProjectsProjectIamResult':
        """
        IAM resource information
        """
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter(name="manualQuota")
    def manual_quota(self) -> _builtins.bool:
        """
        Manual quota prevent automatic quota upgrade
        """
        return pulumi.get(self, "manual_quota")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> _builtins.float:
        """
        Project order ID
        """
        return pulumi.get(self, "order_id")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Order plan code
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        ID of the public cloud project
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Current status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def unleash(self) -> _builtins.bool:
        """
        Project unleashed
        """
        return pulumi.get(self, "unleash")


@pulumi.output_type
class GetProjectsProjectIamResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 urn: _builtins.str):
        """
        :param _builtins.str display_name: Resource display name
        :param _builtins.str id: Unique identifier of the resource in the IAM
        :param Mapping[str, _builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with `ovh:`
        :param _builtins.str urn: URN of the private database, used when writing IAM policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier of the resource in the IAM
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with `ovh:`
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> _builtins.str:
        """
        URN of the private database, used when writing IAM policies
        """
        return pulumi.get(self, "urn")


