# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayInterfaceInitArgs', 'GatewayInterface']

@pulumi.input_type
class GatewayInterfaceInitArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 interface_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GatewayInterface resource.
        :param pulumi.Input[_builtins.str] region: Region of the gateway
        :param pulumi.Input[_builtins.str] service_name: ID of the cloud project
        :param pulumi.Input[_builtins.str] subnet_id: ID of the subnet to add
        :param pulumi.Input[_builtins.str] interface_id: ID of the interface
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if interface_id is not None:
            pulumi.set(__self__, "interface_id", interface_id)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        Region of the gateway
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the cloud project
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the subnet to add
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the interface
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_id", value)


@pulumi.input_type
class _GatewayInterfaceState:
    def __init__(__self__, *,
                 interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayInterface resources.
        :param pulumi.Input[_builtins.str] interface_id: ID of the interface
        :param pulumi.Input[_builtins.str] ip: IP of the interface
        :param pulumi.Input[_builtins.str] network_id: Network ID of the interface
        :param pulumi.Input[_builtins.str] region: Region of the gateway
        :param pulumi.Input[_builtins.str] service_name: ID of the cloud project
        :param pulumi.Input[_builtins.str] subnet_id: ID of the subnet to add
        """
        if interface_id is not None:
            pulumi.set(__self__, "interface_id", interface_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the interface
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_id", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP of the interface
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network ID of the interface
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region of the gateway
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the cloud project
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the subnet to add
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.type_token("ovh:CloudProject/gatewayInterface:GatewayInterface")
class GatewayInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a new Gateway Interface for existing subnet in the specified public cloud project.

        ## Import

        A gateway interface can be imported using the `service_name`, `region`, `id` (identifier of the gateway) and `interface_id` properties, separated by a `/`.

        bash

        ```sh
        $ pulumi import ovh:CloudProject/gatewayInterface:GatewayInterface gateway service_name/region/id/interface_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] interface_id: ID of the interface
        :param pulumi.Input[_builtins.str] region: Region of the gateway
        :param pulumi.Input[_builtins.str] service_name: ID of the cloud project
        :param pulumi.Input[_builtins.str] subnet_id: ID of the subnet to add
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayInterfaceInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a new Gateway Interface for existing subnet in the specified public cloud project.

        ## Import

        A gateway interface can be imported using the `service_name`, `region`, `id` (identifier of the gateway) and `interface_id` properties, separated by a `/`.

        bash

        ```sh
        $ pulumi import ovh:CloudProject/gatewayInterface:GatewayInterface gateway service_name/region/id/interface_id
        ```

        :param str resource_name: The name of the resource.
        :param GatewayInterfaceInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayInterfaceInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayInterfaceInitArgs.__new__(GatewayInterfaceInitArgs)

            __props__.__dict__["interface_id"] = interface_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["ip"] = None
            __props__.__dict__["network_id"] = None
        super(GatewayInterface, __self__).__init__(
            'ovh:CloudProject/gatewayInterface:GatewayInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayInterface':
        """
        Get an existing GatewayInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] interface_id: ID of the interface
        :param pulumi.Input[_builtins.str] ip: IP of the interface
        :param pulumi.Input[_builtins.str] network_id: Network ID of the interface
        :param pulumi.Input[_builtins.str] region: Region of the gateway
        :param pulumi.Input[_builtins.str] service_name: ID of the cloud project
        :param pulumi.Input[_builtins.str] subnet_id: ID of the subnet to add
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayInterfaceState.__new__(_GatewayInterfaceState)

        __props__.__dict__["interface_id"] = interface_id
        __props__.__dict__["ip"] = ip
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["region"] = region
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["subnet_id"] = subnet_id
        return GatewayInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the interface
        """
        return pulumi.get(self, "interface_id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[_builtins.str]:
        """
        IP of the interface
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        Network ID of the interface
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region of the gateway
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the cloud project
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the subnet to add
        """
        return pulumi.get(self, "subnet_id")

