# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetContainerRegistryOIDCResult',
    'AwaitableGetContainerRegistryOIDCResult',
    'get_container_registry_oidc',
    'get_container_registry_oidc_output',
]

@pulumi.output_type
class GetContainerRegistryOIDCResult:
    """
    A collection of values returned by getContainerRegistryOIDC.
    """
    def __init__(__self__, id=None, oidc_admin_group=None, oidc_auto_onboard=None, oidc_client_id=None, oidc_endpoint=None, oidc_groups_claim=None, oidc_name=None, oidc_scope=None, oidc_user_claim=None, oidc_verify_cert=None, registry_id=None, service_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oidc_admin_group and not isinstance(oidc_admin_group, str):
            raise TypeError("Expected argument 'oidc_admin_group' to be a str")
        pulumi.set(__self__, "oidc_admin_group", oidc_admin_group)
        if oidc_auto_onboard and not isinstance(oidc_auto_onboard, bool):
            raise TypeError("Expected argument 'oidc_auto_onboard' to be a bool")
        pulumi.set(__self__, "oidc_auto_onboard", oidc_auto_onboard)
        if oidc_client_id and not isinstance(oidc_client_id, str):
            raise TypeError("Expected argument 'oidc_client_id' to be a str")
        pulumi.set(__self__, "oidc_client_id", oidc_client_id)
        if oidc_endpoint and not isinstance(oidc_endpoint, str):
            raise TypeError("Expected argument 'oidc_endpoint' to be a str")
        pulumi.set(__self__, "oidc_endpoint", oidc_endpoint)
        if oidc_groups_claim and not isinstance(oidc_groups_claim, str):
            raise TypeError("Expected argument 'oidc_groups_claim' to be a str")
        pulumi.set(__self__, "oidc_groups_claim", oidc_groups_claim)
        if oidc_name and not isinstance(oidc_name, str):
            raise TypeError("Expected argument 'oidc_name' to be a str")
        pulumi.set(__self__, "oidc_name", oidc_name)
        if oidc_scope and not isinstance(oidc_scope, str):
            raise TypeError("Expected argument 'oidc_scope' to be a str")
        pulumi.set(__self__, "oidc_scope", oidc_scope)
        if oidc_user_claim and not isinstance(oidc_user_claim, str):
            raise TypeError("Expected argument 'oidc_user_claim' to be a str")
        pulumi.set(__self__, "oidc_user_claim", oidc_user_claim)
        if oidc_verify_cert and not isinstance(oidc_verify_cert, bool):
            raise TypeError("Expected argument 'oidc_verify_cert' to be a bool")
        pulumi.set(__self__, "oidc_verify_cert", oidc_verify_cert)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="oidcAdminGroup")
    def oidc_admin_group(self) -> Optional[_builtins.str]:
        """
        Specify an OIDC admin group name. All OIDC users in this group will have harbor admin privilege. Keep it blank if you do not want to.
        """
        return pulumi.get(self, "oidc_admin_group")

    @_builtins.property
    @pulumi.getter(name="oidcAutoOnboard")
    def oidc_auto_onboard(self) -> Optional[_builtins.bool]:
        """
        Skip the onboarding screen, so user cannot change its username. Username is provided from ID Token.
        """
        return pulumi.get(self, "oidc_auto_onboard")

    @_builtins.property
    @pulumi.getter(name="oidcClientId")
    def oidc_client_id(self) -> Optional[_builtins.str]:
        """
        The client ID with which Harbor is registered as client application with the OIDC provider.
        """
        return pulumi.get(self, "oidc_client_id")

    @_builtins.property
    @pulumi.getter(name="oidcEndpoint")
    def oidc_endpoint(self) -> Optional[_builtins.str]:
        """
        The URL of an OIDC-compliant server.
        """
        return pulumi.get(self, "oidc_endpoint")

    @_builtins.property
    @pulumi.getter(name="oidcGroupsClaim")
    def oidc_groups_claim(self) -> Optional[_builtins.str]:
        """
        The name of Claim in the ID token whose value is the list of group names.
        """
        return pulumi.get(self, "oidc_groups_claim")

    @_builtins.property
    @pulumi.getter(name="oidcName")
    def oidc_name(self) -> Optional[_builtins.str]:
        """
        The name of the OIDC provider.
        """
        return pulumi.get(self, "oidc_name")

    @_builtins.property
    @pulumi.getter(name="oidcScope")
    def oidc_scope(self) -> Optional[_builtins.str]:
        """
        The scope sent to OIDC server during authentication. It's a comma-separated string that must contain 'openid' and usually also contains 'profile' and 'email'. To obtain refresh tokens it should also contain 'offline_access'.
        """
        return pulumi.get(self, "oidc_scope")

    @_builtins.property
    @pulumi.getter(name="oidcUserClaim")
    def oidc_user_claim(self) -> Optional[_builtins.str]:
        """
        The name of the claim in the ID Token where the username is retrieved from. If not specified, it will default to 'name' (only useful when automatic Onboarding is enabled).
        """
        return pulumi.get(self, "oidc_user_claim")

    @_builtins.property
    @pulumi.getter(name="oidcVerifyCert")
    def oidc_verify_cert(self) -> Optional[_builtins.bool]:
        """
        Set it to `false` if your OIDC server is hosted via self-signed certificate.
        """
        return pulumi.get(self, "oidc_verify_cert")

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> _builtins.str:
        """
        The ID of the Managed Private Registry.
        """
        return pulumi.get(self, "registry_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The ID of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetContainerRegistryOIDCResult(GetContainerRegistryOIDCResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerRegistryOIDCResult(
            id=self.id,
            oidc_admin_group=self.oidc_admin_group,
            oidc_auto_onboard=self.oidc_auto_onboard,
            oidc_client_id=self.oidc_client_id,
            oidc_endpoint=self.oidc_endpoint,
            oidc_groups_claim=self.oidc_groups_claim,
            oidc_name=self.oidc_name,
            oidc_scope=self.oidc_scope,
            oidc_user_claim=self.oidc_user_claim,
            oidc_verify_cert=self.oidc_verify_cert,
            registry_id=self.registry_id,
            service_name=self.service_name)


def get_container_registry_oidc(oidc_admin_group: Optional[_builtins.str] = None,
                                oidc_auto_onboard: Optional[_builtins.bool] = None,
                                oidc_client_id: Optional[_builtins.str] = None,
                                oidc_endpoint: Optional[_builtins.str] = None,
                                oidc_groups_claim: Optional[_builtins.str] = None,
                                oidc_name: Optional[_builtins.str] = None,
                                oidc_scope: Optional[_builtins.str] = None,
                                oidc_user_claim: Optional[_builtins.str] = None,
                                oidc_verify_cert: Optional[_builtins.bool] = None,
                                registry_id: Optional[_builtins.str] = None,
                                service_name: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerRegistryOIDCResult:
    """
    Use this data source to get a OVHcloud Managed Private Registry OIDC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_oidc = ovh.CloudProject.get_container_registry_oidc(service_name="XXXXXX",
        registry_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxx")
    pulumi.export("oidc-client-id", my_oidc.oidc_client_id)
    ```


    :param _builtins.str oidc_admin_group: Specify an OIDC admin group name. All OIDC users in this group will have harbor admin privilege. Keep it blank if you do not want to.
    :param _builtins.bool oidc_auto_onboard: Skip the onboarding screen, so user cannot change its username. Username is provided from ID Token.
    :param _builtins.str oidc_client_id: The client ID with which Harbor is registered as client application with the OIDC provider.
    :param _builtins.str oidc_endpoint: The URL of an OIDC-compliant server.
    :param _builtins.str oidc_groups_claim: The name of Claim in the ID token whose value is the list of group names.
    :param _builtins.str oidc_name: The name of the OIDC provider.
    :param _builtins.str oidc_scope: The scope sent to OIDC server during authentication. It's a comma-separated string that must contain 'openid' and usually also contains 'profile' and 'email'. To obtain refresh tokens it should also contain 'offline_access'.
    :param _builtins.str oidc_user_claim: The name of the claim in the ID Token where the username is retrieved from. If not specified, it will default to 'name' (only useful when automatic Onboarding is enabled).
    :param _builtins.bool oidc_verify_cert: Set it to `false` if your OIDC server is hosted via self-signed certificate.
    :param _builtins.str registry_id: The id of the Managed Private Registry.
    :param _builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['oidcAdminGroup'] = oidc_admin_group
    __args__['oidcAutoOnboard'] = oidc_auto_onboard
    __args__['oidcClientId'] = oidc_client_id
    __args__['oidcEndpoint'] = oidc_endpoint
    __args__['oidcGroupsClaim'] = oidc_groups_claim
    __args__['oidcName'] = oidc_name
    __args__['oidcScope'] = oidc_scope
    __args__['oidcUserClaim'] = oidc_user_claim
    __args__['oidcVerifyCert'] = oidc_verify_cert
    __args__['registryId'] = registry_id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getContainerRegistryOIDC:getContainerRegistryOIDC', __args__, opts=opts, typ=GetContainerRegistryOIDCResult).value

    return AwaitableGetContainerRegistryOIDCResult(
        id=pulumi.get(__ret__, 'id'),
        oidc_admin_group=pulumi.get(__ret__, 'oidc_admin_group'),
        oidc_auto_onboard=pulumi.get(__ret__, 'oidc_auto_onboard'),
        oidc_client_id=pulumi.get(__ret__, 'oidc_client_id'),
        oidc_endpoint=pulumi.get(__ret__, 'oidc_endpoint'),
        oidc_groups_claim=pulumi.get(__ret__, 'oidc_groups_claim'),
        oidc_name=pulumi.get(__ret__, 'oidc_name'),
        oidc_scope=pulumi.get(__ret__, 'oidc_scope'),
        oidc_user_claim=pulumi.get(__ret__, 'oidc_user_claim'),
        oidc_verify_cert=pulumi.get(__ret__, 'oidc_verify_cert'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_container_registry_oidc_output(oidc_admin_group: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       oidc_auto_onboard: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                       oidc_client_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       oidc_endpoint: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       oidc_groups_claim: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       oidc_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       oidc_scope: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       oidc_user_claim: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       oidc_verify_cert: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                       registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerRegistryOIDCResult]:
    """
    Use this data source to get a OVHcloud Managed Private Registry OIDC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_oidc = ovh.CloudProject.get_container_registry_oidc(service_name="XXXXXX",
        registry_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxx")
    pulumi.export("oidc-client-id", my_oidc.oidc_client_id)
    ```


    :param _builtins.str oidc_admin_group: Specify an OIDC admin group name. All OIDC users in this group will have harbor admin privilege. Keep it blank if you do not want to.
    :param _builtins.bool oidc_auto_onboard: Skip the onboarding screen, so user cannot change its username. Username is provided from ID Token.
    :param _builtins.str oidc_client_id: The client ID with which Harbor is registered as client application with the OIDC provider.
    :param _builtins.str oidc_endpoint: The URL of an OIDC-compliant server.
    :param _builtins.str oidc_groups_claim: The name of Claim in the ID token whose value is the list of group names.
    :param _builtins.str oidc_name: The name of the OIDC provider.
    :param _builtins.str oidc_scope: The scope sent to OIDC server during authentication. It's a comma-separated string that must contain 'openid' and usually also contains 'profile' and 'email'. To obtain refresh tokens it should also contain 'offline_access'.
    :param _builtins.str oidc_user_claim: The name of the claim in the ID Token where the username is retrieved from. If not specified, it will default to 'name' (only useful when automatic Onboarding is enabled).
    :param _builtins.bool oidc_verify_cert: Set it to `false` if your OIDC server is hosted via self-signed certificate.
    :param _builtins.str registry_id: The id of the Managed Private Registry.
    :param _builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['oidcAdminGroup'] = oidc_admin_group
    __args__['oidcAutoOnboard'] = oidc_auto_onboard
    __args__['oidcClientId'] = oidc_client_id
    __args__['oidcEndpoint'] = oidc_endpoint
    __args__['oidcGroupsClaim'] = oidc_groups_claim
    __args__['oidcName'] = oidc_name
    __args__['oidcScope'] = oidc_scope
    __args__['oidcUserClaim'] = oidc_user_claim
    __args__['oidcVerifyCert'] = oidc_verify_cert
    __args__['registryId'] = registry_id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getContainerRegistryOIDC:getContainerRegistryOIDC', __args__, opts=opts, typ=GetContainerRegistryOIDCResult)
    return __ret__.apply(lambda __response__: GetContainerRegistryOIDCResult(
        id=pulumi.get(__response__, 'id'),
        oidc_admin_group=pulumi.get(__response__, 'oidc_admin_group'),
        oidc_auto_onboard=pulumi.get(__response__, 'oidc_auto_onboard'),
        oidc_client_id=pulumi.get(__response__, 'oidc_client_id'),
        oidc_endpoint=pulumi.get(__response__, 'oidc_endpoint'),
        oidc_groups_claim=pulumi.get(__response__, 'oidc_groups_claim'),
        oidc_name=pulumi.get(__response__, 'oidc_name'),
        oidc_scope=pulumi.get(__response__, 'oidc_scope'),
        oidc_user_claim=pulumi.get(__response__, 'oidc_user_claim'),
        oidc_verify_cert=pulumi.get(__response__, 'oidc_verify_cert'),
        registry_id=pulumi.get(__response__, 'registry_id'),
        service_name=pulumi.get(__response__, 'service_name')))
