# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStorageResult',
    'AwaitableGetStorageResult',
    'get_storage',
    'get_storage_output',
]

@pulumi.output_type
class GetStorageResult:
    """
    A collection of values returned by getStorage.
    """
    def __init__(__self__, created_at=None, encryption=None, id=None, limit=None, marker=None, name=None, objects=None, objects_count=None, objects_size=None, owner_id=None, prefix=None, region=None, region_name=None, replication=None, service_name=None, tags=None, versioning=None, virtual_host=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if encryption and not isinstance(encryption, dict):
            raise TypeError("Expected argument 'encryption' to be a dict")
        pulumi.set(__self__, "encryption", encryption)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, float):
            raise TypeError("Expected argument 'limit' to be a float")
        pulumi.set(__self__, "limit", limit)
        if marker and not isinstance(marker, str):
            raise TypeError("Expected argument 'marker' to be a str")
        pulumi.set(__self__, "marker", marker)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)
        if objects_count and not isinstance(objects_count, float):
            raise TypeError("Expected argument 'objects_count' to be a float")
        pulumi.set(__self__, "objects_count", objects_count)
        if objects_size and not isinstance(objects_size, float):
            raise TypeError("Expected argument 'objects_size' to be a float")
        pulumi.set(__self__, "objects_size", objects_size)
        if owner_id and not isinstance(owner_id, float):
            raise TypeError("Expected argument 'owner_id' to be a float")
        pulumi.set(__self__, "owner_id", owner_id)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if region_name and not isinstance(region_name, str):
            raise TypeError("Expected argument 'region_name' to be a str")
        pulumi.set(__self__, "region_name", region_name)
        if replication and not isinstance(replication, dict):
            raise TypeError("Expected argument 'replication' to be a dict")
        pulumi.set(__self__, "replication", replication)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if versioning and not isinstance(versioning, dict):
            raise TypeError("Expected argument 'versioning' to be a dict")
        pulumi.set(__self__, "versioning", versioning)
        if virtual_host and not isinstance(virtual_host, str):
            raise TypeError("Expected argument 'virtual_host' to be a str")
        pulumi.set(__self__, "virtual_host", virtual_host)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and timestamp when the resource was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> 'outputs.GetStorageEncryptionResult':
        """
        Encryption configuration
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> _builtins.float:
        """
        Limit the number of objects returned (1000 maximum, defaults to 1000)
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter
    def marker(self) -> _builtins.str:
        """
        Key to start with when listing objects
        """
        return pulumi.get(self, "marker")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def objects(self) -> Sequence['outputs.GetStorageObjectResult']:
        """
        Container objects
        """
        return pulumi.get(self, "objects")

    @_builtins.property
    @pulumi.getter(name="objectsCount")
    def objects_count(self) -> _builtins.float:
        """
        Container total objects count
        """
        return pulumi.get(self, "objects_count")

    @_builtins.property
    @pulumi.getter(name="objectsSize")
    def objects_size(self) -> _builtins.float:
        """
        Container total objects size (bytes)
        """
        return pulumi.get(self, "objects_size")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.float:
        """
        Container owner user ID
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        List objects whose key begins with this prefix
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Container region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter
    def replication(self) -> 'outputs.GetStorageReplicationResult':
        """
        Replication configuration
        """
        return pulumi.get(self, "replication")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Container tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> 'outputs.GetStorageVersioningResult':
        """
        Versioning configuration
        """
        return pulumi.get(self, "versioning")

    @_builtins.property
    @pulumi.getter(name="virtualHost")
    def virtual_host(self) -> _builtins.str:
        """
        Container virtual host
        """
        return pulumi.get(self, "virtual_host")


class AwaitableGetStorageResult(GetStorageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageResult(
            created_at=self.created_at,
            encryption=self.encryption,
            id=self.id,
            limit=self.limit,
            marker=self.marker,
            name=self.name,
            objects=self.objects,
            objects_count=self.objects_count,
            objects_size=self.objects_size,
            owner_id=self.owner_id,
            prefix=self.prefix,
            region=self.region,
            region_name=self.region_name,
            replication=self.replication,
            service_name=self.service_name,
            tags=self.tags,
            versioning=self.versioning,
            virtual_host=self.virtual_host)


def get_storage(limit: Optional[_builtins.float] = None,
                marker: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                prefix: Optional[_builtins.str] = None,
                region_name: Optional[_builtins.str] = None,
                service_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageResult:
    """
    Get S3™* compatible storage container. \\* S3 is a trademark filed by Amazon Technologies,Inc. OVHcloud's service is not sponsored by, endorsed by, or otherwise affiliated with Amazon Technologies,Inc.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    storage = ovh.CloudProject.get_storage(service_name="<public cloud project ID>",
        region_name="GRA",
        name="my-storage-name")
    ```


    :param _builtins.float limit: Limit the number of objects returned (1000 maximum, defaults to 1000)
    :param _builtins.str marker: Key to start with when listing objects
    :param _builtins.str name: Name
    :param _builtins.str prefix: List objects whose key begins with this prefix
    :param _builtins.str region_name: Region name
    :param _builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['marker'] = marker
    __args__['name'] = name
    __args__['prefix'] = prefix
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getStorage:getStorage', __args__, opts=opts, typ=GetStorageResult).value

    return AwaitableGetStorageResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        encryption=pulumi.get(__ret__, 'encryption'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        marker=pulumi.get(__ret__, 'marker'),
        name=pulumi.get(__ret__, 'name'),
        objects=pulumi.get(__ret__, 'objects'),
        objects_count=pulumi.get(__ret__, 'objects_count'),
        objects_size=pulumi.get(__ret__, 'objects_size'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        prefix=pulumi.get(__ret__, 'prefix'),
        region=pulumi.get(__ret__, 'region'),
        region_name=pulumi.get(__ret__, 'region_name'),
        replication=pulumi.get(__ret__, 'replication'),
        service_name=pulumi.get(__ret__, 'service_name'),
        tags=pulumi.get(__ret__, 'tags'),
        versioning=pulumi.get(__ret__, 'versioning'),
        virtual_host=pulumi.get(__ret__, 'virtual_host'))
def get_storage_output(limit: Optional[pulumi.Input[Optional[_builtins.float]]] = None,
                       marker: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       name: Optional[pulumi.Input[_builtins.str]] = None,
                       prefix: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region_name: Optional[pulumi.Input[_builtins.str]] = None,
                       service_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageResult]:
    """
    Get S3™* compatible storage container. \\* S3 is a trademark filed by Amazon Technologies,Inc. OVHcloud's service is not sponsored by, endorsed by, or otherwise affiliated with Amazon Technologies,Inc.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    storage = ovh.CloudProject.get_storage(service_name="<public cloud project ID>",
        region_name="GRA",
        name="my-storage-name")
    ```


    :param _builtins.float limit: Limit the number of objects returned (1000 maximum, defaults to 1000)
    :param _builtins.str marker: Key to start with when listing objects
    :param _builtins.str name: Name
    :param _builtins.str prefix: List objects whose key begins with this prefix
    :param _builtins.str region_name: Region name
    :param _builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['marker'] = marker
    __args__['name'] = name
    __args__['prefix'] = prefix
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getStorage:getStorage', __args__, opts=opts, typ=GetStorageResult)
    return __ret__.apply(lambda __response__: GetStorageResult(
        created_at=pulumi.get(__response__, 'created_at'),
        encryption=pulumi.get(__response__, 'encryption'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        marker=pulumi.get(__response__, 'marker'),
        name=pulumi.get(__response__, 'name'),
        objects=pulumi.get(__response__, 'objects'),
        objects_count=pulumi.get(__response__, 'objects_count'),
        objects_size=pulumi.get(__response__, 'objects_size'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        prefix=pulumi.get(__response__, 'prefix'),
        region=pulumi.get(__response__, 'region'),
        region_name=pulumi.get(__response__, 'region_name'),
        replication=pulumi.get(__response__, 'replication'),
        service_name=pulumi.get(__response__, 'service_name'),
        tags=pulumi.get(__response__, 'tags'),
        versioning=pulumi.get(__response__, 'versioning'),
        virtual_host=pulumi.get(__response__, 'virtual_host')))
