# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceSnapshotArgs', 'InstanceSnapshot']

@pulumi.input_type
class InstanceSnapshotArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceSnapshot resource.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.str] name: Snapshot name
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "service_name", service_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance ID
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _InstanceSnapshotState:
    def __init__(__self__, *,
                 creation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 min_disk: Optional[pulumi.Input[_builtins.float]] = None,
                 min_ram: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_code: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceSnapshot resources.
        :param pulumi.Input[_builtins.str] creation_date: Image creation date
        :param pulumi.Input[_builtins.str] flavor_type: Image usable only for this type of flavor if not null
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.float] min_disk: Minimum disks required to use image
        :param pulumi.Input[_builtins.float] min_ram: Minimum RAM required to use image
        :param pulumi.Input[_builtins.str] name: Snapshot name
        :param pulumi.Input[_builtins.str] plan_code: Order plan code
        :param pulumi.Input[_builtins.str] region: Image region
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.float] size: Image size (in GiB)
        :param pulumi.Input[_builtins.str] status: Image status
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags about the image
        :param pulumi.Input[_builtins.str] type: Image type
        :param pulumi.Input[_builtins.str] user: User to connect with
        :param pulumi.Input[_builtins.str] visibility: Image visibility
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if flavor_type is not None:
            pulumi.set(__self__, "flavor_type", flavor_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if min_disk is not None:
            pulumi.set(__self__, "min_disk", min_disk)
        if min_ram is not None:
            pulumi.set(__self__, "min_ram", min_ram)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan_code is not None:
            pulumi.set(__self__, "plan_code", plan_code)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image creation date
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @_builtins.property
    @pulumi.getter(name="flavorType")
    def flavor_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image usable only for this type of flavor if not null
        """
        return pulumi.get(self, "flavor_type")

    @flavor_type.setter
    def flavor_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="minDisk")
    def min_disk(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Minimum disks required to use image
        """
        return pulumi.get(self, "min_disk")

    @min_disk.setter
    def min_disk(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "min_disk", value)

    @_builtins.property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Minimum RAM required to use image
        """
        return pulumi.get(self, "min_ram")

    @min_ram.setter
    def min_ram(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "min_ram", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Order plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_code", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Image size (in GiB)
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags about the image
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User to connect with
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image visibility
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.type_token("ovh:CloudProject/instanceSnapshot:InstanceSnapshot")
class InstanceSnapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create and manage snapshots for an instance in a public cloud project.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        snapshot = ovh.cloudproject.InstanceSnapshot("snapshot",
            service_name="<public cloud project ID>",
            instance_id="<instance ID>",
            name="SnapshotExample")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.str] name: Snapshot name
        :param pulumi.Input[_builtins.str] service_name: Service name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceSnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create and manage snapshots for an instance in a public cloud project.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        snapshot = ovh.cloudproject.InstanceSnapshot("snapshot",
            service_name="<public cloud project ID>",
            instance_id="<instance ID>",
            name="SnapshotExample")
        ```

        :param str resource_name: The name of the resource.
        :param InstanceSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceSnapshotArgs.__new__(InstanceSnapshotArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["flavor_type"] = None
            __props__.__dict__["min_disk"] = None
            __props__.__dict__["min_ram"] = None
            __props__.__dict__["plan_code"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["user"] = None
            __props__.__dict__["visibility"] = None
        super(InstanceSnapshot, __self__).__init__(
            'ovh:CloudProject/instanceSnapshot:InstanceSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_date: Optional[pulumi.Input[_builtins.str]] = None,
            flavor_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            min_disk: Optional[pulumi.Input[_builtins.float]] = None,
            min_ram: Optional[pulumi.Input[_builtins.float]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            plan_code: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.float]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None,
            visibility: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceSnapshot':
        """
        Get an existing InstanceSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_date: Image creation date
        :param pulumi.Input[_builtins.str] flavor_type: Image usable only for this type of flavor if not null
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.float] min_disk: Minimum disks required to use image
        :param pulumi.Input[_builtins.float] min_ram: Minimum RAM required to use image
        :param pulumi.Input[_builtins.str] name: Snapshot name
        :param pulumi.Input[_builtins.str] plan_code: Order plan code
        :param pulumi.Input[_builtins.str] region: Image region
        :param pulumi.Input[_builtins.str] service_name: Service name
        :param pulumi.Input[_builtins.float] size: Image size (in GiB)
        :param pulumi.Input[_builtins.str] status: Image status
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags about the image
        :param pulumi.Input[_builtins.str] type: Image type
        :param pulumi.Input[_builtins.str] user: User to connect with
        :param pulumi.Input[_builtins.str] visibility: Image visibility
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceSnapshotState.__new__(_InstanceSnapshotState)

        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["flavor_type"] = flavor_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["min_disk"] = min_disk
        __props__.__dict__["min_ram"] = min_ram
        __props__.__dict__["name"] = name
        __props__.__dict__["plan_code"] = plan_code
        __props__.__dict__["region"] = region
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["user"] = user
        __props__.__dict__["visibility"] = visibility
        return InstanceSnapshot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[_builtins.str]:
        """
        Image creation date
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter(name="flavorType")
    def flavor_type(self) -> pulumi.Output[_builtins.str]:
        """
        Image usable only for this type of flavor if not null
        """
        return pulumi.get(self, "flavor_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="minDisk")
    def min_disk(self) -> pulumi.Output[_builtins.float]:
        """
        Minimum disks required to use image
        """
        return pulumi.get(self, "min_disk")

    @_builtins.property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> pulumi.Output[_builtins.float]:
        """
        Minimum RAM required to use image
        """
        return pulumi.get(self, "min_ram")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Snapshot name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Output[_builtins.str]:
        """
        Order plan code
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Image region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.float]:
        """
        Image size (in GiB)
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Image status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Tags about the image
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Image type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        User to connect with
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[_builtins.str]:
        """
        Image visibility
        """
        return pulumi.get(self, "visibility")

