# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubeNodePoolArgs', 'KubeNodePool']

@pulumi.input_type
class KubeNodePoolArgs:
    def __init__(__self__, *,
                 flavor_name: pulumi.Input[_builtins.str],
                 kube_id: pulumi.Input[_builtins.str],
                 anti_affinity: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscale: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscaling_scale_down_unneeded_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscaling_scale_down_unready_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscaling_scale_down_utilization_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 desired_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 monthly_billed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input['KubeNodePoolTemplateArgs']] = None):
        """
        The set of arguments for constructing a KubeNodePool resource.
        :param pulumi.Input[_builtins.str] flavor_name: a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] kube_id: The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.bool] anti_affinity: should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.bool] autoscale: Enable auto-scaling for the pool. Default to `false`.
        :param pulumi.Input[_builtins.int] autoscaling_scale_down_unneeded_time_seconds: scaleDownUnneededTimeSeconds autoscaling parameter How long a node should be unneeded before it is eligible for scale down
        :param pulumi.Input[_builtins.int] autoscaling_scale_down_unready_time_seconds: scaleDownUnreadyTimeSeconds autoscaling parameter How long an unready node should be unneeded before it is eligible for scale down
        :param pulumi.Input[_builtins.float] autoscaling_scale_down_utilization_threshold: scaleDownUtilizationThreshold autoscaling parameter Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
               * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
        :param pulumi.Input[_builtins.int] desired_nodes: number of nodes to start.
        :param pulumi.Input[_builtins.int] max_nodes: maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        :param pulumi.Input[_builtins.int] min_nodes: minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        :param pulumi.Input[_builtins.bool] monthly_billed: should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] name: The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input['KubeNodePoolTemplateArgs'] template: Node pool template
        """
        pulumi.set(__self__, "flavor_name", flavor_name)
        pulumi.set(__self__, "kube_id", kube_id)
        if anti_affinity is not None:
            pulumi.set(__self__, "anti_affinity", anti_affinity)
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if autoscaling_scale_down_unneeded_time_seconds is not None:
            pulumi.set(__self__, "autoscaling_scale_down_unneeded_time_seconds", autoscaling_scale_down_unneeded_time_seconds)
        if autoscaling_scale_down_unready_time_seconds is not None:
            pulumi.set(__self__, "autoscaling_scale_down_unready_time_seconds", autoscaling_scale_down_unready_time_seconds)
        if autoscaling_scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "autoscaling_scale_down_utilization_threshold", autoscaling_scale_down_utilization_threshold)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if desired_nodes is not None:
            pulumi.set(__self__, "desired_nodes", desired_nodes)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if monthly_billed is not None:
            pulumi.set(__self__, "monthly_billed", monthly_billed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> pulumi.Input[_builtins.str]:
        """
        a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor_name", value)

    @_builtins.property
    @pulumi.getter(name="kubeId")
    def kube_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "kube_id")

    @kube_id.setter
    def kube_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kube_id", value)

    @_builtins.property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "anti_affinity")

    @anti_affinity.setter
    def anti_affinity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "anti_affinity", value)

    @_builtins.property
    @pulumi.getter
    def autoscale(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable auto-scaling for the pool. Default to `false`.
        """
        return pulumi.get(self, "autoscale")

    @autoscale.setter
    def autoscale(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autoscale", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingScaleDownUnneededTimeSeconds")
    def autoscaling_scale_down_unneeded_time_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        scaleDownUnneededTimeSeconds autoscaling parameter How long a node should be unneeded before it is eligible for scale down
        """
        return pulumi.get(self, "autoscaling_scale_down_unneeded_time_seconds")

    @autoscaling_scale_down_unneeded_time_seconds.setter
    def autoscaling_scale_down_unneeded_time_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autoscaling_scale_down_unneeded_time_seconds", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingScaleDownUnreadyTimeSeconds")
    def autoscaling_scale_down_unready_time_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        scaleDownUnreadyTimeSeconds autoscaling parameter How long an unready node should be unneeded before it is eligible for scale down
        """
        return pulumi.get(self, "autoscaling_scale_down_unready_time_seconds")

    @autoscaling_scale_down_unready_time_seconds.setter
    def autoscaling_scale_down_unready_time_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autoscaling_scale_down_unready_time_seconds", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingScaleDownUtilizationThreshold")
    def autoscaling_scale_down_utilization_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        scaleDownUtilizationThreshold autoscaling parameter Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        """
        return pulumi.get(self, "autoscaling_scale_down_utilization_threshold")

    @autoscaling_scale_down_utilization_threshold.setter
    def autoscaling_scale_down_utilization_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "autoscaling_scale_down_utilization_threshold", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="desiredNodes")
    def desired_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        number of nodes to start.
        """
        return pulumi.get(self, "desired_nodes")

    @desired_nodes.setter
    def desired_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_nodes", value)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_nodes", value)

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_nodes", value)

    @_builtins.property
    @pulumi.getter(name="monthlyBilled")
    def monthly_billed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "monthly_billed")

    @monthly_billed.setter
    def monthly_billed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monthly_billed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['KubeNodePoolTemplateArgs']]:
        """
        Node pool template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['KubeNodePoolTemplateArgs']]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class _KubeNodePoolState:
    def __init__(__self__, *,
                 anti_affinity: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscale: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscaling_scale_down_unneeded_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscaling_scale_down_unready_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscaling_scale_down_utilization_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 current_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 desired_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 monthly_billed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size_status: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input['KubeNodePoolTemplateArgs']] = None,
                 up_to_date_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KubeNodePool resources.
        :param pulumi.Input[_builtins.bool] anti_affinity: should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.bool] autoscale: Enable auto-scaling for the pool. Default to `false`.
        :param pulumi.Input[_builtins.int] autoscaling_scale_down_unneeded_time_seconds: scaleDownUnneededTimeSeconds autoscaling parameter How long a node should be unneeded before it is eligible for scale down
        :param pulumi.Input[_builtins.int] autoscaling_scale_down_unready_time_seconds: scaleDownUnreadyTimeSeconds autoscaling parameter How long an unready node should be unneeded before it is eligible for scale down
        :param pulumi.Input[_builtins.float] autoscaling_scale_down_utilization_threshold: scaleDownUtilizationThreshold autoscaling parameter Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
               * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
        :param pulumi.Input[_builtins.int] available_nodes: Number of nodes which are actually ready in the pool
        :param pulumi.Input[_builtins.str] created_at: Creation date
        :param pulumi.Input[_builtins.int] current_nodes: Number of nodes present in the pool
        :param pulumi.Input[_builtins.int] desired_nodes: number of nodes to start.
        :param pulumi.Input[_builtins.str] flavor: Flavor name
        :param pulumi.Input[_builtins.str] flavor_name: a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] kube_id: The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.int] max_nodes: maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        :param pulumi.Input[_builtins.int] min_nodes: minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        :param pulumi.Input[_builtins.bool] monthly_billed: should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] name: The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] project_id: Project id
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] size_status: Status describing the state between number of nodes wanted and available ones
        :param pulumi.Input[_builtins.str] status: Current status
        :param pulumi.Input['KubeNodePoolTemplateArgs'] template: Node pool template
        :param pulumi.Input[_builtins.int] up_to_date_nodes: Number of nodes with the latest version installed in the pool
        :param pulumi.Input[_builtins.str] updated_at: Last update date
        """
        if anti_affinity is not None:
            pulumi.set(__self__, "anti_affinity", anti_affinity)
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if autoscaling_scale_down_unneeded_time_seconds is not None:
            pulumi.set(__self__, "autoscaling_scale_down_unneeded_time_seconds", autoscaling_scale_down_unneeded_time_seconds)
        if autoscaling_scale_down_unready_time_seconds is not None:
            pulumi.set(__self__, "autoscaling_scale_down_unready_time_seconds", autoscaling_scale_down_unready_time_seconds)
        if autoscaling_scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "autoscaling_scale_down_utilization_threshold", autoscaling_scale_down_utilization_threshold)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_nodes is not None:
            pulumi.set(__self__, "available_nodes", available_nodes)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if current_nodes is not None:
            pulumi.set(__self__, "current_nodes", current_nodes)
        if desired_nodes is not None:
            pulumi.set(__self__, "desired_nodes", desired_nodes)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if flavor_name is not None:
            pulumi.set(__self__, "flavor_name", flavor_name)
        if kube_id is not None:
            pulumi.set(__self__, "kube_id", kube_id)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if monthly_billed is not None:
            pulumi.set(__self__, "monthly_billed", monthly_billed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if size_status is not None:
            pulumi.set(__self__, "size_status", size_status)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if up_to_date_nodes is not None:
            pulumi.set(__self__, "up_to_date_nodes", up_to_date_nodes)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "anti_affinity")

    @anti_affinity.setter
    def anti_affinity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "anti_affinity", value)

    @_builtins.property
    @pulumi.getter
    def autoscale(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable auto-scaling for the pool. Default to `false`.
        """
        return pulumi.get(self, "autoscale")

    @autoscale.setter
    def autoscale(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autoscale", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingScaleDownUnneededTimeSeconds")
    def autoscaling_scale_down_unneeded_time_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        scaleDownUnneededTimeSeconds autoscaling parameter How long a node should be unneeded before it is eligible for scale down
        """
        return pulumi.get(self, "autoscaling_scale_down_unneeded_time_seconds")

    @autoscaling_scale_down_unneeded_time_seconds.setter
    def autoscaling_scale_down_unneeded_time_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autoscaling_scale_down_unneeded_time_seconds", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingScaleDownUnreadyTimeSeconds")
    def autoscaling_scale_down_unready_time_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        scaleDownUnreadyTimeSeconds autoscaling parameter How long an unready node should be unneeded before it is eligible for scale down
        """
        return pulumi.get(self, "autoscaling_scale_down_unready_time_seconds")

    @autoscaling_scale_down_unready_time_seconds.setter
    def autoscaling_scale_down_unready_time_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autoscaling_scale_down_unready_time_seconds", value)

    @_builtins.property
    @pulumi.getter(name="autoscalingScaleDownUtilizationThreshold")
    def autoscaling_scale_down_utilization_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        scaleDownUtilizationThreshold autoscaling parameter Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        """
        return pulumi.get(self, "autoscaling_scale_down_utilization_threshold")

    @autoscaling_scale_down_utilization_threshold.setter
    def autoscaling_scale_down_utilization_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "autoscaling_scale_down_utilization_threshold", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableNodes")
    def available_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes which are actually ready in the pool
        """
        return pulumi.get(self, "available_nodes")

    @available_nodes.setter
    def available_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "available_nodes", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation date
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="currentNodes")
    def current_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes present in the pool
        """
        return pulumi.get(self, "current_nodes")

    @current_nodes.setter
    def current_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "current_nodes", value)

    @_builtins.property
    @pulumi.getter(name="desiredNodes")
    def desired_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        number of nodes to start.
        """
        return pulumi.get(self, "desired_nodes")

    @desired_nodes.setter
    def desired_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_nodes", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flavor name
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_name", value)

    @_builtins.property
    @pulumi.getter(name="kubeId")
    def kube_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "kube_id")

    @kube_id.setter
    def kube_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_id", value)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_nodes", value)

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_nodes", value)

    @_builtins.property
    @pulumi.getter(name="monthlyBilled")
    def monthly_billed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "monthly_billed")

    @monthly_billed.setter
    def monthly_billed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monthly_billed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project id
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="sizeStatus")
    def size_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status describing the state between number of nodes wanted and available ones
        """
        return pulumi.get(self, "size_status")

    @size_status.setter
    def size_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size_status", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['KubeNodePoolTemplateArgs']]:
        """
        Node pool template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['KubeNodePoolTemplateArgs']]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter(name="upToDateNodes")
    def up_to_date_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes with the latest version installed in the pool
        """
        return pulumi.get(self, "up_to_date_nodes")

    @up_to_date_nodes.setter
    def up_to_date_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "up_to_date_nodes", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update date
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("ovh:CloudProject/kubeNodePool:KubeNodePool")
class KubeNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anti_affinity: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscale: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscaling_scale_down_unneeded_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscaling_scale_down_unready_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscaling_scale_down_utilization_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 desired_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 monthly_billed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[Union['KubeNodePoolTemplateArgs', 'KubeNodePoolTemplateArgsDict']]] = None,
                 __props__=None):
        """
        Creates a nodepool in a OVHcloud Managed Kubernetes Service cluster.

        ## Example Usage

        Create a simple node pool in your Kubernetes cluster:

        ```python
        import pulumi
        import pulumi_ovh as ovh

        node_pool = ovh.cloudproject.KubeNodePool("node_pool",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            name="my-pool-1",
            flavor_name="b3-8",
            desired_nodes=3)
        ```

        Create a node pool on a specific availability zones for Kubernetes cluster (with multi-zones support):

        ```python
        import pulumi
        import pulumi_ovh as ovh

        node_pool_multi_zones = ovh.cloudproject.KubeNodePool("node_pool_multi_zones",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            name="my-pool-zone-a",
            flavor_name="b3-8",
            desired_nodes=3,
            availability_zones=["eu-west-par-a"])
        ```

        Create an advanced node pool in your Kubernetes cluster:

        ```python
        import pulumi
        import pulumi_ovh as ovh

        pool = ovh.cloudproject.KubeNodePool("pool",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            name="my-pool",
            flavor_name="b3-8",
            desired_nodes=3,
            template={
                "metadata": {
                    "annotations": {
                        "k1": "v1",
                        "k2": "v2",
                    },
                    "finalizers": [],
                    "labels": {
                        "k3": "v3",
                        "k4": "v4",
                    },
                },
                "spec": {
                    "unschedulable": False,
                    "taints": [{
                        "effect": "PreferNoSchedule",
                        "key": "k",
                        "value": "v",
                    }],
                },
            })
        ```

        ## Import

        OVHcloud Managed Kubernetes Service cluster node pool can be imported using the `service_name`, the `id` of the cluster, and the `id` of the nodepool separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:CloudProject/kubeNodePool:KubeNodePool pool service_name/kube_id/poolid
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] anti_affinity: should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.bool] autoscale: Enable auto-scaling for the pool. Default to `false`.
        :param pulumi.Input[_builtins.int] autoscaling_scale_down_unneeded_time_seconds: scaleDownUnneededTimeSeconds autoscaling parameter How long a node should be unneeded before it is eligible for scale down
        :param pulumi.Input[_builtins.int] autoscaling_scale_down_unready_time_seconds: scaleDownUnreadyTimeSeconds autoscaling parameter How long an unready node should be unneeded before it is eligible for scale down
        :param pulumi.Input[_builtins.float] autoscaling_scale_down_utilization_threshold: scaleDownUtilizationThreshold autoscaling parameter Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
               * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
        :param pulumi.Input[_builtins.int] desired_nodes: number of nodes to start.
        :param pulumi.Input[_builtins.str] flavor_name: a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] kube_id: The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.int] max_nodes: maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        :param pulumi.Input[_builtins.int] min_nodes: minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        :param pulumi.Input[_builtins.bool] monthly_billed: should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] name: The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[Union['KubeNodePoolTemplateArgs', 'KubeNodePoolTemplateArgsDict']] template: Node pool template
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubeNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a nodepool in a OVHcloud Managed Kubernetes Service cluster.

        ## Example Usage

        Create a simple node pool in your Kubernetes cluster:

        ```python
        import pulumi
        import pulumi_ovh as ovh

        node_pool = ovh.cloudproject.KubeNodePool("node_pool",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            name="my-pool-1",
            flavor_name="b3-8",
            desired_nodes=3)
        ```

        Create a node pool on a specific availability zones for Kubernetes cluster (with multi-zones support):

        ```python
        import pulumi
        import pulumi_ovh as ovh

        node_pool_multi_zones = ovh.cloudproject.KubeNodePool("node_pool_multi_zones",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            name="my-pool-zone-a",
            flavor_name="b3-8",
            desired_nodes=3,
            availability_zones=["eu-west-par-a"])
        ```

        Create an advanced node pool in your Kubernetes cluster:

        ```python
        import pulumi
        import pulumi_ovh as ovh

        pool = ovh.cloudproject.KubeNodePool("pool",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            name="my-pool",
            flavor_name="b3-8",
            desired_nodes=3,
            template={
                "metadata": {
                    "annotations": {
                        "k1": "v1",
                        "k2": "v2",
                    },
                    "finalizers": [],
                    "labels": {
                        "k3": "v3",
                        "k4": "v4",
                    },
                },
                "spec": {
                    "unschedulable": False,
                    "taints": [{
                        "effect": "PreferNoSchedule",
                        "key": "k",
                        "value": "v",
                    }],
                },
            })
        ```

        ## Import

        OVHcloud Managed Kubernetes Service cluster node pool can be imported using the `service_name`, the `id` of the cluster, and the `id` of the nodepool separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:CloudProject/kubeNodePool:KubeNodePool pool service_name/kube_id/poolid
        ```

        :param str resource_name: The name of the resource.
        :param KubeNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubeNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anti_affinity: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscale: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscaling_scale_down_unneeded_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscaling_scale_down_unready_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscaling_scale_down_utilization_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 desired_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 monthly_billed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[Union['KubeNodePoolTemplateArgs', 'KubeNodePoolTemplateArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubeNodePoolArgs.__new__(KubeNodePoolArgs)

            __props__.__dict__["anti_affinity"] = anti_affinity
            __props__.__dict__["autoscale"] = autoscale
            __props__.__dict__["autoscaling_scale_down_unneeded_time_seconds"] = autoscaling_scale_down_unneeded_time_seconds
            __props__.__dict__["autoscaling_scale_down_unready_time_seconds"] = autoscaling_scale_down_unready_time_seconds
            __props__.__dict__["autoscaling_scale_down_utilization_threshold"] = autoscaling_scale_down_utilization_threshold
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["desired_nodes"] = desired_nodes
            if flavor_name is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_name'")
            __props__.__dict__["flavor_name"] = flavor_name
            if kube_id is None and not opts.urn:
                raise TypeError("Missing required property 'kube_id'")
            __props__.__dict__["kube_id"] = kube_id
            __props__.__dict__["max_nodes"] = max_nodes
            __props__.__dict__["min_nodes"] = min_nodes
            __props__.__dict__["monthly_billed"] = monthly_billed
            __props__.__dict__["name"] = name
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["template"] = template
            __props__.__dict__["available_nodes"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["current_nodes"] = None
            __props__.__dict__["flavor"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["size_status"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["up_to_date_nodes"] = None
            __props__.__dict__["updated_at"] = None
        super(KubeNodePool, __self__).__init__(
            'ovh:CloudProject/kubeNodePool:KubeNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anti_affinity: Optional[pulumi.Input[_builtins.bool]] = None,
            autoscale: Optional[pulumi.Input[_builtins.bool]] = None,
            autoscaling_scale_down_unneeded_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            autoscaling_scale_down_unready_time_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            autoscaling_scale_down_utilization_threshold: Optional[pulumi.Input[_builtins.float]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            available_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            current_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            desired_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            flavor: Optional[pulumi.Input[_builtins.str]] = None,
            flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
            kube_id: Optional[pulumi.Input[_builtins.str]] = None,
            max_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            min_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            monthly_billed: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            size_status: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            template: Optional[pulumi.Input[Union['KubeNodePoolTemplateArgs', 'KubeNodePoolTemplateArgsDict']]] = None,
            up_to_date_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'KubeNodePool':
        """
        Get an existing KubeNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] anti_affinity: should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.bool] autoscale: Enable auto-scaling for the pool. Default to `false`.
        :param pulumi.Input[_builtins.int] autoscaling_scale_down_unneeded_time_seconds: scaleDownUnneededTimeSeconds autoscaling parameter How long a node should be unneeded before it is eligible for scale down
        :param pulumi.Input[_builtins.int] autoscaling_scale_down_unready_time_seconds: scaleDownUnreadyTimeSeconds autoscaling parameter How long an unready node should be unneeded before it is eligible for scale down
        :param pulumi.Input[_builtins.float] autoscaling_scale_down_utilization_threshold: scaleDownUtilizationThreshold autoscaling parameter Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
               * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
        :param pulumi.Input[_builtins.int] available_nodes: Number of nodes which are actually ready in the pool
        :param pulumi.Input[_builtins.str] created_at: Creation date
        :param pulumi.Input[_builtins.int] current_nodes: Number of nodes present in the pool
        :param pulumi.Input[_builtins.int] desired_nodes: number of nodes to start.
        :param pulumi.Input[_builtins.str] flavor: Flavor name
        :param pulumi.Input[_builtins.str] flavor_name: a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] kube_id: The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.int] max_nodes: maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        :param pulumi.Input[_builtins.int] min_nodes: minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        :param pulumi.Input[_builtins.bool] monthly_billed: should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] name: The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] project_id: Project id
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] size_status: Status describing the state between number of nodes wanted and available ones
        :param pulumi.Input[_builtins.str] status: Current status
        :param pulumi.Input[Union['KubeNodePoolTemplateArgs', 'KubeNodePoolTemplateArgsDict']] template: Node pool template
        :param pulumi.Input[_builtins.int] up_to_date_nodes: Number of nodes with the latest version installed in the pool
        :param pulumi.Input[_builtins.str] updated_at: Last update date
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubeNodePoolState.__new__(_KubeNodePoolState)

        __props__.__dict__["anti_affinity"] = anti_affinity
        __props__.__dict__["autoscale"] = autoscale
        __props__.__dict__["autoscaling_scale_down_unneeded_time_seconds"] = autoscaling_scale_down_unneeded_time_seconds
        __props__.__dict__["autoscaling_scale_down_unready_time_seconds"] = autoscaling_scale_down_unready_time_seconds
        __props__.__dict__["autoscaling_scale_down_utilization_threshold"] = autoscaling_scale_down_utilization_threshold
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["available_nodes"] = available_nodes
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["current_nodes"] = current_nodes
        __props__.__dict__["desired_nodes"] = desired_nodes
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["flavor_name"] = flavor_name
        __props__.__dict__["kube_id"] = kube_id
        __props__.__dict__["max_nodes"] = max_nodes
        __props__.__dict__["min_nodes"] = min_nodes
        __props__.__dict__["monthly_billed"] = monthly_billed
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["size_status"] = size_status
        __props__.__dict__["status"] = status
        __props__.__dict__["template"] = template
        __props__.__dict__["up_to_date_nodes"] = up_to_date_nodes
        __props__.__dict__["updated_at"] = updated_at
        return KubeNodePool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> pulumi.Output[_builtins.bool]:
        """
        should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "anti_affinity")

    @_builtins.property
    @pulumi.getter
    def autoscale(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable auto-scaling for the pool. Default to `false`.
        """
        return pulumi.get(self, "autoscale")

    @_builtins.property
    @pulumi.getter(name="autoscalingScaleDownUnneededTimeSeconds")
    def autoscaling_scale_down_unneeded_time_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        scaleDownUnneededTimeSeconds autoscaling parameter How long a node should be unneeded before it is eligible for scale down
        """
        return pulumi.get(self, "autoscaling_scale_down_unneeded_time_seconds")

    @_builtins.property
    @pulumi.getter(name="autoscalingScaleDownUnreadyTimeSeconds")
    def autoscaling_scale_down_unready_time_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        scaleDownUnreadyTimeSeconds autoscaling parameter How long an unready node should be unneeded before it is eligible for scale down
        """
        return pulumi.get(self, "autoscaling_scale_down_unready_time_seconds")

    @_builtins.property
    @pulumi.getter(name="autoscalingScaleDownUtilizationThreshold")
    def autoscaling_scale_down_utilization_threshold(self) -> pulumi.Output[_builtins.float]:
        """
        scaleDownUtilizationThreshold autoscaling parameter Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        """
        return pulumi.get(self, "autoscaling_scale_down_utilization_threshold")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="availableNodes")
    def available_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        Number of nodes which are actually ready in the pool
        """
        return pulumi.get(self, "available_nodes")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation date
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="currentNodes")
    def current_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        Number of nodes present in the pool
        """
        return pulumi.get(self, "current_nodes")

    @_builtins.property
    @pulumi.getter(name="desiredNodes")
    def desired_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        number of nodes to start.
        """
        return pulumi.get(self, "desired_nodes")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[_builtins.str]:
        """
        Flavor name
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> pulumi.Output[_builtins.str]:
        """
        a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "flavor_name")

    @_builtins.property
    @pulumi.getter(name="kubeId")
    def kube_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "kube_id")

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        """
        return pulumi.get(self, "min_nodes")

    @_builtins.property
    @pulumi.getter(name="monthlyBilled")
    def monthly_billed(self) -> pulumi.Output[_builtins.bool]:
        """
        should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "monthly_billed")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project id
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="sizeStatus")
    def size_status(self) -> pulumi.Output[_builtins.str]:
        """
        Status describing the state between number of nodes wanted and available ones
        """
        return pulumi.get(self, "size_status")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Current status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.KubeNodePoolTemplate']]:
        """
        Node pool template
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="upToDateNodes")
    def up_to_date_nodes(self) -> pulumi.Output[_builtins.int]:
        """
        Number of nodes with the latest version installed in the pool
        """
        return pulumi.get(self, "up_to_date_nodes")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Last update date
        """
        return pulumi.get(self, "updated_at")

