# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AlertingFormattedMonthlyThreshold',
    'ContainerRegistryPlan',
    'ContainerRegistryPlanFeature',
    'ContainerRegistryPlanRegistryLimit',
    'DatabaseEndpoint',
    'DatabaseIpRestriction',
    'DatabaseNode',
    'GatewayExternalInformation',
    'GatewayExternalInformationIp',
    'GatewayInterface',
    'InstanceAddress',
    'InstanceAttachedVolume',
    'InstanceAutoBackup',
    'InstanceBootFrom',
    'InstanceFlavor',
    'InstanceGroup',
    'InstanceNetwork',
    'InstanceNetworkPrivate',
    'InstanceNetworkPrivateFloatingIp',
    'InstanceNetworkPrivateFloatingIpCreate',
    'InstanceNetworkPrivateGateway',
    'InstanceNetworkPrivateGatewayCreate',
    'InstanceNetworkPrivateNetwork',
    'InstanceNetworkPrivateNetworkCreate',
    'InstanceNetworkPrivateNetworkCreateSubnet',
    'InstanceSshKey',
    'InstanceSshKeyCreate',
    'KubeCustomization',
    'KubeCustomizationApiserver',
    'KubeCustomizationApiserverAdmissionplugin',
    'KubeCustomizationKubeProxy',
    'KubeCustomizationKubeProxyIptables',
    'KubeCustomizationKubeProxyIpvs',
    'KubeKubeconfigAttribute',
    'KubeNodePoolTemplate',
    'KubeNodePoolTemplateMetadata',
    'KubeNodePoolTemplateSpec',
    'KubePrivateNetworkConfiguration',
    'LoadBalancerFloatingIp',
    'LoadBalancerListener',
    'LoadBalancerListenerPool',
    'LoadBalancerListenerPoolHealthMonitor',
    'LoadBalancerListenerPoolHealthMonitorHttpConfiguration',
    'LoadBalancerListenerPoolMember',
    'LoadBalancerListenerPoolSessionPersistence',
    'LoadBalancerNetwork',
    'LoadBalancerNetworkPrivate',
    'LoadBalancerNetworkPrivateFloatingIp',
    'LoadBalancerNetworkPrivateFloatingIpCreate',
    'LoadBalancerNetworkPrivateGateway',
    'LoadBalancerNetworkPrivateGatewayCreate',
    'LoadBalancerNetworkPrivateNetwork',
    'NetworkPrivateRegionsAttribute',
    'NetworkPrivateRegionsStatus',
    'NetworkPrivateSubnetIpPool',
    'NetworkPrivateSubnetV2AllocationPool',
    'NetworkPrivateSubnetV2HostRoute',
    'ProjectOrder',
    'ProjectOrderDetail',
    'ProjectPlan',
    'ProjectPlanConfiguration',
    'ProjectPlanOption',
    'ProjectPlanOptionConfiguration',
    'ProjectRegionService',
    'RancherCurrentState',
    'RancherCurrentStateIpRestriction',
    'RancherCurrentStateNetworking',
    'RancherCurrentStateUsage',
    'RancherCurrentTask',
    'RancherTargetSpec',
    'RancherTargetSpecIpRestriction',
    'RegionNetworkSubnet',
    'RegionNetworkSubnetAllocationPool',
    'RegionNetworkSubnetHostRoute',
    'StorageEncryption',
    'StorageObject',
    'StorageReplication',
    'StorageReplicationRule',
    'StorageReplicationRuleDestination',
    'StorageReplicationRuleFilter',
    'StorageVersioning',
    'UserRole',
    'VolumeSubOperation',
    'GetCapabilitiesContainerFilterFeatureResult',
    'GetCapabilitiesContainerFilterRegistryLimitResult',
    'GetCapabilitiesContainerRegistryResultResult',
    'GetCapabilitiesContainerRegistryResultPlanResult',
    'GetCapabilitiesContainerRegistryResultPlanFeatureResult',
    'GetCapabilitiesContainerRegistryResultPlanRegistryLimitResult',
    'GetContainerRegistriesResultResult',
    'GetContainerRegistryUsersResultResult',
    'GetFlavorsFlavorResult',
    'GetFlavorsFlavorCapabilityResult',
    'GetFlavorsFlavorPlanCodesResult',
    'GetFloatingIPsCloudProjectFloatingipResult',
    'GetFloatingIPsCloudProjectFloatingipAssociatedEntityResult',
    'GetImagesImageResult',
    'GetInstanceAddressResult',
    'GetInstanceAttachedVolumeResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceAddressResult',
    'GetInstancesInstanceAttachedVolumeResult',
    'GetKubeCustomizationResult',
    'GetKubeCustomizationApiserverResult',
    'GetKubeCustomizationApiserverAdmissionpluginResult',
    'GetKubeCustomizationKubeProxyResult',
    'GetKubeCustomizationKubeProxyIptablesResult',
    'GetKubeCustomizationKubeProxyIpvsResult',
    'GetKubeKubeconfigAttributeResult',
    'GetKubeNodePoolNodesNodeResult',
    'GetKubeNodePoolTemplateResult',
    'GetKubeNodePoolTemplateMetadataResult',
    'GetKubeNodePoolTemplateSpecResult',
    'GetKubeNodesNodeResult',
    'GetLoadBalancerFlavorsFlavorResult',
    'GetLoadBalancerFloatingIpResult',
    'GetLoadBalancersLoadbalancerResult',
    'GetLoadBalancersLoadbalancerFloatingIpResult',
    'GetNetworkPrivateRegionResult',
    'GetNetworkPrivateSubnetsSubnetResult',
    'GetNetworkPrivateSubnetsSubnetIpPoolResult',
    'GetNetworkPrivatesNetworkResult',
    'GetNetworkPrivatesNetworkRegionResult',
    'GetOpenSearchUserAclResult',
    'GetPrometheusTargetResult',
    'GetRancherCurrentStateResult',
    'GetRancherCurrentStateIpRestrictionResult',
    'GetRancherCurrentStateNetworkingResult',
    'GetRancherCurrentStateUsageResult',
    'GetRancherCurrentTaskResult',
    'GetRancherPlanPlanResult',
    'GetRancherTargetSpecResult',
    'GetRancherTargetSpecIpRestrictionResult',
    'GetRancherVersionVersionResult',
    'GetRegionServiceResult',
    'GetStorageEncryptionResult',
    'GetStorageObjectResult',
    'GetStorageObjectsObjectResult',
    'GetStorageReplicationResult',
    'GetStorageReplicationRuleResult',
    'GetStorageReplicationRuleDestinationResult',
    'GetStorageReplicationRuleFilterResult',
    'GetStorageVersioningResult',
    'GetStoragesContainerResult',
    'GetStoragesContainerEncryptionResult',
    'GetStoragesContainerObjectResult',
    'GetStoragesContainerReplicationResult',
    'GetStoragesContainerReplicationRuleResult',
    'GetStoragesContainerReplicationRuleDestinationResult',
    'GetStoragesContainerReplicationRuleFilterResult',
    'GetStoragesContainerVersioningResult',
    'GetUserRoleResult',
    'GetUsersUserResult',
    'GetUsersUserRoleResult',
    'GetVolumesVolumeResult',
]

@pulumi.output_type
class AlertingFormattedMonthlyThreshold(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currencyCode":
            suggest = "currency_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertingFormattedMonthlyThreshold. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertingFormattedMonthlyThreshold.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertingFormattedMonthlyThreshold.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 currency_code: Optional[_builtins.str] = None,
                 text: Optional[_builtins.str] = None,
                 value: Optional[_builtins.float] = None):
        """
        :param _builtins.str currency_code: Currency of the monthly threshold
        :param _builtins.str text: Text representation of the monthly threshold
        :param _builtins.float value: Value of the monthly threshold
        """
        if currency_code is not None:
            pulumi.set(__self__, "currency_code", currency_code)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional[_builtins.str]:
        """
        Currency of the monthly threshold
        """
        return pulumi.get(self, "currency_code")

    @_builtins.property
    @pulumi.getter
    def text(self) -> Optional[_builtins.str]:
        """
        Text representation of the monthly threshold
        """
        return pulumi.get(self, "text")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.float]:
        """
        Value of the monthly threshold
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerRegistryPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "registryLimits":
            suggest = "registry_limits"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRegistryPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRegistryPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRegistryPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[_builtins.str] = None,
                 created_at: Optional[_builtins.str] = None,
                 features: Optional[Sequence['outputs.ContainerRegistryPlanFeature']] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 registry_limits: Optional[Sequence['outputs.ContainerRegistryPlanRegistryLimit']] = None,
                 updated_at: Optional[_builtins.str] = None):
        """
        :param _builtins.str code: Plan code from the catalog
        :param _builtins.str created_at: Plan creation date
        :param Sequence['ContainerRegistryPlanFeatureArgs'] features: Features of the plan
        :param _builtins.str id: Plan ID
        :param _builtins.str name: Registry name
        :param Sequence['ContainerRegistryPlanRegistryLimitArgs'] registry_limits: Container registry limits
        :param _builtins.str updated_at: Registry last update date
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registry_limits is not None:
            pulumi.set(__self__, "registry_limits", registry_limits)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.str]:
        """
        Plan code from the catalog
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        Plan creation date
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional[Sequence['outputs.ContainerRegistryPlanFeature']]:
        """
        Features of the plan
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Plan ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Registry name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="registryLimits")
    def registry_limits(self) -> Optional[Sequence['outputs.ContainerRegistryPlanRegistryLimit']]:
        """
        Container registry limits
        """
        return pulumi.get(self, "registry_limits")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        Registry last update date
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class ContainerRegistryPlanFeature(dict):
    def __init__(__self__, *,
                 vulnerability: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool vulnerability: Vulnerability scanning
        """
        if vulnerability is not None:
            pulumi.set(__self__, "vulnerability", vulnerability)

    @_builtins.property
    @pulumi.getter
    def vulnerability(self) -> Optional[_builtins.bool]:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class ContainerRegistryPlanRegistryLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageStorage":
            suggest = "image_storage"
        elif key == "parallelRequest":
            suggest = "parallel_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRegistryPlanRegistryLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRegistryPlanRegistryLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRegistryPlanRegistryLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_storage: Optional[_builtins.int] = None,
                 parallel_request: Optional[_builtins.int] = None):
        """
        :param _builtins.int image_storage: Docker image storage limits in bytes
        :param _builtins.int parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        if image_storage is not None:
            pulumi.set(__self__, "image_storage", image_storage)
        if parallel_request is not None:
            pulumi.set(__self__, "parallel_request", parallel_request)

    @_builtins.property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> Optional[_builtins.int]:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @_builtins.property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> Optional[_builtins.int]:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")


@pulumi.output_type
class DatabaseEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 scheme: Optional[_builtins.str] = None,
                 ssl: Optional[_builtins.bool] = None,
                 ssl_mode: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str component: Type of component the URI relates to.
        :param _builtins.str domain: Domain of the cluster.
        :param _builtins.str path: Path of the endpoint.
        :param _builtins.int port: Connection port for the endpoint.
        :param _builtins.str scheme: Scheme used to generate the URI.
        :param _builtins.bool ssl: Defines whether the endpoint uses SSL.
        :param _builtins.str ssl_mode: SSL mode used to connect to the service if the SSL is enabled.
        :param _builtins.str uri: URI of the endpoint.
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def component(self) -> Optional[_builtins.str]:
        """
        Type of component the URI relates to.
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        Domain of the cluster.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path of the endpoint.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Connection port for the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[_builtins.str]:
        """
        Scheme used to generate the URI.
        """
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> Optional[_builtins.bool]:
        """
        Defines whether the endpoint uses SSL.
        """
        return pulumi.get(self, "ssl")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[_builtins.str]:
        """
        SSL mode used to connect to the service if the SSL is enabled.
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        URI of the endpoint.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class DatabaseIpRestriction(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: Description of the IP restriction
        :param _builtins.str ip: Authorized IP
        :param _builtins.str status: Current status of the cluster.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the IP restriction
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        Authorized IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Current status of the cluster.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DatabaseNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: _builtins.str,
                 network_id: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str region: Public cloud region in which the node should be deployed. Ex: "GRA'.
        :param _builtins.str network_id: Private network id in which the node should be deployed. It's the regional openstackId of the private network
        :param _builtins.str subnet_id: Private subnet ID in which the node is.
        """
        pulumi.set(__self__, "region", region)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Public cloud region in which the node should be deployed. Ex: "GRA'.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[_builtins.str]:
        """
        Private network id in which the node should be deployed. It's the regional openstackId of the private network
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        Private subnet ID in which the node is.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GatewayExternalInformation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayExternalInformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayExternalInformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayExternalInformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ips: Optional[Sequence['outputs.GatewayExternalInformationIp']] = None,
                 network_id: Optional[_builtins.str] = None):
        """
        :param Sequence['GatewayExternalInformationIpArgs'] ips: List of external ips of the gateway.
        :param _builtins.str network_id: ID of the private network.
        """
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[Sequence['outputs.GatewayExternalInformationIp']]:
        """
        List of external ips of the gateway.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[_builtins.str]:
        """
        ID of the private network.
        """
        return pulumi.get(self, "network_id")


@pulumi.output_type
class GatewayExternalInformationIp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayExternalInformationIp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayExternalInformationIp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayExternalInformationIp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip: IP of the interface.
        :param _builtins.str subnet_id: ID of the subnet.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP of the interface.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        ID of the subnet.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GatewayInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 network_id: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the interface.
        :param _builtins.str ip: IP of the interface.
        :param _builtins.str network_id: ID of the private network.
        :param _builtins.str subnet_id: ID of the subnet.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the interface.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP of the interface.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[_builtins.str]:
        """
        ID of the private network.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        ID of the subnet.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class InstanceAddress(dict):
    def __init__(__self__, *,
                 ip: Optional[_builtins.str] = None,
                 version: Optional[_builtins.int] = None):
        """
        :param _builtins.str ip: IP address
        :param _builtins.int version: IP version
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP address
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.int]:
        """
        IP version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class InstanceAttachedVolume(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Instance id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Instance id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InstanceAutoBackup(dict):
    def __init__(__self__, *,
                 cron: _builtins.str,
                 rotation: _builtins.int):
        """
        :param _builtins.str cron: Unix cron pattern
        :param _builtins.int rotation: Number of backup to keep
        """
        pulumi.set(__self__, "cron", cron)
        pulumi.set(__self__, "rotation", rotation)

    @_builtins.property
    @pulumi.getter
    def cron(self) -> _builtins.str:
        """
        Unix cron pattern
        """
        return pulumi.get(self, "cron")

    @_builtins.property
    @pulumi.getter
    def rotation(self) -> _builtins.int:
        """
        Number of backup to keep
        """
        return pulumi.get(self, "rotation")


@pulumi.output_type
class InstanceBootFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"
        elif key == "volumeId":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBootFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBootFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBootFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: Optional[_builtins.str] = None,
                 volume_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str image_id: Instance image id. Images can be retrieved using `GET /cloud/project/{serviceName}/image`
        :param _builtins.str volume_id: Instance volume id
        """
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[_builtins.str]:
        """
        Instance image id. Images can be retrieved using `GET /cloud/project/{serviceName}/image`
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        Instance volume id
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class InstanceFlavor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flavorId":
            suggest = "flavor_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceFlavor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceFlavor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceFlavor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flavor_id: _builtins.str):
        """
        :param _builtins.str flavor_id: Flavor ID. Flavors can be retrieved using `GET /cloud/project/{serviceName}/flavor`
        """
        pulumi.set(__self__, "flavor_id", flavor_id)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        Flavor ID. Flavors can be retrieved using `GET /cloud/project/{serviceName}/flavor`
        """
        return pulumi.get(self, "flavor_id")


@pulumi.output_type
class InstanceGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str group_id: Group id
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        """
        Group id
        """
        return pulumi.get(self, "group_id")


@pulumi.output_type
class InstanceNetwork(dict):
    def __init__(__self__, *,
                 private: Optional['outputs.InstanceNetworkPrivate'] = None,
                 public: Optional[_builtins.bool] = None):
        """
        :param 'InstanceNetworkPrivateArgs' private: Private network information
        :param _builtins.bool public: Set the new instance as public
        """
        if private is not None:
            pulumi.set(__self__, "private", private)
        if public is not None:
            pulumi.set(__self__, "public", public)

    @_builtins.property
    @pulumi.getter
    def private(self) -> Optional['outputs.InstanceNetworkPrivate']:
        """
        Private network information
        """
        return pulumi.get(self, "private")

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[_builtins.bool]:
        """
        Set the new instance as public
        """
        return pulumi.get(self, "public")


@pulumi.output_type
class InstanceNetworkPrivate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "floatingIp":
            suggest = "floating_ip"
        elif key == "floatingIpCreate":
            suggest = "floating_ip_create"
        elif key == "gatewayCreate":
            suggest = "gateway_create"
        elif key == "networkCreate":
            suggest = "network_create"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkPrivate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkPrivate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkPrivate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 floating_ip: Optional['outputs.InstanceNetworkPrivateFloatingIp'] = None,
                 floating_ip_create: Optional['outputs.InstanceNetworkPrivateFloatingIpCreate'] = None,
                 gateway: Optional['outputs.InstanceNetworkPrivateGateway'] = None,
                 gateway_create: Optional['outputs.InstanceNetworkPrivateGatewayCreate'] = None,
                 ip: Optional[_builtins.str] = None,
                 network: Optional['outputs.InstanceNetworkPrivateNetwork'] = None,
                 network_create: Optional['outputs.InstanceNetworkPrivateNetworkCreate'] = None):
        """
        :param 'InstanceNetworkPrivateFloatingIpArgs' floating_ip: Existing floating IP
        :param 'InstanceNetworkPrivateFloatingIpCreateArgs' floating_ip_create: Information to create a new floating IP
        :param 'InstanceNetworkPrivateGatewayArgs' gateway: Existing gateway
        :param 'InstanceNetworkPrivateGatewayCreateArgs' gateway_create: Information to create a new gateway
        :param _builtins.str ip: Instance IP in the private network
        :param 'InstanceNetworkPrivateNetworkArgs' network: Existing private network
        :param 'InstanceNetworkPrivateNetworkCreateArgs' network_create: Information to create a new private network
        """
        if floating_ip is not None:
            pulumi.set(__self__, "floating_ip", floating_ip)
        if floating_ip_create is not None:
            pulumi.set(__self__, "floating_ip_create", floating_ip_create)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if gateway_create is not None:
            pulumi.set(__self__, "gateway_create", gateway_create)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_create is not None:
            pulumi.set(__self__, "network_create", network_create)

    @_builtins.property
    @pulumi.getter(name="floatingIp")
    def floating_ip(self) -> Optional['outputs.InstanceNetworkPrivateFloatingIp']:
        """
        Existing floating IP
        """
        return pulumi.get(self, "floating_ip")

    @_builtins.property
    @pulumi.getter(name="floatingIpCreate")
    def floating_ip_create(self) -> Optional['outputs.InstanceNetworkPrivateFloatingIpCreate']:
        """
        Information to create a new floating IP
        """
        return pulumi.get(self, "floating_ip_create")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional['outputs.InstanceNetworkPrivateGateway']:
        """
        Existing gateway
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="gatewayCreate")
    def gateway_create(self) -> Optional['outputs.InstanceNetworkPrivateGatewayCreate']:
        """
        Information to create a new gateway
        """
        return pulumi.get(self, "gateway_create")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        Instance IP in the private network
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional['outputs.InstanceNetworkPrivateNetwork']:
        """
        Existing private network
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="networkCreate")
    def network_create(self) -> Optional['outputs.InstanceNetworkPrivateNetworkCreate']:
        """
        Information to create a new private network
        """
        return pulumi.get(self, "network_create")


@pulumi.output_type
class InstanceNetworkPrivateFloatingIp(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Floating IP ID
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Floating IP ID
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InstanceNetworkPrivateFloatingIpCreate(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: Floating IP description
        """
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Floating IP description
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceNetworkPrivateGateway(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Gateway ID
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Gateway ID
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InstanceNetworkPrivateGatewayCreate(dict):
    def __init__(__self__, *,
                 model: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str model: Gateway model (s | m | l)
        :param _builtins.str name: Gateway name
        """
        if model is not None:
            pulumi.set(__self__, "model", model)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def model(self) -> Optional[_builtins.str]:
        """
        Gateway model (s | m | l)
        """
        return pulumi.get(self, "model")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Gateway name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceNetworkPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Network ID
        :param _builtins.str subnet_id: Existing subnet ID
               * network_create - (Optional, Forces new resource) Information to create a new private network
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Network ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        Existing subnet ID
        * network_create - (Optional, Forces new resource) Information to create a new private network
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class InstanceNetworkPrivateNetworkCreate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkPrivateNetworkCreate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkPrivateNetworkCreate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkPrivateNetworkCreate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 subnet: Optional['outputs.InstanceNetworkPrivateNetworkCreateSubnet'] = None,
                 vlan_id: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: Instance name
        :param 'InstanceNetworkPrivateNetworkCreateSubnetArgs' subnet: New subnet information
        :param _builtins.int vlan_id: Network vlan ID
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Instance name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.InstanceNetworkPrivateNetworkCreateSubnet']:
        """
        New subnet information
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[_builtins.int]:
        """
        Network vlan ID
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class InstanceNetworkPrivateNetworkCreateSubnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDhcp":
            suggest = "enable_dhcp"
        elif key == "ipVersion":
            suggest = "ip_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkPrivateNetworkCreateSubnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkPrivateNetworkCreateSubnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkPrivateNetworkCreateSubnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr: Optional[_builtins.str] = None,
                 enable_dhcp: Optional[_builtins.bool] = None,
                 ip_version: Optional[_builtins.int] = None):
        """
        :param _builtins.str cidr: Subnet range in CIDR notation
        :param _builtins.bool enable_dhcp: Whether to enable DHCP
        :param _builtins.int ip_version: IP version
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if enable_dhcp is not None:
            pulumi.set(__self__, "enable_dhcp", enable_dhcp)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[_builtins.str]:
        """
        Subnet range in CIDR notation
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="enableDhcp")
    def enable_dhcp(self) -> Optional[_builtins.bool]:
        """
        Whether to enable DHCP
        """
        return pulumi.get(self, "enable_dhcp")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[_builtins.int]:
        """
        IP version
        """
        return pulumi.get(self, "ip_version")


@pulumi.output_type
class InstanceSshKey(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: SSH Keypair name
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        SSH Keypair name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceSshKeyCreate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSshKeyCreate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSshKeyCreate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSshKeyCreate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 public_key: _builtins.str):
        """
        :param _builtins.str name: SSH Key pair name
        :param _builtins.str public_key: SSH Public key
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_key", public_key)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        SSH Key pair name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        SSH Public key
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class KubeCustomization(dict):
    def __init__(__self__, *,
                 apiservers: Optional[Sequence['outputs.KubeCustomizationApiserver']] = None):
        """
        :param Sequence['KubeCustomizationApiserverArgs'] apiservers: Kubernetes API server customization
        """
        if apiservers is not None:
            pulumi.set(__self__, "apiservers", apiservers)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use customization_apiserver instead""")
    def apiservers(self) -> Optional[Sequence['outputs.KubeCustomizationApiserver']]:
        """
        Kubernetes API server customization
        """
        return pulumi.get(self, "apiservers")


@pulumi.output_type
class KubeCustomizationApiserver(dict):
    def __init__(__self__, *,
                 admissionplugins: Optional[Sequence['outputs.KubeCustomizationApiserverAdmissionplugin']] = None):
        """
        :param Sequence['KubeCustomizationApiserverAdmissionpluginArgs'] admissionplugins: Kubernetes API server admission plugins customization
        """
        if admissionplugins is not None:
            pulumi.set(__self__, "admissionplugins", admissionplugins)

    @_builtins.property
    @pulumi.getter
    def admissionplugins(self) -> Optional[Sequence['outputs.KubeCustomizationApiserverAdmissionplugin']]:
        """
        Kubernetes API server admission plugins customization
        """
        return pulumi.get(self, "admissionplugins")


@pulumi.output_type
class KubeCustomizationApiserverAdmissionplugin(dict):
    def __init__(__self__, *,
                 disableds: Optional[Sequence[_builtins.str]] = None,
                 enableds: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] disableds: Array of admission plugins disabled, default is [] and only AlwaysPulImages can be disabled at this time.
        :param Sequence[_builtins.str] enableds: Array of admission plugins enabled, default is ["NodeRestriction","AlwaysPulImages"] and only these admission plugins can be enabled at this time.
        """
        if disableds is not None:
            pulumi.set(__self__, "disableds", disableds)
        if enableds is not None:
            pulumi.set(__self__, "enableds", enableds)

    @_builtins.property
    @pulumi.getter
    def disableds(self) -> Optional[Sequence[_builtins.str]]:
        """
        Array of admission plugins disabled, default is [] and only AlwaysPulImages can be disabled at this time.
        """
        return pulumi.get(self, "disableds")

    @_builtins.property
    @pulumi.getter
    def enableds(self) -> Optional[Sequence[_builtins.str]]:
        """
        Array of admission plugins enabled, default is ["NodeRestriction","AlwaysPulImages"] and only these admission plugins can be enabled at this time.
        """
        return pulumi.get(self, "enableds")


@pulumi.output_type
class KubeCustomizationKubeProxy(dict):
    def __init__(__self__, *,
                 iptables: Optional['outputs.KubeCustomizationKubeProxyIptables'] = None,
                 ipvs: Optional['outputs.KubeCustomizationKubeProxyIpvs'] = None):
        """
        :param 'KubeCustomizationKubeProxyIptablesArgs' iptables: Kubernetes cluster kube-proxy customization of iptables specific config (durations format is RFC3339 duration, e.g. `PT60S`)
        :param 'KubeCustomizationKubeProxyIpvsArgs' ipvs: Kubernetes cluster kube-proxy customization of IPVS specific config (durations format is [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration, e.g. `PT60S`)
        """
        if iptables is not None:
            pulumi.set(__self__, "iptables", iptables)
        if ipvs is not None:
            pulumi.set(__self__, "ipvs", ipvs)

    @_builtins.property
    @pulumi.getter
    def iptables(self) -> Optional['outputs.KubeCustomizationKubeProxyIptables']:
        """
        Kubernetes cluster kube-proxy customization of iptables specific config (durations format is RFC3339 duration, e.g. `PT60S`)
        """
        return pulumi.get(self, "iptables")

    @_builtins.property
    @pulumi.getter
    def ipvs(self) -> Optional['outputs.KubeCustomizationKubeProxyIpvs']:
        """
        Kubernetes cluster kube-proxy customization of IPVS specific config (durations format is [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration, e.g. `PT60S`)
        """
        return pulumi.get(self, "ipvs")


@pulumi.output_type
class KubeCustomizationKubeProxyIptables(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minSyncPeriod":
            suggest = "min_sync_period"
        elif key == "syncPeriod":
            suggest = "sync_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubeCustomizationKubeProxyIptables. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubeCustomizationKubeProxyIptables.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubeCustomizationKubeProxyIptables.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_sync_period: Optional[_builtins.str] = None,
                 sync_period: Optional[_builtins.str] = None):
        """
        :param _builtins.str min_sync_period: Period that iptables rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`). Must be greater than 0.
        :param _builtins.str sync_period: Minimum period that iptables rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`).
        """
        if min_sync_period is not None:
            pulumi.set(__self__, "min_sync_period", min_sync_period)
        if sync_period is not None:
            pulumi.set(__self__, "sync_period", sync_period)

    @_builtins.property
    @pulumi.getter(name="minSyncPeriod")
    def min_sync_period(self) -> Optional[_builtins.str]:
        """
        Period that iptables rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`). Must be greater than 0.
        """
        return pulumi.get(self, "min_sync_period")

    @_builtins.property
    @pulumi.getter(name="syncPeriod")
    def sync_period(self) -> Optional[_builtins.str]:
        """
        Minimum period that iptables rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`).
        """
        return pulumi.get(self, "sync_period")


@pulumi.output_type
class KubeCustomizationKubeProxyIpvs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minSyncPeriod":
            suggest = "min_sync_period"
        elif key == "syncPeriod":
            suggest = "sync_period"
        elif key == "tcpFinTimeout":
            suggest = "tcp_fin_timeout"
        elif key == "tcpTimeout":
            suggest = "tcp_timeout"
        elif key == "udpTimeout":
            suggest = "udp_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubeCustomizationKubeProxyIpvs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubeCustomizationKubeProxyIpvs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubeCustomizationKubeProxyIpvs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_sync_period: Optional[_builtins.str] = None,
                 scheduler: Optional[_builtins.str] = None,
                 sync_period: Optional[_builtins.str] = None,
                 tcp_fin_timeout: Optional[_builtins.str] = None,
                 tcp_timeout: Optional[_builtins.str] = None,
                 udp_timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str min_sync_period: Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`).
        :param _builtins.str scheduler: IPVS scheduler.
        :param _builtins.str sync_period: Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`).
        :param _builtins.str tcp_fin_timeout: Timeout value used for IPVS TCP sessions after receiving a FIN in RFC3339 duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        :param _builtins.str tcp_timeout: Timeout value used for idle IPVS TCP sessions in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        :param _builtins.str udp_timeout: timeout value used for IPVS UDP packets in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        """
        if min_sync_period is not None:
            pulumi.set(__self__, "min_sync_period", min_sync_period)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if sync_period is not None:
            pulumi.set(__self__, "sync_period", sync_period)
        if tcp_fin_timeout is not None:
            pulumi.set(__self__, "tcp_fin_timeout", tcp_fin_timeout)
        if tcp_timeout is not None:
            pulumi.set(__self__, "tcp_timeout", tcp_timeout)
        if udp_timeout is not None:
            pulumi.set(__self__, "udp_timeout", udp_timeout)

    @_builtins.property
    @pulumi.getter(name="minSyncPeriod")
    def min_sync_period(self) -> Optional[_builtins.str]:
        """
        Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`).
        """
        return pulumi.get(self, "min_sync_period")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional[_builtins.str]:
        """
        IPVS scheduler.
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter(name="syncPeriod")
    def sync_period(self) -> Optional[_builtins.str]:
        """
        Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`).
        """
        return pulumi.get(self, "sync_period")

    @_builtins.property
    @pulumi.getter(name="tcpFinTimeout")
    def tcp_fin_timeout(self) -> Optional[_builtins.str]:
        """
        Timeout value used for IPVS TCP sessions after receiving a FIN in RFC3339 duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        """
        return pulumi.get(self, "tcp_fin_timeout")

    @_builtins.property
    @pulumi.getter(name="tcpTimeout")
    def tcp_timeout(self) -> Optional[_builtins.str]:
        """
        Timeout value used for idle IPVS TCP sessions in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        """
        return pulumi.get(self, "tcp_timeout")

    @_builtins.property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> Optional[_builtins.str]:
        """
        timeout value used for IPVS UDP packets in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        """
        return pulumi.get(self, "udp_timeout")


@pulumi.output_type
class KubeKubeconfigAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCaCertificate":
            suggest = "cluster_ca_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubeKubeconfigAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubeKubeconfigAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubeKubeconfigAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificate: Optional[_builtins.str] = None,
                 client_key: Optional[_builtins.str] = None,
                 cluster_ca_certificate: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_certificate: The kubernetes API server client certificate.
        :param _builtins.str client_key: The kubernetes API server client key.
        :param _builtins.str cluster_ca_certificate: The kubernetes API server CA certificate.
        :param _builtins.str host: The kubernetes API server URL.
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[_builtins.str]:
        """
        The kubernetes API server client certificate.
        """
        return pulumi.get(self, "client_certificate")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[_builtins.str]:
        """
        The kubernetes API server client key.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[_builtins.str]:
        """
        The kubernetes API server CA certificate.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The kubernetes API server URL.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class KubeNodePoolTemplate(dict):
    def __init__(__self__, *,
                 metadata: 'outputs.KubeNodePoolTemplateMetadata',
                 spec: 'outputs.KubeNodePoolTemplateSpec'):
        """
        :param 'KubeNodePoolTemplateMetadataArgs' metadata: metadata
        :param 'KubeNodePoolTemplateSpecArgs' spec: spec
        """
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> 'outputs.KubeNodePoolTemplateMetadata':
        """
        metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> 'outputs.KubeNodePoolTemplateSpec':
        """
        spec
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class KubeNodePoolTemplateMetadata(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 finalizers: Sequence[_builtins.str],
                 labels: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] annotations: annotations
        :param Sequence[_builtins.str] finalizers: finalizers
        :param Mapping[str, _builtins.str] labels: labels
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "finalizers", finalizers)
        pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        annotations
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def finalizers(self) -> Sequence[_builtins.str]:
        """
        finalizers
        """
        return pulumi.get(self, "finalizers")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        labels
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class KubeNodePoolTemplateSpec(dict):
    def __init__(__self__, *,
                 taints: Sequence[Mapping[str, _builtins.str]],
                 unschedulable: _builtins.bool):
        """
        :param Sequence[Mapping[str, _builtins.str]] taints: taints
        :param _builtins.bool unschedulable: unschedulable
        """
        pulumi.set(__self__, "taints", taints)
        pulumi.set(__self__, "unschedulable", unschedulable)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Sequence[Mapping[str, _builtins.str]]:
        """
        taints
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter
    def unschedulable(self) -> _builtins.bool:
        """
        unschedulable
        """
        return pulumi.get(self, "unschedulable")


@pulumi.output_type
class KubePrivateNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultVrackGateway":
            suggest = "default_vrack_gateway"
        elif key == "privateNetworkRoutingAsDefault":
            suggest = "private_network_routing_as_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubePrivateNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubePrivateNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubePrivateNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_vrack_gateway: _builtins.str,
                 private_network_routing_as_default: _builtins.bool):
        """
        :param _builtins.str default_vrack_gateway: If defined, all egress traffic will be routed towards this IP address, which should belong to the private network. Empty string means disabled.
        :param _builtins.bool private_network_routing_as_default: Defines whether routing should default to using the nodes' private interface, instead of their public interface. Default is false.
               
               In order to use the gateway IP advertised by the private network subnet DHCP, the following configuration shall be used.
        """
        pulumi.set(__self__, "default_vrack_gateway", default_vrack_gateway)
        pulumi.set(__self__, "private_network_routing_as_default", private_network_routing_as_default)

    @_builtins.property
    @pulumi.getter(name="defaultVrackGateway")
    def default_vrack_gateway(self) -> _builtins.str:
        """
        If defined, all egress traffic will be routed towards this IP address, which should belong to the private network. Empty string means disabled.
        """
        return pulumi.get(self, "default_vrack_gateway")

    @_builtins.property
    @pulumi.getter(name="privateNetworkRoutingAsDefault")
    def private_network_routing_as_default(self) -> _builtins.bool:
        """
        Defines whether routing should default to using the nodes' private interface, instead of their public interface. Default is false.

        In order to use the gateway IP advertised by the private network subnet DHCP, the following configuration shall be used.
        """
        return pulumi.get(self, "private_network_routing_as_default")


@pulumi.output_type
class LoadBalancerFloatingIp(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the resource
        :param _builtins.str ip: IP Address of the resource
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP Address of the resource
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class LoadBalancerListener(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedCidrs":
            suggest = "allowed_cidrs"
        elif key == "secretId":
            suggest = "secret_id"
        elif key == "timeoutClientData":
            suggest = "timeout_client_data"
        elif key == "timeoutMemberData":
            suggest = "timeout_member_data"
        elif key == "tlsVersions":
            suggest = "tls_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerListener. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerListener.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerListener.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.float,
                 protocol: _builtins.str,
                 allowed_cidrs: Optional[Sequence[_builtins.str]] = None,
                 description: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 pool: Optional['outputs.LoadBalancerListenerPool'] = None,
                 secret_id: Optional[_builtins.str] = None,
                 timeout_client_data: Optional[_builtins.float] = None,
                 timeout_member_data: Optional[_builtins.float] = None,
                 tls_versions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.float port: Listener port
        :param _builtins.str protocol: Protocol for the listener
        :param Sequence[_builtins.str] allowed_cidrs: The allowed CIDRs
        :param _builtins.str description: The description of the listener
        :param _builtins.str name: Name of the listener
        :param 'LoadBalancerListenerPoolArgs' pool: Listener pool
        :param _builtins.str secret_id: Secret ID to get certificate for SSL listener creation
        :param _builtins.float timeout_client_data: Timeout client data of the listener
        :param _builtins.float timeout_member_data: Timeout member data of the listener
        :param Sequence[_builtins.str] tls_versions: TLS versions of the listener
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if allowed_cidrs is not None:
            pulumi.set(__self__, "allowed_cidrs", allowed_cidrs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if timeout_client_data is not None:
            pulumi.set(__self__, "timeout_client_data", timeout_client_data)
        if timeout_member_data is not None:
            pulumi.set(__self__, "timeout_member_data", timeout_member_data)
        if tls_versions is not None:
            pulumi.set(__self__, "tls_versions", tls_versions)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.float:
        """
        Listener port
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol for the listener
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="allowedCidrs")
    def allowed_cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        The allowed CIDRs
        """
        return pulumi.get(self, "allowed_cidrs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the listener
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the listener
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def pool(self) -> Optional['outputs.LoadBalancerListenerPool']:
        """
        Listener pool
        """
        return pulumi.get(self, "pool")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[_builtins.str]:
        """
        Secret ID to get certificate for SSL listener creation
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="timeoutClientData")
    def timeout_client_data(self) -> Optional[_builtins.float]:
        """
        Timeout client data of the listener
        """
        return pulumi.get(self, "timeout_client_data")

    @_builtins.property
    @pulumi.getter(name="timeoutMemberData")
    def timeout_member_data(self) -> Optional[_builtins.float]:
        """
        Timeout member data of the listener
        """
        return pulumi.get(self, "timeout_member_data")

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        TLS versions of the listener
        """
        return pulumi.get(self, "tls_versions")


@pulumi.output_type
class LoadBalancerListenerPool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthMonitor":
            suggest = "health_monitor"
        elif key == "sessionPersistence":
            suggest = "session_persistence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerListenerPool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerListenerPool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerListenerPool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[_builtins.str] = None,
                 health_monitor: Optional['outputs.LoadBalancerListenerPoolHealthMonitor'] = None,
                 members: Optional[Sequence['outputs.LoadBalancerListenerPoolMember']] = None,
                 name: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 session_persistence: Optional['outputs.LoadBalancerListenerPoolSessionPersistence'] = None):
        """
        :param _builtins.str algorithm: Pool algorithm to split traffic between members
        :param 'LoadBalancerListenerPoolHealthMonitorArgs' health_monitor: Pool health monitor
        :param Sequence['LoadBalancerListenerPoolMemberArgs'] members: Pool members
        :param _builtins.str name: Name of the pool
        :param _builtins.str protocol: Protocol for the pool
        :param 'LoadBalancerListenerPoolSessionPersistenceArgs' session_persistence: Pool session persistence
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if health_monitor is not None:
            pulumi.set(__self__, "health_monitor", health_monitor)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if session_persistence is not None:
            pulumi.set(__self__, "session_persistence", session_persistence)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[_builtins.str]:
        """
        Pool algorithm to split traffic between members
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="healthMonitor")
    def health_monitor(self) -> Optional['outputs.LoadBalancerListenerPoolHealthMonitor']:
        """
        Pool health monitor
        """
        return pulumi.get(self, "health_monitor")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[Sequence['outputs.LoadBalancerListenerPoolMember']]:
        """
        Pool members
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the pool
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol for the pool
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sessionPersistence")
    def session_persistence(self) -> Optional['outputs.LoadBalancerListenerPoolSessionPersistence']:
        """
        Pool session persistence
        """
        return pulumi.get(self, "session_persistence")


@pulumi.output_type
class LoadBalancerListenerPoolHealthMonitor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpConfiguration":
            suggest = "http_configuration"
        elif key == "maxRetries":
            suggest = "max_retries"
        elif key == "maxRetriesDown":
            suggest = "max_retries_down"
        elif key == "monitorType":
            suggest = "monitor_type"
        elif key == "operatingStatus":
            suggest = "operating_status"
        elif key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerListenerPoolHealthMonitor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerListenerPoolHealthMonitor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerListenerPoolHealthMonitor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay: Optional[_builtins.float] = None,
                 http_configuration: Optional['outputs.LoadBalancerListenerPoolHealthMonitorHttpConfiguration'] = None,
                 max_retries: Optional[_builtins.float] = None,
                 max_retries_down: Optional[_builtins.float] = None,
                 monitor_type: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 operating_status: Optional[_builtins.str] = None,
                 provisioning_status: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.float] = None):
        """
        :param _builtins.float delay: Duration between sending probes to members, in seconds
        :param 'LoadBalancerListenerPoolHealthMonitorHttpConfigurationArgs' http_configuration: Monitor HTTP configuration
        :param _builtins.float max_retries: Number of successful checks before changing the operating status of the member to ONLINE
        :param _builtins.float max_retries_down: Number of allowed check failures before changing the operating status of the member to ERROR
        :param _builtins.str monitor_type: Type of the monitor
        :param _builtins.str name: The name of the resource
        :param _builtins.str operating_status: The operating status of the resource
        :param _builtins.str provisioning_status: The provisioning status of the resource
        :param _builtins.float timeout: Maximum time, in seconds, that a monitor waits to connect before it times out. This value must be less than the delay value
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if http_configuration is not None:
            pulumi.set(__self__, "http_configuration", http_configuration)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if max_retries_down is not None:
            pulumi.set(__self__, "max_retries_down", max_retries_down)
        if monitor_type is not None:
            pulumi.set(__self__, "monitor_type", monitor_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operating_status is not None:
            pulumi.set(__self__, "operating_status", operating_status)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[_builtins.float]:
        """
        Duration between sending probes to members, in seconds
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter(name="httpConfiguration")
    def http_configuration(self) -> Optional['outputs.LoadBalancerListenerPoolHealthMonitorHttpConfiguration']:
        """
        Monitor HTTP configuration
        """
        return pulumi.get(self, "http_configuration")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[_builtins.float]:
        """
        Number of successful checks before changing the operating status of the member to ONLINE
        """
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter(name="maxRetriesDown")
    def max_retries_down(self) -> Optional[_builtins.float]:
        """
        Number of allowed check failures before changing the operating status of the member to ERROR
        """
        return pulumi.get(self, "max_retries_down")

    @_builtins.property
    @pulumi.getter(name="monitorType")
    def monitor_type(self) -> Optional[_builtins.str]:
        """
        Type of the monitor
        """
        return pulumi.get(self, "monitor_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> Optional[_builtins.str]:
        """
        The operating status of the resource
        """
        return pulumi.get(self, "operating_status")

    @_builtins.property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional[_builtins.str]:
        """
        The provisioning status of the resource
        """
        return pulumi.get(self, "provisioning_status")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.float]:
        """
        Maximum time, in seconds, that a monitor waits to connect before it times out. This value must be less than the delay value
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class LoadBalancerListenerPoolHealthMonitorHttpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "expectedCodes":
            suggest = "expected_codes"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "httpVersion":
            suggest = "http_version"
        elif key == "urlPath":
            suggest = "url_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerListenerPoolHealthMonitorHttpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerListenerPoolHealthMonitorHttpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerListenerPoolHealthMonitorHttpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 expected_codes: Optional[_builtins.str] = None,
                 http_method: Optional[_builtins.str] = None,
                 http_version: Optional[_builtins.str] = None,
                 url_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: Domain name, which be injected into the HTTP Host Header to the backend server for HTTP health check
        :param _builtins.str expected_codes: Status codes expected in response from the member to declare it healthy; The list of HTTP status codes expected in response from the member to declare it healthy. Specify one of the following values: * A single value, such as 200; * A list, such as 200, 202; * A range, such as 200-204
        :param _builtins.str http_method: HTTP method that the health monitor uses for requests
        :param _builtins.str http_version: HTTP version that the health monitor uses for requests
        :param _builtins.str url_path: HTTP URL path of the request sent by the monitor to test the health of a backend member
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        Domain name, which be injected into the HTTP Host Header to the backend server for HTTP health check
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[_builtins.str]:
        """
        Status codes expected in response from the member to declare it healthy; The list of HTTP status codes expected in response from the member to declare it healthy. Specify one of the following values: * A single value, such as 200; * A list, such as 200, 202; * A range, such as 200-204
        """
        return pulumi.get(self, "expected_codes")

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[_builtins.str]:
        """
        HTTP method that the health monitor uses for requests
        """
        return pulumi.get(self, "http_method")

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[_builtins.str]:
        """
        HTTP version that the health monitor uses for requests
        """
        return pulumi.get(self, "http_version")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[_builtins.str]:
        """
        HTTP URL path of the request sent by the monitor to test the health of a backend member
        """
        return pulumi.get(self, "url_path")


@pulumi.output_type
class LoadBalancerListenerPoolMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolPort":
            suggest = "protocol_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerListenerPoolMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerListenerPoolMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerListenerPoolMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 protocol_port: Optional[_builtins.float] = None,
                 weight: Optional[_builtins.float] = None):
        """
        :param _builtins.str address: IP address of the resource
        :param _builtins.str name: Name of the member
        :param _builtins.float protocol_port: Protocol port number for the resource
        :param _builtins.float weight: Weight of a member determines the portion of requests or connections it services compared to the other members of the pool. Between 1 and 256.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol_port is not None:
            pulumi.set(__self__, "protocol_port", protocol_port)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        IP address of the resource
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the member
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[_builtins.float]:
        """
        Protocol port number for the resource
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.float]:
        """
        Weight of a member determines the portion of requests or connections it services compared to the other members of the pool. Between 1 and 256.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class LoadBalancerListenerPoolSessionPersistence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerListenerPoolSessionPersistence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerListenerPoolSessionPersistence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerListenerPoolSessionPersistence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str cookie_name: Cookie name, only applicable to session persistence through cookie
        :param _builtins.str type: Type of session persistence
        """
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[_builtins.str]:
        """
        Cookie name, only applicable to session persistence through cookie
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of session persistence
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LoadBalancerNetwork(dict):
    def __init__(__self__, *,
                 private: 'outputs.LoadBalancerNetworkPrivate'):
        """
        :param 'LoadBalancerNetworkPrivateArgs' private: Information to private network
        """
        pulumi.set(__self__, "private", private)

    @_builtins.property
    @pulumi.getter
    def private(self) -> 'outputs.LoadBalancerNetworkPrivate':
        """
        Information to private network
        """
        return pulumi.get(self, "private")


@pulumi.output_type
class LoadBalancerNetworkPrivate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "floatingIp":
            suggest = "floating_ip"
        elif key == "floatingIpCreate":
            suggest = "floating_ip_create"
        elif key == "gatewayCreate":
            suggest = "gateway_create"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerNetworkPrivate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerNetworkPrivate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerNetworkPrivate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: 'outputs.LoadBalancerNetworkPrivateNetwork',
                 floating_ip: Optional['outputs.LoadBalancerNetworkPrivateFloatingIp'] = None,
                 floating_ip_create: Optional['outputs.LoadBalancerNetworkPrivateFloatingIpCreate'] = None,
                 gateway: Optional['outputs.LoadBalancerNetworkPrivateGateway'] = None,
                 gateway_create: Optional['outputs.LoadBalancerNetworkPrivateGatewayCreate'] = None):
        """
        :param 'LoadBalancerNetworkPrivateNetworkArgs' network: Network to associate
        :param 'LoadBalancerNetworkPrivateFloatingIpArgs' floating_ip: Floating IP to associate
        :param 'LoadBalancerNetworkPrivateFloatingIpCreateArgs' floating_ip_create: Floating IP to create
        :param 'LoadBalancerNetworkPrivateGatewayArgs' gateway: Gateway to associate
        :param 'LoadBalancerNetworkPrivateGatewayCreateArgs' gateway_create: Gateway to create
        """
        pulumi.set(__self__, "network", network)
        if floating_ip is not None:
            pulumi.set(__self__, "floating_ip", floating_ip)
        if floating_ip_create is not None:
            pulumi.set(__self__, "floating_ip_create", floating_ip_create)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if gateway_create is not None:
            pulumi.set(__self__, "gateway_create", gateway_create)

    @_builtins.property
    @pulumi.getter
    def network(self) -> 'outputs.LoadBalancerNetworkPrivateNetwork':
        """
        Network to associate
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="floatingIp")
    def floating_ip(self) -> Optional['outputs.LoadBalancerNetworkPrivateFloatingIp']:
        """
        Floating IP to associate
        """
        return pulumi.get(self, "floating_ip")

    @_builtins.property
    @pulumi.getter(name="floatingIpCreate")
    def floating_ip_create(self) -> Optional['outputs.LoadBalancerNetworkPrivateFloatingIpCreate']:
        """
        Floating IP to create
        """
        return pulumi.get(self, "floating_ip_create")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional['outputs.LoadBalancerNetworkPrivateGateway']:
        """
        Gateway to associate
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="gatewayCreate")
    def gateway_create(self) -> Optional['outputs.LoadBalancerNetworkPrivateGatewayCreate']:
        """
        Gateway to create
        """
        return pulumi.get(self, "gateway_create")


@pulumi.output_type
class LoadBalancerNetworkPrivateFloatingIp(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the floatingIp
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the floatingIp
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancerNetworkPrivateFloatingIpCreate(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: Description for the floatingIp
        """
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description for the floatingIp
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class LoadBalancerNetworkPrivateGateway(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the gateway
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the gateway
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancerNetworkPrivateGatewayCreate(dict):
    def __init__(__self__, *,
                 model: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str model: Model of the gateway
        :param _builtins.str name: Name of the gateway
        """
        if model is not None:
            pulumi.set(__self__, "model", model)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def model(self) -> Optional[_builtins.str]:
        """
        Model of the gateway
        """
        return pulumi.get(self, "model")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the gateway
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadBalancerNetworkPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerNetworkPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerNetworkPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerNetworkPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str id: Private network ID
        :param _builtins.str subnet_id: Subnet ID
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Private network ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Subnet ID
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class NetworkPrivateRegionsAttribute(dict):
    def __init__(__self__, *,
                 status: _builtins.str,
                 openstackid: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if openstackid is not None:
            pulumi.set(__self__, "openstackid", openstackid)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def openstackid(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "openstackid")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")


@pulumi.output_type
class NetworkPrivateRegionsStatus(dict):
    def __init__(__self__, *,
                 status: _builtins.str,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")


@pulumi.output_type
class NetworkPrivateSubnetIpPool(dict):
    def __init__(__self__, *,
                 dhcp: Optional[_builtins.bool] = None,
                 end: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 start: Optional[_builtins.str] = None):
        """
        :param _builtins.bool dhcp: Enable DHCP. Changing this forces a new resource to be created. Defaults to false.
        :param _builtins.str end: Last ip for this region. Changing this value recreates the subnet.
        :param _builtins.str network: Global network in CIDR format. Changing this value recreates the subnet
        :param _builtins.str region: The region in which the network subnet will be created. Ex.: "GRA1". Changing this value recreates the resource.
        :param _builtins.str start: First ip for this region. Changing this value recreates the subnet.
        """
        if dhcp is not None:
            pulumi.set(__self__, "dhcp", dhcp)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def dhcp(self) -> Optional[_builtins.bool]:
        """
        Enable DHCP. Changing this forces a new resource to be created. Defaults to false.
        """
        return pulumi.get(self, "dhcp")

    @_builtins.property
    @pulumi.getter
    def end(self) -> Optional[_builtins.str]:
        """
        Last ip for this region. Changing this value recreates the subnet.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        Global network in CIDR format. Changing this value recreates the subnet
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region in which the network subnet will be created. Ex.: "GRA1". Changing this value recreates the resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[_builtins.str]:
        """
        First ip for this region. Changing this value recreates the subnet.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class NetworkPrivateSubnetV2AllocationPool(dict):
    def __init__(__self__, *,
                 end: _builtins.str,
                 start: _builtins.str):
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def end(self) -> _builtins.str:
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        return pulumi.get(self, "start")


@pulumi.output_type
class NetworkPrivateSubnetV2HostRoute(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 nexthop: _builtins.str):
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> _builtins.str:
        return pulumi.get(self, "nexthop")


@pulumi.output_type
class ProjectOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[_builtins.str] = None,
                 details: Optional[Sequence['outputs.ProjectOrderDetail']] = None,
                 expiration_date: Optional[_builtins.str] = None,
                 order_id: Optional[_builtins.int] = None):
        """
        :param _builtins.str date: date
        :param Sequence['ProjectOrderDetailArgs'] details: Information about a Bill entry
        :param _builtins.str expiration_date: expiration date
        :param _builtins.int order_id: order id, the same as the `id`
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @_builtins.property
    @pulumi.getter
    def date(self) -> Optional[_builtins.str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ProjectOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[_builtins.str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[_builtins.int]:
        """
        order id, the same as the `id`
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class ProjectOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 order_detail_id: Optional[_builtins.int] = None,
                 quantity: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: A description associated with the user.
        :param _builtins.str domain: expiration date
        :param _builtins.int order_detail_id: order detail id
        :param _builtins.str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[_builtins.int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @_builtins.property
    @pulumi.getter
    def quantity(self) -> Optional[_builtins.str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class ProjectPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 catalog_name: Optional[_builtins.str] = None,
                 configurations: Optional[Sequence['outputs.ProjectPlanConfiguration']] = None):
        """
        :param _builtins.str duration: duration
        :param _builtins.str plan_code: Plan code. This value must be adapted depending on your `OVH_ENDPOINT` value. It's `project.2018` for `ovh-{eu,ca}` and `project` when using `ovh-us`.
        :param _builtins.str pricing_mode: Pricing model identifier
        :param _builtins.str catalog_name: Catalog name
        :param Sequence['ProjectPlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Plan code. This value must be adapted depending on your `OVH_ENDPOINT` value. It's `project.2018` for `ovh-{eu,ca}` and `project` when using `ovh-us`.
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[_builtins.str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ProjectPlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class ProjectPlanConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Identifier of the resource
        :param _builtins.str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectPlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectPlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectPlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectPlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 catalog_name: Optional[_builtins.str] = None,
                 configurations: Optional[Sequence['outputs.ProjectPlanOptionConfiguration']] = None):
        """
        :param _builtins.str duration: duration
        :param _builtins.str plan_code: Plan code
        :param _builtins.str pricing_mode: Pricing model identifier
        :param _builtins.str catalog_name: Catalog name
        :param Sequence['ProjectPlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[_builtins.str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ProjectPlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class ProjectPlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Identifier of the resource
        :param _builtins.str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectRegionService(dict):
    def __init__(__self__, *,
                 endpoint: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint: Endpoint URL
        :param _builtins.str name: Service name
        :param _builtins.str status: Service status
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[_builtins.str]:
        """
        Endpoint URL
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Service status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RancherCurrentState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootstrapPassword":
            suggest = "bootstrap_password"
        elif key == "ipRestrictions":
            suggest = "ip_restrictions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RancherCurrentState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RancherCurrentState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RancherCurrentState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bootstrap_password: Optional[_builtins.str] = None,
                 ip_restrictions: Optional[Sequence['outputs.RancherCurrentStateIpRestriction']] = None,
                 name: Optional[_builtins.str] = None,
                 networking: Optional['outputs.RancherCurrentStateNetworking'] = None,
                 plan: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None,
                 usage: Optional['outputs.RancherCurrentStateUsage'] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str bootstrap_password: Bootstrap password of the managed Rancher service, returned only on creation
        :param Sequence['RancherCurrentStateIpRestrictionArgs'] ip_restrictions: List of allowed CIDR blocks for a managed Rancher service's IP restrictions. When empty, any IP is allowed
        :param _builtins.str name: Name of the managed Rancher service
        :param 'RancherCurrentStateNetworkingArgs' networking: Networking properties of a managed Rancher service
        :param _builtins.str plan: Plan of the managed Rancher service
        :param _builtins.str region: Region of the managed Rancher service
        :param _builtins.str url: URL of the managed Rancher service
        :param 'RancherCurrentStateUsageArgs' usage: Latest metrics regarding the usage of the managed Rancher service
        :param _builtins.str version: Version of the managed Rancher service
        """
        if bootstrap_password is not None:
            pulumi.set(__self__, "bootstrap_password", bootstrap_password)
        if ip_restrictions is not None:
            pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="bootstrapPassword")
    def bootstrap_password(self) -> Optional[_builtins.str]:
        """
        Bootstrap password of the managed Rancher service, returned only on creation
        """
        return pulumi.get(self, "bootstrap_password")

    @_builtins.property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Optional[Sequence['outputs.RancherCurrentStateIpRestriction']]:
        """
        List of allowed CIDR blocks for a managed Rancher service's IP restrictions. When empty, any IP is allowed
        """
        return pulumi.get(self, "ip_restrictions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the managed Rancher service
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networking(self) -> Optional['outputs.RancherCurrentStateNetworking']:
        """
        Networking properties of a managed Rancher service
        """
        return pulumi.get(self, "networking")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[_builtins.str]:
        """
        Plan of the managed Rancher service
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region of the managed Rancher service
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        URL of the managed Rancher service
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional['outputs.RancherCurrentStateUsage']:
        """
        Latest metrics regarding the usage of the managed Rancher service
        """
        return pulumi.get(self, "usage")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the managed Rancher service
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RancherCurrentStateIpRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlock":
            suggest = "cidr_block"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RancherCurrentStateIpRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RancherCurrentStateIpRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RancherCurrentStateIpRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_block: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str cidr_block: Allowed CIDR block (/subnet is optional, if unspecified then /32 will be used)
        :param _builtins.str description: Description of the allowed CIDR block
        """
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[_builtins.str]:
        """
        Allowed CIDR block (/subnet is optional, if unspecified then /32 will be used)
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the allowed CIDR block
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class RancherCurrentStateNetworking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressCidrBlocks":
            suggest = "egress_cidr_blocks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RancherCurrentStateNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RancherCurrentStateNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RancherCurrentStateNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_cidr_blocks: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] egress_cidr_blocks: Specifies the CIDR ranges for egress IP addresses used by Rancher. Ensure these ranges are allowed in any IP restrictions for services that Rancher will access.
        """
        if egress_cidr_blocks is not None:
            pulumi.set(__self__, "egress_cidr_blocks", egress_cidr_blocks)

    @_builtins.property
    @pulumi.getter(name="egressCidrBlocks")
    def egress_cidr_blocks(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the CIDR ranges for egress IP addresses used by Rancher. Ensure these ranges are allowed in any IP restrictions for services that Rancher will access.
        """
        return pulumi.get(self, "egress_cidr_blocks")


@pulumi.output_type
class RancherCurrentStateUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orchestratedVcpus":
            suggest = "orchestrated_vcpus"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RancherCurrentStateUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RancherCurrentStateUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RancherCurrentStateUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datetime: Optional[_builtins.str] = None,
                 orchestrated_vcpus: Optional[_builtins.float] = None):
        """
        :param _builtins.str datetime: Date of the sample
        :param _builtins.float orchestrated_vcpus: Total number of vCPUs orchestrated by the managed Rancher service through the downstream clusters
        """
        if datetime is not None:
            pulumi.set(__self__, "datetime", datetime)
        if orchestrated_vcpus is not None:
            pulumi.set(__self__, "orchestrated_vcpus", orchestrated_vcpus)

    @_builtins.property
    @pulumi.getter
    def datetime(self) -> Optional[_builtins.str]:
        """
        Date of the sample
        """
        return pulumi.get(self, "datetime")

    @_builtins.property
    @pulumi.getter(name="orchestratedVcpus")
    def orchestrated_vcpus(self) -> Optional[_builtins.float]:
        """
        Total number of vCPUs orchestrated by the managed Rancher service through the downstream clusters
        """
        return pulumi.get(self, "orchestrated_vcpus")


@pulumi.output_type
class RancherCurrentTask(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 link: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Identifier of the current task
        :param _builtins.str link: Link to the task details
        :param _builtins.str status: Current global status of the current task
        :param _builtins.str type: Type of the current task
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Identifier of the current task
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def link(self) -> Optional[_builtins.str]:
        """
        Link to the task details
        """
        return pulumi.get(self, "link")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Current global status of the current task
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the current task
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RancherTargetSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRestrictions":
            suggest = "ip_restrictions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RancherTargetSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RancherTargetSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RancherTargetSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 plan: _builtins.str,
                 ip_restrictions: Optional[Sequence['outputs.RancherTargetSpecIpRestriction']] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the managed Rancher service
        :param _builtins.str plan: Plan of the managed Rancher service. Available plans for an existing managed Rancher can be retrieved using GET /rancher/rancherID/capabilities/plan
        :param Sequence['RancherTargetSpecIpRestrictionArgs'] ip_restrictions: List of allowed CIDR blocks for a managed Rancher service's IP restrictions. When empty, any IP is allowed
        :param _builtins.str version: Version of the managed Rancher service. Available versions for an existing managed Rancher can be retrieved using ovh*cloud*project*rancher*version datasource. Default is the latest version.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "plan", plan)
        if ip_restrictions is not None:
            pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the managed Rancher service
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        Plan of the managed Rancher service. Available plans for an existing managed Rancher can be retrieved using GET /rancher/rancherID/capabilities/plan
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Optional[Sequence['outputs.RancherTargetSpecIpRestriction']]:
        """
        List of allowed CIDR blocks for a managed Rancher service's IP restrictions. When empty, any IP is allowed
        """
        return pulumi.get(self, "ip_restrictions")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the managed Rancher service. Available versions for an existing managed Rancher can be retrieved using ovh*cloud*project*rancher*version datasource. Default is the latest version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RancherTargetSpecIpRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlock":
            suggest = "cidr_block"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RancherTargetSpecIpRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RancherTargetSpecIpRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RancherTargetSpecIpRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_block: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str cidr_block: Allowed CIDR block (/subnet is optional, if unspecified then /32 will be used)
        :param _builtins.str description: Description of the allowed CIDR block
        """
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[_builtins.str]:
        """
        Allowed CIDR block (/subnet is optional, if unspecified then /32 will be used)
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the allowed CIDR block
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class RegionNetworkSubnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDhcp":
            suggest = "enable_dhcp"
        elif key == "enableGatewayIp":
            suggest = "enable_gateway_ip"
        elif key == "ipVersion":
            suggest = "ip_version"
        elif key == "allocationPools":
            suggest = "allocation_pools"
        elif key == "dnsNameServers":
            suggest = "dns_name_servers"
        elif key == "gatewayIp":
            suggest = "gateway_ip"
        elif key == "hostRoutes":
            suggest = "host_routes"
        elif key == "useDefaultPublicDnsresolver":
            suggest = "use_default_public_dnsresolver"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegionNetworkSubnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegionNetworkSubnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegionNetworkSubnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr: _builtins.str,
                 enable_dhcp: _builtins.bool,
                 enable_gateway_ip: _builtins.bool,
                 ip_version: _builtins.float,
                 allocation_pools: Optional[Sequence['outputs.RegionNetworkSubnetAllocationPool']] = None,
                 dns_name_servers: Optional[Sequence[_builtins.str]] = None,
                 gateway_ip: Optional[_builtins.str] = None,
                 host_routes: Optional[Sequence['outputs.RegionNetworkSubnetHostRoute']] = None,
                 name: Optional[_builtins.str] = None,
                 use_default_public_dnsresolver: Optional[_builtins.bool] = None):
        """
        :param _builtins.str cidr: Subnet range in CIDR notation
        :param _builtins.bool enable_dhcp: Enable DHCP for the subnet
        :param _builtins.bool enable_gateway_ip: Set a gateway ip for the subnet
        :param _builtins.float ip_version: IP version
        :param Sequence['RegionNetworkSubnetAllocationPoolArgs'] allocation_pools: List of IP pools allocated in subnet
        :param Sequence[_builtins.str] dns_name_servers: DNS nameservers
        :param _builtins.str gateway_ip: Gateway IP
        :param Sequence['RegionNetworkSubnetHostRouteArgs'] host_routes: Host routes
        :param _builtins.str name: Subnet name
        :param _builtins.bool use_default_public_dnsresolver: Use default DNS
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "enable_dhcp", enable_dhcp)
        pulumi.set(__self__, "enable_gateway_ip", enable_gateway_ip)
        pulumi.set(__self__, "ip_version", ip_version)
        if allocation_pools is not None:
            pulumi.set(__self__, "allocation_pools", allocation_pools)
        if dns_name_servers is not None:
            pulumi.set(__self__, "dns_name_servers", dns_name_servers)
        if gateway_ip is not None:
            pulumi.set(__self__, "gateway_ip", gateway_ip)
        if host_routes is not None:
            pulumi.set(__self__, "host_routes", host_routes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if use_default_public_dnsresolver is not None:
            pulumi.set(__self__, "use_default_public_dnsresolver", use_default_public_dnsresolver)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        Subnet range in CIDR notation
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="enableDhcp")
    def enable_dhcp(self) -> _builtins.bool:
        """
        Enable DHCP for the subnet
        """
        return pulumi.get(self, "enable_dhcp")

    @_builtins.property
    @pulumi.getter(name="enableGatewayIp")
    def enable_gateway_ip(self) -> _builtins.bool:
        """
        Set a gateway ip for the subnet
        """
        return pulumi.get(self, "enable_gateway_ip")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.float:
        """
        IP version
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="allocationPools")
    def allocation_pools(self) -> Optional[Sequence['outputs.RegionNetworkSubnetAllocationPool']]:
        """
        List of IP pools allocated in subnet
        """
        return pulumi.get(self, "allocation_pools")

    @_builtins.property
    @pulumi.getter(name="dnsNameServers")
    def dns_name_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        DNS nameservers
        """
        return pulumi.get(self, "dns_name_servers")

    @_builtins.property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> Optional[_builtins.str]:
        """
        Gateway IP
        """
        return pulumi.get(self, "gateway_ip")

    @_builtins.property
    @pulumi.getter(name="hostRoutes")
    def host_routes(self) -> Optional[Sequence['outputs.RegionNetworkSubnetHostRoute']]:
        """
        Host routes
        """
        return pulumi.get(self, "host_routes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Subnet name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="useDefaultPublicDnsresolver")
    def use_default_public_dnsresolver(self) -> Optional[_builtins.bool]:
        """
        Use default DNS
        """
        return pulumi.get(self, "use_default_public_dnsresolver")


@pulumi.output_type
class RegionNetworkSubnetAllocationPool(dict):
    def __init__(__self__, *,
                 end: Optional[_builtins.str] = None,
                 start: Optional[_builtins.str] = None):
        """
        :param _builtins.str end: Last IP for the pool (eg: 192.168.1.24)
        :param _builtins.str start: First IP for the pool (eg: 192.168.1.12)
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def end(self) -> Optional[_builtins.str]:
        """
        Last IP for the pool (eg: 192.168.1.24)
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[_builtins.str]:
        """
        First IP for the pool (eg: 192.168.1.12)
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class RegionNetworkSubnetHostRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextHop":
            suggest = "next_hop"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegionNetworkSubnetHostRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegionNetworkSubnetHostRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegionNetworkSubnetHostRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[_builtins.str] = None,
                 next_hop: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination: Host route destination (eg: 192.168.1.0/24)
        :param _builtins.str next_hop: Host route next hop (eg: 192.168.1.254)
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        """
        Host route destination (eg: 192.168.1.0/24)
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[_builtins.str]:
        """
        Host route next hop (eg: 192.168.1.254)
        """
        return pulumi.get(self, "next_hop")


@pulumi.output_type
class StorageEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseAlgorithm":
            suggest = "sse_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_algorithm: Optional[_builtins.str] = None):
        """
        :param _builtins.str sse_algorithm: Encryption algorithm
        """
        if sse_algorithm is not None:
            pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> Optional[_builtins.str]:
        """
        Encryption algorithm
        """
        return pulumi.get(self, "sse_algorithm")


@pulumi.output_type
class StorageObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isDeleteMarker":
            suggest = "is_delete_marker"
        elif key == "isLatest":
            suggest = "is_latest"
        elif key == "lastModified":
            suggest = "last_modified"
        elif key == "storageClass":
            suggest = "storage_class"
        elif key == "versionId":
            suggest = "version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[_builtins.str] = None,
                 is_delete_marker: Optional[_builtins.bool] = None,
                 is_latest: Optional[_builtins.bool] = None,
                 key: Optional[_builtins.str] = None,
                 last_modified: Optional[_builtins.str] = None,
                 size: Optional[_builtins.float] = None,
                 storage_class: Optional[_builtins.str] = None,
                 version_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str etag: ETag
        :param _builtins.bool is_delete_marker: Whether this object is a delete marker
        :param _builtins.bool is_latest: Whether this is the latest version of the object
        :param _builtins.str key: Key
        :param _builtins.str last_modified: Last modification date
        :param _builtins.float size: Size (bytes)
        :param _builtins.str storage_class: Storage class
        :param _builtins.str version_id: Version ID of the object
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if is_delete_marker is not None:
            pulumi.set(__self__, "is_delete_marker", is_delete_marker)
        if is_latest is not None:
            pulumi.set(__self__, "is_latest", is_latest)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[_builtins.str]:
        """
        ETag
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="isDeleteMarker")
    def is_delete_marker(self) -> Optional[_builtins.bool]:
        """
        Whether this object is a delete marker
        """
        return pulumi.get(self, "is_delete_marker")

    @_builtins.property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[_builtins.bool]:
        """
        Whether this is the latest version of the object
        """
        return pulumi.get(self, "is_latest")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Key
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[_builtins.str]:
        """
        Last modification date
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.float]:
        """
        Size (bytes)
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[_builtins.str]:
        """
        Storage class
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[_builtins.str]:
        """
        Version ID of the object
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class StorageReplication(dict):
    def __init__(__self__, *,
                 rules: Optional[Sequence['outputs.StorageReplicationRule']] = None):
        """
        :param Sequence['StorageReplicationRuleArgs'] rules: Replication rules
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.StorageReplicationRule']]:
        """
        Replication rules
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class StorageReplicationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMarkerReplication":
            suggest = "delete_marker_replication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageReplicationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageReplicationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageReplicationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_marker_replication: Optional[_builtins.str] = None,
                 destination: Optional['outputs.StorageReplicationRuleDestination'] = None,
                 filter: Optional['outputs.StorageReplicationRuleFilter'] = None,
                 id: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.float] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str delete_marker_replication: Delete marker replication
        :param 'StorageReplicationRuleDestinationArgs' destination: Rule destination configuration
        :param 'StorageReplicationRuleFilterArgs' filter: Rule filters
        :param _builtins.str id: Rule ID
        :param _builtins.float priority: Rule priority
        :param _builtins.str status: Rule status
        """
        if delete_marker_replication is not None:
            pulumi.set(__self__, "delete_marker_replication", delete_marker_replication)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="deleteMarkerReplication")
    def delete_marker_replication(self) -> Optional[_builtins.str]:
        """
        Delete marker replication
        """
        return pulumi.get(self, "delete_marker_replication")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional['outputs.StorageReplicationRuleDestination']:
        """
        Rule destination configuration
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.StorageReplicationRuleFilter']:
        """
        Rule filters
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Rule ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.float]:
        """
        Rule priority
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Rule status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class StorageReplicationRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageReplicationRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageReplicationRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageReplicationRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 region: _builtins.str,
                 storage_class: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Destination bucket name
        :param _builtins.str region: Destination region
        :param _builtins.str storage_class: Destination storage class
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Destination bucket name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Destination region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[_builtins.str]:
        """
        Destination storage class
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class StorageReplicationRuleFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str prefix: Prefix filter
        :param Mapping[str, _builtins.str] tags: Tags filter
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        Prefix filter
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Tags filter
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class StorageVersioning(dict):
    def __init__(__self__, *,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str status: Versioning status
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Versioning status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class UserRole(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 permissions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str description: A description associated with the user.
        :param _builtins.str id: id of the role
        :param _builtins.str name: name of the role
        :param Sequence[_builtins.str] permissions: list of permissions associated with the role
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        id of the role
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name of the role
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[_builtins.str]]:
        """
        list of permissions associated with the role
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class VolumeSubOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSubOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSubOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSubOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_id: Affected resource of the sub-operation
        :param _builtins.str resource_type: The started date of the sub-operation
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        """
        Affected resource of the sub-operation
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        The started date of the sub-operation
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetCapabilitiesContainerFilterFeatureResult(dict):
    def __init__(__self__, *,
                 vulnerability: _builtins.bool):
        """
        :param _builtins.bool vulnerability: Vulnerability scanning
        """
        pulumi.set(__self__, "vulnerability", vulnerability)

    @_builtins.property
    @pulumi.getter
    def vulnerability(self) -> _builtins.bool:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class GetCapabilitiesContainerFilterRegistryLimitResult(dict):
    def __init__(__self__, *,
                 image_storage: _builtins.int,
                 parallel_request: _builtins.int):
        """
        :param _builtins.int image_storage: Docker image storage limits in bytes
        :param _builtins.int parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        pulumi.set(__self__, "image_storage", image_storage)
        pulumi.set(__self__, "parallel_request", parallel_request)

    @_builtins.property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> _builtins.int:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @_builtins.property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> _builtins.int:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")


@pulumi.output_type
class GetCapabilitiesContainerRegistryResultResult(dict):
    def __init__(__self__, *,
                 plans: Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanResult'],
                 region_name: _builtins.str):
        """
        :param Sequence['GetCapabilitiesContainerRegistryResultPlanArgs'] plans: Available plans in the region
        :param _builtins.str region_name: The region name
        """
        pulumi.set(__self__, "plans", plans)
        pulumi.set(__self__, "region_name", region_name)

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanResult']:
        """
        Available plans in the region
        """
        return pulumi.get(self, "plans")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        The region name
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class GetCapabilitiesContainerRegistryResultPlanResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 created_at: _builtins.str,
                 features: Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanFeatureResult'],
                 id: _builtins.str,
                 name: _builtins.str,
                 registry_limits: Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanRegistryLimitResult'],
                 updated_at: _builtins.str):
        """
        :param _builtins.str code: Plan code from the catalog
        :param _builtins.str created_at: Plan creation date
        :param Sequence['GetCapabilitiesContainerRegistryResultPlanFeatureArgs'] features: Features of the plan
        :param _builtins.str id: Plan ID
        :param _builtins.str name: Plan name
        :param Sequence['GetCapabilitiesContainerRegistryResultPlanRegistryLimitArgs'] registry_limits: Container registry limits
        :param _builtins.str updated_at: Plan last update date
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "registry_limits", registry_limits)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        Plan code from the catalog
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Plan creation date
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanFeatureResult']:
        """
        Features of the plan
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Plan ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Plan name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="registryLimits")
    def registry_limits(self) -> Sequence['outputs.GetCapabilitiesContainerRegistryResultPlanRegistryLimitResult']:
        """
        Container registry limits
        """
        return pulumi.get(self, "registry_limits")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Plan last update date
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetCapabilitiesContainerRegistryResultPlanFeatureResult(dict):
    def __init__(__self__, *,
                 vulnerability: _builtins.bool):
        """
        :param _builtins.bool vulnerability: Vulnerability scanning
        """
        pulumi.set(__self__, "vulnerability", vulnerability)

    @_builtins.property
    @pulumi.getter
    def vulnerability(self) -> _builtins.bool:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class GetCapabilitiesContainerRegistryResultPlanRegistryLimitResult(dict):
    def __init__(__self__, *,
                 image_storage: _builtins.int,
                 parallel_request: _builtins.int):
        """
        :param _builtins.int image_storage: Docker image storage limits in bytes
        :param _builtins.int parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        pulumi.set(__self__, "image_storage", image_storage)
        pulumi.set(__self__, "parallel_request", parallel_request)

    @_builtins.property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> _builtins.int:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @_builtins.property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> _builtins.int:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")


@pulumi.output_type
class GetContainerRegistriesResultResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 iam_enabled: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 project_id: _builtins.str,
                 region: _builtins.str,
                 size: _builtins.int,
                 status: _builtins.str,
                 updated_at: _builtins.str,
                 url: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str created_at: Registry creation date
        :param _builtins.bool iam_enabled: OVHCloud IAM enabled
        :param _builtins.str id: Registry ID
        :param _builtins.str name: Registry name
        :param _builtins.str project_id: Project ID of your registry
        :param _builtins.str region: Region of the registry
        :param _builtins.int size: Current size of the registry (bytes)
        :param _builtins.str status: Registry status
        :param _builtins.str updated_at: Registry last update date
        :param _builtins.str url: Access url of the registry
        :param _builtins.str version: Version of your registry
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "iam_enabled", iam_enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Registry creation date
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="iamEnabled")
    def iam_enabled(self) -> _builtins.bool:
        """
        OVHCloud IAM enabled
        """
        return pulumi.get(self, "iam_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Registry ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Registry name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Project ID of your registry
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region of the registry
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Current size of the registry (bytes)
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Registry status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Registry last update date
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Access url of the registry
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of your registry
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetContainerRegistryUsersResultResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 id: _builtins.str,
                 user: _builtins.str):
        """
        :param _builtins.str email: User email
        :param _builtins.str id: User ID
        :param _builtins.str user: User name
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        User email
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        User ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        User name
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 available: _builtins.bool,
                 capabilities: Sequence['outputs.GetFlavorsFlavorCapabilityResult'],
                 disk: _builtins.float,
                 id: _builtins.str,
                 inbound_bandwidth: _builtins.float,
                 name: _builtins.str,
                 os_type: _builtins.str,
                 outbound_bandwidth: _builtins.float,
                 plan_codes: 'outputs.GetFlavorsFlavorPlanCodesResult',
                 quota: _builtins.float,
                 ram: _builtins.float,
                 region: _builtins.str,
                 type: _builtins.str,
                 vcpus: _builtins.float):
        """
        :param _builtins.bool available: Available in stock
        :param Sequence['GetFlavorsFlavorCapabilityArgs'] capabilities: Capabilities of the flavor
        :param _builtins.float disk: Number of disks
        :param _builtins.str id: Flavor id
        :param _builtins.float inbound_bandwidth: Max capacity of inbound traffic in Mbit/s
        :param _builtins.str name: Flavor name
        :param _builtins.str os_type: OS to install on
        :param _builtins.float outbound_bandwidth: Max capacity of outbound traffic in Mbit/s
        :param 'GetFlavorsFlavorPlanCodesArgs' plan_codes: Plan codes to order instances
        :param _builtins.float quota: Number instance you can spawn with your actual quota
        :param _builtins.float ram: Ram quantity (Gio)
        :param _builtins.str region: Flavor region
        :param _builtins.str type: Flavor type
        :param _builtins.float vcpus: Number of VCPUs
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "disk", disk)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inbound_bandwidth", inbound_bandwidth)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "outbound_bandwidth", outbound_bandwidth)
        pulumi.set(__self__, "plan_codes", plan_codes)
        pulumi.set(__self__, "quota", quota)
        pulumi.set(__self__, "ram", ram)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vcpus", vcpus)

    @_builtins.property
    @pulumi.getter
    def available(self) -> _builtins.bool:
        """
        Available in stock
        """
        return pulumi.get(self, "available")

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.GetFlavorsFlavorCapabilityResult']:
        """
        Capabilities of the flavor
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def disk(self) -> _builtins.float:
        """
        Number of disks
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Flavor id
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inboundBandwidth")
    def inbound_bandwidth(self) -> _builtins.float:
        """
        Max capacity of inbound traffic in Mbit/s
        """
        return pulumi.get(self, "inbound_bandwidth")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Flavor name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        OS to install on
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="outboundBandwidth")
    def outbound_bandwidth(self) -> _builtins.float:
        """
        Max capacity of outbound traffic in Mbit/s
        """
        return pulumi.get(self, "outbound_bandwidth")

    @_builtins.property
    @pulumi.getter(name="planCodes")
    def plan_codes(self) -> 'outputs.GetFlavorsFlavorPlanCodesResult':
        """
        Plan codes to order instances
        """
        return pulumi.get(self, "plan_codes")

    @_builtins.property
    @pulumi.getter
    def quota(self) -> _builtins.float:
        """
        Number instance you can spawn with your actual quota
        """
        return pulumi.get(self, "quota")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.float:
        """
        Ram quantity (Gio)
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Flavor region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Flavor type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> _builtins.float:
        """
        Number of VCPUs
        """
        return pulumi.get(self, "vcpus")


@pulumi.output_type
class GetFlavorsFlavorCapabilityResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 name: _builtins.str):
        """
        :param _builtins.bool enabled: Is the capability enabled
        :param _builtins.str name: Name of the capability
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is the capability enabled
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the capability
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetFlavorsFlavorPlanCodesResult(dict):
    def __init__(__self__, *,
                 hourly: _builtins.str,
                 monthly: _builtins.str):
        """
        :param _builtins.str hourly: Plan code to order hourly instance
        :param _builtins.str monthly: Plan code to order monthly instance
        """
        pulumi.set(__self__, "hourly", hourly)
        pulumi.set(__self__, "monthly", monthly)

    @_builtins.property
    @pulumi.getter
    def hourly(self) -> _builtins.str:
        """
        Plan code to order hourly instance
        """
        return pulumi.get(self, "hourly")

    @_builtins.property
    @pulumi.getter
    def monthly(self) -> _builtins.str:
        """
        Plan code to order monthly instance
        """
        return pulumi.get(self, "monthly")


@pulumi.output_type
class GetFloatingIPsCloudProjectFloatingipResult(dict):
    def __init__(__self__, *,
                 associated_entity: 'outputs.GetFloatingIPsCloudProjectFloatingipAssociatedEntityResult',
                 id: _builtins.str,
                 ip: _builtins.str,
                 network_id: _builtins.str,
                 region: _builtins.str,
                 status: _builtins.str):
        """
        :param 'GetFloatingIPsCloudProjectFloatingipAssociatedEntityArgs' associated_entity: Associated entity with the floating IP
        :param _builtins.str id: ID of the floating IP
        :param _builtins.str ip: Value of the floating IP
        :param _builtins.str network_id: ID of the network
        :param _builtins.str region: Floating ip region
        :param _builtins.str status: Status of the floating IP (active┃down┃error)
        """
        pulumi.set(__self__, "associated_entity", associated_entity)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="associatedEntity")
    def associated_entity(self) -> 'outputs.GetFloatingIPsCloudProjectFloatingipAssociatedEntityResult':
        """
        Associated entity with the floating IP
        """
        return pulumi.get(self, "associated_entity")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the floating IP
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Value of the floating IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        ID of the network
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Floating ip region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the floating IP (active┃down┃error)
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetFloatingIPsCloudProjectFloatingipAssociatedEntityResult(dict):
    def __init__(__self__, *,
                 gateway_id: _builtins.str,
                 id: _builtins.str,
                 ip: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str gateway_id: ID of the gateway
        :param _builtins.str id: ID of the floating IP
        :param _builtins.str ip: Value of the floating IP
        :param _builtins.str type: Type of the port (dhcp┃instance┃loadbalancer┃routerInterface┃unknown)
        """
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> _builtins.str:
        """
        ID of the gateway
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the floating IP
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Value of the floating IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the port (dhcp┃instance┃loadbalancer┃routerInterface┃unknown)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 creation_date: _builtins.str,
                 flavor_type: _builtins.str,
                 id: _builtins.str,
                 min_disk: _builtins.float,
                 min_ram: _builtins.float,
                 name: _builtins.str,
                 plan_code: _builtins.str,
                 region: _builtins.str,
                 size: _builtins.float,
                 status: _builtins.str,
                 tags: Sequence[_builtins.str],
                 type: _builtins.str,
                 user: _builtins.str,
                 visibility: _builtins.str):
        """
        :param _builtins.str creation_date: Image creation date
        :param _builtins.str flavor_type: Image usable only for this type of flavor if not null
        :param _builtins.str id: Image ID
        :param _builtins.float min_disk: Minimum disks required to use image
        :param _builtins.float min_ram: Minimum RAM required to use image
        :param _builtins.str name: Image name
        :param _builtins.str plan_code: Order plan code
        :param _builtins.str region: Image region
        :param _builtins.float size: Image size (in GiB)
        :param _builtins.str status: Image status
        :param Sequence[_builtins.str] tags: Tags about the image
        :param _builtins.str type: Image type
        :param _builtins.str user: User to connect with
        :param _builtins.str visibility: Image visibility
        """
        pulumi.set(__self__, "creation_date", creation_date)
        pulumi.set(__self__, "flavor_type", flavor_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "min_disk", min_disk)
        pulumi.set(__self__, "min_ram", min_ram)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        Image creation date
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter(name="flavorType")
    def flavor_type(self) -> _builtins.str:
        """
        Image usable only for this type of flavor if not null
        """
        return pulumi.get(self, "flavor_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Image ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="minDisk")
    def min_disk(self) -> _builtins.float:
        """
        Minimum disks required to use image
        """
        return pulumi.get(self, "min_disk")

    @_builtins.property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> _builtins.float:
        """
        Minimum RAM required to use image
        """
        return pulumi.get(self, "min_ram")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Image name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Order plan code
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Image region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.float:
        """
        Image size (in GiB)
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Image status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags about the image
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Image type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        User to connect with
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> _builtins.str:
        """
        Image visibility
        """
        return pulumi.get(self, "visibility")


@pulumi.output_type
class GetInstanceAddressResult(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 version: _builtins.int):
        """
        :param _builtins.str ip: IP address
        :param _builtins.int version: IP version
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP address
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        IP version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetInstanceAttachedVolumeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: Instance id
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Instance id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence['outputs.GetInstancesInstanceAddressResult'],
                 attached_volumes: Sequence['outputs.GetInstancesInstanceAttachedVolumeResult'],
                 availability_zone: _builtins.str,
                 flavor_id: _builtins.str,
                 flavor_name: _builtins.str,
                 id: _builtins.str,
                 image_id: _builtins.str,
                 name: _builtins.str,
                 ssh_key: _builtins.str,
                 status: _builtins.str,
                 task_state: _builtins.str):
        """
        :param Sequence['GetInstancesInstanceAddressArgs'] addresses: Instance IP addresses
        :param Sequence['GetInstancesInstanceAttachedVolumeArgs'] attached_volumes: Volumes attached to the instance
        :param _builtins.str availability_zone: Availability zone of the instance
        :param _builtins.str flavor_id: Flavor id
        :param _builtins.str flavor_name: Flavor name
        :param _builtins.str id: Instance id
        :param _builtins.str image_id: Image id
        :param _builtins.str name: Instance name
        :param _builtins.str ssh_key: SSH Keypair
        :param _builtins.str status: Instance status
        :param _builtins.str task_state: Instance task state
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "attached_volumes", attached_volumes)
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "flavor_name", flavor_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ssh_key", ssh_key)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "task_state", task_state)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.GetInstancesInstanceAddressResult']:
        """
        Instance IP addresses
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="attachedVolumes")
    def attached_volumes(self) -> Sequence['outputs.GetInstancesInstanceAttachedVolumeResult']:
        """
        Volumes attached to the instance
        """
        return pulumi.get(self, "attached_volumes")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Availability zone of the instance
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        Flavor id
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> _builtins.str:
        """
        Flavor name
        """
        return pulumi.get(self, "flavor_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Instance id
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        Image id
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Instance name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> _builtins.str:
        """
        SSH Keypair
        """
        return pulumi.get(self, "ssh_key")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Instance status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="taskState")
    def task_state(self) -> _builtins.str:
        """
        Instance task state
        """
        return pulumi.get(self, "task_state")


@pulumi.output_type
class GetInstancesInstanceAddressResult(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 version: _builtins.int):
        """
        :param _builtins.str ip: IP address
        :param _builtins.int version: IP version
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP address
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        IP version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetInstancesInstanceAttachedVolumeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: Instance id
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Instance id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetKubeCustomizationResult(dict):
    def __init__(__self__, *,
                 apiservers: Sequence['outputs.GetKubeCustomizationApiserverResult']):
        """
        :param Sequence['GetKubeCustomizationApiserverArgs'] apiservers: Kubernetes API server customization
        """
        pulumi.set(__self__, "apiservers", apiservers)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use customization_apiserver instead""")
    def apiservers(self) -> Sequence['outputs.GetKubeCustomizationApiserverResult']:
        """
        Kubernetes API server customization
        """
        return pulumi.get(self, "apiservers")


@pulumi.output_type
class GetKubeCustomizationApiserverResult(dict):
    def __init__(__self__, *,
                 admissionplugins: Sequence['outputs.GetKubeCustomizationApiserverAdmissionpluginResult']):
        """
        :param Sequence['GetKubeCustomizationApiserverAdmissionpluginArgs'] admissionplugins: Kubernetes API server admission plugins customization
        """
        pulumi.set(__self__, "admissionplugins", admissionplugins)

    @_builtins.property
    @pulumi.getter
    def admissionplugins(self) -> Sequence['outputs.GetKubeCustomizationApiserverAdmissionpluginResult']:
        """
        Kubernetes API server admission plugins customization
        """
        return pulumi.get(self, "admissionplugins")


@pulumi.output_type
class GetKubeCustomizationApiserverAdmissionpluginResult(dict):
    def __init__(__self__, *,
                 disableds: Sequence[_builtins.str],
                 enableds: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] disableds: Array of admission plugins disabled, default is [] and only AlwaysPulImages can be disabled at this time.
        :param Sequence[_builtins.str] enableds: Array of admission plugins enabled, default is ["NodeRestriction","AlwaysPulImages"] and only these admission plugins can be enabled at this time.
        """
        pulumi.set(__self__, "disableds", disableds)
        pulumi.set(__self__, "enableds", enableds)

    @_builtins.property
    @pulumi.getter
    def disableds(self) -> Sequence[_builtins.str]:
        """
        Array of admission plugins disabled, default is [] and only AlwaysPulImages can be disabled at this time.
        """
        return pulumi.get(self, "disableds")

    @_builtins.property
    @pulumi.getter
    def enableds(self) -> Sequence[_builtins.str]:
        """
        Array of admission plugins enabled, default is ["NodeRestriction","AlwaysPulImages"] and only these admission plugins can be enabled at this time.
        """
        return pulumi.get(self, "enableds")


@pulumi.output_type
class GetKubeCustomizationKubeProxyResult(dict):
    def __init__(__self__, *,
                 iptables: Optional['outputs.GetKubeCustomizationKubeProxyIptablesResult'] = None,
                 ipvs: Optional['outputs.GetKubeCustomizationKubeProxyIpvsResult'] = None):
        """
        :param 'GetKubeCustomizationKubeProxyIptablesArgs' iptables: Kubernetes cluster kube-proxy customization of iptables specific config.
        :param 'GetKubeCustomizationKubeProxyIpvsArgs' ipvs: Kubernetes cluster kube-proxy customization of IPVS specific config (durations format is [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        if iptables is not None:
            pulumi.set(__self__, "iptables", iptables)
        if ipvs is not None:
            pulumi.set(__self__, "ipvs", ipvs)

    @_builtins.property
    @pulumi.getter
    def iptables(self) -> Optional['outputs.GetKubeCustomizationKubeProxyIptablesResult']:
        """
        Kubernetes cluster kube-proxy customization of iptables specific config.
        """
        return pulumi.get(self, "iptables")

    @_builtins.property
    @pulumi.getter
    def ipvs(self) -> Optional['outputs.GetKubeCustomizationKubeProxyIpvsResult']:
        """
        Kubernetes cluster kube-proxy customization of IPVS specific config (durations format is [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "ipvs")


@pulumi.output_type
class GetKubeCustomizationKubeProxyIptablesResult(dict):
    def __init__(__self__, *,
                 min_sync_period: Optional[_builtins.str] = None,
                 sync_period: Optional[_builtins.str] = None):
        """
        :param _builtins.str min_sync_period: Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        :param _builtins.str sync_period: Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format.
        """
        if min_sync_period is not None:
            pulumi.set(__self__, "min_sync_period", min_sync_period)
        if sync_period is not None:
            pulumi.set(__self__, "sync_period", sync_period)

    @_builtins.property
    @pulumi.getter(name="minSyncPeriod")
    def min_sync_period(self) -> Optional[_builtins.str]:
        """
        Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "min_sync_period")

    @_builtins.property
    @pulumi.getter(name="syncPeriod")
    def sync_period(self) -> Optional[_builtins.str]:
        """
        Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format.
        """
        return pulumi.get(self, "sync_period")


@pulumi.output_type
class GetKubeCustomizationKubeProxyIpvsResult(dict):
    def __init__(__self__, *,
                 min_sync_period: Optional[_builtins.str] = None,
                 scheduler: Optional[_builtins.str] = None,
                 sync_period: Optional[_builtins.str] = None,
                 tcp_fin_timeout: Optional[_builtins.str] = None,
                 tcp_timeout: Optional[_builtins.str] = None,
                 udp_timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str min_sync_period: Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        :param _builtins.str scheduler: IPVS scheduler.
        :param _builtins.str sync_period: Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format.
        :param _builtins.str tcp_fin_timeout: Timeout value used for IPVS TCP sessions after receiving a FIN in RFC3339 duration.
        :param _builtins.str tcp_timeout: Timeout value used for idle IPVS TCP sessions in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        :param _builtins.str udp_timeout: timeout value used for IPVS UDP packets in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        if min_sync_period is not None:
            pulumi.set(__self__, "min_sync_period", min_sync_period)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if sync_period is not None:
            pulumi.set(__self__, "sync_period", sync_period)
        if tcp_fin_timeout is not None:
            pulumi.set(__self__, "tcp_fin_timeout", tcp_fin_timeout)
        if tcp_timeout is not None:
            pulumi.set(__self__, "tcp_timeout", tcp_timeout)
        if udp_timeout is not None:
            pulumi.set(__self__, "udp_timeout", udp_timeout)

    @_builtins.property
    @pulumi.getter(name="minSyncPeriod")
    def min_sync_period(self) -> Optional[_builtins.str]:
        """
        Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "min_sync_period")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional[_builtins.str]:
        """
        IPVS scheduler.
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter(name="syncPeriod")
    def sync_period(self) -> Optional[_builtins.str]:
        """
        Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format.
        """
        return pulumi.get(self, "sync_period")

    @_builtins.property
    @pulumi.getter(name="tcpFinTimeout")
    def tcp_fin_timeout(self) -> Optional[_builtins.str]:
        """
        Timeout value used for IPVS TCP sessions after receiving a FIN in RFC3339 duration.
        """
        return pulumi.get(self, "tcp_fin_timeout")

    @_builtins.property
    @pulumi.getter(name="tcpTimeout")
    def tcp_timeout(self) -> Optional[_builtins.str]:
        """
        Timeout value used for idle IPVS TCP sessions in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "tcp_timeout")

    @_builtins.property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> Optional[_builtins.str]:
        """
        timeout value used for IPVS UDP packets in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "udp_timeout")


@pulumi.output_type
class GetKubeKubeconfigAttributeResult(dict):
    def __init__(__self__, *,
                 client_certificate: _builtins.str,
                 client_key: _builtins.str,
                 cluster_ca_certificate: _builtins.str,
                 host: _builtins.str):
        """
        :param _builtins.str client_certificate: (Sensitive) Client certificate data for authentication.
        :param _builtins.str client_key: (Sensitive) Client private key data for authentication.
        :param _builtins.str cluster_ca_certificate: (Sensitive) Cluster certificate authority data.
        :param _builtins.str host: Kubernetes API server endpoint.
        """
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> _builtins.str:
        """
        (Sensitive) Client certificate data for authentication.
        """
        return pulumi.get(self, "client_certificate")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> _builtins.str:
        """
        (Sensitive) Client private key data for authentication.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> _builtins.str:
        """
        (Sensitive) Cluster certificate authority data.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Kubernetes API server endpoint.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class GetKubeNodePoolNodesNodeResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 deployed_at: _builtins.str,
                 flavor: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 is_up_to_date: _builtins.bool,
                 name: _builtins.str,
                 node_pool_id: _builtins.str,
                 project_id: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str created_at: Creation date.
        :param _builtins.str deployed_at: (Optional) Date of the effective deployment.
        :param _builtins.str flavor: Flavor name.
        :param _builtins.str id: ID of the node.
        :param _builtins.str instance_id: Openstack ID of the underlying VM of the node.
        :param _builtins.bool is_up_to_date: Is the node in the target version of the cluster.
        :param _builtins.str name: Name of the node pool from which we want the nodes.
        :param _builtins.str node_pool_id: Managed kubernetes node pool ID.
        :param _builtins.str project_id: Public cloud project ID.
        :param _builtins.str status: Current status.
        :param _builtins.str updated_at: Last update date.
        :param _builtins.str version: Version in which the node is.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "deployed_at", deployed_at)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_up_to_date", is_up_to_date)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_pool_id", node_pool_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Creation date.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deployedAt")
    def deployed_at(self) -> _builtins.str:
        """
        (Optional) Date of the effective deployment.
        """
        return pulumi.get(self, "deployed_at")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Flavor name.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Openstack ID of the underlying VM of the node.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isUpToDate")
    def is_up_to_date(self) -> _builtins.bool:
        """
        Is the node in the target version of the cluster.
        """
        return pulumi.get(self, "is_up_to_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the node pool from which we want the nodes.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> _builtins.str:
        """
        Managed kubernetes node pool ID.
        """
        return pulumi.get(self, "node_pool_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Public cloud project ID.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Current status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Last update date.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version in which the node is.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetKubeNodePoolTemplateResult(dict):
    def __init__(__self__, *,
                 metadata: Optional['outputs.GetKubeNodePoolTemplateMetadataResult'] = None,
                 spec: Optional['outputs.GetKubeNodePoolTemplateSpecResult'] = None):
        """
        :param 'GetKubeNodePoolTemplateMetadataArgs' metadata: metadata
        :param 'GetKubeNodePoolTemplateSpecArgs' spec: spec
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.GetKubeNodePoolTemplateMetadataResult']:
        """
        metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.GetKubeNodePoolTemplateSpecResult']:
        """
        spec
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class GetKubeNodePoolTemplateMetadataResult(dict):
    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 finalizers: Optional[Sequence[_builtins.str]] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] annotations: annotations
        :param Sequence[_builtins.str] finalizers: finalizers
        :param Mapping[str, _builtins.str] labels: labels
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        annotations
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def finalizers(self) -> Optional[Sequence[_builtins.str]]:
        """
        finalizers
        """
        return pulumi.get(self, "finalizers")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        labels
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class GetKubeNodePoolTemplateSpecResult(dict):
    def __init__(__self__, *,
                 taints: Optional[Sequence[Mapping[str, _builtins.str]]] = None,
                 unschedulable: Optional[_builtins.bool] = None):
        """
        :param Sequence[Mapping[str, _builtins.str]] taints: taints
        :param _builtins.bool unschedulable: unschedulable
        """
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[Sequence[Mapping[str, _builtins.str]]]:
        """
        taints
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter
    def unschedulable(self) -> Optional[_builtins.bool]:
        """
        unschedulable
        """
        return pulumi.get(self, "unschedulable")


@pulumi.output_type
class GetKubeNodesNodeResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 deployed_at: _builtins.str,
                 flavor: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 is_up_to_date: _builtins.bool,
                 name: _builtins.str,
                 node_pool_id: _builtins.str,
                 project_id: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str created_at: Creation date
        :param _builtins.str deployed_at: (Optional) Date of the effective deployment
        :param _builtins.str flavor: Flavor name
        :param _builtins.str id: ID of the node
        :param _builtins.str instance_id: Openstack ID of the underlying VM of the node
        :param _builtins.bool is_up_to_date: Is the node in the target version of the cluster
        :param _builtins.str name: Name of the node
        :param _builtins.str node_pool_id: Managed kubernetes node pool ID
        :param _builtins.str project_id: Public cloud project ID
        :param _builtins.str status: Current status
        :param _builtins.str updated_at: Last update date
        :param _builtins.str version: Version in which the node is
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "deployed_at", deployed_at)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_up_to_date", is_up_to_date)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_pool_id", node_pool_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Creation date
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deployedAt")
    def deployed_at(self) -> _builtins.str:
        """
        (Optional) Date of the effective deployment
        """
        return pulumi.get(self, "deployed_at")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Flavor name
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the node
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Openstack ID of the underlying VM of the node
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isUpToDate")
    def is_up_to_date(self) -> _builtins.bool:
        """
        Is the node in the target version of the cluster
        """
        return pulumi.get(self, "is_up_to_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the node
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> _builtins.str:
        """
        Managed kubernetes node pool ID
        """
        return pulumi.get(self, "node_pool_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Public cloud project ID
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Current status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Last update date
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version in which the node is
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetLoadBalancerFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str id: Flavor id
        :param _builtins.str name: Flavor name
        :param _builtins.str region: Region name
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Flavor id
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Flavor name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region name
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetLoadBalancerFloatingIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 ip: _builtins.str):
        """
        :param _builtins.str id: ID of the loadbalancer
        :param _builtins.str ip: Value of the floating IP
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the loadbalancer
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Value of the floating IP
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetLoadBalancersLoadbalancerResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 flavor_id: _builtins.str,
                 floating_ip: 'outputs.GetLoadBalancersLoadbalancerFloatingIpResult',
                 id: _builtins.str,
                 name: _builtins.str,
                 operating_status: _builtins.str,
                 provisioning_status: _builtins.str,
                 region: _builtins.str,
                 updated_at: _builtins.str,
                 vip_address: _builtins.str,
                 vip_network_id: _builtins.str,
                 vip_subnet_id: _builtins.str):
        """
        :param _builtins.str created_at: Date of creation of the loadbalancer
        :param _builtins.str flavor_id: ID of the flavor
        :param 'GetLoadBalancersLoadbalancerFloatingIpArgs' floating_ip: Information about the floating IP
        :param _builtins.str id: ID of the floating IP
        :param _builtins.str name: Name of the loadbalancer
        :param _builtins.str operating_status: Operating status of the loadbalancer
        :param _builtins.str provisioning_status: Provisioning status of the loadbalancer
        :param _builtins.str region: Region of the loadbalancer
        :param _builtins.str updated_at: Last update date of the loadbalancer
        :param _builtins.str vip_address: IP address of the Virtual IP
        :param _builtins.str vip_network_id: Openstack ID of the network for the Virtual IP
        :param _builtins.str vip_subnet_id: ID of the subnet for the Virtual IP
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "floating_ip", floating_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operating_status", operating_status)
        pulumi.set(__self__, "provisioning_status", provisioning_status)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "vip_address", vip_address)
        pulumi.set(__self__, "vip_network_id", vip_network_id)
        pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date of creation of the loadbalancer
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        ID of the flavor
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="floatingIp")
    def floating_ip(self) -> 'outputs.GetLoadBalancersLoadbalancerFloatingIpResult':
        """
        Information about the floating IP
        """
        return pulumi.get(self, "floating_ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the floating IP
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the loadbalancer
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> _builtins.str:
        """
        Operating status of the loadbalancer
        """
        return pulumi.get(self, "operating_status")

    @_builtins.property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> _builtins.str:
        """
        Provisioning status of the loadbalancer
        """
        return pulumi.get(self, "provisioning_status")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region of the loadbalancer
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Last update date of the loadbalancer
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> _builtins.str:
        """
        IP address of the Virtual IP
        """
        return pulumi.get(self, "vip_address")

    @_builtins.property
    @pulumi.getter(name="vipNetworkId")
    def vip_network_id(self) -> _builtins.str:
        """
        Openstack ID of the network for the Virtual IP
        """
        return pulumi.get(self, "vip_network_id")

    @_builtins.property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> _builtins.str:
        """
        ID of the subnet for the Virtual IP
        """
        return pulumi.get(self, "vip_subnet_id")


@pulumi.output_type
class GetLoadBalancersLoadbalancerFloatingIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 ip: _builtins.str):
        """
        :param _builtins.str id: ID of the floating IP
        :param _builtins.str ip: Value of the floating IP
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the floating IP
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Value of the floating IP
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetNetworkPrivateRegionResult(dict):
    def __init__(__self__, *,
                 openstack_id: _builtins.str,
                 region: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str openstack_id: Network ID on openstack region
        :param _builtins.str region: Name of the region
        :param _builtins.str status: Status of the network
        """
        pulumi.set(__self__, "openstack_id", openstack_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="openstackId")
    def openstack_id(self) -> _builtins.str:
        """
        Network ID on openstack region
        """
        return pulumi.get(self, "openstack_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Name of the region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the network
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNetworkPrivateSubnetsSubnetResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 dhcp_enabled: _builtins.bool,
                 gateway_ip: _builtins.str,
                 id: _builtins.str,
                 ip_pools: Sequence['outputs.GetNetworkPrivateSubnetsSubnetIpPoolResult']):
        """
        :param _builtins.str cidr: CIDR of the subnet
        :param _builtins.bool dhcp_enabled: Whether or not if DHCP is enabled for the subnet
        :param _builtins.str gateway_ip: Gateway IP of the subnet
        :param _builtins.str id: ID of the subnet
        :param Sequence['GetNetworkPrivateSubnetsSubnetIpPoolArgs'] ip_pools: List of ip pools allocated in the subnet
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "dhcp_enabled", dhcp_enabled)
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_pools", ip_pools)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        CIDR of the subnet
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> _builtins.bool:
        """
        Whether or not if DHCP is enabled for the subnet
        """
        return pulumi.get(self, "dhcp_enabled")

    @_builtins.property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> _builtins.str:
        """
        Gateway IP of the subnet
        """
        return pulumi.get(self, "gateway_ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the subnet
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Sequence['outputs.GetNetworkPrivateSubnetsSubnetIpPoolResult']:
        """
        List of ip pools allocated in the subnet
        """
        return pulumi.get(self, "ip_pools")


@pulumi.output_type
class GetNetworkPrivateSubnetsSubnetIpPoolResult(dict):
    def __init__(__self__, *,
                 dhcp: _builtins.bool,
                 end: _builtins.str,
                 network: _builtins.str,
                 region: _builtins.str,
                 start: _builtins.str):
        """
        :param _builtins.bool dhcp: Whether or not if DHCP is enabled
        :param _builtins.str end: Last IP for this region (eg: 192.168.1.24)
        :param _builtins.str network: Global network with cidr (eg: 192.168.1.0/24)
        :param _builtins.str region: Region associated to the subnet
        :param _builtins.str start: First IP for this region (eg: 192.168.1.12)
        """
        pulumi.set(__self__, "dhcp", dhcp)
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def dhcp(self) -> _builtins.bool:
        """
        Whether or not if DHCP is enabled
        """
        return pulumi.get(self, "dhcp")

    @_builtins.property
    @pulumi.getter
    def end(self) -> _builtins.str:
        """
        Last IP for this region (eg: 192.168.1.24)
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Global network with cidr (eg: 192.168.1.0/24)
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region associated to the subnet
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        First IP for this region (eg: 192.168.1.12)
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class GetNetworkPrivatesNetworkResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 regions: Sequence['outputs.GetNetworkPrivatesNetworkRegionResult'],
                 status: _builtins.str,
                 type: _builtins.str,
                 vlan_id: _builtins.float):
        """
        :param _builtins.str id: ID of the network
        :param _builtins.str name: Name of the network
        :param Sequence['GetNetworkPrivatesNetworkRegionArgs'] regions: Information about the private network in the openstack region
        :param _builtins.str status: Status of the network
        :param _builtins.str type: Type of the network
        :param _builtins.float vlan_id: VLAN ID of the network
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the network
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the network
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetNetworkPrivatesNetworkRegionResult']:
        """
        Information about the private network in the openstack region
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the network
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the network
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> _builtins.float:
        """
        VLAN ID of the network
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class GetNetworkPrivatesNetworkRegionResult(dict):
    def __init__(__self__, *,
                 openstack_id: _builtins.str,
                 region: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str openstack_id: Network ID on openstack region
        :param _builtins.str region: Name of the region
        :param _builtins.str status: Status of the network
        """
        pulumi.set(__self__, "openstack_id", openstack_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="openstackId")
    def openstack_id(self) -> _builtins.str:
        """
        Network ID on openstack region
        """
        return pulumi.get(self, "openstack_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Name of the region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the network
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetOpenSearchUserAclResult(dict):
    def __init__(__self__, *,
                 pattern: _builtins.str,
                 permission: _builtins.str):
        """
        :param _builtins.str pattern: Pattern of the ACL.
        :param _builtins.str permission: Permission of the ACL.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "permission", permission)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> _builtins.str:
        """
        Pattern of the ACL.
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Permission of the ACL.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class GetPrometheusTargetResult(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str host: Host of the endpoint
        :param _builtins.int port: Connection port for the endpoint
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Host of the endpoint
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Connection port for the endpoint
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetRancherCurrentStateResult(dict):
    def __init__(__self__, *,
                 bootstrap_password: _builtins.str,
                 ip_restrictions: Sequence['outputs.GetRancherCurrentStateIpRestrictionResult'],
                 name: _builtins.str,
                 networking: 'outputs.GetRancherCurrentStateNetworkingResult',
                 plan: _builtins.str,
                 region: _builtins.str,
                 url: _builtins.str,
                 usage: 'outputs.GetRancherCurrentStateUsageResult',
                 version: _builtins.str):
        """
        :param _builtins.str bootstrap_password: Bootstrap password of the managed Rancher service, returned only on creation
        :param Sequence['GetRancherCurrentStateIpRestrictionArgs'] ip_restrictions: List of allowed CIDR blocks for a managed Rancher service's IP restrictions. When empty, any IP is allowed
        :param _builtins.str name: Name of the managed Rancher service
        :param 'GetRancherCurrentStateNetworkingArgs' networking: Networking properties of a managed Rancher service
        :param _builtins.str plan: Plan of the managed Rancher service
        :param _builtins.str region: Region of the managed Rancher service
        :param _builtins.str url: URL of the managed Rancher service
        :param 'GetRancherCurrentStateUsageArgs' usage: Latest metrics regarding the usage of the managed Rancher service
        :param _builtins.str version: Version of the managed Rancher service
        """
        pulumi.set(__self__, "bootstrap_password", bootstrap_password)
        pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "networking", networking)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "usage", usage)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="bootstrapPassword")
    def bootstrap_password(self) -> _builtins.str:
        """
        Bootstrap password of the managed Rancher service, returned only on creation
        """
        return pulumi.get(self, "bootstrap_password")

    @_builtins.property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Sequence['outputs.GetRancherCurrentStateIpRestrictionResult']:
        """
        List of allowed CIDR blocks for a managed Rancher service's IP restrictions. When empty, any IP is allowed
        """
        return pulumi.get(self, "ip_restrictions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the managed Rancher service
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networking(self) -> 'outputs.GetRancherCurrentStateNetworkingResult':
        """
        Networking properties of a managed Rancher service
        """
        return pulumi.get(self, "networking")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        Plan of the managed Rancher service
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region of the managed Rancher service
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL of the managed Rancher service
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> 'outputs.GetRancherCurrentStateUsageResult':
        """
        Latest metrics regarding the usage of the managed Rancher service
        """
        return pulumi.get(self, "usage")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of the managed Rancher service
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetRancherCurrentStateIpRestrictionResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 description: _builtins.str):
        """
        :param _builtins.str cidr_block: Allowed CIDR block (/subnet is optional, if unspecified then /32 will be used)
        :param _builtins.str description: Description of the allowed CIDR block
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        Allowed CIDR block (/subnet is optional, if unspecified then /32 will be used)
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the allowed CIDR block
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetRancherCurrentStateNetworkingResult(dict):
    def __init__(__self__, *,
                 egress_cidr_blocks: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] egress_cidr_blocks: Specifies the CIDR ranges for egress IP addresses used by Rancher. Ensure these ranges are allowed in any IP restrictions for services that Rancher will access.
        """
        pulumi.set(__self__, "egress_cidr_blocks", egress_cidr_blocks)

    @_builtins.property
    @pulumi.getter(name="egressCidrBlocks")
    def egress_cidr_blocks(self) -> Sequence[_builtins.str]:
        """
        Specifies the CIDR ranges for egress IP addresses used by Rancher. Ensure these ranges are allowed in any IP restrictions for services that Rancher will access.
        """
        return pulumi.get(self, "egress_cidr_blocks")


@pulumi.output_type
class GetRancherCurrentStateUsageResult(dict):
    def __init__(__self__, *,
                 datetime: _builtins.str,
                 orchestrated_vcpus: _builtins.float):
        """
        :param _builtins.str datetime: Date of the sample
        :param _builtins.float orchestrated_vcpus: Total number of vCPUs orchestrated by the managed Rancher service through the downstream clusters
        """
        pulumi.set(__self__, "datetime", datetime)
        pulumi.set(__self__, "orchestrated_vcpus", orchestrated_vcpus)

    @_builtins.property
    @pulumi.getter
    def datetime(self) -> _builtins.str:
        """
        Date of the sample
        """
        return pulumi.get(self, "datetime")

    @_builtins.property
    @pulumi.getter(name="orchestratedVcpus")
    def orchestrated_vcpus(self) -> _builtins.float:
        """
        Total number of vCPUs orchestrated by the managed Rancher service through the downstream clusters
        """
        return pulumi.get(self, "orchestrated_vcpus")


@pulumi.output_type
class GetRancherCurrentTaskResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 link: _builtins.str,
                 status: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: Identifier of the current task
        :param _builtins.str link: Link to the task details
        :param _builtins.str status: Current global status of the current task
        :param _builtins.str type: Type of the current task
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "link", link)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier of the current task
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def link(self) -> _builtins.str:
        """
        Link to the task details
        """
        return pulumi.get(self, "link")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Current global status of the current task
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the current task
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRancherPlanPlanResult(dict):
    def __init__(__self__, *,
                 cause: _builtins.str,
                 message: _builtins.str,
                 name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str cause: Cause for an unavailability
        :param _builtins.str message: Human-readable description of the unavailability cause
        :param _builtins.str name: Name of the plan
        :param _builtins.str status: Status of the plan
        """
        pulumi.set(__self__, "cause", cause)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def cause(self) -> _builtins.str:
        """
        Cause for an unavailability
        """
        return pulumi.get(self, "cause")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Human-readable description of the unavailability cause
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the plan
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the plan
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRancherTargetSpecResult(dict):
    def __init__(__self__, *,
                 ip_restrictions: Sequence['outputs.GetRancherTargetSpecIpRestrictionResult'],
                 name: _builtins.str,
                 plan: _builtins.str,
                 version: _builtins.str):
        """
        :param Sequence['GetRancherTargetSpecIpRestrictionArgs'] ip_restrictions: List of allowed CIDR blocks for a managed Rancher service's IP restrictions. When empty, any IP is allowed
        :param _builtins.str name: Name of the managed Rancher service
        :param _builtins.str plan: Plan of the managed Rancher service. Available plans for an existing managed Rancher can be retrieved using GET /rancher/rancherID/capabilities/plan
        :param _builtins.str version: Version of the managed Rancher service. Available versions for an existing managed Rancher can be retrieved using GET /rancher/rancherID/capabilities/version
        """
        pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Sequence['outputs.GetRancherTargetSpecIpRestrictionResult']:
        """
        List of allowed CIDR blocks for a managed Rancher service's IP restrictions. When empty, any IP is allowed
        """
        return pulumi.get(self, "ip_restrictions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the managed Rancher service
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        Plan of the managed Rancher service. Available plans for an existing managed Rancher can be retrieved using GET /rancher/rancherID/capabilities/plan
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of the managed Rancher service. Available versions for an existing managed Rancher can be retrieved using GET /rancher/rancherID/capabilities/version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetRancherTargetSpecIpRestrictionResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 description: _builtins.str):
        """
        :param _builtins.str cidr_block: Allowed CIDR block (/subnet is optional, if unspecified then /32 will be used)
        :param _builtins.str description: Description of the allowed CIDR block
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        Allowed CIDR block (/subnet is optional, if unspecified then /32 will be used)
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the allowed CIDR block
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetRancherVersionVersionResult(dict):
    def __init__(__self__, *,
                 cause: _builtins.str,
                 changelog_url: _builtins.str,
                 message: _builtins.str,
                 name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str cause: Cause for an unavailability
        :param _builtins.str changelog_url: Changelog URL of the version
        :param _builtins.str message: Human-readable description of the unavailability cause
        :param _builtins.str name: Name of the version
        :param _builtins.str status: Status of the version
        """
        pulumi.set(__self__, "cause", cause)
        pulumi.set(__self__, "changelog_url", changelog_url)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def cause(self) -> _builtins.str:
        """
        Cause for an unavailability
        """
        return pulumi.get(self, "cause")

    @_builtins.property
    @pulumi.getter(name="changelogUrl")
    def changelog_url(self) -> _builtins.str:
        """
        Changelog URL of the version
        """
        return pulumi.get(self, "changelog_url")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Human-readable description of the unavailability cause
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the version
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the version
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRegionServiceResult(dict):
    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str endpoint: Endpoint URL
        :param _builtins.str name: The name of the region associated with the public cloud project.
        :param _builtins.str status: the status of the service
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        Endpoint URL
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the region associated with the public cloud project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        the status of the service
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetStorageEncryptionResult(dict):
    def __init__(__self__, *,
                 sse_algorithm: _builtins.str):
        """
        :param _builtins.str sse_algorithm: Encryption algorithm
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> _builtins.str:
        """
        Encryption algorithm
        """
        return pulumi.get(self, "sse_algorithm")


@pulumi.output_type
class GetStorageObjectResult(dict):
    def __init__(__self__, *,
                 etag: _builtins.str,
                 is_delete_marker: _builtins.bool,
                 is_latest: _builtins.bool,
                 key: _builtins.str,
                 last_modified: _builtins.str,
                 size: _builtins.float,
                 storage_class: _builtins.str,
                 version_id: _builtins.str):
        """
        :param _builtins.str etag: ETag
        :param _builtins.bool is_delete_marker: Whether this object is a delete marker
        :param _builtins.bool is_latest: Whether this is the latest version of the object
        :param _builtins.str key: Key
        :param _builtins.str last_modified: Last modification date
        :param _builtins.float size: Size (bytes)
        :param _builtins.str storage_class: Storage class
        :param _builtins.str version_id: Version ID of the object
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "is_delete_marker", is_delete_marker)
        pulumi.set(__self__, "is_latest", is_latest)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "last_modified", last_modified)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        ETag
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="isDeleteMarker")
    def is_delete_marker(self) -> _builtins.bool:
        """
        Whether this object is a delete marker
        """
        return pulumi.get(self, "is_delete_marker")

    @_builtins.property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> _builtins.bool:
        """
        Whether this is the latest version of the object
        """
        return pulumi.get(self, "is_latest")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> _builtins.str:
        """
        Last modification date
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.float:
        """
        Size (bytes)
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Storage class
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        Version ID of the object
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class GetStorageObjectsObjectResult(dict):
    def __init__(__self__, *,
                 etag: _builtins.str,
                 is_delete_marker: _builtins.bool,
                 is_latest: _builtins.bool,
                 key: _builtins.str,
                 last_modified: _builtins.str,
                 size: _builtins.float,
                 storage_class: _builtins.str,
                 version_id: _builtins.str):
        """
        :param _builtins.str etag: ETag
        :param _builtins.bool is_delete_marker: Whether this object is a delete marker
        :param _builtins.bool is_latest: Whether this is the latest version of the object
        :param _builtins.str key: Key
        :param _builtins.str last_modified: Last modification date
        :param _builtins.float size: Size (bytes)
        :param _builtins.str storage_class: Storage class
        :param _builtins.str version_id: Version ID of the object
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "is_delete_marker", is_delete_marker)
        pulumi.set(__self__, "is_latest", is_latest)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "last_modified", last_modified)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        ETag
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="isDeleteMarker")
    def is_delete_marker(self) -> _builtins.bool:
        """
        Whether this object is a delete marker
        """
        return pulumi.get(self, "is_delete_marker")

    @_builtins.property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> _builtins.bool:
        """
        Whether this is the latest version of the object
        """
        return pulumi.get(self, "is_latest")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> _builtins.str:
        """
        Last modification date
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.float:
        """
        Size (bytes)
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Storage class
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        Version ID of the object
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class GetStorageReplicationResult(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.GetStorageReplicationRuleResult']):
        """
        :param Sequence['GetStorageReplicationRuleArgs'] rules: Replication rules
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetStorageReplicationRuleResult']:
        """
        Replication rules
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class GetStorageReplicationRuleResult(dict):
    def __init__(__self__, *,
                 delete_marker_replication: _builtins.str,
                 destination: 'outputs.GetStorageReplicationRuleDestinationResult',
                 filter: 'outputs.GetStorageReplicationRuleFilterResult',
                 id: _builtins.str,
                 priority: _builtins.float,
                 status: _builtins.str):
        """
        :param _builtins.str delete_marker_replication: Delete marker replication
        :param 'GetStorageReplicationRuleDestinationArgs' destination: Rule destination configuration
        :param 'GetStorageReplicationRuleFilterArgs' filter: Rule filters
        :param _builtins.str id: Rule ID
        :param _builtins.float priority: Rule priority
        :param _builtins.str status: Rule status
        """
        pulumi.set(__self__, "delete_marker_replication", delete_marker_replication)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="deleteMarkerReplication")
    def delete_marker_replication(self) -> _builtins.str:
        """
        Delete marker replication
        """
        return pulumi.get(self, "delete_marker_replication")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> 'outputs.GetStorageReplicationRuleDestinationResult':
        """
        Rule destination configuration
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> 'outputs.GetStorageReplicationRuleFilterResult':
        """
        Rule filters
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Rule ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.float:
        """
        Rule priority
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Rule status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetStorageReplicationRuleDestinationResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 region: _builtins.str,
                 storage_class: _builtins.str):
        """
        :param _builtins.str name: Destination bucket name
        :param _builtins.str region: Destination region, can be null if destination bucket has been deleted
        :param _builtins.str storage_class: Destination storage class
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Destination bucket name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Destination region, can be null if destination bucket has been deleted
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Destination storage class
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetStorageReplicationRuleFilterResult(dict):
    def __init__(__self__, *,
                 prefix: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str prefix: Prefix filter
        :param Mapping[str, _builtins.str] tags: Tags filter
        """
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        Prefix filter
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags filter
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetStorageVersioningResult(dict):
    def __init__(__self__, *,
                 status: _builtins.str):
        """
        :param _builtins.str status: Versioning status
        """
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Versioning status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetStoragesContainerResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 encryption: 'outputs.GetStoragesContainerEncryptionResult',
                 name: _builtins.str,
                 objects: Sequence['outputs.GetStoragesContainerObjectResult'],
                 objects_count: _builtins.float,
                 objects_size: _builtins.float,
                 owner_id: _builtins.float,
                 region: _builtins.str,
                 replication: 'outputs.GetStoragesContainerReplicationResult',
                 tags: Mapping[str, _builtins.str],
                 versioning: 'outputs.GetStoragesContainerVersioningResult',
                 virtual_host: _builtins.str):
        """
        :param _builtins.str created_at: The date and timestamp when the resource was created
        :param 'GetStoragesContainerEncryptionArgs' encryption: Encryption configuration
        :param _builtins.str name: Container name
        :param Sequence['GetStoragesContainerObjectArgs'] objects: Container objects
        :param _builtins.float objects_count: Container total objects count
        :param _builtins.float objects_size: Container total objects size (bytes)
        :param _builtins.float owner_id: Container owner user ID
        :param _builtins.str region: Container region
        :param 'GetStoragesContainerReplicationArgs' replication: Replication configuration
        :param Mapping[str, _builtins.str] tags: Container tags
        :param 'GetStoragesContainerVersioningArgs' versioning: Versioning configuration
        :param _builtins.str virtual_host: Container virtual host
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "encryption", encryption)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "objects", objects)
        pulumi.set(__self__, "objects_count", objects_count)
        pulumi.set(__self__, "objects_size", objects_size)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "replication", replication)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "versioning", versioning)
        pulumi.set(__self__, "virtual_host", virtual_host)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and timestamp when the resource was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> 'outputs.GetStoragesContainerEncryptionResult':
        """
        Encryption configuration
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Container name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def objects(self) -> Sequence['outputs.GetStoragesContainerObjectResult']:
        """
        Container objects
        """
        return pulumi.get(self, "objects")

    @_builtins.property
    @pulumi.getter(name="objectsCount")
    def objects_count(self) -> _builtins.float:
        """
        Container total objects count
        """
        return pulumi.get(self, "objects_count")

    @_builtins.property
    @pulumi.getter(name="objectsSize")
    def objects_size(self) -> _builtins.float:
        """
        Container total objects size (bytes)
        """
        return pulumi.get(self, "objects_size")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.float:
        """
        Container owner user ID
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Container region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def replication(self) -> 'outputs.GetStoragesContainerReplicationResult':
        """
        Replication configuration
        """
        return pulumi.get(self, "replication")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Container tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> 'outputs.GetStoragesContainerVersioningResult':
        """
        Versioning configuration
        """
        return pulumi.get(self, "versioning")

    @_builtins.property
    @pulumi.getter(name="virtualHost")
    def virtual_host(self) -> _builtins.str:
        """
        Container virtual host
        """
        return pulumi.get(self, "virtual_host")


@pulumi.output_type
class GetStoragesContainerEncryptionResult(dict):
    def __init__(__self__, *,
                 sse_algorithm: _builtins.str):
        """
        :param _builtins.str sse_algorithm: Encryption algorithm
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> _builtins.str:
        """
        Encryption algorithm
        """
        return pulumi.get(self, "sse_algorithm")


@pulumi.output_type
class GetStoragesContainerObjectResult(dict):
    def __init__(__self__, *,
                 etag: _builtins.str,
                 is_delete_marker: _builtins.bool,
                 is_latest: _builtins.bool,
                 key: _builtins.str,
                 last_modified: _builtins.str,
                 size: _builtins.float,
                 storage_class: _builtins.str,
                 version_id: _builtins.str):
        """
        :param _builtins.str etag: ETag
        :param _builtins.bool is_delete_marker: Whether this object is a delete marker
        :param _builtins.bool is_latest: Whether this is the latest version of the object
        :param _builtins.str key: Key
        :param _builtins.str last_modified: Last modification date
        :param _builtins.float size: Size (bytes)
        :param _builtins.str storage_class: Storage class
        :param _builtins.str version_id: Version ID of the object
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "is_delete_marker", is_delete_marker)
        pulumi.set(__self__, "is_latest", is_latest)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "last_modified", last_modified)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        ETag
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="isDeleteMarker")
    def is_delete_marker(self) -> _builtins.bool:
        """
        Whether this object is a delete marker
        """
        return pulumi.get(self, "is_delete_marker")

    @_builtins.property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> _builtins.bool:
        """
        Whether this is the latest version of the object
        """
        return pulumi.get(self, "is_latest")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> _builtins.str:
        """
        Last modification date
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.float:
        """
        Size (bytes)
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Storage class
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        Version ID of the object
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class GetStoragesContainerReplicationResult(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.GetStoragesContainerReplicationRuleResult']):
        """
        :param Sequence['GetStoragesContainerReplicationRuleArgs'] rules: Replication rules
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetStoragesContainerReplicationRuleResult']:
        """
        Replication rules
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class GetStoragesContainerReplicationRuleResult(dict):
    def __init__(__self__, *,
                 delete_marker_replication: _builtins.str,
                 destination: 'outputs.GetStoragesContainerReplicationRuleDestinationResult',
                 filter: 'outputs.GetStoragesContainerReplicationRuleFilterResult',
                 id: _builtins.str,
                 priority: _builtins.float,
                 status: _builtins.str):
        """
        :param _builtins.str delete_marker_replication: Delete marker replication
        :param 'GetStoragesContainerReplicationRuleDestinationArgs' destination: Rule destination configuration
        :param 'GetStoragesContainerReplicationRuleFilterArgs' filter: Rule filters
        :param _builtins.str id: Rule ID
        :param _builtins.float priority: Rule priority
        :param _builtins.str status: Rule status
        """
        pulumi.set(__self__, "delete_marker_replication", delete_marker_replication)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="deleteMarkerReplication")
    def delete_marker_replication(self) -> _builtins.str:
        """
        Delete marker replication
        """
        return pulumi.get(self, "delete_marker_replication")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> 'outputs.GetStoragesContainerReplicationRuleDestinationResult':
        """
        Rule destination configuration
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> 'outputs.GetStoragesContainerReplicationRuleFilterResult':
        """
        Rule filters
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Rule ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.float:
        """
        Rule priority
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Rule status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetStoragesContainerReplicationRuleDestinationResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 region: _builtins.str,
                 storage_class: _builtins.str):
        """
        :param _builtins.str name: Destination bucket name
        :param _builtins.str region: Destination region, can be null if destination bucket has been deleted
        :param _builtins.str storage_class: Destination storage class
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Destination bucket name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Destination region, can be null if destination bucket has been deleted
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Destination storage class
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetStoragesContainerReplicationRuleFilterResult(dict):
    def __init__(__self__, *,
                 prefix: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str prefix: Prefix filter
        :param Mapping[str, _builtins.str] tags: Tags filter
        """
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        Prefix filter
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags filter
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetStoragesContainerVersioningResult(dict):
    def __init__(__self__, *,
                 status: _builtins.str):
        """
        :param _builtins.str status: Versioning status
        """
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Versioning status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetUserRoleResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 permissions: Sequence[_builtins.str]):
        """
        :param _builtins.str description: description of the role
        :param _builtins.str id: id of the role
        :param _builtins.str name: name of the role
        :param Sequence[_builtins.str] permissions: list of permissions associated with the role
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        description of the role
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        id of the role
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name of the role
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence[_builtins.str]:
        """
        list of permissions associated with the role
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 creation_date: _builtins.str,
                 description: _builtins.str,
                 roles: Sequence['outputs.GetUsersUserRoleResult'],
                 status: _builtins.str,
                 user_id: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str creation_date: the date the user was created.
        :param _builtins.str description: description of the role
        :param Sequence['GetUsersUserRoleArgs'] roles: A list of roles associated with the user.
        :param _builtins.str status: the status of the user. should be normally set to 'ok'.
        :param _builtins.str user_id: The ID of a public cloud project's user.
        :param _builtins.str username: the username generated for the user. This username can be used with the Openstack API.
        """
        pulumi.set(__self__, "creation_date", creation_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        the date the user was created.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        description of the role
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetUsersUserRoleResult']:
        """
        A list of roles associated with the user.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        the status of the user. should be normally set to 'ok'.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The ID of a public cloud project's user.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        the username generated for the user. This username can be used with the Openstack API.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetUsersUserRoleResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 permissions: Sequence[_builtins.str]):
        """
        :param _builtins.str description: description of the role
        :param _builtins.str id: id of the role
        :param _builtins.str name: name of the role
        :param Sequence[_builtins.str] permissions: list of permissions associated with the role
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        description of the role
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        id of the role
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name of the role
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence[_builtins.str]:
        """
        list of permissions associated with the role
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GetVolumesVolumeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 size: _builtins.float):
        """
        :param _builtins.str id: The id of the volume
        :param _builtins.str name: The name of the volume
        :param _builtins.float size: The size of the volume
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the volume
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the volume
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.float:
        """
        The size of the volume
        """
        return pulumi.get(self, "size")


