# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 openstack_rc: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password_reset: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] description: A description associated with the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] openstack_rc: a convenient map representing an openstack_rc file. Note: no password nor sensitive token is set in this map.
        :param pulumi.Input[_builtins.str] password_reset: Arbitrary string to change to trigger a password update
        :param pulumi.Input[_builtins.str] role_name: The name of a role. See `role_names`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_names: A list of role names. Values can be:
               - administrator
               - ai_training_operator
               - ai_training_read
               - authentication
               - backup_operator
               - compute_operator
               - image_operator
               - infrastructure_supervisor
               - key-manager_operator
               - key-manager_read
               - load-balancer_operator
               - network_operator
               - network_security_operator
               - objectstore_operator
               - volume_operator
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if openstack_rc is not None:
            pulumi.set(__self__, "openstack_rc", openstack_rc)
        if password_reset is not None:
            pulumi.set(__self__, "password_reset", password_reset)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_names is not None:
            pulumi.set(__self__, "role_names", role_names)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="openstackRc")
    def openstack_rc(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        a convenient map representing an openstack_rc file. Note: no password nor sensitive token is set in this map.
        """
        return pulumi.get(self, "openstack_rc")

    @openstack_rc.setter
    def openstack_rc(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "openstack_rc", value)

    @_builtins.property
    @pulumi.getter(name="passwordReset")
    def password_reset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary string to change to trigger a password update
        """
        return pulumi.get(self, "password_reset")

    @password_reset.setter
    def password_reset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_reset", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a role. See `role_names`.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of role names. Values can be:
        - administrator
        - ai_training_operator
        - ai_training_read
        - authentication
        - backup_operator
        - compute_operator
        - image_operator
        - infrastructure_supervisor
        - key-manager_operator
        - key-manager_read
        - load-balancer_operator
        - network_operator
        - network_security_operator
        - objectstore_operator
        - volume_operator
        """
        return pulumi.get(self, "role_names")

    @role_names.setter
    def role_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "role_names", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 creation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 openstack_rc: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_reset: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[_builtins.str] creation_date: the date the user was created.
        :param pulumi.Input[_builtins.str] description: A description associated with the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] openstack_rc: a convenient map representing an openstack_rc file. Note: no password nor sensitive token is set in this map.
        :param pulumi.Input[_builtins.str] password: (Sensitive) the password generated for the user. The password can be used with the Openstack API. This attribute is sensitive and will only be retrieve once during creation.
        :param pulumi.Input[_builtins.str] password_reset: Arbitrary string to change to trigger a password update
        :param pulumi.Input[_builtins.str] role_name: The name of a role. See `role_names`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_names: A list of role names. Values can be:
               - administrator
               - ai_training_operator
               - ai_training_read
               - authentication
               - backup_operator
               - compute_operator
               - image_operator
               - infrastructure_supervisor
               - key-manager_operator
               - key-manager_read
               - load-balancer_operator
               - network_operator
               - network_security_operator
               - objectstore_operator
               - volume_operator
        :param pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]] roles: A list of roles associated with the user.
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[_builtins.str] status: the status of the user. should be normally set to 'ok'.
        :param pulumi.Input[_builtins.str] username: the username generated for the user. This username can be used with the Openstack API.
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if openstack_rc is not None:
            pulumi.set(__self__, "openstack_rc", openstack_rc)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_reset is not None:
            pulumi.set(__self__, "password_reset", password_reset)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_names is not None:
            pulumi.set(__self__, "role_names", role_names)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the date the user was created.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="openstackRc")
    def openstack_rc(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        a convenient map representing an openstack_rc file. Note: no password nor sensitive token is set in this map.
        """
        return pulumi.get(self, "openstack_rc")

    @openstack_rc.setter
    def openstack_rc(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "openstack_rc", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Sensitive) the password generated for the user. The password can be used with the Openstack API. This attribute is sensitive and will only be retrieve once during creation.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordReset")
    def password_reset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary string to change to trigger a password update
        """
        return pulumi.get(self, "password_reset")

    @password_reset.setter
    def password_reset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_reset", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a role. See `role_names`.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of role names. Values can be:
        - administrator
        - ai_training_operator
        - ai_training_read
        - authentication
        - backup_operator
        - compute_operator
        - image_operator
        - infrastructure_supervisor
        - key-manager_operator
        - key-manager_read
        - load-balancer_operator
        - network_operator
        - network_security_operator
        - objectstore_operator
        - volume_operator
        """
        return pulumi.get(self, "role_names")

    @role_names.setter
    def role_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "role_names", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]]]:
        """
        A list of roles associated with the user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the status of the user. should be normally set to 'ok'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the username generated for the user. This username can be used with the Openstack API.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("ovh:CloudProject/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 openstack_rc: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password_reset: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a User resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description associated with the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] openstack_rc: a convenient map representing an openstack_rc file. Note: no password nor sensitive token is set in this map.
        :param pulumi.Input[_builtins.str] password_reset: Arbitrary string to change to trigger a password update
        :param pulumi.Input[_builtins.str] role_name: The name of a role. See `role_names`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_names: A list of role names. Values can be:
               - administrator
               - ai_training_operator
               - ai_training_read
               - authentication
               - backup_operator
               - compute_operator
               - image_operator
               - infrastructure_supervisor
               - key-manager_operator
               - key-manager_read
               - load-balancer_operator
               - network_operator
               - network_security_operator
               - objectstore_operator
               - volume_operator
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UserArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a User resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 openstack_rc: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password_reset: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["openstack_rc"] = openstack_rc
            __props__.__dict__["password_reset"] = password_reset
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["role_names"] = role_names
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["password"] = None
            __props__.__dict__["roles"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["username"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'ovh:CloudProject/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_date: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            openstack_rc: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            password_reset: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserRoleArgs', 'UserRoleArgsDict']]]]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_date: the date the user was created.
        :param pulumi.Input[_builtins.str] description: A description associated with the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] openstack_rc: a convenient map representing an openstack_rc file. Note: no password nor sensitive token is set in this map.
        :param pulumi.Input[_builtins.str] password: (Sensitive) the password generated for the user. The password can be used with the Openstack API. This attribute is sensitive and will only be retrieve once during creation.
        :param pulumi.Input[_builtins.str] password_reset: Arbitrary string to change to trigger a password update
        :param pulumi.Input[_builtins.str] role_name: The name of a role. See `role_names`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_names: A list of role names. Values can be:
               - administrator
               - ai_training_operator
               - ai_training_read
               - authentication
               - backup_operator
               - compute_operator
               - image_operator
               - infrastructure_supervisor
               - key-manager_operator
               - key-manager_read
               - load-balancer_operator
               - network_operator
               - network_security_operator
               - objectstore_operator
               - volume_operator
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserRoleArgs', 'UserRoleArgsDict']]]] roles: A list of roles associated with the user.
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[_builtins.str] status: the status of the user. should be normally set to 'ok'.
        :param pulumi.Input[_builtins.str] username: the username generated for the user. This username can be used with the Openstack API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["description"] = description
        __props__.__dict__["openstack_rc"] = openstack_rc
        __props__.__dict__["password"] = password
        __props__.__dict__["password_reset"] = password_reset
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["role_names"] = role_names
        __props__.__dict__["roles"] = roles
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["username"] = username
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[_builtins.str]:
        """
        the date the user was created.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="openstackRc")
    def openstack_rc(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        a convenient map representing an openstack_rc file. Note: no password nor sensitive token is set in this map.
        """
        return pulumi.get(self, "openstack_rc")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        (Sensitive) the password generated for the user. The password can be used with the Openstack API. This attribute is sensitive and will only be retrieve once during creation.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordReset")
    def password_reset(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Arbitrary string to change to trigger a password update
        """
        return pulumi.get(self, "password_reset")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of a role. See `role_names`.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of role names. Values can be:
        - administrator
        - ai_training_operator
        - ai_training_read
        - authentication
        - backup_operator
        - compute_operator
        - image_operator
        - infrastructure_supervisor
        - key-manager_operator
        - key-manager_read
        - load-balancer_operator
        - network_operator
        - network_security_operator
        - objectstore_operator
        - volume_operator
        """
        return pulumi.get(self, "role_names")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence['outputs.UserRole']]:
        """
        A list of roles associated with the user.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        the status of the user. should be normally set to 'ok'.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        the username generated for the user. This username can be used with the Openstack API.
        """
        return pulumi.get(self, "username")

