# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 region_name: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[_builtins.str] region_name: Required. A valid OVHcloud public cloud region name in which the volume will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] service_name: Required. The id of the public cloud project. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] description: A description of the volume
        :param pulumi.Input[_builtins.str] image_id: Image ID
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.str] name: Name of the volume
        :param pulumi.Input[_builtins.float] size: Size (GB) of the volume
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID
        :param pulumi.Input[_builtins.str] type: Type of the volume **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] volume_id: Volume ID
        """
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "service_name", service_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[_builtins.str]:
        """
        Required. A valid OVHcloud public cloud region name in which the volume will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The id of the public cloud project. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the volume
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image ID
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the volume
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Size (GB) of the volume
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot ID
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the volume **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume ID
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 completed_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 progress: Optional[pulumi.Input[_builtins.float]] = None,
                 region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 started_at: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_operations: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSubOperationArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[_builtins.str] action: The action of the operation
        :param pulumi.Input[_builtins.str] completed_at: The completed date of the operation
        :param pulumi.Input[_builtins.str] created_at: The creation date of the operation
        :param pulumi.Input[_builtins.str] description: A description of the volume
        :param pulumi.Input[_builtins.str] image_id: Image ID
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.str] name: Name of the volume
        :param pulumi.Input[_builtins.float] progress: Volume status
        :param pulumi.Input[_builtins.str] region_name: Required. A valid OVHcloud public cloud region name in which the volume will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: List of regions
        :param pulumi.Input[_builtins.str] resource_id: Id of the resource
        :param pulumi.Input[_builtins.str] service_name: Required. The id of the public cloud project. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.float] size: Size (GB) of the volume
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID
        :param pulumi.Input[_builtins.str] started_at: Datetime of the operation creation
        :param pulumi.Input[_builtins.str] status: Volume status
        :param pulumi.Input[Sequence[pulumi.Input['VolumeSubOperationArgs']]] sub_operations: Sub-operations of the operation
        :param pulumi.Input[_builtins.str] type: Type of the volume **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] volume_id: Volume ID
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if completed_at is not None:
            pulumi.set(__self__, "completed_at", completed_at)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if started_at is not None:
            pulumi.set(__self__, "started_at", started_at)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_operations is not None:
            pulumi.set(__self__, "sub_operations", sub_operations)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action of the operation
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="completedAt")
    def completed_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The completed date of the operation
        """
        return pulumi.get(self, "completed_at")

    @completed_at.setter
    def completed_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "completed_at", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation date of the operation
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the volume
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image ID
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the volume
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Volume status
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "progress", value)

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. A valid OVHcloud public cloud region name in which the volume will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_name", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of regions
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the resource
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The id of the public cloud project. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Size (GB) of the volume
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snapshot ID
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="startedAt")
    def started_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Datetime of the operation creation
        """
        return pulumi.get(self, "started_at")

    @started_at.setter
    def started_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "started_at", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subOperations")
    def sub_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSubOperationArgs']]]]:
        """
        Sub-operations of the operation
        """
        return pulumi.get(self, "sub_operations")

    @sub_operations.setter
    def sub_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSubOperationArgs']]]]):
        pulumi.set(self, "sub_operations", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the volume **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume ID
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)


@pulumi.type_token("ovh:CloudProject/volume:Volume")
class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create volume in a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        vol = ovh.cloudproject.Volume("vol",
            region_name="xxx",
            service_name="yyyyy",
            description="Terraform volume",
            name="terrformName",
            size=15,
            type="classic")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the volume
        :param pulumi.Input[_builtins.str] image_id: Image ID
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.str] name: Name of the volume
        :param pulumi.Input[_builtins.str] region_name: Required. A valid OVHcloud public cloud region name in which the volume will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] service_name: Required. The id of the public cloud project. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.float] size: Size (GB) of the volume
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID
        :param pulumi.Input[_builtins.str] type: Type of the volume **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] volume_id: Volume ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create volume in a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        vol = ovh.cloudproject.Volume("vol",
            region_name="xxx",
            service_name="yyyyy",
            description="Terraform volume",
            name="terrformName",
            size=15,
            type="classic")
        ```

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.float]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if region_name is None and not opts.urn:
                raise TypeError("Missing required property 'region_name'")
            __props__.__dict__["region_name"] = region_name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["type"] = type
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["action"] = None
            __props__.__dict__["completed_at"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["progress"] = None
            __props__.__dict__["regions"] = None
            __props__.__dict__["resource_id"] = None
            __props__.__dict__["started_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["sub_operations"] = None
        super(Volume, __self__).__init__(
            'ovh:CloudProject/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            completed_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            progress: Optional[pulumi.Input[_builtins.float]] = None,
            region_name: Optional[pulumi.Input[_builtins.str]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.float]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            started_at: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            sub_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeSubOperationArgs', 'VolumeSubOperationArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            volume_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The action of the operation
        :param pulumi.Input[_builtins.str] completed_at: The completed date of the operation
        :param pulumi.Input[_builtins.str] created_at: The creation date of the operation
        :param pulumi.Input[_builtins.str] description: A description of the volume
        :param pulumi.Input[_builtins.str] image_id: Image ID
        :param pulumi.Input[_builtins.str] instance_id: Instance ID
        :param pulumi.Input[_builtins.str] name: Name of the volume
        :param pulumi.Input[_builtins.float] progress: Volume status
        :param pulumi.Input[_builtins.str] region_name: Required. A valid OVHcloud public cloud region name in which the volume will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: List of regions
        :param pulumi.Input[_builtins.str] resource_id: Id of the resource
        :param pulumi.Input[_builtins.str] service_name: Required. The id of the public cloud project. **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.float] size: Size (GB) of the volume
        :param pulumi.Input[_builtins.str] snapshot_id: Snapshot ID
        :param pulumi.Input[_builtins.str] started_at: Datetime of the operation creation
        :param pulumi.Input[_builtins.str] status: Volume status
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeSubOperationArgs', 'VolumeSubOperationArgsDict']]]] sub_operations: Sub-operations of the operation
        :param pulumi.Input[_builtins.str] type: Type of the volume **Changing this value recreates the resource.**
        :param pulumi.Input[_builtins.str] volume_id: Volume ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["action"] = action
        __props__.__dict__["completed_at"] = completed_at
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["progress"] = progress
        __props__.__dict__["region_name"] = region_name
        __props__.__dict__["regions"] = regions
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["started_at"] = started_at
        __props__.__dict__["status"] = status
        __props__.__dict__["sub_operations"] = sub_operations
        __props__.__dict__["type"] = type
        __props__.__dict__["volume_id"] = volume_id
        return Volume(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        The action of the operation
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="completedAt")
    def completed_at(self) -> pulumi.Output[_builtins.str]:
        """
        The completed date of the operation
        """
        return pulumi.get(self, "completed_at")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation date of the operation
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A description of the volume
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        Image ID
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the volume
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def progress(self) -> pulumi.Output[_builtins.float]:
        """
        Volume status
        """
        return pulumi.get(self, "progress")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Output[_builtins.str]:
        """
        Required. A valid OVHcloud public cloud region name in which the volume will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of regions
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the resource
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The id of the public cloud project. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.float]:
        """
        Size (GB) of the volume
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[_builtins.str]:
        """
        Snapshot ID
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="startedAt")
    def started_at(self) -> pulumi.Output[_builtins.str]:
        """
        Datetime of the operation creation
        """
        return pulumi.get(self, "started_at")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Volume status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subOperations")
    def sub_operations(self) -> pulumi.Output[Sequence['outputs.VolumeSubOperation']]:
        """
        Sub-operations of the operation
        """
        return pulumi.get(self, "sub_operations")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the volume **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        Volume ID
        """
        return pulumi.get(self, "volume_id")

