# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKafkaUserAccessResult',
    'AwaitableGetKafkaUserAccessResult',
    'get_kafka_user_access',
    'get_kafka_user_access_output',
]

@pulumi.output_type
class GetKafkaUserAccessResult:
    """
    A collection of values returned by getKafkaUserAccess.
    """
    def __init__(__self__, cert=None, cluster_id=None, id=None, key=None, service_name=None, user_id=None):
        if cert and not isinstance(cert, str):
            raise TypeError("Expected argument 'cert' to be a str")
        pulumi.set(__self__, "cert", cert)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> _builtins.str:
        """
        User cert.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        (Sensitive) User key for the cert.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetKafkaUserAccessResult(GetKafkaUserAccessResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaUserAccessResult(
            cert=self.cert,
            cluster_id=self.cluster_id,
            id=self.id,
            key=self.key,
            service_name=self.service_name,
            user_id=self.user_id)


def get_kafka_user_access(cluster_id: Optional[_builtins.str] = None,
                          service_name: Optional[_builtins.str] = None,
                          user_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaUserAccessResult:
    """
    Use this data source to get information about user acces of a kafka cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    access = ovh.CloudProjectDatabase.get_kafka_user_access(service_name="XXX",
        cluster_id="YYY",
        user_id="ZZZ")
    pulumi.export("accessCert", access.cert)
    ```


    :param _builtins.str cluster_id: Cluster ID
    :param _builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    :param _builtins.str user_id: User ID
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['serviceName'] = service_name
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProjectDatabase/getKafkaUserAccess:getKafkaUserAccess', __args__, opts=opts, typ=GetKafkaUserAccessResult).value

    return AwaitableGetKafkaUserAccessResult(
        cert=pulumi.get(__ret__, 'cert'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        service_name=pulumi.get(__ret__, 'service_name'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_kafka_user_access_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKafkaUserAccessResult]:
    """
    Use this data source to get information about user acces of a kafka cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    access = ovh.CloudProjectDatabase.get_kafka_user_access(service_name="XXX",
        cluster_id="YYY",
        user_id="ZZZ")
    pulumi.export("accessCert", access.cert)
    ```


    :param _builtins.str cluster_id: Cluster ID
    :param _builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    :param _builtins.str user_id: User ID
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['serviceName'] = service_name
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProjectDatabase/getKafkaUserAccess:getKafkaUserAccess', __args__, opts=opts, typ=GetKafkaUserAccessResult)
    return __ret__.apply(lambda __response__: GetKafkaUserAccessResult(
        cert=pulumi.get(__response__, 'cert'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        service_name=pulumi.get(__response__, 'service_name'),
        user_id=pulumi.get(__response__, 'user_id')))
