# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['M3DbNamespaceArgs', 'M3DbNamespace']

@pulumi.input_type
class M3DbNamespaceArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 resolution: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_block_data_expiration_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_block_size_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_buffer_future_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_buffer_past_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 writes_to_commit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a M3DbNamespace resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID.
        :param pulumi.Input[_builtins.str] resolution: Resolution for an aggregated namespace. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] name: Name of the namespace. A namespace named "default" is mapped with already created default namespace instead of creating a new namespace.
        :param pulumi.Input[_builtins.str] retention_block_data_expiration_duration: Controls how long we wait before expiring stale data. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_block_size_duration: Controls how long to keep a block in memory before flushing to a fileset on disk. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_buffer_future_duration: Controls how far into the future writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_buffer_past_duration: Controls how far into the past writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_period_duration: Controls the duration of time that M3DB will retain data for the namespace. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[_builtins.bool] snapshot_enabled: Defines whether M3DB will create snapshot files for this namespace.
        :param pulumi.Input[_builtins.bool] writes_to_commit_log_enabled: Defines whether M3DB will include writes to this namespace in the commit log.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "resolution", resolution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_block_data_expiration_duration is not None:
            pulumi.set(__self__, "retention_block_data_expiration_duration", retention_block_data_expiration_duration)
        if retention_block_size_duration is not None:
            pulumi.set(__self__, "retention_block_size_duration", retention_block_size_duration)
        if retention_buffer_future_duration is not None:
            pulumi.set(__self__, "retention_buffer_future_duration", retention_buffer_future_duration)
        if retention_buffer_past_duration is not None:
            pulumi.set(__self__, "retention_buffer_past_duration", retention_buffer_past_duration)
        if retention_period_duration is not None:
            pulumi.set(__self__, "retention_period_duration", retention_period_duration)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if snapshot_enabled is not None:
            pulumi.set(__self__, "snapshot_enabled", snapshot_enabled)
        if writes_to_commit_log_enabled is not None:
            pulumi.set(__self__, "writes_to_commit_log_enabled", writes_to_commit_log_enabled)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def resolution(self) -> pulumi.Input[_builtins.str]:
        """
        Resolution for an aggregated namespace. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resolution", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the namespace. A namespace named "default" is mapped with already created default namespace instead of creating a new namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retentionBlockDataExpirationDuration")
    def retention_block_data_expiration_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how long we wait before expiring stale data. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_block_data_expiration_duration")

    @retention_block_data_expiration_duration.setter
    def retention_block_data_expiration_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_block_data_expiration_duration", value)

    @_builtins.property
    @pulumi.getter(name="retentionBlockSizeDuration")
    def retention_block_size_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how long to keep a block in memory before flushing to a fileset on disk. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_block_size_duration")

    @retention_block_size_duration.setter
    def retention_block_size_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_block_size_duration", value)

    @_builtins.property
    @pulumi.getter(name="retentionBufferFutureDuration")
    def retention_buffer_future_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how far into the future writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_buffer_future_duration")

    @retention_buffer_future_duration.setter
    def retention_buffer_future_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_buffer_future_duration", value)

    @_builtins.property
    @pulumi.getter(name="retentionBufferPastDuration")
    def retention_buffer_past_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how far into the past writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_buffer_past_duration")

    @retention_buffer_past_duration.setter
    def retention_buffer_past_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_buffer_past_duration", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriodDuration")
    def retention_period_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the duration of time that M3DB will retain data for the namespace. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_period_duration")

    @retention_period_duration.setter
    def retention_period_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_period_duration", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotEnabled")
    def snapshot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether M3DB will create snapshot files for this namespace.
        """
        return pulumi.get(self, "snapshot_enabled")

    @snapshot_enabled.setter
    def snapshot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "snapshot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="writesToCommitLogEnabled")
    def writes_to_commit_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether M3DB will include writes to this namespace in the commit log.
        """
        return pulumi.get(self, "writes_to_commit_log_enabled")

    @writes_to_commit_log_enabled.setter
    def writes_to_commit_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "writes_to_commit_log_enabled", value)


@pulumi.input_type
class _M3DbNamespaceState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_block_data_expiration_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_block_size_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_buffer_future_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_buffer_past_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 writes_to_commit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering M3DbNamespace resources.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID.
        :param pulumi.Input[_builtins.str] name: Name of the namespace. A namespace named "default" is mapped with already created default namespace instead of creating a new namespace.
        :param pulumi.Input[_builtins.str] resolution: Resolution for an aggregated namespace. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_block_data_expiration_duration: Controls how long we wait before expiring stale data. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_block_size_duration: Controls how long to keep a block in memory before flushing to a fileset on disk. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_buffer_future_duration: Controls how far into the future writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_buffer_past_duration: Controls how far into the past writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_period_duration: Controls the duration of time that M3DB will retain data for the namespace. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[_builtins.bool] snapshot_enabled: Defines whether M3DB will create snapshot files for this namespace.
        :param pulumi.Input[_builtins.str] type: Type of namespace.
        :param pulumi.Input[_builtins.bool] writes_to_commit_log_enabled: Defines whether M3DB will include writes to this namespace in the commit log.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if retention_block_data_expiration_duration is not None:
            pulumi.set(__self__, "retention_block_data_expiration_duration", retention_block_data_expiration_duration)
        if retention_block_size_duration is not None:
            pulumi.set(__self__, "retention_block_size_duration", retention_block_size_duration)
        if retention_buffer_future_duration is not None:
            pulumi.set(__self__, "retention_buffer_future_duration", retention_buffer_future_duration)
        if retention_buffer_past_duration is not None:
            pulumi.set(__self__, "retention_buffer_past_duration", retention_buffer_past_duration)
        if retention_period_duration is not None:
            pulumi.set(__self__, "retention_period_duration", retention_period_duration)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if snapshot_enabled is not None:
            pulumi.set(__self__, "snapshot_enabled", snapshot_enabled)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if writes_to_commit_log_enabled is not None:
            pulumi.set(__self__, "writes_to_commit_log_enabled", writes_to_commit_log_enabled)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the namespace. A namespace named "default" is mapped with already created default namespace instead of creating a new namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resolution for an aggregated namespace. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resolution", value)

    @_builtins.property
    @pulumi.getter(name="retentionBlockDataExpirationDuration")
    def retention_block_data_expiration_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how long we wait before expiring stale data. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_block_data_expiration_duration")

    @retention_block_data_expiration_duration.setter
    def retention_block_data_expiration_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_block_data_expiration_duration", value)

    @_builtins.property
    @pulumi.getter(name="retentionBlockSizeDuration")
    def retention_block_size_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how long to keep a block in memory before flushing to a fileset on disk. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_block_size_duration")

    @retention_block_size_duration.setter
    def retention_block_size_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_block_size_duration", value)

    @_builtins.property
    @pulumi.getter(name="retentionBufferFutureDuration")
    def retention_buffer_future_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how far into the future writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_buffer_future_duration")

    @retention_buffer_future_duration.setter
    def retention_buffer_future_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_buffer_future_duration", value)

    @_builtins.property
    @pulumi.getter(name="retentionBufferPastDuration")
    def retention_buffer_past_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how far into the past writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_buffer_past_duration")

    @retention_buffer_past_duration.setter
    def retention_buffer_past_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_buffer_past_duration", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriodDuration")
    def retention_period_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the duration of time that M3DB will retain data for the namespace. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_period_duration")

    @retention_period_duration.setter
    def retention_period_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_period_duration", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotEnabled")
    def snapshot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether M3DB will create snapshot files for this namespace.
        """
        return pulumi.get(self, "snapshot_enabled")

    @snapshot_enabled.setter
    def snapshot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "snapshot_enabled", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of namespace.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="writesToCommitLogEnabled")
    def writes_to_commit_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether M3DB will include writes to this namespace in the commit log.
        """
        return pulumi.get(self, "writes_to_commit_log_enabled")

    @writes_to_commit_log_enabled.setter
    def writes_to_commit_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "writes_to_commit_log_enabled", value)


@pulumi.type_token("ovh:CloudProjectDatabase/m3DbNamespace:M3DbNamespace")
class M3DbNamespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_block_data_expiration_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_block_size_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_buffer_future_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_buffer_past_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 writes_to_commit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Creates a namespace for a M3DB cluster associated with a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        m3db = ovh.CloudProjectDatabase.get_database(service_name="XXX",
            engine="m3db",
            id="ZZZ")
        namespace = ovh.cloudprojectdatabase.M3DbNamespace("namespace",
            service_name=m3db.service_name,
            cluster_id=m3db.id,
            name="mynamespace",
            resolution="P2D",
            retention_period_duration="PT48H")
        ```

        ## Import

        OVHcloud Managed M3DB clusters namespaces can be imported using the `service_name`, `cluster_id` and `id` of the namespace, separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:CloudProjectDatabase/m3DbNamespace:M3DbNamespace my_namespace service_name/cluster_id/id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID.
        :param pulumi.Input[_builtins.str] name: Name of the namespace. A namespace named "default" is mapped with already created default namespace instead of creating a new namespace.
        :param pulumi.Input[_builtins.str] resolution: Resolution for an aggregated namespace. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_block_data_expiration_duration: Controls how long we wait before expiring stale data. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_block_size_duration: Controls how long to keep a block in memory before flushing to a fileset on disk. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_buffer_future_duration: Controls how far into the future writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_buffer_past_duration: Controls how far into the past writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_period_duration: Controls the duration of time that M3DB will retain data for the namespace. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[_builtins.bool] snapshot_enabled: Defines whether M3DB will create snapshot files for this namespace.
        :param pulumi.Input[_builtins.bool] writes_to_commit_log_enabled: Defines whether M3DB will include writes to this namespace in the commit log.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: M3DbNamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a namespace for a M3DB cluster associated with a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        m3db = ovh.CloudProjectDatabase.get_database(service_name="XXX",
            engine="m3db",
            id="ZZZ")
        namespace = ovh.cloudprojectdatabase.M3DbNamespace("namespace",
            service_name=m3db.service_name,
            cluster_id=m3db.id,
            name="mynamespace",
            resolution="P2D",
            retention_period_duration="PT48H")
        ```

        ## Import

        OVHcloud Managed M3DB clusters namespaces can be imported using the `service_name`, `cluster_id` and `id` of the namespace, separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:CloudProjectDatabase/m3DbNamespace:M3DbNamespace my_namespace service_name/cluster_id/id
        ```

        :param str resource_name: The name of the resource.
        :param M3DbNamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(M3DbNamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolution: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_block_data_expiration_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_block_size_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_buffer_future_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_buffer_past_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 writes_to_commit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = M3DbNamespaceArgs.__new__(M3DbNamespaceArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["name"] = name
            if resolution is None and not opts.urn:
                raise TypeError("Missing required property 'resolution'")
            __props__.__dict__["resolution"] = resolution
            __props__.__dict__["retention_block_data_expiration_duration"] = retention_block_data_expiration_duration
            __props__.__dict__["retention_block_size_duration"] = retention_block_size_duration
            __props__.__dict__["retention_buffer_future_duration"] = retention_buffer_future_duration
            __props__.__dict__["retention_buffer_past_duration"] = retention_buffer_past_duration
            __props__.__dict__["retention_period_duration"] = retention_period_duration
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["snapshot_enabled"] = snapshot_enabled
            __props__.__dict__["writes_to_commit_log_enabled"] = writes_to_commit_log_enabled
            __props__.__dict__["type"] = None
        super(M3DbNamespace, __self__).__init__(
            'ovh:CloudProjectDatabase/m3DbNamespace:M3DbNamespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resolution: Optional[pulumi.Input[_builtins.str]] = None,
            retention_block_data_expiration_duration: Optional[pulumi.Input[_builtins.str]] = None,
            retention_block_size_duration: Optional[pulumi.Input[_builtins.str]] = None,
            retention_buffer_future_duration: Optional[pulumi.Input[_builtins.str]] = None,
            retention_buffer_past_duration: Optional[pulumi.Input[_builtins.str]] = None,
            retention_period_duration: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            writes_to_commit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'M3DbNamespace':
        """
        Get an existing M3DbNamespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID.
        :param pulumi.Input[_builtins.str] name: Name of the namespace. A namespace named "default" is mapped with already created default namespace instead of creating a new namespace.
        :param pulumi.Input[_builtins.str] resolution: Resolution for an aggregated namespace. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_block_data_expiration_duration: Controls how long we wait before expiring stale data. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_block_size_duration: Controls how long to keep a block in memory before flushing to a fileset on disk. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_buffer_future_duration: Controls how far into the future writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_buffer_past_duration: Controls how far into the past writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] retention_period_duration: Controls the duration of time that M3DB will retain data for the namespace. Should follow Rfc3339 e.g P2D, PT48H.
        :param pulumi.Input[_builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[_builtins.bool] snapshot_enabled: Defines whether M3DB will create snapshot files for this namespace.
        :param pulumi.Input[_builtins.str] type: Type of namespace.
        :param pulumi.Input[_builtins.bool] writes_to_commit_log_enabled: Defines whether M3DB will include writes to this namespace in the commit log.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _M3DbNamespaceState.__new__(_M3DbNamespaceState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["name"] = name
        __props__.__dict__["resolution"] = resolution
        __props__.__dict__["retention_block_data_expiration_duration"] = retention_block_data_expiration_duration
        __props__.__dict__["retention_block_size_duration"] = retention_block_size_duration
        __props__.__dict__["retention_buffer_future_duration"] = retention_buffer_future_duration
        __props__.__dict__["retention_buffer_past_duration"] = retention_buffer_past_duration
        __props__.__dict__["retention_period_duration"] = retention_period_duration
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["snapshot_enabled"] = snapshot_enabled
        __props__.__dict__["type"] = type
        __props__.__dict__["writes_to_commit_log_enabled"] = writes_to_commit_log_enabled
        return M3DbNamespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the namespace. A namespace named "default" is mapped with already created default namespace instead of creating a new namespace.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def resolution(self) -> pulumi.Output[_builtins.str]:
        """
        Resolution for an aggregated namespace. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "resolution")

    @_builtins.property
    @pulumi.getter(name="retentionBlockDataExpirationDuration")
    def retention_block_data_expiration_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Controls how long we wait before expiring stale data. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_block_data_expiration_duration")

    @_builtins.property
    @pulumi.getter(name="retentionBlockSizeDuration")
    def retention_block_size_duration(self) -> pulumi.Output[_builtins.str]:
        """
        Controls how long to keep a block in memory before flushing to a fileset on disk. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_block_size_duration")

    @_builtins.property
    @pulumi.getter(name="retentionBufferFutureDuration")
    def retention_buffer_future_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Controls how far into the future writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_buffer_future_duration")

    @_builtins.property
    @pulumi.getter(name="retentionBufferPastDuration")
    def retention_buffer_past_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Controls how far into the past writes to the namespace will be accepted. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_buffer_past_duration")

    @_builtins.property
    @pulumi.getter(name="retentionPeriodDuration")
    def retention_period_duration(self) -> pulumi.Output[_builtins.str]:
        """
        Controls the duration of time that M3DB will retain data for the namespace. Should follow Rfc3339 e.g P2D, PT48H.
        """
        return pulumi.get(self, "retention_period_duration")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="snapshotEnabled")
    def snapshot_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Defines whether M3DB will create snapshot files for this namespace.
        """
        return pulumi.get(self, "snapshot_enabled")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of namespace.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="writesToCommitLogEnabled")
    def writes_to_commit_log_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Defines whether M3DB will include writes to this namespace in the commit log.
        """
        return pulumi.get(self, "writes_to_commit_log_enabled")

