# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ServerCustomizations',
    'ServerIam',
    'ServerNetworkingInterface',
    'ServerOrder',
    'ServerOrderDetail',
    'ServerPlan',
    'ServerPlanConfiguration',
    'ServerPlanOption',
    'ServerPlanOptionConfiguration',
    'ServerReinstallTaskCustomizations',
    'ServerReinstallTaskStorage',
    'ServerReinstallTaskStorageHardwareRaid',
    'ServerReinstallTaskStoragePartitioning',
    'ServerReinstallTaskStoragePartitioningLayout',
    'ServerReinstallTaskStoragePartitioningLayoutExtra',
    'ServerReinstallTaskStoragePartitioningLayoutExtraLv',
    'ServerReinstallTaskStoragePartitioningLayoutExtraZp',
    'ServerStorage',
    'ServerStorageHardwareRaid',
    'ServerStoragePartitioning',
    'ServerStoragePartitioningLayout',
    'ServerStoragePartitioningLayoutExtras',
    'ServerStoragePartitioningLayoutExtrasLv',
    'ServerStoragePartitioningLayoutExtrasZp',
    'GetCloudIamResult',
    'GetCloudVersionResult',
    'GetServerSpecificationsHardwareDefaultHardwareRaidSizeResult',
    'GetServerSpecificationsHardwareDiskGroupResult',
    'GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeResult',
    'GetServerSpecificationsHardwareDiskGroupDiskSizeResult',
    'GetServerSpecificationsHardwareExpansionCardResult',
    'GetServerSpecificationsHardwareMemorySizeResult',
    'GetServerSpecificationsHardwareUsbKeyResult',
    'GetServerSpecificationsNetworkBandwidthResult',
    'GetServerSpecificationsNetworkBandwidthInternetToOvhResult',
    'GetServerSpecificationsNetworkBandwidthOvhToInternetResult',
    'GetServerSpecificationsNetworkBandwidthOvhToOvhResult',
    'GetServerSpecificationsNetworkConnectionValResult',
    'GetServerSpecificationsNetworkOlaResult',
    'GetServerSpecificationsNetworkOlaAvailableModeResult',
    'GetServerSpecificationsNetworkOlaAvailableModeInterfaceResult',
    'GetServerSpecificationsNetworkRoutingResult',
    'GetServerSpecificationsNetworkRoutingIpv4Result',
    'GetServerSpecificationsNetworkRoutingIpv6Result',
    'GetServerSpecificationsNetworkSwitchingResult',
    'GetServerSpecificationsNetworkTrafficResult',
    'GetServerSpecificationsNetworkTrafficInputQuotaSizeResult',
    'GetServerSpecificationsNetworkTrafficInputQuotaUsedResult',
    'GetServerSpecificationsNetworkTrafficOutputQuotaSizeResult',
    'GetServerSpecificationsNetworkTrafficOutputQuotaUsedResult',
    'GetServerSpecificationsNetworkVmacResult',
    'GetServerSpecificationsNetworkVrackResult',
    'GetServerSpecificationsNetworkVrackBandwidthResult',
]

@pulumi.output_type
class ServerCustomizations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configDriveUserData":
            suggest = "config_drive_user_data"
        elif key == "efiBootloaderPath":
            suggest = "efi_bootloader_path"
        elif key == "httpHeaders":
            suggest = "http_headers"
        elif key == "imageCheckSum":
            suggest = "image_check_sum"
        elif key == "imageCheckSumType":
            suggest = "image_check_sum_type"
        elif key == "imageType":
            suggest = "image_type"
        elif key == "imageUrl":
            suggest = "image_url"
        elif key == "postInstallationScript":
            suggest = "post_installation_script"
        elif key == "postInstallationScriptExtension":
            suggest = "post_installation_script_extension"
        elif key == "sshKey":
            suggest = "ssh_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerCustomizations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerCustomizations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerCustomizations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_drive_user_data: Optional[_builtins.str] = None,
                 efi_bootloader_path: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 http_headers: Optional[Mapping[str, _builtins.str]] = None,
                 image_check_sum: Optional[_builtins.str] = None,
                 image_check_sum_type: Optional[_builtins.str] = None,
                 image_type: Optional[_builtins.str] = None,
                 image_url: Optional[_builtins.str] = None,
                 language: Optional[_builtins.str] = None,
                 post_installation_script: Optional[_builtins.str] = None,
                 post_installation_script_extension: Optional[_builtins.str] = None,
                 ssh_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str config_drive_user_data: Config Drive UserData
        :param _builtins.str efi_bootloader_path: Path of the EFI bootloader
        :param _builtins.str hostname: Custom hostname
        :param Mapping[str, _builtins.str] http_headers: Image HTTP Headers
        :param _builtins.str image_check_sum: Image checksum
        :param _builtins.str image_check_sum_type: Checksum type
        :param _builtins.str image_type: Image Type
        :param _builtins.str image_url: Image URL
        :param _builtins.str language: Display Language
        :param _builtins.str post_installation_script: Post-Installation Script
        :param _builtins.str post_installation_script_extension: Post-Installation Script File Extension
        :param _builtins.str ssh_key: SSH Public Key
        """
        if config_drive_user_data is not None:
            pulumi.set(__self__, "config_drive_user_data", config_drive_user_data)
        if efi_bootloader_path is not None:
            pulumi.set(__self__, "efi_bootloader_path", efi_bootloader_path)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if image_check_sum is not None:
            pulumi.set(__self__, "image_check_sum", image_check_sum)
        if image_check_sum_type is not None:
            pulumi.set(__self__, "image_check_sum_type", image_check_sum_type)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if post_installation_script is not None:
            pulumi.set(__self__, "post_installation_script", post_installation_script)
        if post_installation_script_extension is not None:
            pulumi.set(__self__, "post_installation_script_extension", post_installation_script_extension)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)

    @_builtins.property
    @pulumi.getter(name="configDriveUserData")
    def config_drive_user_data(self) -> Optional[_builtins.str]:
        """
        Config Drive UserData
        """
        return pulumi.get(self, "config_drive_user_data")

    @_builtins.property
    @pulumi.getter(name="efiBootloaderPath")
    def efi_bootloader_path(self) -> Optional[_builtins.str]:
        """
        Path of the EFI bootloader
        """
        return pulumi.get(self, "efi_bootloader_path")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Custom hostname
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Image HTTP Headers
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter(name="imageCheckSum")
    def image_check_sum(self) -> Optional[_builtins.str]:
        """
        Image checksum
        """
        return pulumi.get(self, "image_check_sum")

    @_builtins.property
    @pulumi.getter(name="imageCheckSumType")
    def image_check_sum_type(self) -> Optional[_builtins.str]:
        """
        Checksum type
        """
        return pulumi.get(self, "image_check_sum_type")

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[_builtins.str]:
        """
        Image Type
        """
        return pulumi.get(self, "image_type")

    @_builtins.property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[_builtins.str]:
        """
        Image URL
        """
        return pulumi.get(self, "image_url")

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[_builtins.str]:
        """
        Display Language
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="postInstallationScript")
    def post_installation_script(self) -> Optional[_builtins.str]:
        """
        Post-Installation Script
        """
        return pulumi.get(self, "post_installation_script")

    @_builtins.property
    @pulumi.getter(name="postInstallationScriptExtension")
    def post_installation_script_extension(self) -> Optional[_builtins.str]:
        """
        Post-Installation Script File Extension
        """
        return pulumi.get(self, "post_installation_script_extension")

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[_builtins.str]:
        """
        SSH Public Key
        """
        return pulumi.get(self, "ssh_key")


@pulumi.output_type
class ServerIam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerIam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerIam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerIam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 urn: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: Resource display name
        :param _builtins.str id: Unique identifier of the resource in the IAM
        :param Mapping[str, _builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with `ovh:`
        :param _builtins.str urn: URN of the private database, used when writing IAM policies
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the resource in the IAM
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Resource tags. Tags that were internally computed are prefixed with `ovh:`
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> Optional[_builtins.str]:
        """
        URN of the private database, used when writing IAM policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class ServerNetworkingInterface(dict):
    def __init__(__self__, *,
                 macs: Sequence[_builtins.str],
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] macs: Interface Mac address
        :param _builtins.str type: Interface type
        """
        pulumi.set(__self__, "macs", macs)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def macs(self) -> Sequence[_builtins.str]:
        """
        Interface Mac address
        """
        return pulumi.get(self, "macs")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Interface type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServerOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[_builtins.str] = None,
                 details: Optional[Sequence['outputs.ServerOrderDetail']] = None,
                 expiration_date: Optional[_builtins.str] = None,
                 order_id: Optional[_builtins.float] = None):
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @_builtins.property
    @pulumi.getter
    def date(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "date")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ServerOrderDetail']]:
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expiration_date")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "order_id")


@pulumi.output_type
class ServerOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailType":
            suggest = "detail_type"
        elif key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 detail_type: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 order_detail_id: Optional[_builtins.float] = None,
                 quantity: Optional[_builtins.str] = None):
        """
        :param _builtins.str detail_type: Product type of item in order
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detail_type is not None:
            pulumi.set(__self__, "detail_type", detail_type)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> Optional[_builtins.str]:
        """
        Product type of item in order
        """
        return pulumi.get(self, "detail_type")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "order_detail_id")

    @_builtins.property
    @pulumi.getter
    def quantity(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "quantity")


@pulumi.output_type
class ServerPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "itemId":
            suggest = "item_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 configurations: Optional[Sequence['outputs.ServerPlanConfiguration']] = None,
                 item_id: Optional[_builtins.float] = None,
                 quantity: Optional[_builtins.float] = None):
        """
        :param _builtins.str duration: Duration selected for the purchase of the product
        :param _builtins.str plan_code: Identifier of the option offer
        :param _builtins.str pricing_mode: Pricing mode selected for the purchase of the product
        :param _builtins.float item_id: Cart item to be linked
        :param _builtins.float quantity: Quantity of product desired
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if item_id is not None:
            pulumi.set(__self__, "item_id", item_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Duration selected for the purchase of the product
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Identifier of the option offer
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing mode selected for the purchase of the product
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ServerPlanConfiguration']]:
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[_builtins.float]:
        """
        Cart item to be linked
        """
        return pulumi.get(self, "item_id")

    @_builtins.property
    @pulumi.getter
    def quantity(self) -> Optional[_builtins.float]:
        """
        Quantity of product desired
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class ServerPlanConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Label for your configuration item
        :param _builtins.str value: Value or resource URL on API.OVH.COM of your configuration item
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label for your configuration item
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value or resource URL on API.OVH.COM of your configuration item
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServerPlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 quantity: _builtins.float,
                 configurations: Optional[Sequence['outputs.ServerPlanOptionConfiguration']] = None):
        """
        :param _builtins.str duration: Duration selected for the purchase of the product
        :param _builtins.str plan_code: Identifier of the option offer
        :param _builtins.str pricing_mode: Pricing mode selected for the purchase of the product
        :param _builtins.float quantity: Quantity of product desired
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        pulumi.set(__self__, "quantity", quantity)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Duration selected for the purchase of the product
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Identifier of the option offer
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing mode selected for the purchase of the product
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter
    def quantity(self) -> _builtins.float:
        """
        Quantity of product desired
        """
        return pulumi.get(self, "quantity")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ServerPlanOptionConfiguration']]:
        return pulumi.get(self, "configurations")


@pulumi.output_type
class ServerPlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Label for your configuration item
        :param _builtins.str value: Value or resource URL on API.OVH.COM of your configuration item
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label for your configuration item
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value or resource URL on API.OVH.COM of your configuration item
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServerReinstallTaskCustomizations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configDriveUserData":
            suggest = "config_drive_user_data"
        elif key == "efiBootloaderPath":
            suggest = "efi_bootloader_path"
        elif key == "httpHeaders":
            suggest = "http_headers"
        elif key == "imageCheckSum":
            suggest = "image_check_sum"
        elif key == "imageCheckSumType":
            suggest = "image_check_sum_type"
        elif key == "imageType":
            suggest = "image_type"
        elif key == "imageUrl":
            suggest = "image_url"
        elif key == "postInstallationScript":
            suggest = "post_installation_script"
        elif key == "postInstallationScriptExtension":
            suggest = "post_installation_script_extension"
        elif key == "sshKey":
            suggest = "ssh_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskCustomizations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskCustomizations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskCustomizations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_drive_user_data: Optional[_builtins.str] = None,
                 efi_bootloader_path: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 http_headers: Optional[Mapping[str, _builtins.str]] = None,
                 image_check_sum: Optional[_builtins.str] = None,
                 image_check_sum_type: Optional[_builtins.str] = None,
                 image_type: Optional[_builtins.str] = None,
                 image_url: Optional[_builtins.str] = None,
                 language: Optional[_builtins.str] = None,
                 post_installation_script: Optional[_builtins.str] = None,
                 post_installation_script_extension: Optional[_builtins.str] = None,
                 ssh_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str config_drive_user_data: Config Drive UserData
        :param _builtins.str efi_bootloader_path: EFI bootloader path
        :param _builtins.str hostname: Custom hostname
        :param Mapping[str, _builtins.str] http_headers: Image HTTP Headers
        :param _builtins.str image_check_sum: Image checksum
        :param _builtins.str image_check_sum_type: Checksum type
        :param _builtins.str image_type: Image Type
        :param _builtins.str image_url: Image URL
        :param _builtins.str language: Display Language
        :param _builtins.str post_installation_script: Post-Installation Script
        :param _builtins.str post_installation_script_extension: Post-Installation Script File Extension
        :param _builtins.str ssh_key: SSH Public Key
        """
        if config_drive_user_data is not None:
            pulumi.set(__self__, "config_drive_user_data", config_drive_user_data)
        if efi_bootloader_path is not None:
            pulumi.set(__self__, "efi_bootloader_path", efi_bootloader_path)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if image_check_sum is not None:
            pulumi.set(__self__, "image_check_sum", image_check_sum)
        if image_check_sum_type is not None:
            pulumi.set(__self__, "image_check_sum_type", image_check_sum_type)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if post_installation_script is not None:
            pulumi.set(__self__, "post_installation_script", post_installation_script)
        if post_installation_script_extension is not None:
            pulumi.set(__self__, "post_installation_script_extension", post_installation_script_extension)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)

    @_builtins.property
    @pulumi.getter(name="configDriveUserData")
    def config_drive_user_data(self) -> Optional[_builtins.str]:
        """
        Config Drive UserData
        """
        return pulumi.get(self, "config_drive_user_data")

    @_builtins.property
    @pulumi.getter(name="efiBootloaderPath")
    def efi_bootloader_path(self) -> Optional[_builtins.str]:
        """
        EFI bootloader path
        """
        return pulumi.get(self, "efi_bootloader_path")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Custom hostname
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Image HTTP Headers
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter(name="imageCheckSum")
    def image_check_sum(self) -> Optional[_builtins.str]:
        """
        Image checksum
        """
        return pulumi.get(self, "image_check_sum")

    @_builtins.property
    @pulumi.getter(name="imageCheckSumType")
    def image_check_sum_type(self) -> Optional[_builtins.str]:
        """
        Checksum type
        """
        return pulumi.get(self, "image_check_sum_type")

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[_builtins.str]:
        """
        Image Type
        """
        return pulumi.get(self, "image_type")

    @_builtins.property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[_builtins.str]:
        """
        Image URL
        """
        return pulumi.get(self, "image_url")

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[_builtins.str]:
        """
        Display Language
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="postInstallationScript")
    def post_installation_script(self) -> Optional[_builtins.str]:
        """
        Post-Installation Script
        """
        return pulumi.get(self, "post_installation_script")

    @_builtins.property
    @pulumi.getter(name="postInstallationScriptExtension")
    def post_installation_script_extension(self) -> Optional[_builtins.str]:
        """
        Post-Installation Script File Extension
        """
        return pulumi.get(self, "post_installation_script_extension")

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[_builtins.str]:
        """
        SSH Public Key
        """
        return pulumi.get(self, "ssh_key")


@pulumi.output_type
class ServerReinstallTaskStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskGroupId":
            suggest = "disk_group_id"
        elif key == "hardwareRaids":
            suggest = "hardware_raids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_group_id: Optional[_builtins.int] = None,
                 hardware_raids: Optional[Sequence['outputs.ServerReinstallTaskStorageHardwareRaid']] = None,
                 partitionings: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioning']] = None):
        """
        :param _builtins.int disk_group_id: Disk group id to install the OS to (default is 0, meaning automatic).
        :param Sequence['ServerReinstallTaskStorageHardwareRaidArgs'] hardware_raids: Hardware Raid configurations (if not specified, all disks of the chosen disk group id will be configured in JBOD mode).
        :param Sequence['ServerReinstallTaskStoragePartitioningArgs'] partitionings: Partitioning configuration
        """
        if disk_group_id is not None:
            pulumi.set(__self__, "disk_group_id", disk_group_id)
        if hardware_raids is not None:
            pulumi.set(__self__, "hardware_raids", hardware_raids)
        if partitionings is not None:
            pulumi.set(__self__, "partitionings", partitionings)

    @_builtins.property
    @pulumi.getter(name="diskGroupId")
    def disk_group_id(self) -> Optional[_builtins.int]:
        """
        Disk group id to install the OS to (default is 0, meaning automatic).
        """
        return pulumi.get(self, "disk_group_id")

    @_builtins.property
    @pulumi.getter(name="hardwareRaids")
    def hardware_raids(self) -> Optional[Sequence['outputs.ServerReinstallTaskStorageHardwareRaid']]:
        """
        Hardware Raid configurations (if not specified, all disks of the chosen disk group id will be configured in JBOD mode).
        """
        return pulumi.get(self, "hardware_raids")

    @_builtins.property
    @pulumi.getter
    def partitionings(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioning']]:
        """
        Partitioning configuration
        """
        return pulumi.get(self, "partitionings")


@pulumi.output_type
class ServerReinstallTaskStorageHardwareRaid(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskStorageHardwareRaid. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskStorageHardwareRaid.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskStorageHardwareRaid.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arrays: Optional[_builtins.int] = None,
                 disks: Optional[_builtins.int] = None,
                 raid_level: Optional[_builtins.int] = None,
                 spares: Optional[_builtins.int] = None):
        """
        :param _builtins.int arrays: Number of arrays (default is 1)
        :param _builtins.int disks: Total number of disks in the disk group involved in the hardware raid configuration (all disks of the disk group by default)
        :param _builtins.int raid_level: Hardware raid type (default is 1)
        :param _builtins.int spares: Number of disks in the disk group involved in the spare (default is 0)
        """
        if arrays is not None:
            pulumi.set(__self__, "arrays", arrays)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if spares is not None:
            pulumi.set(__self__, "spares", spares)

    @_builtins.property
    @pulumi.getter
    def arrays(self) -> Optional[_builtins.int]:
        """
        Number of arrays (default is 1)
        """
        return pulumi.get(self, "arrays")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[_builtins.int]:
        """
        Total number of disks in the disk group involved in the hardware raid configuration (all disks of the disk group by default)
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[_builtins.int]:
        """
        Hardware raid type (default is 1)
        """
        return pulumi.get(self, "raid_level")

    @_builtins.property
    @pulumi.getter
    def spares(self) -> Optional[_builtins.int]:
        """
        Number of disks in the disk group involved in the spare (default is 0)
        """
        return pulumi.get(self, "spares")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemeName":
            suggest = "scheme_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskStoragePartitioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskStoragePartitioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskStoragePartitioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disks: Optional[_builtins.int] = None,
                 layouts: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayout']] = None,
                 scheme_name: Optional[_builtins.str] = None):
        """
        :param _builtins.int disks: Total number of disks in the disk group involved in the partitioning configuration (all disks of the disk group by default)
        :param Sequence['ServerReinstallTaskStoragePartitioningLayoutArgs'] layouts: Custom partitioning layout (default is the default layout of the operating system's default partitioning scheme). Accept multiple values (multiple partitions):
        :param _builtins.str scheme_name: Partitioning scheme (if applicable with selected operating system)
        """
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if layouts is not None:
            pulumi.set(__self__, "layouts", layouts)
        if scheme_name is not None:
            pulumi.set(__self__, "scheme_name", scheme_name)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[_builtins.int]:
        """
        Total number of disks in the disk group involved in the partitioning configuration (all disks of the disk group by default)
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter
    def layouts(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayout']]:
        """
        Custom partitioning layout (default is the default layout of the operating system's default partitioning scheme). Accept multiple values (multiple partitions):
        """
        return pulumi.get(self, "layouts")

    @_builtins.property
    @pulumi.getter(name="schemeName")
    def scheme_name(self) -> Optional[_builtins.str]:
        """
        Partitioning scheme (if applicable with selected operating system)
        """
        return pulumi.get(self, "scheme_name")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioningLayout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystem":
            suggest = "file_system"
        elif key == "mountPoint":
            suggest = "mount_point"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskStoragePartitioningLayout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskStoragePartitioningLayout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskStoragePartitioningLayout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system: _builtins.str,
                 mount_point: _builtins.str,
                 extras: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtra']] = None,
                 raid_level: Optional[_builtins.int] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.str file_system: File system type
        :param _builtins.str mount_point: Mount point
        :param Sequence['ServerReinstallTaskStoragePartitioningLayoutExtraArgs'] extras: Partition extras parameters (when applicable)
        :param _builtins.int raid_level: Software raid type (default is 1)
        :param _builtins.int size: Partition size in MiB (default value is 0 which means to fill the disk with that partition)
        """
        pulumi.set(__self__, "file_system", file_system)
        pulumi.set(__self__, "mount_point", mount_point)
        if extras is not None:
            pulumi.set(__self__, "extras", extras)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> _builtins.str:
        """
        File system type
        """
        return pulumi.get(self, "file_system")

    @_builtins.property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> _builtins.str:
        """
        Mount point
        """
        return pulumi.get(self, "mount_point")

    @_builtins.property
    @pulumi.getter
    def extras(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtra']]:
        """
        Partition extras parameters (when applicable)
        """
        return pulumi.get(self, "extras")

    @_builtins.property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[_builtins.int]:
        """
        Software raid type (default is 1)
        """
        return pulumi.get(self, "raid_level")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Partition size in MiB (default value is 0 which means to fill the disk with that partition)
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioningLayoutExtra(dict):
    def __init__(__self__, *,
                 lvs: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtraLv']] = None,
                 zps: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtraZp']] = None):
        """
        :param Sequence['ServerReinstallTaskStoragePartitioningLayoutExtraLvArgs'] lvs: LVM-specific parameters (when applicable)
        :param Sequence['ServerReinstallTaskStoragePartitioningLayoutExtraZpArgs'] zps: ZFS-specific parameters (when applicable)
        """
        if lvs is not None:
            pulumi.set(__self__, "lvs", lvs)
        if zps is not None:
            pulumi.set(__self__, "zps", zps)

    @_builtins.property
    @pulumi.getter
    def lvs(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtraLv']]:
        """
        LVM-specific parameters (when applicable)
        """
        return pulumi.get(self, "lvs")

    @_builtins.property
    @pulumi.getter
    def zps(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtraZp']]:
        """
        ZFS-specific parameters (when applicable)
        """
        return pulumi.get(self, "zps")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioningLayoutExtraLv(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Logical volume name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Logical volume name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioningLayoutExtraZp(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: zpool name (generated automatically if not specified, note that multiple ZFS partitions with same zpool names will be configured as multiple datasets belonging to the same zpool if compatible)
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        zpool name (generated automatically if not specified, note that multiple ZFS partitions with same zpool names will be configured as multiple datasets belonging to the same zpool if compatible)
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServerStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskGroupId":
            suggest = "disk_group_id"
        elif key == "hardwareRaids":
            suggest = "hardware_raids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_group_id: Optional[_builtins.float] = None,
                 hardware_raids: Optional[Sequence['outputs.ServerStorageHardwareRaid']] = None,
                 partitioning: Optional['outputs.ServerStoragePartitioning'] = None):
        """
        :param _builtins.float disk_group_id: Disk group id (default is 0, meaning automatic)
        :param Sequence['ServerStorageHardwareRaidArgs'] hardware_raids: Hardware Raid configurations (if not specified, all disks of the chosen disk group id will be configured in JBOD mode)
        :param 'ServerStoragePartitioningArgs' partitioning: Partitioning configuration
        """
        if disk_group_id is not None:
            pulumi.set(__self__, "disk_group_id", disk_group_id)
        if hardware_raids is not None:
            pulumi.set(__self__, "hardware_raids", hardware_raids)
        if partitioning is not None:
            pulumi.set(__self__, "partitioning", partitioning)

    @_builtins.property
    @pulumi.getter(name="diskGroupId")
    def disk_group_id(self) -> Optional[_builtins.float]:
        """
        Disk group id (default is 0, meaning automatic)
        """
        return pulumi.get(self, "disk_group_id")

    @_builtins.property
    @pulumi.getter(name="hardwareRaids")
    def hardware_raids(self) -> Optional[Sequence['outputs.ServerStorageHardwareRaid']]:
        """
        Hardware Raid configurations (if not specified, all disks of the chosen disk group id will be configured in JBOD mode)
        """
        return pulumi.get(self, "hardware_raids")

    @_builtins.property
    @pulumi.getter
    def partitioning(self) -> Optional['outputs.ServerStoragePartitioning']:
        """
        Partitioning configuration
        """
        return pulumi.get(self, "partitioning")


@pulumi.output_type
class ServerStorageHardwareRaid(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerStorageHardwareRaid. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerStorageHardwareRaid.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerStorageHardwareRaid.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arrays: Optional[_builtins.float] = None,
                 disks: Optional[_builtins.float] = None,
                 raid_level: Optional[_builtins.float] = None,
                 spares: Optional[_builtins.float] = None):
        """
        :param _builtins.float arrays: Number of arrays (default is 1)
        :param _builtins.float disks: Total number of disks in the disk group involved in the hardware raid configuration (all disks of the disk group by default)
        :param _builtins.float raid_level: Hardware raid type (default is 1)
        :param _builtins.float spares: Number of disks in the disk group involved in the spare (default is 0)
        """
        if arrays is not None:
            pulumi.set(__self__, "arrays", arrays)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if spares is not None:
            pulumi.set(__self__, "spares", spares)

    @_builtins.property
    @pulumi.getter
    def arrays(self) -> Optional[_builtins.float]:
        """
        Number of arrays (default is 1)
        """
        return pulumi.get(self, "arrays")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[_builtins.float]:
        """
        Total number of disks in the disk group involved in the hardware raid configuration (all disks of the disk group by default)
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[_builtins.float]:
        """
        Hardware raid type (default is 1)
        """
        return pulumi.get(self, "raid_level")

    @_builtins.property
    @pulumi.getter
    def spares(self) -> Optional[_builtins.float]:
        """
        Number of disks in the disk group involved in the spare (default is 0)
        """
        return pulumi.get(self, "spares")


@pulumi.output_type
class ServerStoragePartitioning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemeName":
            suggest = "scheme_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerStoragePartitioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerStoragePartitioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerStoragePartitioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disks: Optional[_builtins.float] = None,
                 layouts: Optional[Sequence['outputs.ServerStoragePartitioningLayout']] = None,
                 scheme_name: Optional[_builtins.str] = None):
        """
        :param _builtins.float disks: Total number of disks in the disk group involved in the partitioning configuration (all disks of the disk group by default)
        :param Sequence['ServerStoragePartitioningLayoutArgs'] layouts: Custom partitioning layout (default is the default layout of the operating system's default partitioning scheme)
        :param _builtins.str scheme_name: Partitioning scheme (if applicable with selected operating system)
        """
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if layouts is not None:
            pulumi.set(__self__, "layouts", layouts)
        if scheme_name is not None:
            pulumi.set(__self__, "scheme_name", scheme_name)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[_builtins.float]:
        """
        Total number of disks in the disk group involved in the partitioning configuration (all disks of the disk group by default)
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter
    def layouts(self) -> Optional[Sequence['outputs.ServerStoragePartitioningLayout']]:
        """
        Custom partitioning layout (default is the default layout of the operating system's default partitioning scheme)
        """
        return pulumi.get(self, "layouts")

    @_builtins.property
    @pulumi.getter(name="schemeName")
    def scheme_name(self) -> Optional[_builtins.str]:
        """
        Partitioning scheme (if applicable with selected operating system)
        """
        return pulumi.get(self, "scheme_name")


@pulumi.output_type
class ServerStoragePartitioningLayout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystem":
            suggest = "file_system"
        elif key == "mountPoint":
            suggest = "mount_point"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerStoragePartitioningLayout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerStoragePartitioningLayout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerStoragePartitioningLayout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system: _builtins.str,
                 mount_point: _builtins.str,
                 extras: Optional['outputs.ServerStoragePartitioningLayoutExtras'] = None,
                 raid_level: Optional[_builtins.float] = None,
                 size: Optional[_builtins.float] = None):
        """
        :param _builtins.str file_system: File system type
        :param _builtins.str mount_point: Mount point
        :param 'ServerStoragePartitioningLayoutExtrasArgs' extras: Partition extras parameters
        :param _builtins.float raid_level: Software raid type (default is 1)
        :param _builtins.float size: Partition size in MiB (default value is 0 which means to fill the disk with that partition)
        """
        pulumi.set(__self__, "file_system", file_system)
        pulumi.set(__self__, "mount_point", mount_point)
        if extras is not None:
            pulumi.set(__self__, "extras", extras)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> _builtins.str:
        """
        File system type
        """
        return pulumi.get(self, "file_system")

    @_builtins.property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> _builtins.str:
        """
        Mount point
        """
        return pulumi.get(self, "mount_point")

    @_builtins.property
    @pulumi.getter
    def extras(self) -> Optional['outputs.ServerStoragePartitioningLayoutExtras']:
        """
        Partition extras parameters
        """
        return pulumi.get(self, "extras")

    @_builtins.property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[_builtins.float]:
        """
        Software raid type (default is 1)
        """
        return pulumi.get(self, "raid_level")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.float]:
        """
        Partition size in MiB (default value is 0 which means to fill the disk with that partition)
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class ServerStoragePartitioningLayoutExtras(dict):
    def __init__(__self__, *,
                 lv: Optional['outputs.ServerStoragePartitioningLayoutExtrasLv'] = None,
                 zp: Optional['outputs.ServerStoragePartitioningLayoutExtrasZp'] = None):
        """
        :param 'ServerStoragePartitioningLayoutExtrasLvArgs' lv: LVM-specific parameters
        :param 'ServerStoragePartitioningLayoutExtrasZpArgs' zp: ZFS-specific parameters
        """
        if lv is not None:
            pulumi.set(__self__, "lv", lv)
        if zp is not None:
            pulumi.set(__self__, "zp", zp)

    @_builtins.property
    @pulumi.getter
    def lv(self) -> Optional['outputs.ServerStoragePartitioningLayoutExtrasLv']:
        """
        LVM-specific parameters
        """
        return pulumi.get(self, "lv")

    @_builtins.property
    @pulumi.getter
    def zp(self) -> Optional['outputs.ServerStoragePartitioningLayoutExtrasZp']:
        """
        ZFS-specific parameters
        """
        return pulumi.get(self, "zp")


@pulumi.output_type
class ServerStoragePartitioningLayoutExtrasLv(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Dedicated server name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Dedicated server name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServerStoragePartitioningLayoutExtrasZp(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Dedicated server name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Dedicated server name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetCloudIamResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 urn: _builtins.str):
        """
        :param _builtins.str display_name: Resource display name
        :param _builtins.str id: Unique identifier of the resource
        :param Mapping[str, _builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with ovh:
        :param _builtins.str urn: Unique resource name used in policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with ovh:
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> _builtins.str:
        """
        Unique resource name used in policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetCloudVersionResult(dict):
    def __init__(__self__, *,
                 build: _builtins.str,
                 major: _builtins.str,
                 minor: _builtins.str):
        pulumi.set(__self__, "build", build)
        pulumi.set(__self__, "major", major)
        pulumi.set(__self__, "minor", minor)

    @_builtins.property
    @pulumi.getter
    def build(self) -> _builtins.str:
        return pulumi.get(self, "build")

    @_builtins.property
    @pulumi.getter
    def major(self) -> _builtins.str:
        return pulumi.get(self, "major")

    @_builtins.property
    @pulumi.getter
    def minor(self) -> _builtins.str:
        return pulumi.get(self, "minor")


@pulumi.output_type
class GetServerSpecificationsHardwareDefaultHardwareRaidSizeResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsHardwareDiskGroupResult(dict):
    def __init__(__self__, *,
                 default_hardware_raid_size: 'outputs.GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeResult',
                 default_hardware_raid_type: _builtins.str,
                 description: _builtins.str,
                 disk_group_id: _builtins.float,
                 disk_size: 'outputs.GetServerSpecificationsHardwareDiskGroupDiskSizeResult',
                 disk_type: _builtins.str,
                 number_of_disks: _builtins.float,
                 raid_controller: _builtins.str):
        """
        :param 'GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeArgs' default_hardware_raid_size: Default hardware raid size for this disk group
        :param _builtins.str default_hardware_raid_type: Default hardware raid type for this disk group
        :param _builtins.str description: Expansion card description
        :param _builtins.float disk_group_id: Identifier of this disk group
        :param 'GetServerSpecificationsHardwareDiskGroupDiskSizeArgs' disk_size: Disk capacity
        :param _builtins.str disk_type: Type of the disk (SSD, SATA, SAS, ...)
        :param _builtins.float number_of_disks: Number of disks in this group
        :param _builtins.str raid_controller: Raid controller, if any, managing this group of disks
        """
        pulumi.set(__self__, "default_hardware_raid_size", default_hardware_raid_size)
        pulumi.set(__self__, "default_hardware_raid_type", default_hardware_raid_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk_group_id", disk_group_id)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "raid_controller", raid_controller)

    @_builtins.property
    @pulumi.getter(name="defaultHardwareRaidSize")
    def default_hardware_raid_size(self) -> 'outputs.GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeResult':
        """
        Default hardware raid size for this disk group
        """
        return pulumi.get(self, "default_hardware_raid_size")

    @_builtins.property
    @pulumi.getter(name="defaultHardwareRaidType")
    def default_hardware_raid_type(self) -> _builtins.str:
        """
        Default hardware raid type for this disk group
        """
        return pulumi.get(self, "default_hardware_raid_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Expansion card description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskGroupId")
    def disk_group_id(self) -> _builtins.float:
        """
        Identifier of this disk group
        """
        return pulumi.get(self, "disk_group_id")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> 'outputs.GetServerSpecificationsHardwareDiskGroupDiskSizeResult':
        """
        Disk capacity
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.str:
        """
        Type of the disk (SSD, SATA, SAS, ...)
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> _builtins.float:
        """
        Number of disks in this group
        """
        return pulumi.get(self, "number_of_disks")

    @_builtins.property
    @pulumi.getter(name="raidController")
    def raid_controller(self) -> _builtins.str:
        """
        Raid controller, if any, managing this group of disks
        """
        return pulumi.get(self, "raid_controller")


@pulumi.output_type
class GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsHardwareDiskGroupDiskSizeResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsHardwareExpansionCardResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str description: Expansion card description
        :param _builtins.str type: Expansion card type enum
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Expansion card description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Expansion card type enum
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerSpecificationsHardwareMemorySizeResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsHardwareUsbKeyResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkBandwidthResult(dict):
    def __init__(__self__, *,
                 internet_to_ovh: 'outputs.GetServerSpecificationsNetworkBandwidthInternetToOvhResult',
                 ovh_to_internet: 'outputs.GetServerSpecificationsNetworkBandwidthOvhToInternetResult',
                 ovh_to_ovh: 'outputs.GetServerSpecificationsNetworkBandwidthOvhToOvhResult',
                 type: _builtins.str):
        """
        :param 'GetServerSpecificationsNetworkBandwidthInternetToOvhArgs' internet_to_ovh: Bandwidth limitation Internet to OVH
        :param 'GetServerSpecificationsNetworkBandwidthOvhToInternetArgs' ovh_to_internet: Bandwidth limitation OVH to Internet
        :param 'GetServerSpecificationsNetworkBandwidthOvhToOvhArgs' ovh_to_ovh: Bandwidth limitation OVH to OVH
        :param _builtins.str type: Bandwidth offer type (included┃standard)
        """
        pulumi.set(__self__, "internet_to_ovh", internet_to_ovh)
        pulumi.set(__self__, "ovh_to_internet", ovh_to_internet)
        pulumi.set(__self__, "ovh_to_ovh", ovh_to_ovh)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="internetToOvh")
    def internet_to_ovh(self) -> 'outputs.GetServerSpecificationsNetworkBandwidthInternetToOvhResult':
        """
        Bandwidth limitation Internet to OVH
        """
        return pulumi.get(self, "internet_to_ovh")

    @_builtins.property
    @pulumi.getter(name="ovhToInternet")
    def ovh_to_internet(self) -> 'outputs.GetServerSpecificationsNetworkBandwidthOvhToInternetResult':
        """
        Bandwidth limitation OVH to Internet
        """
        return pulumi.get(self, "ovh_to_internet")

    @_builtins.property
    @pulumi.getter(name="ovhToOvh")
    def ovh_to_ovh(self) -> 'outputs.GetServerSpecificationsNetworkBandwidthOvhToOvhResult':
        """
        Bandwidth limitation OVH to OVH
        """
        return pulumi.get(self, "ovh_to_ovh")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Bandwidth offer type (included┃standard)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerSpecificationsNetworkBandwidthInternetToOvhResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkBandwidthOvhToInternetResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkBandwidthOvhToOvhResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkConnectionValResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkOlaResult(dict):
    def __init__(__self__, *,
                 available: _builtins.bool,
                 available_modes: Sequence['outputs.GetServerSpecificationsNetworkOlaAvailableModeResult'],
                 supported_modes: Sequence[_builtins.str]):
        """
        :param _builtins.bool available: Is the OLA feature available
        :param Sequence['GetServerSpecificationsNetworkOlaAvailableModeArgs'] available_modes: Supported modes
        :param Sequence[_builtins.str] supported_modes: Supported modes (DEPRECATED)
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "available_modes", available_modes)
        pulumi.set(__self__, "supported_modes", supported_modes)

    @_builtins.property
    @pulumi.getter
    def available(self) -> _builtins.bool:
        """
        Is the OLA feature available
        """
        return pulumi.get(self, "available")

    @_builtins.property
    @pulumi.getter(name="availableModes")
    def available_modes(self) -> Sequence['outputs.GetServerSpecificationsNetworkOlaAvailableModeResult']:
        """
        Supported modes
        """
        return pulumi.get(self, "available_modes")

    @_builtins.property
    @pulumi.getter(name="supportedModes")
    def supported_modes(self) -> Sequence[_builtins.str]:
        """
        Supported modes (DEPRECATED)
        """
        return pulumi.get(self, "supported_modes")


@pulumi.output_type
class GetServerSpecificationsNetworkOlaAvailableModeResult(dict):
    def __init__(__self__, *,
                 default: _builtins.bool,
                 interfaces: Sequence['outputs.GetServerSpecificationsNetworkOlaAvailableModeInterfaceResult'],
                 name: _builtins.str):
        """
        :param _builtins.bool default: Whether it is the default configuration of the server
        :param Sequence['GetServerSpecificationsNetworkOlaAvailableModeInterfaceArgs'] interfaces: Interface layout
        :param _builtins.str name: Switch name
        """
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "interfaces", interfaces)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def default(self) -> _builtins.bool:
        """
        Whether it is the default configuration of the server
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.GetServerSpecificationsNetworkOlaAvailableModeInterfaceResult']:
        """
        Interface layout
        """
        return pulumi.get(self, "interfaces")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Switch name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServerSpecificationsNetworkOlaAvailableModeInterfaceResult(dict):
    def __init__(__self__, *,
                 aggregation: _builtins.bool,
                 count: _builtins.float,
                 type: _builtins.str):
        """
        :param _builtins.bool aggregation: Interface aggregation status
        :param _builtins.float count: Interface count
        :param _builtins.str type: Bandwidth offer type (included┃standard)
        """
        pulumi.set(__self__, "aggregation", aggregation)
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def aggregation(self) -> _builtins.bool:
        """
        Interface aggregation status
        """
        return pulumi.get(self, "aggregation")

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.float:
        """
        Interface count
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Bandwidth offer type (included┃standard)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerSpecificationsNetworkRoutingResult(dict):
    def __init__(__self__, *,
                 ipv4: 'outputs.GetServerSpecificationsNetworkRoutingIpv4Result',
                 ipv6: 'outputs.GetServerSpecificationsNetworkRoutingIpv6Result'):
        """
        :param 'GetServerSpecificationsNetworkRoutingIpv4Args' ipv4: Ipv4 routing details
        :param 'GetServerSpecificationsNetworkRoutingIpv6Args' ipv6: Ipv6 routing details
        """
        pulumi.set(__self__, "ipv4", ipv4)
        pulumi.set(__self__, "ipv6", ipv6)

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> 'outputs.GetServerSpecificationsNetworkRoutingIpv4Result':
        """
        Ipv4 routing details
        """
        return pulumi.get(self, "ipv4")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> 'outputs.GetServerSpecificationsNetworkRoutingIpv6Result':
        """
        Ipv6 routing details
        """
        return pulumi.get(self, "ipv6")


@pulumi.output_type
class GetServerSpecificationsNetworkRoutingIpv4Result(dict):
    def __init__(__self__, *,
                 gateway: _builtins.str,
                 ip: _builtins.str,
                 network: _builtins.str):
        """
        :param _builtins.str gateway: Server gateway
        :param _builtins.str ip: Server main IP
        :param _builtins.str network: Server network
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "network", network)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> _builtins.str:
        """
        Server gateway
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Server main IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Server network
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class GetServerSpecificationsNetworkRoutingIpv6Result(dict):
    def __init__(__self__, *,
                 gateway: _builtins.str,
                 ip: _builtins.str,
                 network: _builtins.str):
        """
        :param _builtins.str gateway: Server gateway
        :param _builtins.str ip: Server main IP
        :param _builtins.str network: Server network
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "network", network)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> _builtins.str:
        """
        Server gateway
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Server main IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Server network
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class GetServerSpecificationsNetworkSwitchingResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Switch name
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Switch name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficResult(dict):
    def __init__(__self__, *,
                 input_quota_size: 'outputs.GetServerSpecificationsNetworkTrafficInputQuotaSizeResult',
                 input_quota_used: 'outputs.GetServerSpecificationsNetworkTrafficInputQuotaUsedResult',
                 is_throttled: _builtins.bool,
                 output_quota_size: 'outputs.GetServerSpecificationsNetworkTrafficOutputQuotaSizeResult',
                 output_quota_used: 'outputs.GetServerSpecificationsNetworkTrafficOutputQuotaUsedResult',
                 reset_quota_date: _builtins.str):
        """
        :param 'GetServerSpecificationsNetworkTrafficInputQuotaSizeArgs' input_quota_size: Monthly input traffic quota allowed
        :param 'GetServerSpecificationsNetworkTrafficInputQuotaUsedArgs' input_quota_used: Monthly input traffic consumed this month
        :param _builtins.bool is_throttled: Whether bandwidth is throttleted for being over quota
        :param 'GetServerSpecificationsNetworkTrafficOutputQuotaSizeArgs' output_quota_size: Monthly output traffic quota allowed
        :param 'GetServerSpecificationsNetworkTrafficOutputQuotaUsedArgs' output_quota_used: Monthly output traffic consumed this month
        :param _builtins.str reset_quota_date: Next reset quota date for traffic counter
        """
        pulumi.set(__self__, "input_quota_size", input_quota_size)
        pulumi.set(__self__, "input_quota_used", input_quota_used)
        pulumi.set(__self__, "is_throttled", is_throttled)
        pulumi.set(__self__, "output_quota_size", output_quota_size)
        pulumi.set(__self__, "output_quota_used", output_quota_used)
        pulumi.set(__self__, "reset_quota_date", reset_quota_date)

    @_builtins.property
    @pulumi.getter(name="inputQuotaSize")
    def input_quota_size(self) -> 'outputs.GetServerSpecificationsNetworkTrafficInputQuotaSizeResult':
        """
        Monthly input traffic quota allowed
        """
        return pulumi.get(self, "input_quota_size")

    @_builtins.property
    @pulumi.getter(name="inputQuotaUsed")
    def input_quota_used(self) -> 'outputs.GetServerSpecificationsNetworkTrafficInputQuotaUsedResult':
        """
        Monthly input traffic consumed this month
        """
        return pulumi.get(self, "input_quota_used")

    @_builtins.property
    @pulumi.getter(name="isThrottled")
    def is_throttled(self) -> _builtins.bool:
        """
        Whether bandwidth is throttleted for being over quota
        """
        return pulumi.get(self, "is_throttled")

    @_builtins.property
    @pulumi.getter(name="outputQuotaSize")
    def output_quota_size(self) -> 'outputs.GetServerSpecificationsNetworkTrafficOutputQuotaSizeResult':
        """
        Monthly output traffic quota allowed
        """
        return pulumi.get(self, "output_quota_size")

    @_builtins.property
    @pulumi.getter(name="outputQuotaUsed")
    def output_quota_used(self) -> 'outputs.GetServerSpecificationsNetworkTrafficOutputQuotaUsedResult':
        """
        Monthly output traffic consumed this month
        """
        return pulumi.get(self, "output_quota_used")

    @_builtins.property
    @pulumi.getter(name="resetQuotaDate")
    def reset_quota_date(self) -> _builtins.str:
        """
        Next reset quota date for traffic counter
        """
        return pulumi.get(self, "reset_quota_date")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficInputQuotaSizeResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficInputQuotaUsedResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficOutputQuotaSizeResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficOutputQuotaUsedResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkVmacResult(dict):
    def __init__(__self__, *,
                 supported: _builtins.bool):
        """
        :param _builtins.bool supported: Whether server is compatible vmac
        """
        pulumi.set(__self__, "supported", supported)

    @_builtins.property
    @pulumi.getter
    def supported(self) -> _builtins.bool:
        """
        Whether server is compatible vmac
        """
        return pulumi.get(self, "supported")


@pulumi.output_type
class GetServerSpecificationsNetworkVrackResult(dict):
    def __init__(__self__, *,
                 bandwidth: 'outputs.GetServerSpecificationsNetworkVrackBandwidthResult',
                 type: _builtins.str):
        """
        :param 'GetServerSpecificationsNetworkVrackBandwidthArgs' bandwidth: vrack bandwidth limitation
        :param _builtins.str type: Bandwidth offer type (included┃standard)
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> 'outputs.GetServerSpecificationsNetworkVrackBandwidthResult':
        """
        vrack bandwidth limitation
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Bandwidth offer type (included┃standard)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerSpecificationsNetworkVrackBandwidthResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


