# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 boot_id: Optional[pulumi.Input[_builtins.float]] = None,
                 boot_script: Optional[pulumi.Input[_builtins.str]] = None,
                 customizations: Optional[pulumi.Input['ServerCustomizationsArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 efi_bootloader_path: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_service_after_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_intervention: Optional[pulumi.Input[_builtins.bool]] = None,
                 os: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanOptionArgs']]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanArgs']]]] = None,
                 prevent_install_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 prevent_install_on_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rescue_mail: Optional[pulumi.Input[_builtins.str]] = None,
                 rescue_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 root_device: Optional[pulumi.Input[_builtins.str]] = None,
                 run_actions_before_destroys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageArgs']]]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[_builtins.float] boot_id: Boot id of the server
        :param pulumi.Input[_builtins.str] boot_script: Boot script of the server
        :param pulumi.Input['ServerCustomizationsArgs'] customizations: OS reinstallation customizations
        :param pulumi.Input[_builtins.str] display_name: Resource display name
        :param pulumi.Input[_builtins.str] efi_bootloader_path: Path of the EFI bootloader
        :param pulumi.Input[_builtins.bool] keep_service_after_destroy: Whether we should avoid terminating the service when destroying the resource
        :param pulumi.Input[_builtins.bool] monitoring: Icmp monitoring state
        :param pulumi.Input[_builtins.bool] no_intervention: Prevent datacenter intervention
        :param pulumi.Input[_builtins.str] os: Operating system
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.bool] prevent_install_on_create: Defines whether the server should not be reinstalled after creating the resource
        :param pulumi.Input[_builtins.bool] prevent_install_on_import: Defines whether the server should not be reinstalled when importing the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Arbitrary properties to pass to cloud-init's config drive datasource
        :param pulumi.Input[_builtins.str] rescue_mail: Rescue mail of the server
        :param pulumi.Input[_builtins.str] rescue_ssh_key: Public SSH Key used in the rescue mode
        :param pulumi.Input[_builtins.str] root_device: Root device of the server
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] run_actions_before_destroys: Actions to run before destroying the resource
        :param pulumi.Input[_builtins.str] service_name: The service_name of your dedicated server
        :param pulumi.Input[_builtins.str] state: All states a Dedicated can be in (error, hacked, hackedBlocked, ok)
        :param pulumi.Input[Sequence[pulumi.Input['ServerStorageArgs']]] storages: OS reinstallation storage configurations
        """
        if boot_id is not None:
            pulumi.set(__self__, "boot_id", boot_id)
        if boot_script is not None:
            pulumi.set(__self__, "boot_script", boot_script)
        if customizations is not None:
            pulumi.set(__self__, "customizations", customizations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if efi_bootloader_path is not None:
            pulumi.set(__self__, "efi_bootloader_path", efi_bootloader_path)
        if keep_service_after_destroy is not None:
            pulumi.set(__self__, "keep_service_after_destroy", keep_service_after_destroy)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if no_intervention is not None:
            pulumi.set(__self__, "no_intervention", no_intervention)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if plans is not None:
            pulumi.set(__self__, "plans", plans)
        if prevent_install_on_create is not None:
            pulumi.set(__self__, "prevent_install_on_create", prevent_install_on_create)
        if prevent_install_on_import is not None:
            pulumi.set(__self__, "prevent_install_on_import", prevent_install_on_import)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if rescue_mail is not None:
            pulumi.set(__self__, "rescue_mail", rescue_mail)
        if rescue_ssh_key is not None:
            pulumi.set(__self__, "rescue_ssh_key", rescue_ssh_key)
        if root_device is not None:
            pulumi.set(__self__, "root_device", root_device)
        if run_actions_before_destroys is not None:
            pulumi.set(__self__, "run_actions_before_destroys", run_actions_before_destroys)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)

    @_builtins.property
    @pulumi.getter(name="bootId")
    def boot_id(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Boot id of the server
        """
        return pulumi.get(self, "boot_id")

    @boot_id.setter
    def boot_id(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "boot_id", value)

    @_builtins.property
    @pulumi.getter(name="bootScript")
    def boot_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Boot script of the server
        """
        return pulumi.get(self, "boot_script")

    @boot_script.setter
    def boot_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_script", value)

    @_builtins.property
    @pulumi.getter
    def customizations(self) -> Optional[pulumi.Input['ServerCustomizationsArgs']]:
        """
        OS reinstallation customizations
        """
        return pulumi.get(self, "customizations")

    @customizations.setter
    def customizations(self, value: Optional[pulumi.Input['ServerCustomizationsArgs']]):
        pulumi.set(self, "customizations", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="efiBootloaderPath")
    def efi_bootloader_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of the EFI bootloader
        """
        return pulumi.get(self, "efi_bootloader_path")

    @efi_bootloader_path.setter
    def efi_bootloader_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "efi_bootloader_path", value)

    @_builtins.property
    @pulumi.getter(name="keepServiceAfterDestroy")
    def keep_service_after_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether we should avoid terminating the service when destroying the resource
        """
        return pulumi.get(self, "keep_service_after_destroy")

    @keep_service_after_destroy.setter
    def keep_service_after_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_service_after_destroy", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Icmp monitoring state
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter(name="noIntervention")
    def no_intervention(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent datacenter intervention
        """
        return pulumi.get(self, "no_intervention")

    @no_intervention.setter
    def no_intervention(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_intervention", value)

    @_builtins.property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os", value)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OVH subsidiaries
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanOptionArgs']]]]:
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanArgs']]]]:
        return pulumi.get(self, "plans")

    @plans.setter
    def plans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanArgs']]]]):
        pulumi.set(self, "plans", value)

    @_builtins.property
    @pulumi.getter(name="preventInstallOnCreate")
    def prevent_install_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the server should not be reinstalled after creating the resource
        """
        return pulumi.get(self, "prevent_install_on_create")

    @prevent_install_on_create.setter
    def prevent_install_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prevent_install_on_create", value)

    @_builtins.property
    @pulumi.getter(name="preventInstallOnImport")
    def prevent_install_on_import(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the server should not be reinstalled when importing the resource
        """
        return pulumi.get(self, "prevent_install_on_import")

    @prevent_install_on_import.setter
    def prevent_install_on_import(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prevent_install_on_import", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Arbitrary properties to pass to cloud-init's config drive datasource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="rescueMail")
    def rescue_mail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rescue mail of the server
        """
        return pulumi.get(self, "rescue_mail")

    @rescue_mail.setter
    def rescue_mail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rescue_mail", value)

    @_builtins.property
    @pulumi.getter(name="rescueSshKey")
    def rescue_ssh_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public SSH Key used in the rescue mode
        """
        return pulumi.get(self, "rescue_ssh_key")

    @rescue_ssh_key.setter
    def rescue_ssh_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rescue_ssh_key", value)

    @_builtins.property
    @pulumi.getter(name="rootDevice")
    def root_device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Root device of the server
        """
        return pulumi.get(self, "root_device")

    @root_device.setter
    def root_device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_device", value)

    @_builtins.property
    @pulumi.getter(name="runActionsBeforeDestroys")
    def run_actions_before_destroys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Actions to run before destroying the resource
        """
        return pulumi.get(self, "run_actions_before_destroys")

    @run_actions_before_destroys.setter
    def run_actions_before_destroys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "run_actions_before_destroys", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service_name of your dedicated server
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        All states a Dedicated can be in (error, hacked, hackedBlocked, ok)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageArgs']]]]:
        """
        OS reinstallation storage configurations
        """
        return pulumi.get(self, "storages")

    @storages.setter
    def storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageArgs']]]]):
        pulumi.set(self, "storages", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_id: Optional[pulumi.Input[_builtins.float]] = None,
                 boot_script: Optional[pulumi.Input[_builtins.str]] = None,
                 commercial_range: Optional[pulumi.Input[_builtins.str]] = None,
                 customizations: Optional[pulumi.Input['ServerCustomizationsArgs']] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 efi_bootloader_path: Optional[pulumi.Input[_builtins.str]] = None,
                 iam: Optional[pulumi.Input['ServerIamArgs']] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_service_after_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_speed: Optional[pulumi.Input[_builtins.float]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_upgrade_system: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_intervention: Optional[pulumi.Input[_builtins.bool]] = None,
                 order: Optional[pulumi.Input['ServerOrderArgs']] = None,
                 os: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanOptionArgs']]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanArgs']]]] = None,
                 power_state: Optional[pulumi.Input[_builtins.str]] = None,
                 prevent_install_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 prevent_install_on_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 professional_use: Optional[pulumi.Input[_builtins.bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rack: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rescue_mail: Optional[pulumi.Input[_builtins.str]] = None,
                 rescue_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse: Optional[pulumi.Input[_builtins.str]] = None,
                 root_device: Optional[pulumi.Input[_builtins.str]] = None,
                 run_actions_before_destroys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_id: Optional[pulumi.Input[_builtins.float]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageArgs']]]] = None,
                 support_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[_builtins.str] availability_zone: Dedicated AZ localisation
        :param pulumi.Input[_builtins.float] boot_id: Boot id of the server
        :param pulumi.Input[_builtins.str] boot_script: Boot script of the server
        :param pulumi.Input[_builtins.str] commercial_range: Dedicated server commercial range
        :param pulumi.Input['ServerCustomizationsArgs'] customizations: OS reinstallation customizations
        :param pulumi.Input[_builtins.str] datacenter: Dedicated datacenter localisation (bhs1,bhs2,...)
        :param pulumi.Input[_builtins.str] display_name: Resource display name
        :param pulumi.Input[_builtins.str] efi_bootloader_path: Path of the EFI bootloader
        :param pulumi.Input['ServerIamArgs'] iam: IAM resource information
        :param pulumi.Input[_builtins.str] ip: Dedicated server ip (IPv4)
        :param pulumi.Input[_builtins.bool] keep_service_after_destroy: Whether we should avoid terminating the service when destroying the resource
        :param pulumi.Input[_builtins.float] link_speed: Link speed of the server
        :param pulumi.Input[_builtins.bool] monitoring: Icmp monitoring state
        :param pulumi.Input[_builtins.str] name: Dedicated server name
        :param pulumi.Input[_builtins.bool] no_intervention: Prevent datacenter intervention
        :param pulumi.Input['ServerOrderArgs'] order: Details about an Order
        :param pulumi.Input[_builtins.str] os: Operating system
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.str] power_state: Power state of the server (poweron, poweroff)
        :param pulumi.Input[_builtins.bool] prevent_install_on_create: Defines whether the server should not be reinstalled after creating the resource
        :param pulumi.Input[_builtins.bool] prevent_install_on_import: Defines whether the server should not be reinstalled when importing the resource
        :param pulumi.Input[_builtins.bool] professional_use: Does this server have professional use option
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Arbitrary properties to pass to cloud-init's config drive datasource
        :param pulumi.Input[_builtins.str] rack: Rack id of the server
        :param pulumi.Input[_builtins.str] region: Dedicated region localisation
        :param pulumi.Input[_builtins.str] rescue_mail: Rescue mail of the server
        :param pulumi.Input[_builtins.str] rescue_ssh_key: Public SSH Key used in the rescue mode
        :param pulumi.Input[_builtins.str] reverse: Dedicated server reverse
        :param pulumi.Input[_builtins.str] root_device: Root device of the server
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] run_actions_before_destroys: Actions to run before destroying the resource
        :param pulumi.Input[_builtins.float] server_id: Server id
        :param pulumi.Input[_builtins.str] service_name: The service_name of your dedicated server
        :param pulumi.Input[_builtins.str] state: All states a Dedicated can be in (error, hacked, hackedBlocked, ok)
        :param pulumi.Input[Sequence[pulumi.Input['ServerStorageArgs']]] storages: OS reinstallation storage configurations
        :param pulumi.Input[_builtins.str] support_level: Dedicated server support level (critical, fastpath, gs, pro)
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if boot_id is not None:
            pulumi.set(__self__, "boot_id", boot_id)
        if boot_script is not None:
            pulumi.set(__self__, "boot_script", boot_script)
        if commercial_range is not None:
            pulumi.set(__self__, "commercial_range", commercial_range)
        if customizations is not None:
            pulumi.set(__self__, "customizations", customizations)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if efi_bootloader_path is not None:
            pulumi.set(__self__, "efi_bootloader_path", efi_bootloader_path)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if keep_service_after_destroy is not None:
            pulumi.set(__self__, "keep_service_after_destroy", keep_service_after_destroy)
        if link_speed is not None:
            pulumi.set(__self__, "link_speed", link_speed)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_upgrade_system is not None:
            pulumi.set(__self__, "new_upgrade_system", new_upgrade_system)
        if no_intervention is not None:
            pulumi.set(__self__, "no_intervention", no_intervention)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if plans is not None:
            pulumi.set(__self__, "plans", plans)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if prevent_install_on_create is not None:
            pulumi.set(__self__, "prevent_install_on_create", prevent_install_on_create)
        if prevent_install_on_import is not None:
            pulumi.set(__self__, "prevent_install_on_import", prevent_install_on_import)
        if professional_use is not None:
            pulumi.set(__self__, "professional_use", professional_use)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if rack is not None:
            pulumi.set(__self__, "rack", rack)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rescue_mail is not None:
            pulumi.set(__self__, "rescue_mail", rescue_mail)
        if rescue_ssh_key is not None:
            pulumi.set(__self__, "rescue_ssh_key", rescue_ssh_key)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if root_device is not None:
            pulumi.set(__self__, "root_device", root_device)
        if run_actions_before_destroys is not None:
            pulumi.set(__self__, "run_actions_before_destroys", run_actions_before_destroys)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)
        if support_level is not None:
            pulumi.set(__self__, "support_level", support_level)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated AZ localisation
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="bootId")
    def boot_id(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Boot id of the server
        """
        return pulumi.get(self, "boot_id")

    @boot_id.setter
    def boot_id(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "boot_id", value)

    @_builtins.property
    @pulumi.getter(name="bootScript")
    def boot_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Boot script of the server
        """
        return pulumi.get(self, "boot_script")

    @boot_script.setter
    def boot_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_script", value)

    @_builtins.property
    @pulumi.getter(name="commercialRange")
    def commercial_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated server commercial range
        """
        return pulumi.get(self, "commercial_range")

    @commercial_range.setter
    def commercial_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commercial_range", value)

    @_builtins.property
    @pulumi.getter
    def customizations(self) -> Optional[pulumi.Input['ServerCustomizationsArgs']]:
        """
        OS reinstallation customizations
        """
        return pulumi.get(self, "customizations")

    @customizations.setter
    def customizations(self, value: Optional[pulumi.Input['ServerCustomizationsArgs']]):
        pulumi.set(self, "customizations", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated datacenter localisation (bhs1,bhs2,...)
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="efiBootloaderPath")
    def efi_bootloader_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of the EFI bootloader
        """
        return pulumi.get(self, "efi_bootloader_path")

    @efi_bootloader_path.setter
    def efi_bootloader_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "efi_bootloader_path", value)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input['ServerIamArgs']]:
        """
        IAM resource information
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input['ServerIamArgs']]):
        pulumi.set(self, "iam", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated server ip (IPv4)
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="keepServiceAfterDestroy")
    def keep_service_after_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether we should avoid terminating the service when destroying the resource
        """
        return pulumi.get(self, "keep_service_after_destroy")

    @keep_service_after_destroy.setter
    def keep_service_after_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_service_after_destroy", value)

    @_builtins.property
    @pulumi.getter(name="linkSpeed")
    def link_speed(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Link speed of the server
        """
        return pulumi.get(self, "link_speed")

    @link_speed.setter
    def link_speed(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "link_speed", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Icmp monitoring state
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated server name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newUpgradeSystem")
    def new_upgrade_system(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "new_upgrade_system")

    @new_upgrade_system.setter
    def new_upgrade_system(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_upgrade_system", value)

    @_builtins.property
    @pulumi.getter(name="noIntervention")
    def no_intervention(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent datacenter intervention
        """
        return pulumi.get(self, "no_intervention")

    @no_intervention.setter
    def no_intervention(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_intervention", value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input['ServerOrderArgs']]:
        """
        Details about an Order
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input['ServerOrderArgs']]):
        pulumi.set(self, "order", value)

    @_builtins.property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os", value)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OVH subsidiaries
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanOptionArgs']]]]:
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanArgs']]]]:
        return pulumi.get(self, "plans")

    @plans.setter
    def plans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPlanArgs']]]]):
        pulumi.set(self, "plans", value)

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Power state of the server (poweron, poweroff)
        """
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_state", value)

    @_builtins.property
    @pulumi.getter(name="preventInstallOnCreate")
    def prevent_install_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the server should not be reinstalled after creating the resource
        """
        return pulumi.get(self, "prevent_install_on_create")

    @prevent_install_on_create.setter
    def prevent_install_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prevent_install_on_create", value)

    @_builtins.property
    @pulumi.getter(name="preventInstallOnImport")
    def prevent_install_on_import(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the server should not be reinstalled when importing the resource
        """
        return pulumi.get(self, "prevent_install_on_import")

    @prevent_install_on_import.setter
    def prevent_install_on_import(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prevent_install_on_import", value)

    @_builtins.property
    @pulumi.getter(name="professionalUse")
    def professional_use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Does this server have professional use option
        """
        return pulumi.get(self, "professional_use")

    @professional_use.setter
    def professional_use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "professional_use", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Arbitrary properties to pass to cloud-init's config drive datasource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def rack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rack id of the server
        """
        return pulumi.get(self, "rack")

    @rack.setter
    def rack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rack", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated region localisation
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rescueMail")
    def rescue_mail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rescue mail of the server
        """
        return pulumi.get(self, "rescue_mail")

    @rescue_mail.setter
    def rescue_mail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rescue_mail", value)

    @_builtins.property
    @pulumi.getter(name="rescueSshKey")
    def rescue_ssh_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public SSH Key used in the rescue mode
        """
        return pulumi.get(self, "rescue_ssh_key")

    @rescue_ssh_key.setter
    def rescue_ssh_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rescue_ssh_key", value)

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated server reverse
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reverse", value)

    @_builtins.property
    @pulumi.getter(name="rootDevice")
    def root_device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Root device of the server
        """
        return pulumi.get(self, "root_device")

    @root_device.setter
    def root_device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_device", value)

    @_builtins.property
    @pulumi.getter(name="runActionsBeforeDestroys")
    def run_actions_before_destroys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Actions to run before destroying the resource
        """
        return pulumi.get(self, "run_actions_before_destroys")

    @run_actions_before_destroys.setter
    def run_actions_before_destroys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "run_actions_before_destroys", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Server id
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service_name of your dedicated server
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        All states a Dedicated can be in (error, hacked, hackedBlocked, ok)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageArgs']]]]:
        """
        OS reinstallation storage configurations
        """
        return pulumi.get(self, "storages")

    @storages.setter
    def storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageArgs']]]]):
        pulumi.set(self, "storages", value)

    @_builtins.property
    @pulumi.getter(name="supportLevel")
    def support_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated server support level (critical, fastpath, gs, pro)
        """
        return pulumi.get(self, "support_level")

    @support_level.setter
    def support_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "support_level", value)


@pulumi.type_token("ovh:Dedicated/server:Server")
class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boot_id: Optional[pulumi.Input[_builtins.float]] = None,
                 boot_script: Optional[pulumi.Input[_builtins.str]] = None,
                 customizations: Optional[pulumi.Input[Union['ServerCustomizationsArgs', 'ServerCustomizationsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 efi_bootloader_path: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_service_after_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_intervention: Optional[pulumi.Input[_builtins.bool]] = None,
                 os: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPlanOptionArgs', 'ServerPlanOptionArgsDict']]]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPlanArgs', 'ServerPlanArgsDict']]]]] = None,
                 prevent_install_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 prevent_install_on_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rescue_mail: Optional[pulumi.Input[_builtins.str]] = None,
                 rescue_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 root_device: Optional[pulumi.Input[_builtins.str]] = None,
                 run_actions_before_destroys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageArgs', 'ServerStorageArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Import

        Dedicated servers can be imported using the `service_name`. Using the following configuration:

        terraform

        import {

          to = ovh_dedicated_server.server

          id = "<service name>"

        }

        You can then run:

        bash

        pulumi preview -generate-config-out=dedicated.tf

        pulumi up

        The file `dedicated.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] boot_id: Boot id of the server
        :param pulumi.Input[_builtins.str] boot_script: Boot script of the server
        :param pulumi.Input[Union['ServerCustomizationsArgs', 'ServerCustomizationsArgsDict']] customizations: OS reinstallation customizations
        :param pulumi.Input[_builtins.str] display_name: Resource display name
        :param pulumi.Input[_builtins.str] efi_bootloader_path: Path of the EFI bootloader
        :param pulumi.Input[_builtins.bool] keep_service_after_destroy: Whether we should avoid terminating the service when destroying the resource
        :param pulumi.Input[_builtins.bool] monitoring: Icmp monitoring state
        :param pulumi.Input[_builtins.bool] no_intervention: Prevent datacenter intervention
        :param pulumi.Input[_builtins.str] os: Operating system
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.bool] prevent_install_on_create: Defines whether the server should not be reinstalled after creating the resource
        :param pulumi.Input[_builtins.bool] prevent_install_on_import: Defines whether the server should not be reinstalled when importing the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Arbitrary properties to pass to cloud-init's config drive datasource
        :param pulumi.Input[_builtins.str] rescue_mail: Rescue mail of the server
        :param pulumi.Input[_builtins.str] rescue_ssh_key: Public SSH Key used in the rescue mode
        :param pulumi.Input[_builtins.str] root_device: Root device of the server
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] run_actions_before_destroys: Actions to run before destroying the resource
        :param pulumi.Input[_builtins.str] service_name: The service_name of your dedicated server
        :param pulumi.Input[_builtins.str] state: All states a Dedicated can be in (error, hacked, hackedBlocked, ok)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageArgs', 'ServerStorageArgsDict']]]] storages: OS reinstallation storage configurations
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Dedicated servers can be imported using the `service_name`. Using the following configuration:

        terraform

        import {

          to = ovh_dedicated_server.server

          id = "<service name>"

        }

        You can then run:

        bash

        pulumi preview -generate-config-out=dedicated.tf

        pulumi up

        The file `dedicated.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boot_id: Optional[pulumi.Input[_builtins.float]] = None,
                 boot_script: Optional[pulumi.Input[_builtins.str]] = None,
                 customizations: Optional[pulumi.Input[Union['ServerCustomizationsArgs', 'ServerCustomizationsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 efi_bootloader_path: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_service_after_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_intervention: Optional[pulumi.Input[_builtins.bool]] = None,
                 os: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPlanOptionArgs', 'ServerPlanOptionArgsDict']]]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPlanArgs', 'ServerPlanArgsDict']]]]] = None,
                 prevent_install_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 prevent_install_on_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 rescue_mail: Optional[pulumi.Input[_builtins.str]] = None,
                 rescue_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 root_device: Optional[pulumi.Input[_builtins.str]] = None,
                 run_actions_before_destroys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageArgs', 'ServerStorageArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["boot_id"] = boot_id
            __props__.__dict__["boot_script"] = boot_script
            __props__.__dict__["customizations"] = customizations
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["efi_bootloader_path"] = efi_bootloader_path
            __props__.__dict__["keep_service_after_destroy"] = keep_service_after_destroy
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["no_intervention"] = no_intervention
            __props__.__dict__["os"] = os
            __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
            __props__.__dict__["plan_options"] = plan_options
            __props__.__dict__["plans"] = plans
            __props__.__dict__["prevent_install_on_create"] = prevent_install_on_create
            __props__.__dict__["prevent_install_on_import"] = prevent_install_on_import
            __props__.__dict__["properties"] = properties
            __props__.__dict__["rescue_mail"] = rescue_mail
            __props__.__dict__["rescue_ssh_key"] = rescue_ssh_key
            __props__.__dict__["root_device"] = root_device
            __props__.__dict__["run_actions_before_destroys"] = run_actions_before_destroys
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["state"] = state
            __props__.__dict__["storages"] = storages
            __props__.__dict__["availability_zone"] = None
            __props__.__dict__["commercial_range"] = None
            __props__.__dict__["datacenter"] = None
            __props__.__dict__["iam"] = None
            __props__.__dict__["ip"] = None
            __props__.__dict__["link_speed"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["new_upgrade_system"] = None
            __props__.__dict__["order"] = None
            __props__.__dict__["power_state"] = None
            __props__.__dict__["professional_use"] = None
            __props__.__dict__["rack"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["reverse"] = None
            __props__.__dict__["server_id"] = None
            __props__.__dict__["support_level"] = None
        super(Server, __self__).__init__(
            'ovh:Dedicated/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            boot_id: Optional[pulumi.Input[_builtins.float]] = None,
            boot_script: Optional[pulumi.Input[_builtins.str]] = None,
            commercial_range: Optional[pulumi.Input[_builtins.str]] = None,
            customizations: Optional[pulumi.Input[Union['ServerCustomizationsArgs', 'ServerCustomizationsArgsDict']]] = None,
            datacenter: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            efi_bootloader_path: Optional[pulumi.Input[_builtins.str]] = None,
            iam: Optional[pulumi.Input[Union['ServerIamArgs', 'ServerIamArgsDict']]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            keep_service_after_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            link_speed: Optional[pulumi.Input[_builtins.float]] = None,
            monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            new_upgrade_system: Optional[pulumi.Input[_builtins.bool]] = None,
            no_intervention: Optional[pulumi.Input[_builtins.bool]] = None,
            order: Optional[pulumi.Input[Union['ServerOrderArgs', 'ServerOrderArgsDict']]] = None,
            os: Optional[pulumi.Input[_builtins.str]] = None,
            ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
            plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPlanOptionArgs', 'ServerPlanOptionArgsDict']]]]] = None,
            plans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPlanArgs', 'ServerPlanArgsDict']]]]] = None,
            power_state: Optional[pulumi.Input[_builtins.str]] = None,
            prevent_install_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
            prevent_install_on_import: Optional[pulumi.Input[_builtins.bool]] = None,
            professional_use: Optional[pulumi.Input[_builtins.bool]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            rack: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rescue_mail: Optional[pulumi.Input[_builtins.str]] = None,
            rescue_ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
            reverse: Optional[pulumi.Input[_builtins.str]] = None,
            root_device: Optional[pulumi.Input[_builtins.str]] = None,
            run_actions_before_destroys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            server_id: Optional[pulumi.Input[_builtins.float]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageArgs', 'ServerStorageArgsDict']]]]] = None,
            support_level: Optional[pulumi.Input[_builtins.str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: Dedicated AZ localisation
        :param pulumi.Input[_builtins.float] boot_id: Boot id of the server
        :param pulumi.Input[_builtins.str] boot_script: Boot script of the server
        :param pulumi.Input[_builtins.str] commercial_range: Dedicated server commercial range
        :param pulumi.Input[Union['ServerCustomizationsArgs', 'ServerCustomizationsArgsDict']] customizations: OS reinstallation customizations
        :param pulumi.Input[_builtins.str] datacenter: Dedicated datacenter localisation (bhs1,bhs2,...)
        :param pulumi.Input[_builtins.str] display_name: Resource display name
        :param pulumi.Input[_builtins.str] efi_bootloader_path: Path of the EFI bootloader
        :param pulumi.Input[Union['ServerIamArgs', 'ServerIamArgsDict']] iam: IAM resource information
        :param pulumi.Input[_builtins.str] ip: Dedicated server ip (IPv4)
        :param pulumi.Input[_builtins.bool] keep_service_after_destroy: Whether we should avoid terminating the service when destroying the resource
        :param pulumi.Input[_builtins.float] link_speed: Link speed of the server
        :param pulumi.Input[_builtins.bool] monitoring: Icmp monitoring state
        :param pulumi.Input[_builtins.str] name: Dedicated server name
        :param pulumi.Input[_builtins.bool] no_intervention: Prevent datacenter intervention
        :param pulumi.Input[Union['ServerOrderArgs', 'ServerOrderArgsDict']] order: Details about an Order
        :param pulumi.Input[_builtins.str] os: Operating system
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.str] power_state: Power state of the server (poweron, poweroff)
        :param pulumi.Input[_builtins.bool] prevent_install_on_create: Defines whether the server should not be reinstalled after creating the resource
        :param pulumi.Input[_builtins.bool] prevent_install_on_import: Defines whether the server should not be reinstalled when importing the resource
        :param pulumi.Input[_builtins.bool] professional_use: Does this server have professional use option
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Arbitrary properties to pass to cloud-init's config drive datasource
        :param pulumi.Input[_builtins.str] rack: Rack id of the server
        :param pulumi.Input[_builtins.str] region: Dedicated region localisation
        :param pulumi.Input[_builtins.str] rescue_mail: Rescue mail of the server
        :param pulumi.Input[_builtins.str] rescue_ssh_key: Public SSH Key used in the rescue mode
        :param pulumi.Input[_builtins.str] reverse: Dedicated server reverse
        :param pulumi.Input[_builtins.str] root_device: Root device of the server
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] run_actions_before_destroys: Actions to run before destroying the resource
        :param pulumi.Input[_builtins.float] server_id: Server id
        :param pulumi.Input[_builtins.str] service_name: The service_name of your dedicated server
        :param pulumi.Input[_builtins.str] state: All states a Dedicated can be in (error, hacked, hackedBlocked, ok)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageArgs', 'ServerStorageArgsDict']]]] storages: OS reinstallation storage configurations
        :param pulumi.Input[_builtins.str] support_level: Dedicated server support level (critical, fastpath, gs, pro)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["boot_id"] = boot_id
        __props__.__dict__["boot_script"] = boot_script
        __props__.__dict__["commercial_range"] = commercial_range
        __props__.__dict__["customizations"] = customizations
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["efi_bootloader_path"] = efi_bootloader_path
        __props__.__dict__["iam"] = iam
        __props__.__dict__["ip"] = ip
        __props__.__dict__["keep_service_after_destroy"] = keep_service_after_destroy
        __props__.__dict__["link_speed"] = link_speed
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["name"] = name
        __props__.__dict__["new_upgrade_system"] = new_upgrade_system
        __props__.__dict__["no_intervention"] = no_intervention
        __props__.__dict__["order"] = order
        __props__.__dict__["os"] = os
        __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
        __props__.__dict__["plan_options"] = plan_options
        __props__.__dict__["plans"] = plans
        __props__.__dict__["power_state"] = power_state
        __props__.__dict__["prevent_install_on_create"] = prevent_install_on_create
        __props__.__dict__["prevent_install_on_import"] = prevent_install_on_import
        __props__.__dict__["professional_use"] = professional_use
        __props__.__dict__["properties"] = properties
        __props__.__dict__["rack"] = rack
        __props__.__dict__["region"] = region
        __props__.__dict__["rescue_mail"] = rescue_mail
        __props__.__dict__["rescue_ssh_key"] = rescue_ssh_key
        __props__.__dict__["reverse"] = reverse
        __props__.__dict__["root_device"] = root_device
        __props__.__dict__["run_actions_before_destroys"] = run_actions_before_destroys
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["state"] = state
        __props__.__dict__["storages"] = storages
        __props__.__dict__["support_level"] = support_level
        return Server(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Dedicated AZ localisation
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="bootId")
    def boot_id(self) -> pulumi.Output[_builtins.float]:
        """
        Boot id of the server
        """
        return pulumi.get(self, "boot_id")

    @_builtins.property
    @pulumi.getter(name="bootScript")
    def boot_script(self) -> pulumi.Output[_builtins.str]:
        """
        Boot script of the server
        """
        return pulumi.get(self, "boot_script")

    @_builtins.property
    @pulumi.getter(name="commercialRange")
    def commercial_range(self) -> pulumi.Output[_builtins.str]:
        """
        Dedicated server commercial range
        """
        return pulumi.get(self, "commercial_range")

    @_builtins.property
    @pulumi.getter
    def customizations(self) -> pulumi.Output[Optional['outputs.ServerCustomizations']]:
        """
        OS reinstallation customizations
        """
        return pulumi.get(self, "customizations")

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[_builtins.str]:
        """
        Dedicated datacenter localisation (bhs1,bhs2,...)
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="efiBootloaderPath")
    def efi_bootloader_path(self) -> pulumi.Output[_builtins.str]:
        """
        Path of the EFI bootloader
        """
        return pulumi.get(self, "efi_bootloader_path")

    @_builtins.property
    @pulumi.getter
    def iam(self) -> pulumi.Output['outputs.ServerIam']:
        """
        IAM resource information
        """
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[_builtins.str]:
        """
        Dedicated server ip (IPv4)
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="keepServiceAfterDestroy")
    def keep_service_after_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether we should avoid terminating the service when destroying the resource
        """
        return pulumi.get(self, "keep_service_after_destroy")

    @_builtins.property
    @pulumi.getter(name="linkSpeed")
    def link_speed(self) -> pulumi.Output[_builtins.float]:
        """
        Link speed of the server
        """
        return pulumi.get(self, "link_speed")

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[_builtins.bool]:
        """
        Icmp monitoring state
        """
        return pulumi.get(self, "monitoring")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Dedicated server name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newUpgradeSystem")
    def new_upgrade_system(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "new_upgrade_system")

    @_builtins.property
    @pulumi.getter(name="noIntervention")
    def no_intervention(self) -> pulumi.Output[_builtins.bool]:
        """
        Prevent datacenter intervention
        """
        return pulumi.get(self, "no_intervention")

    @_builtins.property
    @pulumi.getter
    def order(self) -> pulumi.Output['outputs.ServerOrder']:
        """
        Details about an Order
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def os(self) -> pulumi.Output[_builtins.str]:
        """
        Operating system
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OVH subsidiaries
        """
        return pulumi.get(self, "ovh_subsidiary")

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> pulumi.Output[Optional[Sequence['outputs.ServerPlanOption']]]:
        return pulumi.get(self, "plan_options")

    @_builtins.property
    @pulumi.getter
    def plans(self) -> pulumi.Output[Optional[Sequence['outputs.ServerPlan']]]:
        return pulumi.get(self, "plans")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> pulumi.Output[_builtins.str]:
        """
        Power state of the server (poweron, poweroff)
        """
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="preventInstallOnCreate")
    def prevent_install_on_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether the server should not be reinstalled after creating the resource
        """
        return pulumi.get(self, "prevent_install_on_create")

    @_builtins.property
    @pulumi.getter(name="preventInstallOnImport")
    def prevent_install_on_import(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether the server should not be reinstalled when importing the resource
        """
        return pulumi.get(self, "prevent_install_on_import")

    @_builtins.property
    @pulumi.getter(name="professionalUse")
    def professional_use(self) -> pulumi.Output[_builtins.bool]:
        """
        Does this server have professional use option
        """
        return pulumi.get(self, "professional_use")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Arbitrary properties to pass to cloud-init's config drive datasource
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def rack(self) -> pulumi.Output[_builtins.str]:
        """
        Rack id of the server
        """
        return pulumi.get(self, "rack")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Dedicated region localisation
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rescueMail")
    def rescue_mail(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rescue mail of the server
        """
        return pulumi.get(self, "rescue_mail")

    @_builtins.property
    @pulumi.getter(name="rescueSshKey")
    def rescue_ssh_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Public SSH Key used in the rescue mode
        """
        return pulumi.get(self, "rescue_ssh_key")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> pulumi.Output[_builtins.str]:
        """
        Dedicated server reverse
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter(name="rootDevice")
    def root_device(self) -> pulumi.Output[_builtins.str]:
        """
        Root device of the server
        """
        return pulumi.get(self, "root_device")

    @_builtins.property
    @pulumi.getter(name="runActionsBeforeDestroys")
    def run_actions_before_destroys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Actions to run before destroying the resource
        """
        return pulumi.get(self, "run_actions_before_destroys")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.float]:
        """
        Server id
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The service_name of your dedicated server
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        All states a Dedicated can be in (error, hacked, hackedBlocked, ok)
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def storages(self) -> pulumi.Output[Optional[Sequence['outputs.ServerStorage']]]:
        """
        OS reinstallation storage configurations
        """
        return pulumi.get(self, "storages")

    @_builtins.property
    @pulumi.getter(name="supportLevel")
    def support_level(self) -> pulumi.Output[_builtins.str]:
        """
        Dedicated server support level (critical, fastpath, gs, pro)
        """
        return pulumi.get(self, "support_level")

