# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServerRebootTaskArgs', 'ServerRebootTask']

@pulumi.input_type
class ServerRebootTaskArgs:
    def __init__(__self__, *,
                 keepers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 service_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ServerRebootTask resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] keepers: List of values tracked to trigger reboot, used also to form implicit dependencies.
        :param pulumi.Input[_builtins.str] service_name: The service_name of your dedicated server.
        """
        pulumi.set(__self__, "keepers", keepers)
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter
    def keepers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of values tracked to trigger reboot, used also to form implicit dependencies.
        """
        return pulumi.get(self, "keepers")

    @keepers.setter
    def keepers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "keepers", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The service_name of your dedicated server.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _ServerRebootTaskState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 done_date: Optional[pulumi.Input[_builtins.str]] = None,
                 function: Optional[pulumi.Input[_builtins.str]] = None,
                 keepers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 last_update: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_date: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerRebootTask resources.
        :param pulumi.Input[_builtins.str] comment: Details of this task. (should be `Reboot asked`)
        :param pulumi.Input[_builtins.str] done_date: Completion date in RFC3339 format.
        :param pulumi.Input[_builtins.str] function: Function name (should be `hardReboot`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] keepers: List of values tracked to trigger reboot, used also to form implicit dependencies.
        :param pulumi.Input[_builtins.str] last_update: Last update in RFC3339 format.
        :param pulumi.Input[_builtins.str] service_name: The service_name of your dedicated server.
        :param pulumi.Input[_builtins.str] start_date: Task creation date in RFC3339 format.
        :param pulumi.Input[_builtins.str] status: Task status (should be `done`)
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if done_date is not None:
            pulumi.set(__self__, "done_date", done_date)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if keepers is not None:
            pulumi.set(__self__, "keepers", keepers)
        if last_update is not None:
            pulumi.set(__self__, "last_update", last_update)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details of this task. (should be `Reboot asked`)
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="doneDate")
    def done_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Completion date in RFC3339 format.
        """
        return pulumi.get(self, "done_date")

    @done_date.setter
    def done_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "done_date", value)

    @_builtins.property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function name (should be `hardReboot`).
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function", value)

    @_builtins.property
    @pulumi.getter
    def keepers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of values tracked to trigger reboot, used also to form implicit dependencies.
        """
        return pulumi.get(self, "keepers")

    @keepers.setter
    def keepers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "keepers", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update in RFC3339 format.
        """
        return pulumi.get(self, "last_update")

    @last_update.setter
    def last_update(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service_name of your dedicated server.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task creation date in RFC3339 format.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_date", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task status (should be `done`)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("ovh:Dedicated/serverRebootTask:ServerRebootTask")
class ServerRebootTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 keepers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        rescue = ovh.Dedicated.get_server_boots(service_name="nsxxxxxxx.ip-xx-xx-xx.eu",
            boot_type="rescue",
            kernel="rescue64-pro")
        server_on_rescue = ovh.dedicated.ServerUpdate("server_on_rescue",
            service_name="nsxxxxxxx.ip-xx-xx-xx.eu",
            boot_id=rescue.results[0],
            monitoring=True,
            state="ok")
        server_reboot = ovh.dedicated.ServerRebootTask("server_reboot",
            service_name=rescue.service_name,
            keepers=[server_on_rescue.boot_id])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] keepers: List of values tracked to trigger reboot, used also to form implicit dependencies.
        :param pulumi.Input[_builtins.str] service_name: The service_name of your dedicated server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerRebootTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        rescue = ovh.Dedicated.get_server_boots(service_name="nsxxxxxxx.ip-xx-xx-xx.eu",
            boot_type="rescue",
            kernel="rescue64-pro")
        server_on_rescue = ovh.dedicated.ServerUpdate("server_on_rescue",
            service_name="nsxxxxxxx.ip-xx-xx-xx.eu",
            boot_id=rescue.results[0],
            monitoring=True,
            state="ok")
        server_reboot = ovh.dedicated.ServerRebootTask("server_reboot",
            service_name=rescue.service_name,
            keepers=[server_on_rescue.boot_id])
        ```

        :param str resource_name: The name of the resource.
        :param ServerRebootTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerRebootTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 keepers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerRebootTaskArgs.__new__(ServerRebootTaskArgs)

            if keepers is None and not opts.urn:
                raise TypeError("Missing required property 'keepers'")
            __props__.__dict__["keepers"] = keepers
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["comment"] = None
            __props__.__dict__["done_date"] = None
            __props__.__dict__["function"] = None
            __props__.__dict__["last_update"] = None
            __props__.__dict__["start_date"] = None
            __props__.__dict__["status"] = None
        super(ServerRebootTask, __self__).__init__(
            'ovh:Dedicated/serverRebootTask:ServerRebootTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            done_date: Optional[pulumi.Input[_builtins.str]] = None,
            function: Optional[pulumi.Input[_builtins.str]] = None,
            keepers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            last_update: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            start_date: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerRebootTask':
        """
        Get an existing ServerRebootTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Details of this task. (should be `Reboot asked`)
        :param pulumi.Input[_builtins.str] done_date: Completion date in RFC3339 format.
        :param pulumi.Input[_builtins.str] function: Function name (should be `hardReboot`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] keepers: List of values tracked to trigger reboot, used also to form implicit dependencies.
        :param pulumi.Input[_builtins.str] last_update: Last update in RFC3339 format.
        :param pulumi.Input[_builtins.str] service_name: The service_name of your dedicated server.
        :param pulumi.Input[_builtins.str] start_date: Task creation date in RFC3339 format.
        :param pulumi.Input[_builtins.str] status: Task status (should be `done`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerRebootTaskState.__new__(_ServerRebootTaskState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["done_date"] = done_date
        __props__.__dict__["function"] = function
        __props__.__dict__["keepers"] = keepers
        __props__.__dict__["last_update"] = last_update
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["start_date"] = start_date
        __props__.__dict__["status"] = status
        return ServerRebootTask(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[_builtins.str]:
        """
        Details of this task. (should be `Reboot asked`)
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="doneDate")
    def done_date(self) -> pulumi.Output[_builtins.str]:
        """
        Completion date in RFC3339 format.
        """
        return pulumi.get(self, "done_date")

    @_builtins.property
    @pulumi.getter
    def function(self) -> pulumi.Output[_builtins.str]:
        """
        Function name (should be `hardReboot`).
        """
        return pulumi.get(self, "function")

    @_builtins.property
    @pulumi.getter
    def keepers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of values tracked to trigger reboot, used also to form implicit dependencies.
        """
        return pulumi.get(self, "keepers")

    @_builtins.property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> pulumi.Output[_builtins.str]:
        """
        Last update in RFC3339 format.
        """
        return pulumi.get(self, "last_update")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The service_name of your dedicated server.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Output[_builtins.str]:
        """
        Task creation date in RFC3339 format.
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Task status (should be `done`)
        """
        return pulumi.get(self, "status")

