# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NameArgs', 'Name']

@pulumi.input_type
class NameArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[_builtins.str],
                 checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanOptionArgs']]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanArgs']]]] = None,
                 target_spec: Optional[pulumi.Input['NameTargetSpecArgs']] = None):
        """
        The set of arguments for constructing a Name resource.
        :param pulumi.Input[_builtins.str] domain_name: Domain name
        :param pulumi.Input[_builtins.str] checksum: Computed hash used to control concurrent modification requests. Here, it represents the current target specification value
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input['NameTargetSpecArgs'] target_spec: Latest target specification of the domain name resource.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if plans is not None:
            pulumi.set(__self__, "plans", plans)
        if target_spec is not None:
            pulumi.set(__self__, "target_spec", target_spec)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        Domain name
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Computed hash used to control concurrent modification requests. Here, it represents the current target specification value
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum", value)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OVH subsidiaries
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanOptionArgs']]]]:
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanArgs']]]]:
        return pulumi.get(self, "plans")

    @plans.setter
    def plans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanArgs']]]]):
        pulumi.set(self, "plans", value)

    @_builtins.property
    @pulumi.getter(name="targetSpec")
    def target_spec(self) -> Optional[pulumi.Input['NameTargetSpecArgs']]:
        """
        Latest target specification of the domain name resource.
        """
        return pulumi.get(self, "target_spec")

    @target_spec.setter
    def target_spec(self, value: Optional[pulumi.Input['NameTargetSpecArgs']]):
        pulumi.set(self, "target_spec", value)


@pulumi.input_type
class _NameState:
    def __init__(__self__, *,
                 checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 current_state: Optional[pulumi.Input['NameCurrentStateArgs']] = None,
                 current_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['NameCurrentTaskArgs']]]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iam: Optional[pulumi.Input['NameIamArgs']] = None,
                 order: Optional[pulumi.Input['NameOrderArgs']] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanOptionArgs']]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanArgs']]]] = None,
                 resource_status: Optional[pulumi.Input[_builtins.str]] = None,
                 target_spec: Optional[pulumi.Input['NameTargetSpecArgs']] = None):
        """
        Input properties used for looking up and filtering Name resources.
        :param pulumi.Input[_builtins.str] checksum: Computed hash used to control concurrent modification requests. Here, it represents the current target specification value
        :param pulumi.Input['NameCurrentStateArgs'] current_state: Current state of the domain name
        :param pulumi.Input[Sequence[pulumi.Input['NameCurrentTaskArgs']]] current_tasks: Ongoing asynchronous tasks related to the domain name resource
        :param pulumi.Input[_builtins.str] domain_name: Domain name
        :param pulumi.Input['NameIamArgs'] iam: IAM resource metadata
        :param pulumi.Input['NameOrderArgs'] order: Details about an Order
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.str] resource_status: Reflects the readiness of the domain name resource. A new target specification request will be accepted only in `READY`, `UPDATING` or `ERROR` status
        :param pulumi.Input['NameTargetSpecArgs'] target_spec: Latest target specification of the domain name resource.
        """
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if current_state is not None:
            pulumi.set(__self__, "current_state", current_state)
        if current_tasks is not None:
            pulumi.set(__self__, "current_tasks", current_tasks)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if ovh_subsidiary is not None:
            pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if plan_options is not None:
            pulumi.set(__self__, "plan_options", plan_options)
        if plans is not None:
            pulumi.set(__self__, "plans", plans)
        if resource_status is not None:
            pulumi.set(__self__, "resource_status", resource_status)
        if target_spec is not None:
            pulumi.set(__self__, "target_spec", target_spec)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Computed hash used to control concurrent modification requests. Here, it represents the current target specification value
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum", value)

    @_builtins.property
    @pulumi.getter(name="currentState")
    def current_state(self) -> Optional[pulumi.Input['NameCurrentStateArgs']]:
        """
        Current state of the domain name
        """
        return pulumi.get(self, "current_state")

    @current_state.setter
    def current_state(self, value: Optional[pulumi.Input['NameCurrentStateArgs']]):
        pulumi.set(self, "current_state", value)

    @_builtins.property
    @pulumi.getter(name="currentTasks")
    def current_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NameCurrentTaskArgs']]]]:
        """
        Ongoing asynchronous tasks related to the domain name resource
        """
        return pulumi.get(self, "current_tasks")

    @current_tasks.setter
    def current_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NameCurrentTaskArgs']]]]):
        pulumi.set(self, "current_tasks", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input['NameIamArgs']]:
        """
        IAM resource metadata
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input['NameIamArgs']]):
        pulumi.set(self, "iam", value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input['NameOrderArgs']]:
        """
        Details about an Order
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input['NameOrderArgs']]):
        pulumi.set(self, "order", value)

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OVH subsidiaries
        """
        return pulumi.get(self, "ovh_subsidiary")

    @ovh_subsidiary.setter
    def ovh_subsidiary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ovh_subsidiary", value)

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanOptionArgs']]]]:
        return pulumi.get(self, "plan_options")

    @plan_options.setter
    def plan_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanOptionArgs']]]]):
        pulumi.set(self, "plan_options", value)

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanArgs']]]]:
        return pulumi.get(self, "plans")

    @plans.setter
    def plans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamePlanArgs']]]]):
        pulumi.set(self, "plans", value)

    @_builtins.property
    @pulumi.getter(name="resourceStatus")
    def resource_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reflects the readiness of the domain name resource. A new target specification request will be accepted only in `READY`, `UPDATING` or `ERROR` status
        """
        return pulumi.get(self, "resource_status")

    @resource_status.setter
    def resource_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_status", value)

    @_builtins.property
    @pulumi.getter(name="targetSpec")
    def target_spec(self) -> Optional[pulumi.Input['NameTargetSpecArgs']]:
        """
        Latest target specification of the domain name resource.
        """
        return pulumi.get(self, "target_spec")

    @target_spec.setter
    def target_spec(self, value: Optional[pulumi.Input['NameTargetSpecArgs']]):
        pulumi.set(self, "target_spec", value)


@pulumi.type_token("ovh:Domain/name:Name")
class Name(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamePlanOptionArgs', 'NamePlanOptionArgsDict']]]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamePlanArgs', 'NamePlanArgsDict']]]]] = None,
                 target_spec: Optional[pulumi.Input[Union['NameTargetSpecArgs', 'NameTargetSpecArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] checksum: Computed hash used to control concurrent modification requests. Here, it represents the current target specification value
        :param pulumi.Input[_builtins.str] domain_name: Domain name
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[Union['NameTargetSpecArgs', 'NameTargetSpecArgsDict']] target_spec: Latest target specification of the domain name resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NameArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param NameArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NameArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamePlanOptionArgs', 'NamePlanOptionArgsDict']]]]] = None,
                 plans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamePlanArgs', 'NamePlanArgsDict']]]]] = None,
                 target_spec: Optional[pulumi.Input[Union['NameTargetSpecArgs', 'NameTargetSpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NameArgs.__new__(NameArgs)

            __props__.__dict__["checksum"] = checksum
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
            __props__.__dict__["plan_options"] = plan_options
            __props__.__dict__["plans"] = plans
            __props__.__dict__["target_spec"] = target_spec
            __props__.__dict__["current_state"] = None
            __props__.__dict__["current_tasks"] = None
            __props__.__dict__["iam"] = None
            __props__.__dict__["order"] = None
            __props__.__dict__["resource_status"] = None
        super(Name, __self__).__init__(
            'ovh:Domain/name:Name',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checksum: Optional[pulumi.Input[_builtins.str]] = None,
            current_state: Optional[pulumi.Input[Union['NameCurrentStateArgs', 'NameCurrentStateArgsDict']]] = None,
            current_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NameCurrentTaskArgs', 'NameCurrentTaskArgsDict']]]]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            iam: Optional[pulumi.Input[Union['NameIamArgs', 'NameIamArgsDict']]] = None,
            order: Optional[pulumi.Input[Union['NameOrderArgs', 'NameOrderArgsDict']]] = None,
            ovh_subsidiary: Optional[pulumi.Input[_builtins.str]] = None,
            plan_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamePlanOptionArgs', 'NamePlanOptionArgsDict']]]]] = None,
            plans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamePlanArgs', 'NamePlanArgsDict']]]]] = None,
            resource_status: Optional[pulumi.Input[_builtins.str]] = None,
            target_spec: Optional[pulumi.Input[Union['NameTargetSpecArgs', 'NameTargetSpecArgsDict']]] = None) -> 'Name':
        """
        Get an existing Name resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] checksum: Computed hash used to control concurrent modification requests. Here, it represents the current target specification value
        :param pulumi.Input[Union['NameCurrentStateArgs', 'NameCurrentStateArgsDict']] current_state: Current state of the domain name
        :param pulumi.Input[Sequence[pulumi.Input[Union['NameCurrentTaskArgs', 'NameCurrentTaskArgsDict']]]] current_tasks: Ongoing asynchronous tasks related to the domain name resource
        :param pulumi.Input[_builtins.str] domain_name: Domain name
        :param pulumi.Input[Union['NameIamArgs', 'NameIamArgsDict']] iam: IAM resource metadata
        :param pulumi.Input[Union['NameOrderArgs', 'NameOrderArgsDict']] order: Details about an Order
        :param pulumi.Input[_builtins.str] ovh_subsidiary: OVH subsidiaries
        :param pulumi.Input[_builtins.str] resource_status: Reflects the readiness of the domain name resource. A new target specification request will be accepted only in `READY`, `UPDATING` or `ERROR` status
        :param pulumi.Input[Union['NameTargetSpecArgs', 'NameTargetSpecArgsDict']] target_spec: Latest target specification of the domain name resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NameState.__new__(_NameState)

        __props__.__dict__["checksum"] = checksum
        __props__.__dict__["current_state"] = current_state
        __props__.__dict__["current_tasks"] = current_tasks
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["iam"] = iam
        __props__.__dict__["order"] = order
        __props__.__dict__["ovh_subsidiary"] = ovh_subsidiary
        __props__.__dict__["plan_options"] = plan_options
        __props__.__dict__["plans"] = plans
        __props__.__dict__["resource_status"] = resource_status
        __props__.__dict__["target_spec"] = target_spec
        return Name(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> pulumi.Output[_builtins.str]:
        """
        Computed hash used to control concurrent modification requests. Here, it represents the current target specification value
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="currentState")
    def current_state(self) -> pulumi.Output['outputs.NameCurrentState']:
        """
        Current state of the domain name
        """
        return pulumi.get(self, "current_state")

    @_builtins.property
    @pulumi.getter(name="currentTasks")
    def current_tasks(self) -> pulumi.Output[Sequence['outputs.NameCurrentTask']]:
        """
        Ongoing asynchronous tasks related to the domain name resource
        """
        return pulumi.get(self, "current_tasks")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Domain name
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def iam(self) -> pulumi.Output['outputs.NameIam']:
        """
        IAM resource metadata
        """
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter
    def order(self) -> pulumi.Output['outputs.NameOrder']:
        """
        Details about an Order
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OVH subsidiaries
        """
        return pulumi.get(self, "ovh_subsidiary")

    @_builtins.property
    @pulumi.getter(name="planOptions")
    def plan_options(self) -> pulumi.Output[Optional[Sequence['outputs.NamePlanOption']]]:
        return pulumi.get(self, "plan_options")

    @_builtins.property
    @pulumi.getter
    def plans(self) -> pulumi.Output[Optional[Sequence['outputs.NamePlan']]]:
        return pulumi.get(self, "plans")

    @_builtins.property
    @pulumi.getter(name="resourceStatus")
    def resource_status(self) -> pulumi.Output[_builtins.str]:
        """
        Reflects the readiness of the domain name resource. A new target specification request will be accepted only in `READY`, `UPDATING` or `ERROR` status
        """
        return pulumi.get(self, "resource_status")

    @_builtins.property
    @pulumi.getter(name="targetSpec")
    def target_spec(self) -> pulumi.Output['outputs.NameTargetSpec']:
        """
        Latest target specification of the domain name resource.
        """
        return pulumi.get(self, "target_spec")

