# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NameServersArgs', 'NameServers']

@pulumi.input_type
class NameServersArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 servers: pulumi.Input[Sequence[pulumi.Input['NameServersServerArgs']]]):
        """
        The set of arguments for constructing a NameServers resource.
        :param pulumi.Input[_builtins.str] domain: Domain name for which to manage name servers
        :param pulumi.Input[Sequence[pulumi.Input['NameServersServerArgs']]] servers: Details about a name server
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "servers", servers)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        Domain name for which to manage name servers
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input['NameServersServerArgs']]]:
        """
        Details about a name server
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input['NameServersServerArgs']]]):
        pulumi.set(self, "servers", value)


@pulumi.input_type
class _NameServersState:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['NameServersServerArgs']]]] = None):
        """
        Input properties used for looking up and filtering NameServers resources.
        :param pulumi.Input[_builtins.str] domain: Domain name for which to manage name servers
        :param pulumi.Input[Sequence[pulumi.Input['NameServersServerArgs']]] servers: Details about a name server
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name for which to manage name servers
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NameServersServerArgs']]]]:
        """
        Details about a name server
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NameServersServerArgs']]]]):
        pulumi.set(self, "servers", value)


@pulumi.type_token("ovh:Domain/nameServers:NameServers")
class NameServers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NameServersServerArgs', 'NameServersServerArgsDict']]]]] = None,
                 __props__=None):
        """
        Use this resource to manage a domain's name servers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        name_servers = ovh.domain.NameServers("name_servers",
            domain="mydomain.ovh",
            servers=[
                {
                    "host": "dns105.ovh.net",
                    "ip": "213.251.188.144",
                },
                {
                    "host": "ns105.ovh.net",
                },
            ])
        ```

        ## Import

        Name servers can be imported using their `domain`.

        Using the following configuration:

        terraform

        import {

          to = ovh_domain_name_servers.name_servers

          id = "<domain name>"

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=name_servers.tf

        $ pulumi up

        The file `name_servers.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: Domain name for which to manage name servers
        :param pulumi.Input[Sequence[pulumi.Input[Union['NameServersServerArgs', 'NameServersServerArgsDict']]]] servers: Details about a name server
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NameServersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to manage a domain's name servers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        name_servers = ovh.domain.NameServers("name_servers",
            domain="mydomain.ovh",
            servers=[
                {
                    "host": "dns105.ovh.net",
                    "ip": "213.251.188.144",
                },
                {
                    "host": "ns105.ovh.net",
                },
            ])
        ```

        ## Import

        Name servers can be imported using their `domain`.

        Using the following configuration:

        terraform

        import {

          to = ovh_domain_name_servers.name_servers

          id = "<domain name>"

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=name_servers.tf

        $ pulumi up

        The file `name_servers.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param NameServersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NameServersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NameServersServerArgs', 'NameServersServerArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NameServersArgs.__new__(NameServersArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if servers is None and not opts.urn:
                raise TypeError("Missing required property 'servers'")
            __props__.__dict__["servers"] = servers
        super(NameServers, __self__).__init__(
            'ovh:Domain/nameServers:NameServers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NameServersServerArgs', 'NameServersServerArgsDict']]]]] = None) -> 'NameServers':
        """
        Get an existing NameServers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: Domain name for which to manage name servers
        :param pulumi.Input[Sequence[pulumi.Input[Union['NameServersServerArgs', 'NameServersServerArgsDict']]]] servers: Details about a name server
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NameServersState.__new__(_NameServersState)

        __props__.__dict__["domain"] = domain
        __props__.__dict__["servers"] = servers
        return NameServers(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        Domain name for which to manage name servers
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Sequence['outputs.NameServersServer']]:
        """
        Details about a name server
        """
        return pulumi.get(self, "servers")

