# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DSRecordsDsRecord',
    'NameCurrentState',
    'NameCurrentStateDnsConfiguration',
    'NameCurrentStateDnsConfigurationNameServer',
    'NameCurrentTask',
    'NameIam',
    'NameOrder',
    'NameOrderDetail',
    'NamePlan',
    'NamePlanConfiguration',
    'NamePlanOption',
    'NamePlanOptionConfiguration',
    'NameServersServer',
    'NameTargetSpec',
    'NameTargetSpecDnsConfiguration',
    'NameTargetSpecDnsConfigurationNameServer',
    'ZoneOrder',
    'ZoneOrderDetail',
    'ZonePlan',
    'ZonePlanConfiguration',
    'ZonePlanOption',
    'ZonePlanOptionConfiguration',
]

@pulumi.output_type
class DSRecordsDsRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DSRecordsDsRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DSRecordsDsRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DSRecordsDsRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 flags: _builtins.str,
                 public_key: _builtins.str,
                 tag: _builtins.int):
        """
        :param _builtins.str algorithm: The record algorithm (`RSASHA1`, `RSASHA1_NSEC3_SHA1`, `RSASHA256`, `RSASHA512`, `ECDSAP256SHA256`, `ECDSAP384SHA384`, `ED25519`)
        :param _builtins.str flags: The record flag (`ZONE_SIGNING_KEY`, `KEY_SIGNING_KEY`)
        :param _builtins.str public_key: The record base64 encoded public key
        :param _builtins.int tag: The record tag
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        The record algorithm (`RSASHA1`, `RSASHA1_NSEC3_SHA1`, `RSASHA256`, `RSASHA512`, `ECDSAP256SHA256`, `ECDSAP384SHA384`, `ED25519`)
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> _builtins.str:
        """
        The record flag (`ZONE_SIGNING_KEY`, `KEY_SIGNING_KEY`)
        """
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The record base64 encoded public key
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.int:
        """
        The record tag
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class NameCurrentState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalStates":
            suggest = "additional_states"
        elif key == "dnsConfiguration":
            suggest = "dns_configuration"
        elif key == "mainState":
            suggest = "main_state"
        elif key == "protectionState":
            suggest = "protection_state"
        elif key == "suspensionState":
            suggest = "suspension_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NameCurrentState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NameCurrentState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NameCurrentState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_states: Optional[Sequence[_builtins.str]] = None,
                 dns_configuration: Optional['outputs.NameCurrentStateDnsConfiguration'] = None,
                 extension: Optional[_builtins.str] = None,
                 main_state: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 protection_state: Optional[_builtins.str] = None,
                 suspension_state: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] additional_states: Domain additional states
        :param 'NameCurrentStateDnsConfigurationArgs' dns_configuration: The domain DNS configuration
        :param _builtins.str extension: Extension of the domain name
        :param _builtins.str main_state: Domain main state
        :param _builtins.str name: Domain name
        :param _builtins.str protection_state: Domain protection state
        :param _builtins.str suspension_state: Domain suspension state
        """
        if additional_states is not None:
            pulumi.set(__self__, "additional_states", additional_states)
        if dns_configuration is not None:
            pulumi.set(__self__, "dns_configuration", dns_configuration)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if main_state is not None:
            pulumi.set(__self__, "main_state", main_state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if suspension_state is not None:
            pulumi.set(__self__, "suspension_state", suspension_state)

    @_builtins.property
    @pulumi.getter(name="additionalStates")
    def additional_states(self) -> Optional[Sequence[_builtins.str]]:
        """
        Domain additional states
        """
        return pulumi.get(self, "additional_states")

    @_builtins.property
    @pulumi.getter(name="dnsConfiguration")
    def dns_configuration(self) -> Optional['outputs.NameCurrentStateDnsConfiguration']:
        """
        The domain DNS configuration
        """
        return pulumi.get(self, "dns_configuration")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[_builtins.str]:
        """
        Extension of the domain name
        """
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter(name="mainState")
    def main_state(self) -> Optional[_builtins.str]:
        """
        Domain main state
        """
        return pulumi.get(self, "main_state")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Domain name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[_builtins.str]:
        """
        Domain protection state
        """
        return pulumi.get(self, "protection_state")

    @_builtins.property
    @pulumi.getter(name="suspensionState")
    def suspension_state(self) -> Optional[_builtins.str]:
        """
        Domain suspension state
        """
        return pulumi.get(self, "suspension_state")


@pulumi.output_type
class NameCurrentStateDnsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "glueRecordIpv6supported":
            suggest = "glue_record_ipv6supported"
        elif key == "hostSupported":
            suggest = "host_supported"
        elif key == "maxDns":
            suggest = "max_dns"
        elif key == "minDns":
            suggest = "min_dns"
        elif key == "nameServers":
            suggest = "name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NameCurrentStateDnsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NameCurrentStateDnsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NameCurrentStateDnsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: Optional[_builtins.str] = None,
                 glue_record_ipv6supported: Optional[_builtins.bool] = None,
                 host_supported: Optional[_builtins.bool] = None,
                 max_dns: Optional[_builtins.float] = None,
                 min_dns: Optional[_builtins.float] = None,
                 name_servers: Optional[Sequence['outputs.NameCurrentStateDnsConfigurationNameServer']] = None):
        """
        :param _builtins.str configuration_type: The type of DNS configuration of the domain
        :param _builtins.bool glue_record_ipv6supported: Whether the registry supports IPv6 or not
        :param _builtins.bool host_supported: Whether the registry accepts hosts or not
        :param _builtins.float max_dns: The maximum number of name servers allowed by the registry
        :param _builtins.float min_dns: The minimum number of name servers allowed by the registry
        :param Sequence['NameCurrentStateDnsConfigurationNameServerArgs'] name_servers: The name servers used by the domain name
        """
        if configuration_type is not None:
            pulumi.set(__self__, "configuration_type", configuration_type)
        if glue_record_ipv6supported is not None:
            pulumi.set(__self__, "glue_record_ipv6supported", glue_record_ipv6supported)
        if host_supported is not None:
            pulumi.set(__self__, "host_supported", host_supported)
        if max_dns is not None:
            pulumi.set(__self__, "max_dns", max_dns)
        if min_dns is not None:
            pulumi.set(__self__, "min_dns", min_dns)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)

    @_builtins.property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> Optional[_builtins.str]:
        """
        The type of DNS configuration of the domain
        """
        return pulumi.get(self, "configuration_type")

    @_builtins.property
    @pulumi.getter(name="glueRecordIpv6supported")
    def glue_record_ipv6supported(self) -> Optional[_builtins.bool]:
        """
        Whether the registry supports IPv6 or not
        """
        return pulumi.get(self, "glue_record_ipv6supported")

    @_builtins.property
    @pulumi.getter(name="hostSupported")
    def host_supported(self) -> Optional[_builtins.bool]:
        """
        Whether the registry accepts hosts or not
        """
        return pulumi.get(self, "host_supported")

    @_builtins.property
    @pulumi.getter(name="maxDns")
    def max_dns(self) -> Optional[_builtins.float]:
        """
        The maximum number of name servers allowed by the registry
        """
        return pulumi.get(self, "max_dns")

    @_builtins.property
    @pulumi.getter(name="minDns")
    def min_dns(self) -> Optional[_builtins.float]:
        """
        The minimum number of name servers allowed by the registry
        """
        return pulumi.get(self, "min_dns")

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[Sequence['outputs.NameCurrentStateDnsConfigurationNameServer']]:
        """
        The name servers used by the domain name
        """
        return pulumi.get(self, "name_servers")


@pulumi.output_type
class NameCurrentStateDnsConfigurationNameServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameServer":
            suggest = "name_server"
        elif key == "nameServerType":
            suggest = "name_server_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NameCurrentStateDnsConfigurationNameServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NameCurrentStateDnsConfigurationNameServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NameCurrentStateDnsConfigurationNameServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4: Optional[_builtins.str] = None,
                 ipv6: Optional[_builtins.str] = None,
                 name_server: Optional[_builtins.str] = None,
                 name_server_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str ipv4: The IPv4 associated to the name server
        :param _builtins.str ipv6: The IPv6 associated to the name server
        :param _builtins.str name_server: The host name
        :param _builtins.str name_server_type: The type of name server
        """
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if name_server is not None:
            pulumi.set(__self__, "name_server", name_server)
        if name_server_type is not None:
            pulumi.set(__self__, "name_server_type", name_server_type)

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> Optional[_builtins.str]:
        """
        The IPv4 associated to the name server
        """
        return pulumi.get(self, "ipv4")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[_builtins.str]:
        """
        The IPv6 associated to the name server
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter(name="nameServer")
    def name_server(self) -> Optional[_builtins.str]:
        """
        The host name
        """
        return pulumi.get(self, "name_server")

    @_builtins.property
    @pulumi.getter(name="nameServerType")
    def name_server_type(self) -> Optional[_builtins.str]:
        """
        The type of name server
        """
        return pulumi.get(self, "name_server_type")


@pulumi.output_type
class NameCurrentTask(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 link: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Identifier of the current task
        :param _builtins.str link: Link to the task details
        :param _builtins.str status: Current global status of the current task
        :param _builtins.str type: Type of the current task
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Identifier of the current task
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def link(self) -> Optional[_builtins.str]:
        """
        Link to the task details
        """
        return pulumi.get(self, "link")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Current global status of the current task
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the current task
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NameIam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NameIam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NameIam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NameIam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 urn: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: Resource display name
        :param _builtins.str id: Unique identifier of the resource
        :param Mapping[str, _builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with ovh:
        :param _builtins.str urn: Unique resource name used in policies
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Resource tags. Tags that were internally computed are prefixed with ovh:
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> Optional[_builtins.str]:
        """
        Unique resource name used in policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class NameOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NameOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NameOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NameOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[_builtins.str] = None,
                 details: Optional[Sequence['outputs.NameOrderDetail']] = None,
                 expiration_date: Optional[_builtins.str] = None,
                 order_id: Optional[_builtins.float] = None):
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @_builtins.property
    @pulumi.getter
    def date(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "date")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.NameOrderDetail']]:
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "expiration_date")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "order_id")


@pulumi.output_type
class NameOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailType":
            suggest = "detail_type"
        elif key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NameOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NameOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NameOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 detail_type: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 order_detail_id: Optional[_builtins.float] = None,
                 quantity: Optional[_builtins.str] = None):
        """
        :param _builtins.str detail_type: Product type of item in order
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detail_type is not None:
            pulumi.set(__self__, "detail_type", detail_type)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> Optional[_builtins.str]:
        """
        Product type of item in order
        """
        return pulumi.get(self, "detail_type")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "order_detail_id")

    @_builtins.property
    @pulumi.getter
    def quantity(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "quantity")


@pulumi.output_type
class NamePlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "itemId":
            suggest = "item_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamePlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamePlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamePlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 configurations: Optional[Sequence['outputs.NamePlanConfiguration']] = None,
                 item_id: Optional[_builtins.float] = None,
                 quantity: Optional[_builtins.float] = None):
        """
        :param _builtins.str duration: Duration selected for the purchase of the product (defaults to "P1Y")
        :param _builtins.str plan_code: Identifier of the option offer
        :param _builtins.str pricing_mode: Pricing mode selected for the purchase of the product
        :param _builtins.float item_id: Cart item to be linked
        :param _builtins.float quantity: Quantity of product desired
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if item_id is not None:
            pulumi.set(__self__, "item_id", item_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Duration selected for the purchase of the product (defaults to "P1Y")
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Identifier of the option offer
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing mode selected for the purchase of the product
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.NamePlanConfiguration']]:
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[_builtins.float]:
        """
        Cart item to be linked
        """
        return pulumi.get(self, "item_id")

    @_builtins.property
    @pulumi.getter
    def quantity(self) -> Optional[_builtins.float]:
        """
        Quantity of product desired
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class NamePlanConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Label for your configuration item
        :param _builtins.str value: Value or resource URL on API.OVH.COM of your configuration item
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label for your configuration item
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value or resource URL on API.OVH.COM of your configuration item
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NamePlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamePlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamePlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamePlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 quantity: _builtins.float,
                 configurations: Optional[Sequence['outputs.NamePlanOptionConfiguration']] = None):
        """
        :param _builtins.str duration: Duration selected for the purchase of the product
        :param _builtins.str plan_code: Identifier of the option offer
        :param _builtins.str pricing_mode: Pricing mode selected for the purchase of the product
        :param _builtins.float quantity: Quantity of product desired
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        pulumi.set(__self__, "quantity", quantity)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Duration selected for the purchase of the product
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Identifier of the option offer
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing mode selected for the purchase of the product
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter
    def quantity(self) -> _builtins.float:
        """
        Quantity of product desired
        """
        return pulumi.get(self, "quantity")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.NamePlanOptionConfiguration']]:
        return pulumi.get(self, "configurations")


@pulumi.output_type
class NamePlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Label for your configuration item
        :param _builtins.str value: Value or resource URL on API.OVH.COM of your configuration item
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Label for your configuration item
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value or resource URL on API.OVH.COM of your configuration item
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NameServersServer(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str host: The server hostname
        :param _builtins.str ip: The server IP
        """
        pulumi.set(__self__, "host", host)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The server hostname
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        The server IP
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class NameTargetSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsConfiguration":
            suggest = "dns_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NameTargetSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NameTargetSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NameTargetSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_configuration: Optional['outputs.NameTargetSpecDnsConfiguration'] = None):
        """
        :param 'NameTargetSpecDnsConfigurationArgs' dns_configuration: The domain DNS configuration
        """
        if dns_configuration is not None:
            pulumi.set(__self__, "dns_configuration", dns_configuration)

    @_builtins.property
    @pulumi.getter(name="dnsConfiguration")
    def dns_configuration(self) -> Optional['outputs.NameTargetSpecDnsConfiguration']:
        """
        The domain DNS configuration
        """
        return pulumi.get(self, "dns_configuration")


@pulumi.output_type
class NameTargetSpecDnsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameServers":
            suggest = "name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NameTargetSpecDnsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NameTargetSpecDnsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NameTargetSpecDnsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name_servers: Optional[Sequence['outputs.NameTargetSpecDnsConfigurationNameServer']] = None):
        """
        :param Sequence['NameTargetSpecDnsConfigurationNameServerArgs'] name_servers: The name servers to update
        """
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[Sequence['outputs.NameTargetSpecDnsConfigurationNameServer']]:
        """
        The name servers to update
        """
        return pulumi.get(self, "name_servers")


@pulumi.output_type
class NameTargetSpecDnsConfigurationNameServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameServer":
            suggest = "name_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NameTargetSpecDnsConfigurationNameServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NameTargetSpecDnsConfigurationNameServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NameTargetSpecDnsConfigurationNameServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4: Optional[_builtins.str] = None,
                 ipv6: Optional[_builtins.str] = None,
                 name_server: Optional[_builtins.str] = None):
        """
        :param _builtins.str ipv4: The IPv4 associated to the name server
        :param _builtins.str ipv6: The IPv6 associated to the name server
        :param _builtins.str name_server: The host name
        """
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if name_server is not None:
            pulumi.set(__self__, "name_server", name_server)

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> Optional[_builtins.str]:
        """
        The IPv4 associated to the name server
        """
        return pulumi.get(self, "ipv4")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[_builtins.str]:
        """
        The IPv6 associated to the name server
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter(name="nameServer")
    def name_server(self) -> Optional[_builtins.str]:
        """
        The host name
        """
        return pulumi.get(self, "name_server")


@pulumi.output_type
class ZoneOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[_builtins.str] = None,
                 details: Optional[Sequence['outputs.ZoneOrderDetail']] = None,
                 expiration_date: Optional[_builtins.str] = None,
                 order_id: Optional[_builtins.int] = None):
        """
        :param _builtins.str date: date
        :param Sequence['ZoneOrderDetailArgs'] details: Information about a Bill entry
        :param _builtins.str expiration_date: expiration date
        :param _builtins.int order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @_builtins.property
    @pulumi.getter
    def date(self) -> Optional[_builtins.str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ZoneOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[_builtins.str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[_builtins.int]:
        """
        order id
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class ZoneOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 order_detail_id: Optional[_builtins.int] = None,
                 quantity: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: description
        :param _builtins.str domain: expiration date
        :param _builtins.int order_detail_id: order detail id
        :param _builtins.str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[_builtins.int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @_builtins.property
    @pulumi.getter
    def quantity(self) -> Optional[_builtins.str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class ZonePlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZonePlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZonePlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZonePlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 catalog_name: Optional[_builtins.str] = None,
                 configurations: Optional[Sequence['outputs.ZonePlanConfiguration']] = None):
        """
        :param _builtins.str duration: duration
        :param _builtins.str plan_code: Plan code
        :param _builtins.str pricing_mode: Pricing model identifier
        :param _builtins.str catalog_name: Catalog name
        :param Sequence['ZonePlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product. 2 configurations are required : one for `zone` and one for `template`
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[_builtins.str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ZonePlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product. 2 configurations are required : one for `zone` and one for `template`
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class ZonePlanConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Identifier of the resource : `zone` or `template`
        :param _builtins.str value: For `zone`, the value is the zone name `myzone.example.com`. For `template`, the value can be `basic`, `minimized` or `redirect` which is the same as `minimized` with additional entries for a redirect configuration.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Identifier of the resource : `zone` or `template`
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        For `zone`, the value is the zone name `myzone.example.com`. For `template`, the value can be `basic`, `minimized` or `redirect` which is the same as `minimized` with additional entries for a redirect configuration.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ZonePlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZonePlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZonePlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZonePlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 catalog_name: Optional[_builtins.str] = None,
                 configurations: Optional[Sequence['outputs.ZonePlanOptionConfiguration']] = None):
        """
        :param _builtins.str duration: duration
        :param _builtins.str plan_code: Plan code
        :param _builtins.str pricing_mode: Pricing model identifier
        :param _builtins.str catalog_name: Catalog name
        :param Sequence['ZonePlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[_builtins.str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ZonePlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class ZonePlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Identifier of the resource
        :param _builtins.str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


