# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DomainZoneDynhostRecordArgs', 'DomainZoneDynhostRecord']

@pulumi.input_type
class DomainZoneDynhostRecordArgs:
    def __init__(__self__, *,
                 zone_name: pulumi.Input[_builtins.str],
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_domain: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DomainZoneDynhostRecord resource.
        :param pulumi.Input[_builtins.str] zone_name: Zone name
        :param pulumi.Input[_builtins.str] ip: Record IP
        :param pulumi.Input[_builtins.str] sub_domain: Record sub-domain
        """
        pulumi.set(__self__, "zone_name", zone_name)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if sub_domain is not None:
            pulumi.set(__self__, "sub_domain", sub_domain)

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> pulumi.Input[_builtins.str]:
        """
        Zone name
        """
        return pulumi.get(self, "zone_name")

    @zone_name.setter
    def zone_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_name", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record IP
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record sub-domain
        """
        return pulumi.get(self, "sub_domain")

    @sub_domain.setter
    def sub_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_domain", value)


@pulumi.input_type
class _DomainZoneDynhostRecordState:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainZoneDynhostRecord resources.
        :param pulumi.Input[_builtins.str] ip: Record IP
        :param pulumi.Input[_builtins.str] sub_domain: Record sub-domain
        :param pulumi.Input[_builtins.float] ttl: Record TTL (Time to Live)
        :param pulumi.Input[_builtins.str] zone: Record zone
        :param pulumi.Input[_builtins.str] zone_name: Zone name
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if sub_domain is not None:
            pulumi.set(__self__, "sub_domain", sub_domain)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)
        if zone_name is not None:
            pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record IP
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record sub-domain
        """
        return pulumi.get(self, "sub_domain")

    @sub_domain.setter
    def sub_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_domain", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Record TTL (Time to Live)
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record zone
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone name
        """
        return pulumi.get(self, "zone_name")

    @zone_name.setter
    def zone_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_name", value)


@pulumi.type_token("ovh:index/domainZoneDynhostRecord:DomainZoneDynhostRecord")
class DomainZoneDynhostRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a dynhost record for a given domain zone.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        dynhost_record = ovh.DomainZoneDynhostRecord("dynhost_record",
            zone_name="mydomain.ovh",
            sub_domain="dynhost",
            ip="1.2.3.4")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ip: Record IP
        :param pulumi.Input[_builtins.str] sub_domain: Record sub-domain
        :param pulumi.Input[_builtins.str] zone_name: Zone name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainZoneDynhostRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a dynhost record for a given domain zone.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        dynhost_record = ovh.DomainZoneDynhostRecord("dynhost_record",
            zone_name="mydomain.ovh",
            sub_domain="dynhost",
            ip="1.2.3.4")
        ```

        :param str resource_name: The name of the resource.
        :param DomainZoneDynhostRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainZoneDynhostRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainZoneDynhostRecordArgs.__new__(DomainZoneDynhostRecordArgs)

            __props__.__dict__["ip"] = ip
            __props__.__dict__["sub_domain"] = sub_domain
            if zone_name is None and not opts.urn:
                raise TypeError("Missing required property 'zone_name'")
            __props__.__dict__["zone_name"] = zone_name
            __props__.__dict__["ttl"] = None
            __props__.__dict__["zone"] = None
        super(DomainZoneDynhostRecord, __self__).__init__(
            'ovh:index/domainZoneDynhostRecord:DomainZoneDynhostRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            sub_domain: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.float]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None,
            zone_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'DomainZoneDynhostRecord':
        """
        Get an existing DomainZoneDynhostRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ip: Record IP
        :param pulumi.Input[_builtins.str] sub_domain: Record sub-domain
        :param pulumi.Input[_builtins.float] ttl: Record TTL (Time to Live)
        :param pulumi.Input[_builtins.str] zone: Record zone
        :param pulumi.Input[_builtins.str] zone_name: Zone name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainZoneDynhostRecordState.__new__(_DomainZoneDynhostRecordState)

        __props__.__dict__["ip"] = ip
        __props__.__dict__["sub_domain"] = sub_domain
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["zone"] = zone
        __props__.__dict__["zone_name"] = zone_name
        return DomainZoneDynhostRecord(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[_builtins.str]:
        """
        Record IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> pulumi.Output[_builtins.str]:
        """
        Record sub-domain
        """
        return pulumi.get(self, "sub_domain")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.float]:
        """
        Record TTL (Time to Live)
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        Record zone
        """
        return pulumi.get(self, "zone")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> pulumi.Output[_builtins.str]:
        """
        Zone name
        """
        return pulumi.get(self, "zone_name")

