# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPrivateDatabaseResult',
    'AwaitableGetPrivateDatabaseResult',
    'get_private_database',
    'get_private_database_output',
]

@pulumi.output_type
class GetPrivateDatabaseResult:
    """
    A collection of values returned by getPrivateDatabase.
    """
    def __init__(__self__, cpu=None, datacenter=None, display_name=None, hostname=None, hostname_ftp=None, id=None, infrastructure=None, offer=None, port=None, port_ftp=None, quota_size=None, quota_used=None, ram=None, server=None, service_name=None, state=None, type=None, urn=None, version=None, version_label=None, version_number=None):
        if cpu and not isinstance(cpu, int):
            raise TypeError("Expected argument 'cpu' to be a int")
        pulumi.set(__self__, "cpu", cpu)
        if datacenter and not isinstance(datacenter, str):
            raise TypeError("Expected argument 'datacenter' to be a str")
        pulumi.set(__self__, "datacenter", datacenter)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if hostname_ftp and not isinstance(hostname_ftp, str):
            raise TypeError("Expected argument 'hostname_ftp' to be a str")
        pulumi.set(__self__, "hostname_ftp", hostname_ftp)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infrastructure and not isinstance(infrastructure, str):
            raise TypeError("Expected argument 'infrastructure' to be a str")
        pulumi.set(__self__, "infrastructure", infrastructure)
        if offer and not isinstance(offer, str):
            raise TypeError("Expected argument 'offer' to be a str")
        pulumi.set(__self__, "offer", offer)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if port_ftp and not isinstance(port_ftp, int):
            raise TypeError("Expected argument 'port_ftp' to be a int")
        pulumi.set(__self__, "port_ftp", port_ftp)
        if quota_size and not isinstance(quota_size, int):
            raise TypeError("Expected argument 'quota_size' to be a int")
        pulumi.set(__self__, "quota_size", quota_size)
        if quota_used and not isinstance(quota_used, int):
            raise TypeError("Expected argument 'quota_used' to be a int")
        pulumi.set(__self__, "quota_used", quota_used)
        if ram and not isinstance(ram, int):
            raise TypeError("Expected argument 'ram' to be a int")
        pulumi.set(__self__, "ram", ram)
        if server and not isinstance(server, str):
            raise TypeError("Expected argument 'server' to be a str")
        pulumi.set(__self__, "server", server)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if urn and not isinstance(urn, str):
            raise TypeError("Expected argument 'urn' to be a str")
        pulumi.set(__self__, "urn", urn)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if version_label and not isinstance(version_label, str):
            raise TypeError("Expected argument 'version_label' to be a str")
        pulumi.set(__self__, "version_label", version_label)
        if version_number and not isinstance(version_number, float):
            raise TypeError("Expected argument 'version_number' to be a float")
        pulumi.set(__self__, "version_number", version_number)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        """
        Number of CPU on your private database
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> _builtins.str:
        """
        Datacenter where this private database is located
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Name displayed in customer panel for your private database
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        Private database hostname
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="hostnameFtp")
    def hostname_ftp(self) -> _builtins.str:
        """
        Private database FTP hostname
        """
        return pulumi.get(self, "hostname_ftp")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def infrastructure(self) -> _builtins.str:
        """
        Infrastructure where service was stored
        """
        return pulumi.get(self, "infrastructure")

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        """
        Type of the private database offer
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Private database service port
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portFtp")
    def port_ftp(self) -> _builtins.int:
        """
        Private database FTP port
        """
        return pulumi.get(self, "port_ftp")

    @_builtins.property
    @pulumi.getter(name="quotaSize")
    def quota_size(self) -> _builtins.int:
        """
        Space allowed (in MB) on your private database
        """
        return pulumi.get(self, "quota_size")

    @_builtins.property
    @pulumi.getter(name="quotaUsed")
    def quota_used(self) -> _builtins.int:
        """
        Sapce used (in MB) on your private database
        """
        return pulumi.get(self, "quota_used")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        """
        Amount of ram (in MB) on your private database
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        Private database server name
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Private database state
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> _builtins.str:
        """
        URN of the private database
        """
        return pulumi.get(self, "urn")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Private database available versions
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> _builtins.str:
        """
        Private database version label
        """
        return pulumi.get(self, "version_label")

    @_builtins.property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> _builtins.float:
        """
        Private database version number
        """
        return pulumi.get(self, "version_number")


class AwaitableGetPrivateDatabaseResult(GetPrivateDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateDatabaseResult(
            cpu=self.cpu,
            datacenter=self.datacenter,
            display_name=self.display_name,
            hostname=self.hostname,
            hostname_ftp=self.hostname_ftp,
            id=self.id,
            infrastructure=self.infrastructure,
            offer=self.offer,
            port=self.port,
            port_ftp=self.port_ftp,
            quota_size=self.quota_size,
            quota_used=self.quota_used,
            ram=self.ram,
            server=self.server,
            service_name=self.service_name,
            state=self.state,
            type=self.type,
            urn=self.urn,
            version=self.version,
            version_label=self.version_label,
            version_number=self.version_number)


def get_private_database(service_name: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateDatabaseResult:
    """
    Use this data source to retrieve information about an hosting database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    database = ovh.Hosting.get_private_database(service_name="XXXXXX")
    ```


    :param _builtins.str service_name: The internal name of your private database
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Hosting/getPrivateDatabase:getPrivateDatabase', __args__, opts=opts, typ=GetPrivateDatabaseResult).value

    return AwaitableGetPrivateDatabaseResult(
        cpu=pulumi.get(__ret__, 'cpu'),
        datacenter=pulumi.get(__ret__, 'datacenter'),
        display_name=pulumi.get(__ret__, 'display_name'),
        hostname=pulumi.get(__ret__, 'hostname'),
        hostname_ftp=pulumi.get(__ret__, 'hostname_ftp'),
        id=pulumi.get(__ret__, 'id'),
        infrastructure=pulumi.get(__ret__, 'infrastructure'),
        offer=pulumi.get(__ret__, 'offer'),
        port=pulumi.get(__ret__, 'port'),
        port_ftp=pulumi.get(__ret__, 'port_ftp'),
        quota_size=pulumi.get(__ret__, 'quota_size'),
        quota_used=pulumi.get(__ret__, 'quota_used'),
        ram=pulumi.get(__ret__, 'ram'),
        server=pulumi.get(__ret__, 'server'),
        service_name=pulumi.get(__ret__, 'service_name'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'),
        urn=pulumi.get(__ret__, 'urn'),
        version=pulumi.get(__ret__, 'version'),
        version_label=pulumi.get(__ret__, 'version_label'),
        version_number=pulumi.get(__ret__, 'version_number'))
def get_private_database_output(service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivateDatabaseResult]:
    """
    Use this data source to retrieve information about an hosting database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    database = ovh.Hosting.get_private_database(service_name="XXXXXX")
    ```


    :param _builtins.str service_name: The internal name of your private database
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Hosting/getPrivateDatabase:getPrivateDatabase', __args__, opts=opts, typ=GetPrivateDatabaseResult)
    return __ret__.apply(lambda __response__: GetPrivateDatabaseResult(
        cpu=pulumi.get(__response__, 'cpu'),
        datacenter=pulumi.get(__response__, 'datacenter'),
        display_name=pulumi.get(__response__, 'display_name'),
        hostname=pulumi.get(__response__, 'hostname'),
        hostname_ftp=pulumi.get(__response__, 'hostname_ftp'),
        id=pulumi.get(__response__, 'id'),
        infrastructure=pulumi.get(__response__, 'infrastructure'),
        offer=pulumi.get(__response__, 'offer'),
        port=pulumi.get(__response__, 'port'),
        port_ftp=pulumi.get(__response__, 'port_ftp'),
        quota_size=pulumi.get(__response__, 'quota_size'),
        quota_used=pulumi.get(__response__, 'quota_used'),
        ram=pulumi.get(__response__, 'ram'),
        server=pulumi.get(__response__, 'server'),
        service_name=pulumi.get(__response__, 'service_name'),
        state=pulumi.get(__response__, 'state'),
        type=pulumi.get(__response__, 'type'),
        urn=pulumi.get(__response__, 'urn'),
        version=pulumi.get(__response__, 'version'),
        version_label=pulumi.get(__response__, 'version_label'),
        version_number=pulumi.get(__response__, 'version_number')))
