# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMitigationResult',
    'AwaitableGetMitigationResult',
    'get_mitigation',
    'get_mitigation_output',
]

@pulumi.output_type
class GetMitigationResult:
    """
    A collection of values returned by getMitigation.
    """
    def __init__(__self__, auto=None, id=None, ip=None, ip_on_mitigation=None, permanent=None, state=None):
        if auto and not isinstance(auto, bool):
            raise TypeError("Expected argument 'auto' to be a bool")
        pulumi.set(__self__, "auto", auto)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if ip_on_mitigation and not isinstance(ip_on_mitigation, str):
            raise TypeError("Expected argument 'ip_on_mitigation' to be a str")
        pulumi.set(__self__, "ip_on_mitigation", ip_on_mitigation)
        if permanent and not isinstance(permanent, bool):
            raise TypeError("Expected argument 'permanent' to be a bool")
        pulumi.set(__self__, "permanent", permanent)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def auto(self) -> _builtins.bool:
        """
        Set on true if the IP is on auto-mitigation
        """
        return pulumi.get(self, "auto")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP or the CIDR
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipOnMitigation")
    def ip_on_mitigation(self) -> _builtins.str:
        """
        IPv4 address
        * `permanent ` - Set on true if the IP is on permanent mitigation
        """
        return pulumi.get(self, "ip_on_mitigation")

    @_builtins.property
    @pulumi.getter
    def permanent(self) -> _builtins.bool:
        return pulumi.get(self, "permanent")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Current state of the IP on mitigation
        """
        return pulumi.get(self, "state")


class AwaitableGetMitigationResult(GetMitigationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMitigationResult(
            auto=self.auto,
            id=self.id,
            ip=self.ip,
            ip_on_mitigation=self.ip_on_mitigation,
            permanent=self.permanent,
            state=self.state)


def get_mitigation(ip: Optional[_builtins.str] = None,
                   ip_on_mitigation: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMitigationResult:
    """
    Use this resource to retrieve information about an IP permanent mitigation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    mitigation_data = ovh.Ip.get_mitigation(ip="XXXXXX",
        ip_on_mitigation="XXXXXX")
    ```


    :param _builtins.str ip: The IP or the CIDR
    :param _builtins.str ip_on_mitigation: IPv4 address
    """
    __args__ = dict()
    __args__['ip'] = ip
    __args__['ipOnMitigation'] = ip_on_mitigation
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Ip/getMitigation:getMitigation', __args__, opts=opts, typ=GetMitigationResult).value

    return AwaitableGetMitigationResult(
        auto=pulumi.get(__ret__, 'auto'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        ip_on_mitigation=pulumi.get(__ret__, 'ip_on_mitigation'),
        permanent=pulumi.get(__ret__, 'permanent'),
        state=pulumi.get(__ret__, 'state'))
def get_mitigation_output(ip: Optional[pulumi.Input[_builtins.str]] = None,
                          ip_on_mitigation: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMitigationResult]:
    """
    Use this resource to retrieve information about an IP permanent mitigation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    mitigation_data = ovh.Ip.get_mitigation(ip="XXXXXX",
        ip_on_mitigation="XXXXXX")
    ```


    :param _builtins.str ip: The IP or the CIDR
    :param _builtins.str ip_on_mitigation: IPv4 address
    """
    __args__ = dict()
    __args__['ip'] = ip
    __args__['ipOnMitigation'] = ip_on_mitigation
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Ip/getMitigation:getMitigation', __args__, opts=opts, typ=GetMitigationResult)
    return __ret__.apply(lambda __response__: GetMitigationResult(
        auto=pulumi.get(__response__, 'auto'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        ip_on_mitigation=pulumi.get(__response__, 'ip_on_mitigation'),
        permanent=pulumi.get(__response__, 'permanent'),
        state=pulumi.get(__response__, 'state')))
