# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'HttpFarmProbe',
    'HttpRouteAction',
    'HttpRouteRule',
    'LoadBalancerOrder',
    'LoadBalancerOrderDetail',
    'LoadBalancerOrderableZone',
    'LoadBalancerPlan',
    'LoadBalancerPlanConfiguration',
    'LoadBalancerPlanOption',
    'LoadBalancerPlanOptionConfiguration',
    'TcpFarmProbe',
    'TcpRouteAction',
    'TcpRouteRule',
    'GetIpLoadBalancingOrderableZoneResult',
]

@pulumi.output_type
class HttpFarmProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceSsl":
            suggest = "force_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpFarmProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpFarmProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpFarmProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 force_ssl: Optional[_builtins.bool] = None,
                 interval: Optional[_builtins.int] = None,
                 match: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 negate: Optional[_builtins.bool] = None,
                 pattern: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        :param _builtins.bool force_ssl: Force use of SSL (TLS)
        :param _builtins.int interval: probe interval, Value between 30 and 3600 seconds, default 30
        :param _builtins.str match: What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        :param _builtins.str method: HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        :param _builtins.bool negate: Negate probe result
        :param _builtins.str pattern: Pattern to match against `match`
        :param _builtins.int port: Port for backends to receive traffic on.
        :param _builtins.str url: URL for HTTP probe type.
        """
        pulumi.set(__self__, "type", type)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[_builtins.bool]:
        """
        Force use of SSL (TLS)
        """
        return pulumi.get(self, "force_ssl")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[_builtins.str]:
        """
        What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def negate(self) -> Optional[_builtins.bool]:
        """
        Negate probe result
        """
        return pulumi.get(self, "negate")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[_builtins.str]:
        """
        Pattern to match against `match`
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port for backends to receive traffic on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        URL for HTTP probe type.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class HttpRouteAction(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 status: Optional[_builtins.int] = None,
                 target: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Action to trigger if all the rules of this route matches
        :param _builtins.int status: HTTP status code for "redirect" and "reject" actions
        :param _builtins.str target: Farm ID for "farm" action type or URL template for "redirect" action. You may use ${uri}, ${protocol}, ${host}, ${port} and ${path} variables in redirect target
        """
        pulumi.set(__self__, "type", type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Action to trigger if all the rules of this route matches
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.int]:
        """
        HTTP status code for "redirect" and "reject" actions
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        """
        Farm ID for "farm" action type or URL template for "redirect" action. You may use ${uri}, ${protocol}, ${host}, ${port} and ${path} variables in redirect target
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class HttpRouteRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "subField":
            suggest = "sub_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: Optional[_builtins.str] = None,
                 match: Optional[_builtins.str] = None,
                 negate: Optional[_builtins.bool] = None,
                 pattern: Optional[_builtins.str] = None,
                 rule_id: Optional[_builtins.int] = None,
                 sub_field: Optional[_builtins.str] = None):
        """
        :param _builtins.str field: Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        :param _builtins.str match: Matching operator. Not all operators are available for all fields. See "availableRules"
        :param _builtins.bool negate: Invert the matching operator effect
        :param _builtins.str pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param _builtins.int rule_id: Id of your rule
        :param _builtins.str sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @_builtins.property
    @pulumi.getter
    def field(self) -> Optional[_builtins.str]:
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[_builtins.str]:
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def negate(self) -> Optional[_builtins.bool]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[_builtins.str]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.int]:
        """
        Id of your rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[_builtins.str]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")


@pulumi.output_type
class LoadBalancerOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[_builtins.str] = None,
                 details: Optional[Sequence['outputs.LoadBalancerOrderDetail']] = None,
                 expiration_date: Optional[_builtins.str] = None,
                 order_id: Optional[_builtins.int] = None):
        """
        :param _builtins.str date: date
        :param Sequence['LoadBalancerOrderDetailArgs'] details: Information about a Bill entry
        :param _builtins.str expiration_date: expiration date
        :param _builtins.int order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @_builtins.property
    @pulumi.getter
    def date(self) -> Optional[_builtins.str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.LoadBalancerOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[_builtins.str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[_builtins.int]:
        """
        order id
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class LoadBalancerOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 domain: Optional[_builtins.str] = None,
                 order_detail_id: Optional[_builtins.int] = None,
                 quantity: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: description
        :param _builtins.str domain: expiration date
        :param _builtins.int order_detail_id: order detail id
        :param _builtins.str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[_builtins.int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @_builtins.property
    @pulumi.getter
    def quantity(self) -> Optional[_builtins.str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class LoadBalancerOrderableZone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerOrderableZone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerOrderableZone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerOrderableZone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 plan_code: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The zone three letter code
        :param _builtins.str plan_code: The billing planCode for this zone
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan_code is not None:
            pulumi.set(__self__, "plan_code", plan_code)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The zone three letter code
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> Optional[_builtins.str]:
        """
        The billing planCode for this zone
        """
        return pulumi.get(self, "plan_code")


@pulumi.output_type
class LoadBalancerPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 catalog_name: Optional[_builtins.str] = None,
                 configurations: Optional[Sequence['outputs.LoadBalancerPlanConfiguration']] = None):
        """
        :param _builtins.str duration: duration
        :param _builtins.str plan_code: Plan code
        :param _builtins.str pricing_mode: Pricing model identifier
        :param _builtins.str catalog_name: Catalog name
        :param Sequence['LoadBalancerPlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[_builtins.str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.LoadBalancerPlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class LoadBalancerPlanConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Identifier of the resource
        :param _builtins.str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadBalancerPlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerPlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerPlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerPlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: _builtins.str,
                 plan_code: _builtins.str,
                 pricing_mode: _builtins.str,
                 catalog_name: Optional[_builtins.str] = None,
                 configurations: Optional[Sequence['outputs.LoadBalancerPlanOptionConfiguration']] = None):
        """
        :param _builtins.str duration: duration
        :param _builtins.str plan_code: Plan code
        :param _builtins.str pricing_mode: Pricing model identifier
        :param _builtins.str catalog_name: Catalog name
        :param Sequence['LoadBalancerPlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> _builtins.str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[_builtins.str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.LoadBalancerPlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class LoadBalancerPlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Identifier of the resource
        :param _builtins.str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TcpFarmProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceSsl":
            suggest = "force_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpFarmProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpFarmProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpFarmProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 force_ssl: Optional[_builtins.bool] = None,
                 interval: Optional[_builtins.int] = None,
                 match: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 negate: Optional[_builtins.bool] = None,
                 pattern: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        :param _builtins.bool force_ssl: Force use of SSL (TLS)
        :param _builtins.int interval: probe interval, Value between 30 and 3600 seconds, default 30
        :param _builtins.str match: What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        :param _builtins.str method: HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        :param _builtins.bool negate: Negate probe result
        :param _builtins.str pattern: Pattern to match against `match`
        :param _builtins.int port: Port for backends to receive traffic on.
        :param _builtins.str url: URL for HTTP probe type.
        """
        pulumi.set(__self__, "type", type)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[_builtins.bool]:
        """
        Force use of SSL (TLS)
        """
        return pulumi.get(self, "force_ssl")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[_builtins.str]:
        """
        What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def negate(self) -> Optional[_builtins.bool]:
        """
        Negate probe result
        """
        return pulumi.get(self, "negate")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[_builtins.str]:
        """
        Pattern to match against `match`
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port for backends to receive traffic on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        URL for HTTP probe type.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class TcpRouteAction(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 target: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Action to trigger if all the rules of this route matches
        :param _builtins.str target: Farm ID for "farm" action type, empty for others.
        """
        pulumi.set(__self__, "type", type)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Action to trigger if all the rules of this route matches
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        """
        Farm ID for "farm" action type, empty for others.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class TcpRouteRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "subField":
            suggest = "sub_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpRouteRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpRouteRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpRouteRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: Optional[_builtins.str] = None,
                 match: Optional[_builtins.str] = None,
                 negate: Optional[_builtins.bool] = None,
                 pattern: Optional[_builtins.str] = None,
                 rule_id: Optional[_builtins.int] = None,
                 sub_field: Optional[_builtins.str] = None):
        """
        :param _builtins.str field: Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        :param _builtins.str match: Matching operator. Not all operators are available for all fields. See "availableRules"
        :param _builtins.bool negate: Invert the matching operator effect
        :param _builtins.str pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param _builtins.int rule_id: Id of your rule
        :param _builtins.str sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @_builtins.property
    @pulumi.getter
    def field(self) -> Optional[_builtins.str]:
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[_builtins.str]:
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def negate(self) -> Optional[_builtins.bool]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[_builtins.str]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.int]:
        """
        Id of your rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[_builtins.str]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")


@pulumi.output_type
class GetIpLoadBalancingOrderableZoneResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 plan_code: _builtins.str):
        """
        :param _builtins.str name: The zone three letter code
        :param _builtins.str plan_code: The billing planCode for this zone
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "plan_code", plan_code)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The zone three letter code
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> _builtins.str:
        """
        The billing planCode for this zone
        """
        return pulumi.get(self, "plan_code")


